.\" dpkg manual page - update-alternatives(1)
.\"
.\" Copyright © 1997-1998 Charles Briscoe-Smith
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008 Pierre Habouzit <madcoder@debian.org>
.\" Copyright © 2009-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH update\-alternatives 1 %RELEASE_DATE% %VERSION% "użytki dpkg"
.nh
.SH NAZWA
update\-alternatives \- zarządzanie dowiązaniami symbolicznymi określającymi
domyślne polecenia
.
.SH SKŁADNIA
\fBupdate\-alternatives\fP [\fIopcja\fP...] \fIpolecenie\fP
.
.SH OPIS
\fBupdate\-alternatives\fP tworzy, usuwa, wyświetla informacje o dowiązaniach
symbolicznych składających się na system alternatyw Debiana oraz nimi
zarządza.
.PP
Kilka programów mających tę samą lub podobną funkcjonalność może zostać
zainstalowanych w systemie w tym samym czasie. Na przykład w wielu systemach
jest zainstalowanych jednocześnie kilka edytorów tekstu. Stanowi to
ułatwienie dla użytkowników takiego systemu, z których każdy może uruchomić
inny edytor, jeśli ma na to ochotę. Z drugiej strony jest to jednak
utrudnienie dla programów chcących podjąć właściwą decyzję, który edytor
uruchomić, jeżeli użytkownik nie określił swoich preferencji co do edytora.
.PP
Celem systemu alternatyw Debiana jest rozwiązanie tego problemu. Ogólna
nazwa w systemie plików jest współdzielona przez wszystkie pliki
dostarczające zmieniającą się funkcjonalność. System alternatyw oraz
administrator systemu określają, do którego obecnego pliku prowadzi ta
ogólna nazwa. Na przykład, jeżeli zainstalowano zarówno edytor \fBed\fP(1) jak
i \fBnvi\fP(1), to system alternatyw spowoduje, że nazwa ogólna
\fI/usr/bin/editor\fP będzie się odnosić do \fI/usr/bin/nvi\fP. Administrator
systemu może zmienić to ustawienie na \fI/usr/bin/ed\fP, a system alternatyw
tego nie zmieni, chyba że administrator każe mu tak zrobić.
.PP
Nazwa ogólna nie jest bezpośrednim dowiązaniem symbolicznym do wybranej
alternatywy, ale jest dowiązaniem do pliku w \fIkatalogu\fP \fIalternatyw\fP,
które z kolei jest dowiązaniem do właściwego pliku. Jest tak zrobione
dlatego, żeby zmiany wprowadzane przez administratora systemu były
ograniczone do katalogu \fI%CONFDIR%\fP: standard FHS wymienia powody, aby tak
zrobić.
.PP
When each package providing a file with a particular functionality is
installed, changed or removed, \fBupdate\-alternatives\fP is called to update
information about that file in the alternatives system.
\fBupdate\-alternatives\fP is usually called from the \fBpostinst\fP (configure) or
\fBprerm\fP (remove and deconfigure) scripts in Debian packages.
.PP
Często użyteczne jest, aby pewna liczba alternatyw była zsynchronizowana,
tak żeby była zmieniana jako grupa. Na przykład jeżeli jest zainstalowane
kilka wersji edytora \fBvi\fP(1), to strona podręcznika
\fI/usr/share/man/man1/vi.1\fP powinna odpowiadać wersji programu
zainstalowanego jako \fI/usr/bin/vi\fP. \fBupdate\-alternatives\fP obsługuje to
przy pomocy dowiązań \fIgłównych\fP i \fIpodrzędnych\fP \- zmiana dowiązania
głównego powoduje zmianę skojarzonych dowiązań podrzędnych. Dowiązanie
główne i skojarzone z nim dowiązania podrzędne tworzą \fIgrupę\fP \fIdowiązań\fP.
.PP
Każda grupa dowiązań jest zawsze w jednym z dwóch trybów: automatycznym lub
ręcznym. W trybie automatycznym podczas instalacji lub usuwania pakietu
system alternatyw automatycznie zdecyduje, czy i jak aktualizować
dowiązania. W trybie ręcznym system alternatyw nie będzie zmieniał dowiązań
i zostawi wszystkie decyzje administratorowi systemu.
.PP
Grupa dowiązań jest trybie automatycznym, kiedy jest po raz pierwszy
wprowadzana do systemu. Jeżeli administrator systemu wprowadzi zmiany do
automatycznych ustawień, będą one wzięte pod uwagę podczas następnego
uruchomienia \fBupdate\-alternatives\fP na takiej zmienionej grupie dowiązań, a
grupa ta automatycznie przejdzie w tryb ręczny.
.PP
Z każdą alternatywą skojarzony jest \fIpriorytet\fP. Jeżeli grupa dowiązań jest
w trybie automatycznym, to wybraną alternatywą będzie ta, która ma najwyższy
priorytet.
.PP
When using the \fB\-\-config\fP option, \fBupdate\-alternatives\fP will list all of
the choices for the link group of which given \fIname\fP is the master
alternative name.  The current choice is marked with a ‘*’.  You will then
be prompted for your choice regarding this link group.  Depending on the
choice made, the link group might no longer be in \fIauto\fP mode. You will
need to use the \fB\-\-auto\fP option in order to return to the automatic mode
(or you can rerun \fB\-\-config\fP and select the entry marked as automatic).
.PP
Aby skonfigurować nieinteraktywnie, można użyć opcji \fB\-\-set\fP (patrz niżej).
.PP
Różne pakiety dostarczające tych samych plików powinny \fBwspółpracować\fP ze
sobą w tym zakresie. Oznacza to, że używanie programu \fBupdate\-alternatives\fP
jest \fBobowiązkowe\fP dla wszystkich takich pakietów \- nie jest możliwe
nadpisanie pewnych plików w pakiecie, który nie używa mechanizmu
\fBupdate\-alternatives\fP.
.
.SH TERMINOLOGIA
Ponieważ operacje programu \fBupdate\-alternatives\fP są dość złożone, poniżej
podane są terminy, które pomogą je zrozumieć.
.TP 
nazwa ogólna (lub dowiązanie alternatywy)
Nazwa, taka jak \fI/usr/bin/editor\fP, która odnosi się przez system alternatyw
do jednego z kilku plików o podobnej funkcjonalności.
.TP 
nazwa alternatywy
Nazwa dowiązania symbolicznego w katalogu alternatyw.
.TP 
alternatywa (lub ścieżka alternatywy)
Nazwa określonego pliku w systemie plików, który w systemie alternatyw może
być dostępny przez nazwę ogólną.
.TP 
katalog alternatyw
Katalog zawierający dowiązania symboliczne, domyślnie
\fI%CONFDIR%/alternatives\fP.
.TP 
katalog administracyjny
Katalog zawierający informacje o stanie \fBupdate\-alternatives\fP, domyślnie
\fI/var/lib/dpkg/alternatives\fP.
.TP 
grupa dowiązań
Zbiór powiązanych dowiązań symbolicznych, zarządzany jako grupa.
.TP 
dowiązanie główne
Dowiązanie alternatywy w grupie dowiązań, które określa sposób
konfigurowania innych dowiązań z tej grupy.
.TP 
dowiązanie podrzędne
Dowiązanie alternatywy w grupie dowiązań, które jest kontrolowane przez
ustawienie głównego dowiązania.
.TP 
tryb automatyczny
Kiedy grupa dowiązań jest w trybie automatycznym, system alternatyw zapewni,
że dowiązania z tej grupy wskazują na alternatywę o najwyższym priorytecie.
.TP 
tryb ręczny
Kiedy grupa dowiązań jest w trybie ręcznym, system alternatyw nic nie zmieni
w ustawieniach wprowadzonych przez administratora systemu.
.
.SH POLECENIA
.TP 
\fB\-\-install\fP \fIdowiązanie nazwa ścieżka priorytet\fP [\fB\-\-slave\fP \fIdowiązanie nazwa ścieżka\fP]...
Dodaje grupę alternatyw do systemu. \fIdowiązanie\fP jest ogólną nazwą głównego
dowiązania, \fInazwa\fP jest nazwą dowiązania symbolicznego w katalogu
alternatyw, a \fIścieżka\fP jest wprowadzaną alternatywą dla głównego
dowiązania. Argumentami opcji \fB\-\-slave\fP są nazwa ogólna, nazwa dowiązania
symbolicznego w katalogu alternatyw i ścieżka alternatywy dla dowiązania
podrzędnego. Można podać zero lub więcej opcji \fB\-\-slave\fP, po każdej muszą
następować jej trzy argumenty. Należy zauważyć, że główna alternatywa musi
istnieć, inaczej wywołanie się nie powiedzie. Jednak jeśli nie będzie
istnieć podrzędna alternatywa, odpowiednie dowiązanie podrzędne po prostu
nie zostanie zainstalowane (ale nadal będzie wyświetlane ostrzeżenie). Jeśli
w miejscu gdzie powinno być zainstalowane dowiązanie alternatywy istnieje
rzeczywisty plik, jest on zachowywany, chyba że użyta jest opcja \fB\-\-force\fP.
.IP
Jeżeli określona nazwa alternatywy już istnieje w systemie alternatyw, to
podana informacja będzie dodana jako nowy zbiór alternatyw dla tej grupy. W
przeciwnym wypadku zostanie utworzona nowa grupa, ustawiona w tryb
automatyczny. Jeżeli grupa jest w trybie automatycznym, a priorytet nowo
dodawanych alternatyw jest większy od priorytetu każdej z innych
zainstalowanych alternatyw w tej grupie, to dowiązania symboliczne będą
zaktualizowane tak, żeby prowadziły do nowo dodanych alternatyw.
.TP 
\fB\-\-set\fP \fInazwa ścieżka\fP
Ustawia program \fIścieżka\fP jako alternatywę dla \fInazwy\fP. Jest to
nieinteraktywny, a więc możliwy do użycia w skryptach, odpowiednik opcji
\fB\-\-config\fP.
.TP 
\fB\-\-remove\fP \fInazwa ścieżka\fP
Usuwa alternatywę i wszystkie dowiązania podrzędne z nią
skojarzone. \fInazwa\fP jest nazwą w katalogu alternatyw, \fIścieżka\fP jest
absolutną nazwą pliku, do której \fInazwa\fP mogłaby być dowiązaniem. Jeżeli
\fInazwa\fP rzeczywiście jest dowiązaniem do \fIścieżki\fP, to \fInazwa\fP zostanie
zaktualizowana, tak żeby wskazywała na inną odpowiednią alternatywę (zaś
grupa jest ustawiana ponownie w tryb automatyczny), albo zostanie usunięta
jeżeli nie pozostanie ani jedna alternatywa. Skojarzone dowiązania podrzędne
zostaną odpowiednio zaktualizowane lub usunięte. Jeżeli dowiązanie nie
prowadzi obecnie do \fIścieżki\fP, to żadne dowiązania nie będą aktualizowane;
zostanie tylko usunięta informacja o alternatywie.
.TP 
\fB\-\-remove\-all\fP \fInazwa\fP
Usuwa wszystkie dowiązania alternatyw i wszystkie skojarzone z nimi
dowiązania podrzędne. \fInazwa\fP jest nazwą w katalogu alternatyw.
.TP 
\fB\-\-all\fP
Wywołuje \fB\-\-config\fP dla wszystkich alternatyw. Można to użytecznie połączyć
z \fB\-\-skip\-auto\fP aby przejrzeć i skonfigurować wszystkie alternatywy, które
nie są skonfigurowane w tryb automatyczny. Wyświetlane są również
nieaktualne alternatywy. Dlatego prostym sposobem naprawienia uszkodzonych
alternatyw jest wywołanie \fByes \*(rq | update\-alternatives \-\-force \-\-all\fP.
.TP 
\fB\-\-auto\fP \fInazwa\fP
Przełącza grupę dowiązań dla alternatywy w tryb automatyczny. Podczas tego
procesu, główne dowiązanie wraz z jego dowiązaniami podrzędnymi będą
zaktualizowane tak, aby wskazywać na alternatywę o najwyższym priorytecie.
.TP 
\fB\-\-display\fP \fInazwa\fP
Display information about the link group.  Information displayed includes
the group's mode (auto or manual), the master and slave links, which
alternative the master link currently points to, what other alternatives are
available (and their corresponding slave alternatives), and the highest
priority alternative currently installed.
.TP 
\fB\-\-get\-selections\fP
List all master alternative names (those controlling a link group)  and
their status (since version 1.15.0).  Each line contains up to 3 fields
(separated by one or more spaces). The first field is the alternative name,
the second one is the status (either \fBauto\fP or \fBmanual\fP), and the last one
contains the current choice in the alternative (beware: it's a filename and
thus might contain spaces).
.TP 
\fB\-\-set\-selections\fP
Read configuration of alternatives on standard input in the format generated
by \fB\-\-get\-selections\fP and reconfigure them accordingly (since version
1.15.0).
.TP 
\fB\-\-query\fP \fInazwa\fP
Display information about the link group like \fB\-\-display\fP does, but in a
machine parseable way (since version 1.15.0, see section \fBQUERY FORMAT\fP
below).
.TP 
\fB\-\-list\fP \fInazwa\fP
Wyświetla wszystkie cele w grupie dowiązań.
.TP 
\fB\-\-config\fP \fInazwa\fP
Wyświetla dostępne alternatywy w grupie dowiązań i pozwala użytkownikowi
interaktywnie wybrać, której należy użyć. Grupa dowiązań zostanie
odpowiednio zaktualizowana.
.TP 
\fB\-\-help\fP
Wyświetla informację o użytkowaniu i kończy działanie.
.TP 
\fB\-\-version\fP
Wyświetla informację o wersji i pomyślnie kończy działanie.
.
.SH OPCJE
.TP 
\fB\-\-altdir\fP\fI katalog\fP
Określa katalog alternatyw, jeżeli ma być inny niż domyślny.
.TP 
\fB\-\-admindir\fP\fI katalog\fP
Określa katalog administracyjny, jeżeli ma być inny niż domyślny.
.TP 
\fB\-\-log\fP\fI plik\fP
Specifies the log file (since version 1.15.0), when this is to be different
from the default (%LOGDIR%/alternatives.log).
.TP 
\fB\-\-force\fP
Allow replacing or dropping any real file that is installed where an
alternative link has to be installed or removed.
.TP 
\fB\-\-skip\-auto\fP
Pomija pytania o konfigurację alternatyw, które są właściwie skonfigurowane
w trybie automatycznym. Ta opcja ma znaczenie tylko przy \fB\-\-config\fP lub
\fB\-\-all\fP.
.TP 
\fB\-\-quiet\fP
Do not generate any comments unless errors occur.
.TP 
\fB\-\-verbose\fP
Generate more comments about what is being done.
.TP 
\fB\-\-debug\fP
Generate even more comments, helpful for debugging, about what is being done
(since version 1.19.3).
.
.SH "KOD WYJŚCIA"
.TP 
\fB0\fP
Akcja zakończyła się powodzeniem.
.TP 
\fB2\fP
Wystąpiły problemy podczas przetwarzania linii poleceń lub wykonywania
akcji.
.
.SH ŚRODOWISKO
.TP 
\fBDPKG_ADMINDIR\fP
Jeśli ustawione oraz nie podano opcji \fB\-\-admindir\fP, to będzie użyte jako
bazowy katalog administracyjny.
.
.SH PLIKI
.TP 
\fI%CONFDIR%/alternatives/\fP
Domyślny katalog alternatyw. Można go zmienić opcją \fB\-altdir\fP.
.TP 
\fI%ADMINDIR%/alternatives/\fP
Domyślny katalog administracyjny. Można go zmienić opcją \fB\-admindir\fP.
.
.SH "FORMAT ZAPYTANIA"
The \fB\-\-query\fP format is using an RFC822\-like flat format. It's made of \fIn\fP
+ 1 blocks where \fIn\fP is the number of alternatives available in the queried
link group. The first block contains the following fields:
.TP 
\fBName:\fP\fI nazwa\fP
Nazwa alternatywy w katalogu alternatyw.
.TP 
\fBLink:\fP\fI dowiązanie\fP
Nazwa ogólna alternatywy.
.TP 
\fBSlaves:\fP\fI lista\-alternatyw\-podrzędnych\fP
Gdy to pole jest obecne, \fBnastępne\fP wiersze zawierają wszystkie podrzędne
dowiązania związane z głównym dowiązaniem alternatywy. W każdym wierszu
podana jest jedna podrzędna alternatywa. Każdy wiersz zawiera jedną spację,
ogólną nazwę alternatywy podrzędnej, kolejną spację i w końcu ścieżkę do
dowiązania podrzędnego.
.TP 
\fBStatus:\fP\fI status\fP
Status alternatywy (\fBauto\fP lub \fBmanual\fP).
.TP 
\fBBest:\fP\fI najlepszy wybór\fP
Ścieżka najlepszej alternatywy dla tej grupy dowiązań. Nie jest wyświetlana,
jeśli nie ma dostępnych żadnych alternatyw.
.TP 
\fBValue:\fP\fI aktualnie wybrana alternatywa\fP
Ścieżka aktualnie wybranej alternatywy. Może również przyjmować specjalną
wartość \fBnone\fP \- jest ona używana jeśli dowiązanie nie istnieje.
.PP
Inne bloki opisują dostępne alternatywy w grupie dowiązań, do której odnosi
się zapytanie:
.TP 
\fBAlternative:\fP\fI ścieżka\-alternatywy\fP
Ścieżka do alternatywy opisywanej w tym bloku.
.TP 
\fBPriority:\fP\fI wartość\-priorytetu\fP
Wartość priorytetu alternatywy.
.TP 
\fBSlaves:\fP\fI lista\-alternatyw\-podrzędnych\fP
When this field is present, the \fBnext\fP lines hold all slave alternatives
associated to the master link of the alternative. There is one slave per
line. Each line contains one space, the generic name of the slave
alternative, another space, and the path to the slave alternative.
.
.SS Example
.nf
$ update\-alternatives \-\-query editor
Name: editor
Link: /usr/bin/editor
Slaves:
 editor.1.gz /usr/share/man/man1/editor.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/editor.1.gz
 editor.it.1.gz /usr/share/man/it/man1/editor.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/editor.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/editor.1.gz
Status: auto
Best: /usr/bin/vim.basic
Value: /usr/bin/vim.basic

Alternative: /bin/ed
Priority: \-100
Slaves:
 editor.1.gz /usr/share/man/man1/ed.1.gz

Alternative: /usr/bin/vim.basic
Priority: 50
Slaves:
 editor.1.gz /usr/share/man/man1/vim.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/vim.1.gz
 editor.it.1.gz /usr/share/man/it/man1/vim.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/vim.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/vim.1.gz
.fi
.
.SH DIAGNOSTYKA
Po podaniu \fB\-\-verbose\fP, \fBupdate\-alternatives\fP wypisuje nieustannie
informacje o podejmowanych działaniach na swoim standardowym wyjściu. Jeżeli
wystąpi błąd, \fBupdate\-alternatives\fP wyświetla komunikaty błędów na
standardowym wyjściu błędów i kończy działanie z kodem wyjścia 2. Wypisywana
diagnostyka powinna wszystko wyjaśniać, jeżeli tak nie jest, proszę zgłosić
to jako błąd.
.
.SH PRZYKŁADY
Istnieje klika pakietów, które dostarczają edytora tekstu kompatybilnego z
edytorem \fBvi\fP, na przykład \fBnvi\fP i \fBvim\fP. To, który pakiet będzie
używany, kontrolowane jest przez grupę dowiązań \fBvi\fP, zawierającą
dowiązania do samego programu i odpowiadających mu stron podręcznika.
.PP
Aby wyświetlić listę dostępnych pakietów, które dostarczają \fBvi\fP oraz jego
bieżące ustawienie, należy użyć akcji \fB\-\-display\fP:
.PP
.RS
\fBupdate\-alternatives \-\-display vi\fP
.RE
.PP
Aby wybrać określoną implementację edytora \fBvi\fP, należy użyć tego polecenia
jako użytkownik root i wybrać liczbę z listy:
.PP
.RS
\fBupdate\-alternatives \-\-config vi\fP
.RE
.PP
Aby przywrócić automatyczne wybieranie implementacji programu \fBvi\fP, należy
jako użytkownik root wykonać:
.PP
.RS
\fBupdate\-alternatives \-\-auto vi\fP
.RE
.
.SH "ZOBACZ TAKŻE"
\fBln\fP(1), FHS \- standard hierarchii systemu plików.
.SH TŁUMACZE
Piotr Roszatycki <dexter@debian.org>, 1999
.br
Bartosz Feński <fenio@debian.org>, 2004-2005
.br
Robert Luberda <robert@debian.org>, 2006-2008
.br
Wiktor Wandachowicz <siryes@gmail.com>, 2008
.br
Michał Kułach <michal.kulach@gmail.com>, 2012
