//
// TargetDotNetFrameworkVersion.cs: Represents framework version.
//
// Authors:
//   Marek Sieradzki (marek.sieradzki@gmail.com)
//   Marek Safar (marek.safar@gmail.com)
//
// (C) 2005 Marek Sieradzki
// Copyright 2011 Xamarin Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

namespace Microsoft.Build.Utilities
{
	// If changing something here then update
	// ToolLocationHelper.GetPathToDotNetFramework also
	#if MICROSOFT_BUILD_DLL
	internal
	#else
	public
	#endif
	enum TargetDotNetFrameworkVersion
	{
		Version11,
		Version20,
		Version30,
		Version35,
#if NET_4_0
		Version40,
#endif
#if NET_4_5
		Version45,
#endif
#if XBUILD_12
		Version451,
#endif

#if XBUILD_12
		VersionLatest = Version451
#elif NET_4_5
		VersionLatest = Version45
#elif NET_4_0
		VersionLatest = Version40
#else
		VersionLatest = Version35
#endif
	}
}
