/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.viewer.MainScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressWindow
extends JFrame {
    private long _contentLength;
    private long _byteCount;
    private String _docName;
    private JLabel _progressLabel;
    private JLabel _docNameLabel;
    private int _progressState;
    public static final int UNKNOWN = 0;
    public static final int DOWNLOADING = 1;
    public static final int PROCESSING = 2;

    public ProgressWindow(ActionListener actionListener) {
        Font font = new Font("Dialog", 0, 14);
        Font font2 = new Font("Dialog", 0, 12);
        Dimension dimension = new Dimension(460, 24);
        this._docNameLabel = new JLabel();
        this._docNameLabel.setHorizontalAlignment(0);
        this._docNameLabel.setFont(font);
        this._docNameLabel.setMinimumSize(dimension);
        this._docNameLabel.setPreferredSize(dimension);
        this.getContentPane().add((Component)this._docNameLabel, "North");
        this._progressLabel = new JLabel();
        this._progressLabel.setHorizontalAlignment(0);
        this._progressLabel.setFont(font2);
        this._progressLabel.setMinimumSize(dimension);
        this._progressLabel.setPreferredSize(dimension);
        this.getContentPane().add((Component)this._progressLabel, "Center");
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "South");
        JButton jButton = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        this.setTitle("Progress");
        this.setDefaultCloseOperation(0);
        this.pack();
        MainScreen.centerTopWindow(this);
        this._contentLength = -1L;
        this._byteCount = -1L;
        this._progressState = 0;
    }

    public void setContentLength(long l, boolean bl) {
        this._contentLength = l;
        if (bl) {
            this.updateDisplay();
        }
    }

    public void setProgressState(int n, boolean bl) {
        this._progressState = n;
        if (bl) {
            this.updateDisplay();
        }
    }

    public void setDocName(String string, boolean bl) {
        this._docName = string;
        if (bl) {
            this.updateDisplay();
        }
    }

    public void setByteCount(long l, boolean bl) {
        this._byteCount = l;
        if (bl) {
            this.updateDisplay();
        }
    }

    private void updateDisplay() {
        String string;
        String string2 = "";
        switch (this._progressState) {
            case 1: {
                string = "Downloading " + this._docName;
                break;
            }
            case 2: {
                string = "Processing " + this._docName;
                break;
            }
            default: {
                string = this._docName;
            }
        }
        this._docNameLabel.setText(string);
        if (this._byteCount >= 0L) {
            string2 = Long.toString(this._byteCount) + " bytes";
            if (this._contentLength > 0L) {
                string2 = string2 + " out of " + Long.toString(this._contentLength);
            }
        }
        this._progressLabel.setText(string2);
        Container container = this.getContentPane();
        container.update(container.getGraphics());
    }
}

