#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Night of the Rabbit
# send your bug reports to contact@dotslashplay.it
###

script_version=20250114.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='the-night-of-the-rabbit'
GAME_NAME='The Night of the Rabbit'

ARCHIVE_BASE_0_NAME='the_night_of_the_rabbit_2_2_325_79210.sh'
ARCHIVE_BASE_0_MD5='0130548d6da5db0fee91521e25169066'
ARCHIVE_BASE_0_SIZE='3217360'
ARCHIVE_BASE_0_VERSION='2.2.325-gog79210'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_night_of_the_rabbit'

VISIONAIRE_NAME='rabbit'

CONTENT_PATH_DEFAULT='data/noarch/game'
## The shipped build of OpenAL must be used, to avoid a missing symbol error:
## symbol lookup error: ./satinav: undefined symbol: SelectResampler
CONTENT_LIBS0_BIN_RELATIVE_PATH='libs64'
CONTENT_LIBS0_BIN_FILES='
libopenal.so'

APP_MAIN_ICON='../support/icon.png'

PKG_BIN_ARCH='64'

## Ensure easy upgrades from packages generated with pre-20240901.2 scripts
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
the-night-of-the-rabbit-scenes
the-night-of-the-rabbit-videos"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
