RELEASING
=========

I'm writing this in order to keep some notes on how to release on maven central repository.

After some time I am not releasing this project, things have changed and I forgot the intricate mechanism to deploy jars
on Maven/Sonatype. Now I am trying again, and this time I will keep some notes for future releases here, hoping this 
will help.

RESOURCES
---------

Some links first:

- [OSSRH Guide][]
- [Apache Maven][]

  [OSSRH Guide]: http://central.sonatype.org/pages/ossrh-guide.html
  [Apache Maven]: http://central.sonatype.org/pages/apache-maven.html

SIGNING JARS
------------

In order to sign artifact jars, you need GnuPG.

You can download GnuPG from [here](https://gnupg.org/download/) or try MacPorts; I've had issues with brew version of GnuPG on OS X so my recommendation is to download the most updated binaries built for OS X; that at the time of writing is from sourceforge project [gpgosx](https://sourceforge.net/p/gpgosx/docu/Download/).

RELEASE PROCEDURE
-----------------

This will upload release artifacts to Sonatype.

First you need to make sure all tests are passing and packages can be created without errors.

```bash
# Check that everything builds smoothly and tests are all passing
$ mvn clean install

# First you need to remove the `-SNAPSHOT` thing and commit on git
$ mvn versions:set -DnewVersion=1.0.10
$ mvn versions:commit
$ git commit -am "prepare release owner 1.0.10"
$ git tag owner-1.0.10
$ git push origin owner-1.0.10:owner-1.0.10

# Deploy the signed jars on Sonatype
$ mvn clean deploy -P release-sign-artifacts

# Prepare for next development iteration
$ mvn versions:set -DnewVersion=1.0.11-SNAPSHOT
$ mvn versions:commit
$ git commit -am "prepare for next development iteration"
$ git push
```

That should do.

Maybe I should script this, not urgent anyway since releasing is not a daily routine.

SITE DEPLOY
-----------

The site is generated by [Jekyll](https://jekyllrb.com).

The Jekyll site has an ant file providing help target:

```bash
$ cd owner-site
$ ant
Buildfile: [...]/owner/owner-site/build.xml

help:
     [echo]
     [echo]         ant clean                           - cleans up the target dir
     [echo]         ant build                           - generates the website in the _site dir
     [echo]         ant publish                         - publish site to gh-pages
     [echo]         ant run-drafts                      - run jekyll serve (with '-w --drafts' options)
     [echo]         ant run                             - run jekyll serve (with '-w' option)
     [echo]

BUILD SUCCESSFUL
Total time: 0 seconds

```

Run and run-drafts require Jekyll installed, and run a local version of the website on `http://localhost:4000`.
The difference between `run` and `run-drafts` is that the blog posts in the `_drafts` directory of the website are shown 
or not: the `run` shows an actual preview of what's going to be shown on the website, while the run-drafts also shows
additionally the drafts stored in the `_drafts` folder.

The `publish` target publishes the website on GitHub Pages, on the `gh-pages` branch of the project, and makes actually
updates the online website. It does so by using git command line tools which is required to be properly installed.
