//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Numeric/FixupDoubleValidator.h
//! @brief     Defines class FixupDoubleValidator
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_NUMERIC_FIXUPDOUBLEVALIDATOR_H
#define BORNAGAIN_GUI_VIEW_NUMERIC_FIXUPDOUBLEVALIDATOR_H

#include <QDoubleValidator>

//! The FixupDoubleValidator class is a derivative of QDoubleValidator with non-empty "fixup"
//! method. If the validator return QValidator::Intermediate, then "fixup" lets us know about that,
//! emiting fixupSignal().

class FixupDoubleValidator : public QDoubleValidator {
    Q_OBJECT
public:
    explicit FixupDoubleValidator(QObject* parent = nullptr);
    FixupDoubleValidator(double bottom, double top, int decimals, QObject* parent = nullptr);

    virtual void fixup(QString& input) const override;

signals:
    void fixupSignal() const;
};

#endif // BORNAGAIN_GUI_VIEW_NUMERIC_FIXUPDOUBLEVALIDATOR_H
