/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.JVDialog;
import jalview.appletgui.TransparencySetter;
import jalview.appletgui.UserDefinedColours;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.FeaturesFile;
import jalview.schemes.UserColourScheme;
import jalview.util.Comparison;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FeatureRenderer {
    AlignViewport av;
    Hashtable featureColours = new Hashtable();
    Hashtable featureGroups = null;
    Hashtable featureLinks = null;
    Object currentColour;
    String[] renderOrder;
    FontMetrics fm;
    int charOffset;
    float transparency = 1.0f;
    TransparencySetter transparencySetter = null;
    static String lastFeatureAdded;
    static String lastFeatureGroupAdded;
    static String lastDescriptionAdded;
    int featureIndex = 0;
    boolean deleteFeature = false;
    Panel colourPanel;
    boolean overview = false;
    SequenceI lastSeq;
    SequenceFeature[] sequenceFeatures;
    int sfSize;
    int sfindex;
    int spos;
    int epos;
    char s;
    int i;

    public FeatureRenderer(AlignViewport av) {
        this.av = av;
        if (!System.getProperty("java.version").startsWith("1.1")) {
            this.transparencySetter = new TransparencySetter();
        }
    }

    public void transferSettings(FeatureRenderer fr) {
        this.renderOrder = fr.renderOrder;
        this.featureGroups = fr.featureGroups;
        this.featureColours = fr.featureColours;
        this.transparency = fr.transparency;
    }

    boolean amendFeatures(final SequenceI[] sequences, final SequenceFeature[] features, boolean newFeatures, final AlignmentPanel ap) {
        Panel tmp;
        Panel bigPanel = new Panel(new BorderLayout());
        final TextField name = new TextField(16);
        final TextField source = new TextField(16);
        final TextArea description = new TextArea(3, 35);
        final TextField start = new TextField(8);
        final TextField end = new TextField(8);
        Button deleteButton = new Button("Delete");
        this.deleteFeature = false;
        this.colourPanel = new Panel(null);
        this.colourPanel.setSize(110, 15);
        final FeatureRenderer fr = this;
        Panel panel = new Panel(new GridLayout(3, 1));
        if (!newFeatures && features.length > 1) {
            panel = new Panel(new GridLayout(4, 1));
            tmp = new Panel();
            tmp.add(new Label("Select Feature: "));
            final Choice overlaps = new Choice();
            for (int i = 0; i < features.length; ++i) {
                String item = features[i].getType() + "/" + features[i].getBegin() + "-" + features[i].getEnd();
                if (features[i].getFeatureGroup() != null) {
                    item = item + " (" + features[i].getFeatureGroup() + ")";
                }
                overlaps.addItem(item);
            }
            tmp.add(overlaps);
            overlaps.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    Color col;
                    int index = overlaps.getSelectedIndex();
                    if (index != -1) {
                        FeatureRenderer.this.featureIndex = index;
                        name.setText(features[index].getType());
                        description.setText(features[index].getDescription());
                        source.setText(features[index].getFeatureGroup());
                        start.setText(features[index].getBegin() + "");
                        end.setText(features[index].getEnd() + "");
                        SearchResults highlight = new SearchResults();
                        highlight.addResult(sequences[0], features[index].getBegin(), features[index].getEnd());
                        ap.seqPanel.seqCanvas.highlightSearchResults(highlight);
                    }
                    if ((col = FeatureRenderer.this.getColour(name.getText())) == null) {
                        col = new UserColourScheme().createColourFromName(name.getText());
                    }
                    FeatureRenderer.this.colourPanel.setBackground(col);
                }
            });
            panel.add(tmp);
        }
        tmp = new Panel();
        panel.add(tmp);
        tmp.add(new Label("Name: ", 2));
        tmp.add(name);
        tmp = new Panel();
        panel.add(tmp);
        tmp.add(new Label("Group: ", 2));
        tmp.add(source);
        tmp = new Panel();
        panel.add(tmp);
        tmp.add(new Label("Colour: ", 2));
        tmp.add(this.colourPanel);
        bigPanel.add((Component)panel, "North");
        panel = new Panel();
        panel.add(new Label("Description: ", 2));
        panel.add(new ScrollPane().add(description));
        if (!newFeatures) {
            bigPanel.add((Component)panel, "South");
            panel = new Panel();
            panel.add(new Label(" Start:", 2));
            panel.add(start);
            panel.add(new Label("  End:", 2));
            panel.add(end);
            bigPanel.add((Component)panel, "Center");
        } else {
            bigPanel.add((Component)panel, "Center");
        }
        if (lastFeatureAdded == null) {
            lastFeatureAdded = features[0].type != null ? features[0].type : "feature_1";
        }
        if (lastFeatureGroupAdded == null) {
            if (features[0].featureGroup != null) {
                lastFeatureGroupAdded = features[0].featureGroup;
            } else {
                lastFeatureAdded = "Jalview";
            }
        }
        String title = newFeatures ? "Create New Sequence Feature(s)" : "Amend/Delete Features for " + sequences[0].getName();
        final JVDialog dialog = new JVDialog(ap.alignFrame, title, true, 385, 240);
        dialog.setMainPanel(bigPanel);
        if (newFeatures) {
            name.setText(lastFeatureAdded);
            source.setText(lastFeatureGroupAdded);
        } else {
            dialog.ok.setLabel("Amend");
            dialog.buttonPanel.add((Component)deleteButton, 1);
            deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FeatureRenderer.this.deleteFeature = true;
                    dialog.setVisible(false);
                }
            });
            name.setText(features[0].getType());
            source.setText(features[0].getFeatureGroup());
        }
        start.setText(features[0].getBegin() + "");
        end.setText(features[0].getEnd() + "");
        description.setText(features[0].getDescription());
        Color col = this.getColour(name.getText());
        if (col == null) {
            col = new UserColourScheme().createColourFromName(name.getText());
        }
        this.colourPanel.setBackground(col);
        dialog.setResizable(true);
        this.colourPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                new UserDefinedColours(fr, ap.alignFrame);
            }
        });
        dialog.setVisible(true);
        FeaturesFile ffile = new FeaturesFile();
        if (dialog.accept) {
            this.lastSeq = null;
            lastFeatureAdded = name.getText().trim();
            lastFeatureGroupAdded = source.getText().trim();
            lastDescriptionAdded = description.getText().replace('\n', ' ');
        }
        if (lastFeatureGroupAdded != null && lastFeatureGroupAdded.length() < 1) {
            lastFeatureGroupAdded = null;
        }
        if (!newFeatures) {
            SequenceFeature sf = features[this.featureIndex];
            if (dialog.accept) {
                sf.type = lastFeatureAdded;
                sf.featureGroup = lastFeatureGroupAdded;
                sf.description = lastDescriptionAdded;
                this.setColour(sf.type, this.colourPanel.getBackground());
                try {
                    sf.begin = Integer.parseInt(start.getText());
                    sf.end = Integer.parseInt(end.getText());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                ffile.parseDescriptionHTML(sf, false);
            }
            if (this.deleteFeature) {
                sequences[0].deleteFeature(sf);
            }
        } else {
            if (dialog.accept && name.getText().length() > 0) {
                for (int i = 0; i < sequences.length; ++i) {
                    features[i].type = lastFeatureAdded;
                    features[i].featureGroup = lastFeatureGroupAdded;
                    features[i].description = lastDescriptionAdded;
                    sequences[i].addSequenceFeature(features[i]);
                    ffile.parseDescriptionHTML(features[i], false);
                }
                if (this.av.featuresDisplayed == null) {
                    this.av.featuresDisplayed = new Hashtable();
                }
                if (this.featureGroups == null) {
                    this.featureGroups = new Hashtable();
                }
                col = this.colourPanel.getBackground();
                this.setColour(lastFeatureAdded, col);
                if (lastFeatureGroupAdded != null) {
                    this.featureGroups.put(lastFeatureGroupAdded, new Boolean(true));
                    this.av.featuresDisplayed.put(lastFeatureGroupAdded, new Integer(col.getRGB()));
                }
                this.findAllFeatures();
                String[] tro = new String[this.renderOrder.length];
                tro[0] = this.renderOrder[this.renderOrder.length - 1];
                System.arraycopy(this.renderOrder, 0, tro, 1, this.renderOrder.length - 1);
                this.renderOrder = tro;
                ap.paintAlignment(true);
                return true;
            }
            return false;
        }
        this.findAllFeatures();
        ap.paintAlignment(true);
        return true;
    }

    public Color findFeatureColour(Color initialCol, SequenceI seq, int i) {
        this.overview = true;
        if (!this.av.showSequenceFeatures) {
            return initialCol;
        }
        this.lastSeq = seq;
        this.sequenceFeatures = this.lastSeq.getSequenceFeatures();
        if (this.sequenceFeatures == null) {
            return initialCol;
        }
        this.sfSize = this.sequenceFeatures.length;
        if (Comparison.isGap(this.lastSeq.getCharAt(i))) {
            return Color.white;
        }
        this.currentColour = null;
        this.drawSequence(null, this.lastSeq, this.lastSeq.findPosition(i), -1, -1);
        if (this.currentColour == null) {
            return initialCol;
        }
        return new Color((Integer)this.currentColour);
    }

    public synchronized void drawSequence(Graphics g, SequenceI seq, int start, int end, int y1) {
        if (seq.getSequenceFeatures() == null || seq.getSequenceFeatures().length == 0) {
            return;
        }
        if (this.transparencySetter != null && g != null) {
            this.transparencySetter.setTransparency(g, this.transparency);
        }
        if (this.lastSeq == null || seq != this.lastSeq || this.sequenceFeatures != seq.getSequenceFeatures()) {
            this.lastSeq = seq;
            this.sequenceFeatures = seq.getSequenceFeatures();
            this.sfSize = this.sequenceFeatures.length;
        }
        if (this.av.featuresDisplayed == null || this.renderOrder == null) {
            this.findAllFeatures();
            if (this.av.featuresDisplayed.size() < 1) {
                return;
            }
            this.sequenceFeatures = seq.getSequenceFeatures();
            this.sfSize = this.sequenceFeatures.length;
        }
        if (!this.overview) {
            this.spos = this.lastSeq.findPosition(start);
            this.epos = this.lastSeq.findPosition(end);
            if (g != null) {
                this.fm = g.getFontMetrics();
            }
        }
        for (int renderIndex = 0; renderIndex < this.renderOrder.length; ++renderIndex) {
            String type = this.renderOrder[renderIndex];
            if (!this.av.featuresDisplayed.containsKey(type)) continue;
            this.sfindex = 0;
            while (this.sfindex < this.sfSize) {
                if (this.sequenceFeatures[this.sfindex].type.equals(type) && (this.featureGroups == null || this.sequenceFeatures[this.sfindex].featureGroup == null || !this.featureGroups.containsKey(this.sequenceFeatures[this.sfindex].featureGroup) || ((Boolean)this.featureGroups.get(this.sequenceFeatures[this.sfindex].featureGroup)).booleanValue()) && (this.overview || this.sequenceFeatures[this.sfindex].getBegin() <= this.epos && this.sequenceFeatures[this.sfindex].getEnd() >= this.spos)) {
                    if (this.overview) {
                        if (this.sequenceFeatures[this.sfindex].begin <= start && this.sequenceFeatures[this.sfindex].end >= start) {
                            this.currentColour = this.av.featuresDisplayed.get(this.sequenceFeatures[this.sfindex].type);
                        }
                    } else if (this.sequenceFeatures[this.sfindex].type.equals("disulfide bond")) {
                        this.renderFeature(g, seq, seq.findIndex(this.sequenceFeatures[this.sfindex].begin) - 1, seq.findIndex(this.sequenceFeatures[this.sfindex].begin) - 1, new Color((Integer)this.av.featuresDisplayed.get(this.sequenceFeatures[this.sfindex].type)), start, end, y1);
                        this.renderFeature(g, seq, seq.findIndex(this.sequenceFeatures[this.sfindex].end) - 1, seq.findIndex(this.sequenceFeatures[this.sfindex].end) - 1, new Color((Integer)this.av.featuresDisplayed.get(this.sequenceFeatures[this.sfindex].type)), start, end, y1);
                    } else {
                        this.renderFeature(g, seq, seq.findIndex(this.sequenceFeatures[this.sfindex].begin) - 1, seq.findIndex(this.sequenceFeatures[this.sfindex].end) - 1, this.getColour(this.sequenceFeatures[this.sfindex].type), start, end, y1);
                    }
                }
                ++this.sfindex;
            }
        }
        if (this.transparencySetter != null && g != null) {
            this.transparencySetter.setTransparency(g, 1.0f);
        }
    }

    void renderFeature(Graphics g, SequenceI seq, int fstart, int fend, Color featureColour, int start, int end, int y1) {
        if (fstart <= end && fend >= start) {
            if (fstart < start) {
                fstart = start;
            }
            if (fend >= end) {
                fend = end;
            }
            this.i = fstart;
            while (this.i <= fend) {
                this.s = seq.getCharAt(this.i);
                if (!Comparison.isGap(this.s)) {
                    g.setColor(featureColour);
                    g.fillRect((this.i - start) * this.av.charWidth, y1, this.av.charWidth, this.av.charHeight);
                    if (this.av.validCharWidth) {
                        g.setColor(Color.white);
                        this.charOffset = (this.av.charWidth - this.fm.charWidth(this.s)) / 2;
                        g.drawString(String.valueOf(this.s), this.charOffset + this.av.charWidth * (this.i - start), y1 + this.av.charHeight - this.av.charHeight / 5);
                    }
                }
                ++this.i;
            }
        }
    }

    void findAllFeatures() {
        UserColourScheme ucs = new UserColourScheme();
        this.av.featuresDisplayed = new Hashtable();
        Vector<String> allfeatures = new Vector<String>();
        for (int i = 0; i < this.av.alignment.getHeight(); ++i) {
            SequenceFeature[] features = this.av.alignment.getSequenceAt(i).getSequenceFeatures();
            if (features == null) continue;
            for (int index = 0; index < features.length; ++index) {
                if (this.av.featuresDisplayed.containsKey(features[index].getType())) continue;
                if (this.getColour(features[index].getType()) == null) {
                    this.featureColours.put(features[index].getType(), ucs.createColourFromName(features[index].getType()));
                }
                this.av.featuresDisplayed.put(features[index].getType(), new Integer(this.getColour(features[index].getType()).getRGB()));
                allfeatures.addElement(features[index].getType());
            }
        }
        this.renderOrder = new String[allfeatures.size()];
        Enumeration en = allfeatures.elements();
        int i = allfeatures.size() - 1;
        while (en.hasMoreElements()) {
            this.renderOrder[i] = en.nextElement().toString();
            --i;
        }
    }

    public Color getColour(String featureType) {
        if (!this.featureColours.containsKey(featureType)) {
            UserColourScheme ucs = new UserColourScheme();
            Color col = ucs.createColourFromName(featureType);
            this.featureColours.put(featureType, col);
            return col;
        }
        return (Color)this.featureColours.get(featureType);
    }

    public void setColour(String featureType, Color col) {
        this.featureColours.put(featureType, col);
    }

    public void setFeaturePriority(Object[][] data) {
        if (this.av.featuresDisplayed != null) {
            this.av.featuresDisplayed.clear();
        }
        this.renderOrder = new String[data.length];
        if (data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                String type = data[i][0].toString();
                this.setColour(type, (Color)data[i][1]);
                if (((Boolean)data[i][2]).booleanValue()) {
                    this.av.featuresDisplayed.put(type, new Integer(this.getColour(type).getRGB()));
                }
                this.renderOrder[data.length - i - 1] = type;
            }
        }
    }

    public String[] getGroups() {
        this.buildGroupHash();
        if (this.featureGroups != null) {
            String[] gps = new String[this.featureGroups.size()];
            Enumeration gn = this.featureGroups.keys();
            int i = 0;
            while (gn.hasMoreElements()) {
                gps[i++] = (String)gn.nextElement();
            }
            return gps;
        }
        return null;
    }

    public String[] getGroups(boolean visible) {
        this.buildGroupHash();
        if (this.featureGroups != null) {
            Vector<String> gp = new Vector<String>();
            Enumeration gn = this.featureGroups.keys();
            while (gn.hasMoreElements()) {
                String nm = (String)gn.nextElement();
                Boolean state = (Boolean)this.featureGroups.get(nm);
                if (state != visible) continue;
                gp.addElement(nm);
            }
            Object[] gps = new String[gp.size()];
            gp.copyInto(gps);
            int i = 0;
            while (gn.hasMoreElements()) {
                gps[i++] = (String)gn.nextElement();
            }
            return gps;
        }
        return null;
    }

    public void setGroupState(String[] toset, boolean visible) {
        this.buildGroupHash();
        if (toset != null && toset.length > 0 && this.featureGroups != null) {
            boolean rdrw = false;
            for (int i = 0; i < toset.length; ++i) {
                Object st = this.featureGroups.get(toset[i]);
                if (st == null) continue;
                this.featureGroups.put(toset[i], new Boolean(visible));
                rdrw = rdrw || visible != (Boolean)st;
            }
            if (rdrw) {
                if (this.av != null) {
                    if (this.av.featureSettings != null) {
                        this.av.featureSettings.rebuildGroups();
                        this.av.featureSettings.resetTable(true);
                    } else {
                        this.buildFeatureHash();
                    }
                }
                if (this.av != null) {
                    this.av.alignmentChanged(null);
                }
            }
        }
    }

    public boolean buildGroupHash() {
        boolean alignmentHasFeatures = false;
        if (this.featureGroups == null) {
            this.featureGroups = new Hashtable();
        }
        Vector<String> allFeatures = new Vector<String>();
        Vector<String> allGroups = new Vector<String>();
        for (int i = 0; i < this.av.alignment.getHeight(); ++i) {
            if (this.av.alignment.getSequenceAt(i).getSequenceFeatures() == null) continue;
            alignmentHasFeatures = true;
            SequenceFeature[] tmpfeatures = this.av.alignment.getSequenceAt(i).getSequenceFeatures();
            for (int index = 0; index < tmpfeatures.length; ++index) {
                String group;
                if (tmpfeatures[index].getFeatureGroup() != null && !allGroups.contains(group = tmpfeatures[index].featureGroup)) {
                    allGroups.addElement(group);
                    boolean visible = true;
                    if (this.featureGroups.containsKey(group)) {
                        visible = (Boolean)this.featureGroups.get(group);
                    } else {
                        this.featureGroups.put(group, new Boolean(visible));
                    }
                }
                if (allFeatures.contains(tmpfeatures[index].getType())) continue;
                allFeatures.addElement(tmpfeatures[index].getType());
            }
        }
        return alignmentHasFeatures;
    }

    public boolean buildFeatureHash() {
        boolean alignmentHasFeatures = false;
        if (this.featureGroups == null) {
            alignmentHasFeatures = this.buildGroupHash();
        }
        if (!alignmentHasFeatures) {
            return false;
        }
        Hashtable fdisp = this.av.featuresDisplayed;
        Vector<String> allFeatures = new Vector<String>();
        for (int i = 0; i < this.av.alignment.getHeight(); ++i) {
            if (this.av.alignment.getSequenceAt(i).getSequenceFeatures() == null) continue;
            alignmentHasFeatures = true;
            SequenceFeature[] tmpfeatures = this.av.alignment.getSequenceAt(i).getSequenceFeatures();
            for (int index = 0; index < tmpfeatures.length; ++index) {
                String group;
                boolean visible = true;
                if (tmpfeatures[index].getFeatureGroup() != null && this.featureGroups.containsKey(group = tmpfeatures[index].featureGroup)) {
                    visible = (Boolean)this.featureGroups.get(group);
                }
                if (!visible || allFeatures.contains(tmpfeatures[index].getType())) continue;
                allFeatures.addElement(tmpfeatures[index].getType());
            }
        }
        if (allFeatures.size() > 0) {
            int i;
            String[] neworder = new String[allFeatures.size()];
            int p = neworder.length - 1;
            for (i = this.renderOrder.length - 1; i >= 0; --i) {
                if (allFeatures.contains(this.renderOrder[i])) {
                    neworder[p--] = this.renderOrder[i];
                    allFeatures.removeElement(this.renderOrder[i]);
                    continue;
                }
                this.av.featuresDisplayed.remove(this.renderOrder[i]);
            }
            for (i = allFeatures.size() - 1; i > 0; ++i) {
                Object e = allFeatures.elementAt(i);
                if (e == null) continue;
                neworder[p--] = (String)e;
                this.av.featuresDisplayed.put(e, this.getColour((String)e));
            }
            this.renderOrder = neworder;
            return true;
        }
        return alignmentHasFeatures;
    }
}

