/* $Id: print.c,v 1.29 2009-01-28 14:38:02 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"

/* ==================== RUNTIME_RM || RUNTIME_PM ==================== */
#if defined(RUNTIME_RM) || defined(RUNTIME_PM)

#include "compiler.h"
#ifdef RUNTIME_PM
CODE32;
#else
CODE16;
#endif

#include "stdio.h"
#include <stdarg.h>
#include "io.h"
#include "const.h"
#include "video.h"

void
dprintf(const char *fmt, ...)
{
	va_list args;
	char buf[64];
	int x;
	
	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);

	for (x = 0; buf[x] != '\0'; x++) {
		outb(buf[x], 0xffff);
	}
}

void
putcstr(CONST char *str)
{
	for (;;) {
		char c;

		c = const_get(*str);
		if (c == '\0') {
			break;
		}
		putchar(c);
		str++;
	}
}

#endif /* RUNTIME_RM || RUNTIME_PM */
/* ==================== INIT ==================== */
#if defined(INIT_RM)

#include "compiler.h"
CODE16;

#include "stdio.h"
#include <stdarg.h>
#include "video.h"
#include "io.h"
#include "const.h"

void
bprintf(const char *fmt, ...)
{
	va_list args;
	char buf[64];
	int x;
	
	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);

	for (x = 0; buf[x] != '\0'; x++) {
		putchar(buf[x]);
	}
}

#endif /* INIT_RM */
