/* tp-test-contactlist.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "TpTests", gir_namespace = "TpTests", gir_version = "contactlist", lower_case_cprefix = "tp_tests_")]
namespace TpTests {
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_backend_get_type ()")]
	public class Backend : GLib.Object {
		[CCode (has_construct_function = false)]
		public Backend ();
		public void* add_account (string protocol, string user_id, string cm_name, string account);
		public unowned TpTests.ContactsConnection get_connection_for_handle (void* handle);
		public void remove_account (void* handle);
		public void set_up ();
		public void tear_down ();
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_contact_list_manager_get_type ()")]
	public class ContactListManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ContactListManager ();
		public void add_initial_contacts (uint n_members, TelepathyGLib.Handle members);
		public void add_to_group (string group_name, TelepathyGLib.Handle member);
		public void authorize_publication (uint n_members, TelepathyGLib.Handle members);
		public void remove (uint n_members, TelepathyGLib.Handle members);
		public void remove_from_group (string group_name, TelepathyGLib.Handle member);
		public void request_subscription (uint n_members, TelepathyGLib.Handle members, string message);
		public void unpublish (uint n_members, TelepathyGLib.Handle members);
		public void unsubscribe (uint n_members, TelepathyGLib.Handle members);
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_contacts_connection_get_type ()")]
	public class ContactsConnection : TpTests.SimpleConnection {
		public TelepathyGLib.ContactsMixin contacts_mixin;
		public TelepathyGLib.PresenceMixin presence_mixin;
		[CCode (has_construct_function = false)]
		protected ContactsConnection ();
		public void change_aliases ([CCode (array_length_cname = "n", array_length_pos = 0.5, array_length_type = "guint")] TelepathyGLib.Handle[] handles, [CCode (array_length_cname = "n", array_length_pos = 0.5, array_length_type = "guint")] string[] aliases);
		public void change_avatar_tokens (uint n, TelepathyGLib.Handle handles, string tokens);
		public void change_capabilities (GLib.HashTable<void*,void*> capabilities);
		public void change_locations (uint n, TelepathyGLib.Handle handles, GLib.HashTable<void*,void*> locations);
		public void change_presences (uint n, TelepathyGLib.Handle handles, TpTests.ContactsConnectionPresenceStatusIndex indexes, string messages);
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_legacy_contacts_connection_get_type ()")]
	public class LegacyContactsConnection : TpTests.ContactsConnection {
		[CCode (has_construct_function = false)]
		protected LegacyContactsConnection ();
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_no_requests_connection_get_type ()")]
	public class NoRequestsConnection : TpTests.ContactsConnection {
		[CCode (has_construct_function = false)]
		protected NoRequestsConnection ();
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_props_group_text_channel_get_type ()")]
	public class PropsGroupTextChannel : TpTests.PropsTextChannel {
		public TelepathyGLib.GroupMixin group;
		[CCode (has_construct_function = false)]
		protected PropsGroupTextChannel ();
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_props_text_channel_get_type ()")]
	public class PropsTextChannel : TpTests.TextChannelNull {
		public weak GLib.HashTable<void*,void*> dbus_property_interfaces_retrieved;
		[CCode (has_construct_function = false)]
		protected PropsTextChannel ();
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_room_list_chan_get_type ()")]
	public class RoomListChan : GLib.Object {
		[CCode (has_construct_function = false)]
		protected RoomListChan ();
		[NoAccessorMethod]
		public string server { owned get; construct; }
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", has_type_id = false)]
	[Compact]
	public class RoomListChanPriv {
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_simple_account_get_type ()")]
	public class SimpleAccount : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SimpleAccount ();
		public void removed ();
		public void set_connection (string object_path);
		public void set_enabled (bool enabled);
		public void set_presence (TelepathyGLib.ConnectionPresenceType presence, string status, string message);
		[NoAccessorMethod]
		public bool connect_automatically { get; }
		[NoAccessorMethod]
		public uint connection_status { get; }
		[NoAccessorMethod]
		public uint connection_status_reason { get; }
		[NoAccessorMethod]
		public string display_name { owned get; }
		[NoAccessorMethod]
		public bool enabled { get; }
		[NoAccessorMethod]
		public bool has_been_online { get; }
		[NoAccessorMethod]
		public string icon { owned get; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] interfaces { owned get; }
		[NoAccessorMethod]
		public string nickname { owned get; }
		[NoAccessorMethod]
		public string normalized_name { owned get; }
		[NoAccessorMethod]
		public GLib.Value storage_identifier { owned get; }
		[NoAccessorMethod]
		public string storage_provider { owned get; }
		[NoAccessorMethod]
		public uint storage_restrictions { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] uri_schemes { owned get; }
		[NoAccessorMethod]
		public bool valid { get; }
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_simple_account_manager_get_type ()")]
	public class SimpleAccountManager : GLib.Object {
		public weak string create_cm;
		public weak string create_display_name;
		public weak GLib.HashTable<void*,void*> create_parameters;
		public weak GLib.HashTable<void*,void*> create_properties;
		public weak string create_protocol;
		[CCode (has_construct_function = false)]
		protected SimpleAccountManager ();
		public void add_account (string object_path, bool valid);
		public void remove_account (string object_path);
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] interfaces { owned get; }
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_simple_connection_get_type ()")]
	public class SimpleConnection : TelepathyGLib.BaseConnection {
		[CCode (has_construct_function = false)]
		public SimpleConnection (string account, string protocol);
		public string ensure_room_list_chan (string server, GLib.HashTable<void*,void*> props);
		public string ensure_text_chan (string target_id, GLib.HashTable<void*,void*> props);
		public void inject_disconnect ();
		public void set_get_self_handle_error (GLib.Quark domain, int code, string message);
		public void set_identifier (string identifier);
		[NoAccessorMethod]
		public string account { owned get; construct; }
		[NoAccessorMethod]
		public bool break_0192_properties { get; construct; }
		[NoAccessorMethod]
		public uint dbus_status { get; }
		public signal void got_self_handle ();
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", type_id = "tp_tests_text_channel_null_get_type ()")]
	public class TextChannelNull : GLib.Object {
		public uint get_channel_type_called;
		public uint get_handle_called;
		public uint get_interfaces_called;
		[CCode (has_construct_function = false)]
		protected TextChannelNull ();
		public void close ();
		[NoAccessorMethod]
		public TelepathyGLib.BaseConnection connection { owned get; construct; }
		[NoAccessorMethod]
		public uint initiator_handle { get; }
		[NoAccessorMethod]
		public string initiator_id { owned get; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] interfaces { owned get; }
		[NoAccessorMethod]
		public bool requested { get; }
		[NoAccessorMethod]
		public string target_id { owned get; }
	}
	[CCode (cheader_filename = "tp-test-contactlist.h", cprefix = "TP_TESTS_CONTACTS_CONNECTION_STATUS_", has_type_id = false)]
	public enum ContactsConnectionPresenceStatusIndex {
		AVAILABLE,
		BUSY,
		AWAY,
		OFFLINE,
		UNKNOWN,
		ERROR
	}
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void abort_after (uint sec);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void connection_assert_disconnect_succeeds (TelepathyGLib.Connection connection);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void create_and_connect_conn (GLib.Type conn_type, string account, TelepathyGLib.BaseConnection service_conn, TelepathyGLib.Connection client_conn);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void create_conn (GLib.Type conn_type, string account, bool connect, TelepathyGLib.BaseConnection service_conn, TelepathyGLib.Connection client_conn);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void init (int argc, string argv);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void proxy_run_until_dbus_queue_processed (void* proxy);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void proxy_run_until_prepared (void* proxy, GLib.Quark features);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static bool proxy_run_until_prepared_or_failed (void* proxy, GLib.Quark features) throws GLib.Error;
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void result_ready_cb (GLib.Object object, GLib.AsyncResult res, void* user_data);
	[CCode (cheader_filename = "tp-test-contactlist.h")]
	public static void run_until_result (GLib.AsyncResult result);
}
