/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <math.h>
#include <stdlib.h>
#include "sample_freq_strip.h"

#ifndef __GTK_DIAL_H__
 #include "gtkdial.h"
#endif

/*this struct is used by the sample change dialog*/
/* so enough info can be passed to the callback actually */
/* changing the sample */
typedef struct sample_change_message{
  GtkFileSelection *selector;
  int              seq_handle;
} sample_change_message;


static void sfs_freq_callback(GtkAdjustment *adj, gpointer data)
{
  event *e; 
  event_bookeeper *eb;
  double pitch;

  pitch = pow(2,adj->value);
  eb = (event_bookeeper*)data;
  e = event_pitch_change_new(eb->seq_handle,pitch);

  if(eb != NULL)
    clean_bookeeper(eb,sequencer);
  seq_register_event(sequencer,eb->step,e);
  event_list_add(eb->last_events,e);
}

static void execute_change_sample(GtkFileSelection *selector, gpointer data) 
{
  raw_wave *samp;
  char *fn;

  sample_change_message *scm = (sample_change_message *)data;
  samp = (raw_wave*)sequencer->victims[(scm->seq_handle)];

  fn = (char*) gtk_file_selection_get_filename (GTK_FILE_SELECTION(scm->selector));
  raw_wave_set_sample_file(samp, fn);
  samp->current_index = samp->length; // ??? so sample isn't played
  //free(fn); // hm. apparently this isn't such a good idea.
  free(scm);
}
static void change_samp_callback (GtkWidget *widget, gpointer data)
{
  GtkWidget *file_selector;
  /* char* new_filename; */
  sample_change_message *scm;
  file_selector = gtk_file_selection_new("choose new sample");

  scm = (sample_change_message *)malloc(sizeof(sample_change_message));
  scm->selector = (GtkFileSelection*)file_selector;
  scm->seq_handle = (int)data;

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (execute_change_sample), scm);
                            
    /* Ensure that the dialog box is destroyed when the user clicks a button. */
    
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) file_selector);

  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) file_selector);
    
  /* Display that dialog */
  
  gtk_widget_show (file_selector);

  
}

GtkWidget *sample_freq_strip_new( int seq_handle, seq *s, 
				  int num_steps, GtkStyle *dial_style)
{
  GtkWidget *sample_chooser;
  GtkObject *range;
  GtkWidget *dial;
  GtkWidget *box;
  /* GtkWidget *sample_choose_box; */
  event_bookeeper *eb;
  
  int i;


  /*sample_choose_box = gtk_hbox_new(TRUE,10); */
  sample_chooser = gtk_button_new_with_label(" S ");
  /*  gtk_box_pack_start(GTK_BOX(sample_choose_box),sample_chooser,FALSE,FALSE,
      2);      */
  gtk_signal_connect (GTK_OBJECT (sample_chooser), "clicked",
		      GTK_SIGNAL_FUNC (change_samp_callback), (gpointer)seq_handle);
  gtk_widget_show(sample_chooser);
  /*  gtk_widget_show(sample_choose_box); */
  box = gtk_hbox_new(TRUE,10);
  gtk_box_pack_start(GTK_BOX(box),sample_chooser,FALSE,FALSE,
		     0);      
  
  for(i = 0; i < num_steps;i++)
    {
      eb = e_bookeeper_new(i, seq_handle);
      /* from one octave down to one up */
      range = gtk_adjustment_new(0,-1,1,0.1,0.1,0.1);
      dial = gtk_dial_new(GTK_ADJUSTMENT(range)); 
      gtk_signal_connect (GTK_OBJECT (range), "value_changed",
			  GTK_SIGNAL_FUNC (sfs_freq_callback), (gpointer)eb );
      GTK_ADJUSTMENT(range)->value = 0;
      sfs_freq_callback(GTK_ADJUSTMENT(range),(gpointer)eb);
      gtk_box_pack_start(GTK_BOX(box),dial,FALSE,FALSE,
			 2);      
      if((i + 1) % 4 == 0 && i != num_steps - 1)
	{
	  GtkWidget *sep = gtk_vseparator_new();
	  gtk_box_pack_start(GTK_BOX(box),
			     sep,FALSE,FALSE,0);
	  gtk_widget_show(sep);
	}
      
      gtk_widget_set_style(dial,dial_style);
      gtk_widget_set_usize(dial,25,25);
      gtk_widget_show(dial);
    }

  return box;
  
}




/*
  Local Variables:
  mode: font-lock
  End:
*/

