-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/esql/esql_variables.adb,v $
--  Description     : Subsituation of strings
--  Author          : Michael Erdmann                                        --
--  Created         : 03.08.2002                                             --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2003/11/16 12:11:18 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2002 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                        use Ada.Text_IO;
with GNU.DB.Support.Tables;
with GNU.DB.Support;                     use GNU.DB.Support;

pragma Elaborate_All( GNU.DB.Support.Tables );

package body ESQL_Variables  is

   Version : constant String :=
      "$Id: esql_variables.adb,v 1.6 2003/11/16 12:11:18 merdmann Exp $" ;
   pragma Unreferenced( Version );

   ---------------------
   -- Variable_Record --
   ---------------------
   type Variable_Record is record
         Value : Unbounded_String := Null_Unbounded_String;
         Used  : Boolean          := False;
      end record;

   package Variable_Table is new Tables( Variable_Record );
   use Variable_Table;

   -- This table contains all variables known to gesql
   VT : Variable_Table.Tree_Node_Access := Variable_Table.Create_Tree;

   ---------
   -- Add --
   ---------
   procedure Add(
      Name  : in String;
      Value : in String ) is
      -- add a new variable to the table of variables.
      V     : Variable_Record ;
   begin
      V.Value := To_Unbounded_String(Value);
      V.Used  := False;

      Variable_Table.Insert( VT, Name, V );
   exception
      when Variable_Table.Already_Stored =>
         raise Existing;
   end Add;

   -----------
   -- Value --
   -----------
   function Value(
      Name   : in String ) return Unbounded_String is
      -- retrieve the value of a variable. If found assume the
      -- variable as used and mark it.
      Result : Variable_Record;
   begin
      Variable_Table.Fetch( VT, Name, Result );
      if not Result.Used then
         Result.Used := True;
         Variable_Table.Update( VT, Name, Result );
      end if;

      return Result.Value;

   exception
      when Variable_Table.Entry_Not_Found =>
         raise Not_Existing;
   end Value;

end ESQL_Variables;



