// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakerfeaturestoreruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemakerfeaturestoreruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The PutRecord API is used to ingest a list of Records into your feature group.
//
// If a new record’s EventTime is greater, the new record is written to both the
// OnlineStore and OfflineStore . Otherwise, the record is a historic record and it
// is written only to the OfflineStore .
//
// You can specify the ingestion to be applied to the OnlineStore , OfflineStore ,
// or both by using the TargetStores request parameter.
//
// You can set the ingested record to expire at a given time to live (TTL)
// duration after the record’s event time, ExpiresAt = EventTime + TtlDuration , by
// specifying the TtlDuration parameter. A record level TtlDuration is set when
// specifying the TtlDuration parameter using the PutRecord API call. If the input
// TtlDuration is null or unspecified, TtlDuration is set to the default feature
// group level TtlDuration . A record level TtlDuration supersedes the group level
// TtlDuration .
func (c *Client) PutRecord(ctx context.Context, params *PutRecordInput, optFns ...func(*Options)) (*PutRecordOutput, error) {
	if params == nil {
		params = &PutRecordInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutRecord", params, optFns, c.addOperationPutRecordMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutRecordOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutRecordInput struct {

	// The name or Amazon Resource Name (ARN) of the feature group that you want to
	// insert the record into.
	//
	// This member is required.
	FeatureGroupName *string

	// List of FeatureValues to be inserted. This will be a full over-write. If you
	// only want to update few of the feature values, do the following:
	//
	//   - Use GetRecord to retrieve the latest record.
	//
	//   - Update the record returned from GetRecord .
	//
	//   - Use PutRecord to update feature values.
	//
	// This member is required.
	Record []types.FeatureValue

	// A list of stores to which you're adding the record. By default, Feature Store
	// adds the record to all of the stores that you're using for the FeatureGroup .
	TargetStores []types.TargetStore

	// Time to live duration, where the record is hard deleted after the expiration
	// time is reached; ExpiresAt = EventTime + TtlDuration . For information on
	// HardDelete, see the [DeleteRecord]API in the Amazon SageMaker API Reference guide.
	//
	// [DeleteRecord]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html
	TtlDuration *types.TtlDuration

	noSmithyDocumentSerde
}

type PutRecordOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutRecordMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutRecord{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutRecord{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutRecord"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpPutRecordValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutRecord(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutRecord(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutRecord",
	}
}
