
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQObject.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QObject>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QObject

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QObject::staticMetaObject);
}


#if QT_VERSION < 0x50000

#include <QRegExp>

  QObject *find_child_impl (QObject *object, const QString &name) 
  { 
    return object->findChild<QObject *> (name); 
  }
  QList<QObject *> find_children_impl (QObject *object, const QString &name)
  { 
    return object->findChildren<QObject *> (name); 
  }
  QList<QObject *> find_children_impl2 (QObject *object, const QRegExp &re)
  { 
    return object->findChildren<QObject *> (re); 
  }
#else

#include <QRegularExpression>

  QObject *find_child_impl (QObject *object, const QString &name, Qt::FindChildOptions options)
  { 
    return object->findChild<QObject *> (name, options); 
  }
  QList<QObject *> find_children_impl (QObject *object, const QString &name, Qt::FindChildOptions options)
  { 
    return object->findChildren<QObject *> (name, options); 
  }
  QList<QObject *> find_children_impl2 (QObject *object, const QRegularExpression &re, Qt::FindChildOptions options)
  { 
    return object->findChildren<QObject *> (re, options); 
  }
#endif

// bool QObject::blockSignals(bool b)


static void _init_f_blockSignals_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_blockSignals_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ret.write<bool > ((bool)((QObject *)cls)->blockSignals (arg1));
}


// const QList<QObject*> &QObject::children()


static void _init_f_children_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QList<QObject*> & > ();
}

static void _call_f_children_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QList<QObject*> & > ((const QList<QObject*> &)((QObject *)cls)->children ());
}


// QMetaObject::Connection QObject::connect(const QObject *sender, const char *signal, const char *member, Qt::ConnectionType type)


static void _init_f_connect_c7342 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("member");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("type", true, "Qt::AutoConnection");
  decl->add_arg<const qt_gsi::Converter<Qt::ConnectionType>::target_type & > (argspec_3);
  decl->set_return<QMetaObject::Connection > ();
}

static void _call_f_connect_c7342 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QObject *arg1 = gsi::arg_reader<const QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg3 = gsi::arg_reader<const char * >() (args, heap);
  const qt_gsi::Converter<Qt::ConnectionType>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ConnectionType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ConnectionType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ConnectionType>(heap, Qt::AutoConnection), heap);
  ret.write<QMetaObject::Connection > ((QMetaObject::Connection)((QObject *)cls)->connect (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::ConnectionType>(arg4).cref()));
}


// void QObject::deleteLater()


static void _init_f_deleteLater_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_deleteLater_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->deleteLater ();
}


// bool QObject::disconnect(const char *signal, const QObject *receiver, const char *member)


static void _init_f_disconnect_c5243 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal", true, "nullptr");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("receiver", true, "nullptr");
  decl->add_arg<const QObject * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("member", true, "nullptr");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_c5243 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  const QObject *arg2 = args ? gsi::arg_reader<const QObject * >() (args, heap) : gsi::arg_maker<const QObject * >() (nullptr, heap);
  const char *arg3 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<bool > ((bool)((QObject *)cls)->disconnect (arg1, arg2, arg3));
}


// bool QObject::disconnect(const QObject *receiver, const char *member)


static void _init_f_disconnect_c3620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_c3620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QObject *arg1 = gsi::arg_reader<const QObject * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<bool > ((bool)((QObject *)cls)->disconnect (arg1, arg2));
}


// void QObject::dumpObjectInfo()


static void _init_f_dumpObjectInfo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_dumpObjectInfo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->dumpObjectInfo ();
}


// void QObject::dumpObjectTree()


static void _init_f_dumpObjectTree_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_dumpObjectTree_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->dumpObjectTree ();
}


// QList<QByteArray> QObject::dynamicPropertyNames()


static void _init_f_dynamicPropertyNames_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QByteArray> > ();
}

static void _call_f_dynamicPropertyNames_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QByteArray> > ((QList<QByteArray>)((QObject *)cls)->dynamicPropertyNames ());
}


// bool QObject::event(QEvent *event)


static void _init_f_event_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_event_1217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)((QObject *)cls)->event (arg1));
}


// bool QObject::eventFilter(QObject *watched, QEvent *event)


static void _init_f_eventFilter_2411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_eventFilter_2411 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  QEvent *arg2 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)((QObject *)cls)->eventFilter (arg1, arg2));
}


// bool QObject::inherits(const char *classname)


static void _init_f_inherits_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("classname");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_inherits_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<bool > ((bool)((QObject *)cls)->inherits (arg1));
}


// void QObject::installEventFilter(QObject *filterObj)


static void _init_f_installEventFilter_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filterObj");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installEventFilter_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->installEventFilter (arg1);
}


// bool QObject::isWidgetType()


static void _init_f_isWidgetType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWidgetType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QObject *)cls)->isWidgetType ());
}


// bool QObject::isWindowType()


static void _init_f_isWindowType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWindowType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QObject *)cls)->isWindowType ());
}


// void QObject::killTimer(int id)


static void _init_f_killTimer_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_killTimer_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->killTimer (arg1);
}


// void QObject::moveToThread(QThread *thread)


static void _init_f_moveToThread_1303 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("thread");
  decl->add_arg<QThread * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveToThread_1303 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QThread *arg1 = gsi::arg_reader<QThread * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->moveToThread (arg1);
}


// QString QObject::objectName()


static void _init_f_objectName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_objectName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QObject *)cls)->objectName ());
}


// QObject *QObject::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QObject *)cls)->parent ());
}


// QVariant QObject::property(const char *name)


static void _init_f_property_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_property_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QVariant > ((QVariant)((QObject *)cls)->property (arg1));
}


// void QObject::removeEventFilter(QObject *obj)


static void _init_f_removeEventFilter_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("obj");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeEventFilter_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->removeEventFilter (arg1);
}


// void QObject::setObjectName(const QString &name)


static void _init_f_setObjectName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setObjectName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->setObjectName (arg1);
}


// void QObject::setParent(QObject *parent)


static void _init_f_setParent_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParent_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  if (arg1) {
    qt_gsi::qt_keep ((QObject *)cls);
  } else {
    qt_gsi::qt_release ((QObject *)cls);
  }
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject *)cls)->setParent (arg1);
}


// bool QObject::setProperty(const char *name, const QVariant &value)


static void _init_f_setProperty_3742 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setProperty_3742 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  ret.write<bool > ((bool)((QObject *)cls)->setProperty (arg1, arg2));
}


// bool QObject::signalsBlocked()


static void _init_f_signalsBlocked_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_signalsBlocked_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QObject *)cls)->signalsBlocked ());
}


// int QObject::startTimer(int interval, Qt::TimerType timerType)


static void _init_f_startTimer_2339 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("interval");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("timerType", true, "Qt::CoarseTimer");
  decl->add_arg<const qt_gsi::Converter<Qt::TimerType>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_startTimer_2339 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::TimerType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TimerType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TimerType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TimerType>(heap, Qt::CoarseTimer), heap);
  ret.write<int > ((int)((QObject *)cls)->startTimer (arg1, qt_gsi::QtToCppAdaptor<Qt::TimerType>(arg2).cref()));
}


// QThread *QObject::thread()


static void _init_f_thread_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QThread * > ();
}

static void _call_f_thread_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QThread * > ((QThread *)((QObject *)cls)->thread ());
}


// static QMetaObject::Connection QObject::connect(const QObject *sender, const char *signal, const QObject *receiver, const char *member, Qt::ConnectionType)


static void _init_f_connect_9231 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("receiver");
  decl->add_arg<const QObject * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("member");
  decl->add_arg<const char * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("arg5", true, "Qt::AutoConnection");
  decl->add_arg<const qt_gsi::Converter<Qt::ConnectionType>::target_type & > (argspec_4);
  decl->set_return<QMetaObject::Connection > ();
}

static void _call_f_connect_9231 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QObject *arg1 = gsi::arg_reader<const QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  const QObject *arg3 = gsi::arg_reader<const QObject * >() (args, heap);
  const char *arg4 = gsi::arg_reader<const char * >() (args, heap);
  const qt_gsi::Converter<Qt::ConnectionType>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ConnectionType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ConnectionType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ConnectionType>(heap, Qt::AutoConnection), heap);
  ret.write<QMetaObject::Connection > ((QMetaObject::Connection)QObject::connect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ConnectionType>(arg5).cref()));
}


// static QMetaObject::Connection QObject::connect(const QObject *sender, const QMetaMethod &signal, const QObject *receiver, const QMetaMethod &method, Qt::ConnectionType type)


static void _init_f_connect_10557 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("receiver");
  decl->add_arg<const QObject * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("method");
  decl->add_arg<const QMetaMethod & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("type", true, "Qt::AutoConnection");
  decl->add_arg<const qt_gsi::Converter<Qt::ConnectionType>::target_type & > (argspec_4);
  decl->set_return<QMetaObject::Connection > ();
}

static void _call_f_connect_10557 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QObject *arg1 = gsi::arg_reader<const QObject * >() (args, heap);
  const QMetaMethod &arg2 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  const QObject *arg3 = gsi::arg_reader<const QObject * >() (args, heap);
  const QMetaMethod &arg4 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  const qt_gsi::Converter<Qt::ConnectionType>::target_type & arg5 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::ConnectionType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::ConnectionType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::ConnectionType>(heap, Qt::AutoConnection), heap);
  ret.write<QMetaObject::Connection > ((QMetaObject::Connection)QObject::connect (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ConnectionType>(arg5).cref()));
}


// static bool QObject::disconnect(const QObject *sender, const char *signal, const QObject *receiver, const char *member)


static void _init_f_disconnect_7132 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("receiver");
  decl->add_arg<const QObject * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("member");
  decl->add_arg<const char * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_7132 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QObject *arg1 = gsi::arg_reader<const QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  const QObject *arg3 = gsi::arg_reader<const QObject * >() (args, heap);
  const char *arg4 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<bool > ((bool)QObject::disconnect (arg1, arg2, arg3, arg4));
}


// static bool QObject::disconnect(const QObject *sender, const QMetaMethod &signal, const QObject *receiver, const QMetaMethod &member)


static void _init_f_disconnect_8458 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sender");
  decl->add_arg<const QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("receiver");
  decl->add_arg<const QObject * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("member");
  decl->add_arg<const QMetaMethod & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_8458 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QObject *arg1 = gsi::arg_reader<const QObject * >() (args, heap);
  const QMetaMethod &arg2 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  const QObject *arg3 = gsi::arg_reader<const QObject * >() (args, heap);
  const QMetaMethod &arg4 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)QObject::disconnect (arg1, arg2, arg3, arg4));
}


// static bool QObject::disconnect(const QMetaObject::Connection &)


static void _init_f_disconnect_3540 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QMetaObject::Connection & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_disconnect_3540 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaObject::Connection &arg1 = gsi::arg_reader<const QMetaObject::Connection & >() (args, heap);
  ret.write<bool > ((bool)QObject::disconnect (arg1));
}


// static QString QObject::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QObject::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QObject () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("blockSignals", "@brief Method bool QObject::blockSignals(bool b)\n", false, &_init_f_blockSignals_864, &_call_f_blockSignals_864);
  methods += new qt_gsi::GenericMethod ("children", "@brief Method const QList<QObject*> &QObject::children()\n", true, &_init_f_children_c0, &_call_f_children_c0);
  methods += new qt_gsi::GenericMethod ("connect", "@brief Method QMetaObject::Connection QObject::connect(const QObject *sender, const char *signal, const char *member, Qt::ConnectionType type)\n", true, &_init_f_connect_c7342, &_call_f_connect_c7342);
  methods += new qt_gsi::GenericMethod ("deleteLater", "@brief Method void QObject::deleteLater()\n", false, &_init_f_deleteLater_0, &_call_f_deleteLater_0);
  methods += new qt_gsi::GenericMethod ("disconnect", "@brief Method bool QObject::disconnect(const char *signal, const QObject *receiver, const char *member)\n", true, &_init_f_disconnect_c5243, &_call_f_disconnect_c5243);
  methods += new qt_gsi::GenericMethod ("disconnect", "@brief Method bool QObject::disconnect(const QObject *receiver, const char *member)\n", true, &_init_f_disconnect_c3620, &_call_f_disconnect_c3620);
  methods += new qt_gsi::GenericMethod ("dumpObjectInfo", "@brief Method void QObject::dumpObjectInfo()\n", true, &_init_f_dumpObjectInfo_c0, &_call_f_dumpObjectInfo_c0);
  methods += new qt_gsi::GenericMethod ("dumpObjectTree", "@brief Method void QObject::dumpObjectTree()\n", true, &_init_f_dumpObjectTree_c0, &_call_f_dumpObjectTree_c0);
  methods += new qt_gsi::GenericMethod ("dynamicPropertyNames", "@brief Method QList<QByteArray> QObject::dynamicPropertyNames()\n", true, &_init_f_dynamicPropertyNames_c0, &_call_f_dynamicPropertyNames_c0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Method bool QObject::event(QEvent *event)\n", false, &_init_f_event_1217, &_call_f_event_1217);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Method bool QObject::eventFilter(QObject *watched, QEvent *event)\n", false, &_init_f_eventFilter_2411, &_call_f_eventFilter_2411);
  methods += new qt_gsi::GenericMethod ("inherits", "@brief Method bool QObject::inherits(const char *classname)\n", true, &_init_f_inherits_c1731, &_call_f_inherits_c1731);
  methods += new qt_gsi::GenericMethod ("installEventFilter", "@brief Method void QObject::installEventFilter(QObject *filterObj)\n", false, &_init_f_installEventFilter_1302, &_call_f_installEventFilter_1302);
  methods += new qt_gsi::GenericMethod ("isWidgetType?", "@brief Method bool QObject::isWidgetType()\n", true, &_init_f_isWidgetType_c0, &_call_f_isWidgetType_c0);
  methods += new qt_gsi::GenericMethod ("isWindowType?", "@brief Method bool QObject::isWindowType()\n", true, &_init_f_isWindowType_c0, &_call_f_isWindowType_c0);
  methods += new qt_gsi::GenericMethod ("killTimer", "@brief Method void QObject::killTimer(int id)\n", false, &_init_f_killTimer_767, &_call_f_killTimer_767);
  methods += new qt_gsi::GenericMethod ("moveToThread", "@brief Method void QObject::moveToThread(QThread *thread)\n", false, &_init_f_moveToThread_1303, &_call_f_moveToThread_1303);
  methods += new qt_gsi::GenericMethod (":objectName", "@brief Method QString QObject::objectName()\n", true, &_init_f_objectName_c0, &_call_f_objectName_c0);
  methods += new qt_gsi::GenericMethod (":parent", "@brief Method QObject *QObject::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
  methods += new qt_gsi::GenericMethod ("property", "@brief Method QVariant QObject::property(const char *name)\n", true, &_init_f_property_c1731, &_call_f_property_c1731);
  methods += new qt_gsi::GenericMethod ("removeEventFilter", "@brief Method void QObject::removeEventFilter(QObject *obj)\n", false, &_init_f_removeEventFilter_1302, &_call_f_removeEventFilter_1302);
  methods += new qt_gsi::GenericMethod ("setObjectName|objectName=", "@brief Method void QObject::setObjectName(const QString &name)\n", false, &_init_f_setObjectName_2025, &_call_f_setObjectName_2025);
  methods += new qt_gsi::GenericMethod ("setParent|parent=", "@brief Method void QObject::setParent(QObject *parent)\n", false, &_init_f_setParent_1302, &_call_f_setParent_1302);
  methods += new qt_gsi::GenericMethod ("setProperty", "@brief Method bool QObject::setProperty(const char *name, const QVariant &value)\n", false, &_init_f_setProperty_3742, &_call_f_setProperty_3742);
  methods += new qt_gsi::GenericMethod ("signalsBlocked", "@brief Method bool QObject::signalsBlocked()\n", true, &_init_f_signalsBlocked_c0, &_call_f_signalsBlocked_c0);
  methods += new qt_gsi::GenericMethod ("startTimer", "@brief Method int QObject::startTimer(int interval, Qt::TimerType timerType)\n", false, &_init_f_startTimer_2339, &_call_f_startTimer_2339);
  methods += new qt_gsi::GenericMethod ("thread", "@brief Method QThread *QObject::thread()\n", true, &_init_f_thread_c0, &_call_f_thread_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QObject::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QObject::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("connect", "@brief Static method QMetaObject::Connection QObject::connect(const QObject *sender, const char *signal, const QObject *receiver, const char *member, Qt::ConnectionType)\nThis method is static and can be called without an instance.", &_init_f_connect_9231, &_call_f_connect_9231);
  methods += new qt_gsi::GenericStaticMethod ("connect", "@brief Static method QMetaObject::Connection QObject::connect(const QObject *sender, const QMetaMethod &signal, const QObject *receiver, const QMetaMethod &method, Qt::ConnectionType type)\nThis method is static and can be called without an instance.", &_init_f_connect_10557, &_call_f_connect_10557);
  methods += new qt_gsi::GenericStaticMethod ("disconnect", "@brief Static method bool QObject::disconnect(const QObject *sender, const char *signal, const QObject *receiver, const char *member)\nThis method is static and can be called without an instance.", &_init_f_disconnect_7132, &_call_f_disconnect_7132);
  methods += new qt_gsi::GenericStaticMethod ("disconnect", "@brief Static method bool QObject::disconnect(const QObject *sender, const QMetaMethod &signal, const QObject *receiver, const QMetaMethod &member)\nThis method is static and can be called without an instance.", &_init_f_disconnect_8458, &_call_f_disconnect_8458);
  methods += new qt_gsi::GenericStaticMethod ("disconnect", "@brief Static method bool QObject::disconnect(const QMetaObject::Connection &)\nThis method is static and can be called without an instance.", &_init_f_disconnect_3540, &_call_f_disconnect_3540);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QObject::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

qt_gsi::QtNativeClass<QObject> decl_QObject ("QtCore", "QObject_Native",
#if QT_VERSION < 0x50000
  gsi::method_ext("findChild", &find_child_impl, gsi::arg("name", QString(), "null"), "@brief Specialisation for findChild (uses QObject as T).") +
  gsi::method_ext("findChildren", &find_children_impl, gsi::arg("name", QString(), "null"), "@brief Specialisation for findChildren (uses QObject as T).") +
  gsi::method_ext("findChildren", &find_children_impl2, gsi::arg("re"), "@brief Specialisation for findChildren (uses QObject as T).") 
#else
  gsi::method_ext("findChild", &find_child_impl, gsi::arg("name", QString(), "null"), gsi::arg("options", Qt::FindChildrenRecursively, "Qt::FindChildrenRecursively"), "@brief Specialisation for findChild (uses QObject as T).") +
  gsi::method_ext("findChildren", &find_children_impl, gsi::arg("name", QString(), "null"), gsi::arg("options", Qt::FindChildrenRecursively, "Qt::FindChildrenRecursively"), "@brief Specialisation for findChildren (uses QObject as T).") +
  gsi::method_ext("findChildren", &find_children_impl2, gsi::arg("re"), gsi::arg("options", Qt::FindChildrenRecursively, "Qt::FindChildrenRecursively"), "@brief Specialisation for findChildren (uses QObject as T).") 
#endif
+
  methods_QObject (),
  "@hide\n@alias QObject");

GSI_QTCORE_PUBLIC gsi::Class<QObject> &qtdecl_QObject () { return decl_QObject; }

}


class QObject_Adaptor : public QObject, public qt_gsi::QtObjectBase
{
public:

  virtual ~QObject_Adaptor();

  //  [adaptor ctor] QObject::QObject(QObject *parent)
  QObject_Adaptor() : QObject()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QObject::QObject(QObject *parent)
  QObject_Adaptor(QObject *parent) : QObject(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QObject::isSignalConnected(const QMetaMethod &signal)
  bool fp_QObject_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QObject::isSignalConnected(signal);
  }

  //  [expose] int QObject::receivers(const char *signal)
  int fp_QObject_receivers_c1731 (const char *signal) const {
    return QObject::receivers(signal);
  }

  //  [expose] QObject *QObject::sender()
  QObject * fp_QObject_sender_c0 () const {
    return QObject::sender();
  }

  //  [expose] int QObject::senderSignalIndex()
  int fp_QObject_senderSignalIndex_c0 () const {
    return QObject::senderSignalIndex();
  }

  //  [emitter impl] void QObject::destroyed(QObject *)
  void emitter_QObject_destroyed_1302(QObject *arg1)
  {
    emit QObject::destroyed(arg1);
  }

  //  [adaptor impl] bool QObject::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QObject::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QObject_Adaptor, bool, QEvent *>(&QObject_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QObject::event(_event);
    }
  }

  //  [adaptor impl] bool QObject::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QObject::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QObject_Adaptor, bool, QObject *, QEvent *>(&QObject_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QObject::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QObject::objectNameChanged(const QString &objectName)
  void emitter_QObject_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QObject::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QObject::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QObject::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QObject_Adaptor, QChildEvent *>(&QObject_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QObject::childEvent(event);
    }
  }

  //  [adaptor impl] void QObject::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QObject::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QObject_Adaptor, QEvent *>(&QObject_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QObject::customEvent(event);
    }
  }

  //  [adaptor impl] void QObject::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QObject::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QObject_Adaptor, const QMetaMethod &>(&QObject_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QObject::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QObject::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QObject::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QObject_Adaptor, QTimerEvent *>(&QObject_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QObject::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QObject_Adaptor::~QObject_Adaptor() { }

//  Constructor QObject::QObject(QObject *parent) (adaptor class)

static void _init_ctor_QObject_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QObject_Adaptor> ();
}

static void _call_ctor_QObject_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QObject_Adaptor *> (new QObject_Adaptor (arg1));
}


// void QObject::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QObject::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QObject::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QObject_Adaptor *)cls)->emitter_QObject_destroyed_1302 (arg1);
}


// void QObject::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QObject::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QObject_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QObject::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QObject_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QObject::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QObject_Adaptor *)cls)->fp_QObject_isSignalConnected_c2394 (arg1));
}


// emitter void QObject::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QObject_Adaptor *)cls)->emitter_QObject_objectNameChanged_4567 (arg1);
}


// exposed int QObject::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QObject_Adaptor *)cls)->fp_QObject_receivers_c1731 (arg1));
}


// exposed QObject *QObject::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QObject_Adaptor *)cls)->fp_QObject_sender_c0 ());
}


// exposed int QObject::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QObject_Adaptor *)cls)->fp_QObject_senderSignalIndex_c0 ());
}


// void QObject::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QObject_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QObject_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QObject> &qtdecl_QObject ();

static gsi::Methods methods_QObject_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QObject::QObject(QObject *parent)\nThis method creates an object of class QObject.", &_init_ctor_QObject_Adaptor_1302, &_call_ctor_QObject_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QObject::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QObject::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QObject::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QObject::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QObject::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QObject::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QObject::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QObject::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QObject::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QObject::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QObject::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QObject::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QObject_Adaptor> decl_QObject_Adaptor (qtdecl_QObject (), "QtCore", "QObject",
  methods_QObject_Adaptor (),
  "@qt\n@brief Binding of QObject");

}

