
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlTableModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSqlTableModel>
#include <QChildEvent>
#include <QDataStream>
#include <QEvent>
#include <QMetaMethod>
#include <QMimeData>
#include <QModelIndex>
#include <QModelRoleDataSpan>
#include <QObject>
#include <QPersistentModelIndex>
#include <QSize>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtSqlCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlTableModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSqlTableModel::staticMetaObject);
}


// void QSqlTableModel::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->clear ();
}


// bool QSqlTableModel::clearItemData(const QModelIndex &index)


static void _init_f_clearItemData_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_clearItemData_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->clearItemData (arg1));
}


// QVariant QSqlTableModel::data(const QModelIndex &idx, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QSqlTableModel *)cls)->data (arg1, arg2));
}


// QSqlDatabase QSqlTableModel::database()


static void _init_f_database_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlDatabase > ();
}

static void _call_f_database_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlDatabase > ((QSqlDatabase)((QSqlTableModel *)cls)->database ());
}


// QSqlTableModel::EditStrategy QSqlTableModel::editStrategy()


static void _init_f_editStrategy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type > ();
}

static void _call_f_editStrategy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type > ((qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type)qt_gsi::CppToQtAdaptor<QSqlTableModel::EditStrategy>(((QSqlTableModel *)cls)->editStrategy ()));
}


// int QSqlTableModel::fieldIndex(const QString &fieldName)


static void _init_f_fieldIndex_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fieldName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_fieldIndex_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QSqlTableModel *)cls)->fieldIndex (arg1));
}


// QString QSqlTableModel::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlTableModel *)cls)->filter ());
}


// QFlags<Qt::ItemFlag> QSqlTableModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QSqlTableModel *)cls)->flags (arg1));
}


// QVariant QSqlTableModel::headerData(int section, Qt::Orientation orientation, int role)


static void _init_f_headerData_c3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::DisplayRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_f_headerData_c3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::DisplayRole, heap);
  ret.write<QVariant > ((QVariant)((QSqlTableModel *)cls)->headerData (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}


// bool QSqlTableModel::insertRecord(int row, const QSqlRecord &record)


static void _init_f_insertRecord_2964 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<const QSqlRecord & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_insertRecord_2964 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QSqlRecord &arg2 = gsi::arg_reader<const QSqlRecord & >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->insertRecord (arg1, arg2));
}


// bool QSqlTableModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->insertRows (arg1, arg2, arg3));
}


// bool QSqlTableModel::isDirty()


static void _init_f_isDirty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDirty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->isDirty ());
}


// bool QSqlTableModel::isDirty(const QModelIndex &index)


static void _init_f_isDirty_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isDirty_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->isDirty (arg1));
}


// QSqlIndex QSqlTableModel::primaryKey()


static void _init_f_primaryKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlIndex > ();
}

static void _call_f_primaryKey_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlIndex > ((QSqlIndex)((QSqlTableModel *)cls)->primaryKey ());
}


// QSqlRecord QSqlTableModel::record()


static void _init_f_record_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlRecord > ();
}

static void _call_f_record_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlTableModel *)cls)->record ());
}


// QSqlRecord QSqlTableModel::record(int row)


static void _init_f_record_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_f_record_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlTableModel *)cls)->record (arg1));
}


// bool QSqlTableModel::removeColumns(int column, int count, const QModelIndex &parent)


static void _init_f_removeColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->removeColumns (arg1, arg2, arg3));
}


// bool QSqlTableModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->removeRows (arg1, arg2, arg3));
}


// void QSqlTableModel::revert()


static void _init_f_revert_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_revert_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->revert ();
}


// void QSqlTableModel::revertAll()


static void _init_f_revertAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_revertAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->revertAll ();
}


// void QSqlTableModel::revertRow(int row)


static void _init_f_revertRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_revertRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->revertRow (arg1);
}


// int QSqlTableModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args ? gsi::arg_reader<const QModelIndex & >() (args, heap) : gsi::arg_maker<const QModelIndex & >() (QModelIndex(), heap);
  ret.write<int > ((int)((QSqlTableModel *)cls)->rowCount (arg1));
}


// bool QSqlTableModel::select()


static void _init_f_select_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_select_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->select ());
}


// bool QSqlTableModel::selectRow(int row)


static void _init_f_selectRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_selectRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->selectRow (arg1));
}


// bool QSqlTableModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (Qt::EditRole, heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->setData (arg1, arg2, arg3));
}


// void QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)


static void _init_f_setEditStrategy_3163 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strategy");
  decl->add_arg<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEditStrategy_3163 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->setEditStrategy (qt_gsi::QtToCppAdaptor<QSqlTableModel::EditStrategy>(arg1).cref());
}


// void QSqlTableModel::setFilter(const QString &filter)


static void _init_f_setFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->setFilter (arg1);
}


// bool QSqlTableModel::setRecord(int row, const QSqlRecord &record)


static void _init_f_setRecord_2964 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<const QSqlRecord & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setRecord_2964 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QSqlRecord &arg2 = gsi::arg_reader<const QSqlRecord & >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->setRecord (arg1, arg2));
}


// void QSqlTableModel::setSort(int column, Qt::SortOrder order)


static void _init_f_setSort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSort_2340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->setSort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}


// void QSqlTableModel::setTable(const QString &tableName)


static void _init_f_setTable_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTable_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->setTable (arg1);
}


// void QSqlTableModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}


// bool QSqlTableModel::submit()


static void _init_f_submit_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_submit_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->submit ());
}


// bool QSqlTableModel::submitAll()


static void _init_f_submitAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_submitAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlTableModel *)cls)->submitAll ());
}


// QString QSqlTableModel::tableName()


static void _init_f_tableName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_tableName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlTableModel *)cls)->tableName ());
}


// static QString QSqlTableModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSqlTableModel::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSqlTableModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QSqlTableModel::clear()\nThis is a reimplementation of QSqlQueryModel::clear", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@brief Method bool QSqlTableModel::clearItemData(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::clearItemData", false, &_init_f_clearItemData_2395, &_call_f_clearItemData_2395);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QSqlTableModel::data(const QModelIndex &idx, int role)\nThis is a reimplementation of QSqlQueryModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
  methods += new qt_gsi::GenericMethod ("database", "@brief Method QSqlDatabase QSqlTableModel::database()\n", true, &_init_f_database_c0, &_call_f_database_c0);
  methods += new qt_gsi::GenericMethod (":editStrategy", "@brief Method QSqlTableModel::EditStrategy QSqlTableModel::editStrategy()\n", true, &_init_f_editStrategy_c0, &_call_f_editStrategy_c0);
  methods += new qt_gsi::GenericMethod ("fieldIndex", "@brief Method int QSqlTableModel::fieldIndex(const QString &fieldName)\n", true, &_init_f_fieldIndex_c2025, &_call_f_fieldIndex_c2025);
  methods += new qt_gsi::GenericMethod (":filter", "@brief Method QString QSqlTableModel::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QSqlTableModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractTableModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Method QVariant QSqlTableModel::headerData(int section, Qt::Orientation orientation, int role)\nThis is a reimplementation of QSqlQueryModel::headerData", true, &_init_f_headerData_c3231, &_call_f_headerData_c3231);
  methods += new qt_gsi::GenericMethod ("insertRecord", "@brief Method bool QSqlTableModel::insertRecord(int row, const QSqlRecord &record)\n", false, &_init_f_insertRecord_2964, &_call_f_insertRecord_2964);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QSqlTableModel::insertRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertRows", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
  methods += new qt_gsi::GenericMethod ("isDirty?", "@brief Method bool QSqlTableModel::isDirty()\n", true, &_init_f_isDirty_c0, &_call_f_isDirty_c0);
  methods += new qt_gsi::GenericMethod ("isDirty?", "@brief Method bool QSqlTableModel::isDirty(const QModelIndex &index)\n", true, &_init_f_isDirty_c2395, &_call_f_isDirty_c2395);
  methods += new qt_gsi::GenericMethod ("primaryKey", "@brief Method QSqlIndex QSqlTableModel::primaryKey()\n", true, &_init_f_primaryKey_c0, &_call_f_primaryKey_c0);
  methods += new qt_gsi::GenericMethod ("record", "@brief Method QSqlRecord QSqlTableModel::record()\n", true, &_init_f_record_c0, &_call_f_record_c0);
  methods += new qt_gsi::GenericMethod ("record", "@brief Method QSqlRecord QSqlTableModel::record(int row)\n", true, &_init_f_record_c767, &_call_f_record_c767);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Method bool QSqlTableModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis is a reimplementation of QSqlQueryModel::removeColumns", false, &_init_f_removeColumns_3713, &_call_f_removeColumns_3713);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QSqlTableModel::removeRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeRows", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Method void QSqlTableModel::revert()\nThis is a reimplementation of QAbstractItemModel::revert", false, &_init_f_revert_0, &_call_f_revert_0);
  methods += new qt_gsi::GenericMethod ("revertAll", "@brief Method void QSqlTableModel::revertAll()\n", false, &_init_f_revertAll_0, &_call_f_revertAll_0);
  methods += new qt_gsi::GenericMethod ("revertRow", "@brief Method void QSqlTableModel::revertRow(int row)\n", false, &_init_f_revertRow_767, &_call_f_revertRow_767);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QSqlTableModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QSqlQueryModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
  methods += new qt_gsi::GenericMethod ("select", "@brief Method bool QSqlTableModel::select()\n", false, &_init_f_select_0, &_call_f_select_0);
  methods += new qt_gsi::GenericMethod ("selectRow", "@brief Method bool QSqlTableModel::selectRow(int row)\n", false, &_init_f_selectRow_767, &_call_f_selectRow_767);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Method bool QSqlTableModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
  methods += new qt_gsi::GenericMethod ("setEditStrategy|editStrategy=", "@brief Method void QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)\n", false, &_init_f_setEditStrategy_3163, &_call_f_setEditStrategy_3163);
  methods += new qt_gsi::GenericMethod ("setFilter|filter=", "@brief Method void QSqlTableModel::setFilter(const QString &filter)\n", false, &_init_f_setFilter_2025, &_call_f_setFilter_2025);
  methods += new qt_gsi::GenericMethod ("setRecord", "@brief Method bool QSqlTableModel::setRecord(int row, const QSqlRecord &record)\n", false, &_init_f_setRecord_2964, &_call_f_setRecord_2964);
  methods += new qt_gsi::GenericMethod ("setSort", "@brief Method void QSqlTableModel::setSort(int column, Qt::SortOrder order)\n", false, &_init_f_setSort_2340, &_call_f_setSort_2340);
  methods += new qt_gsi::GenericMethod ("setTable", "@brief Method void QSqlTableModel::setTable(const QString &tableName)\n", false, &_init_f_setTable_2025, &_call_f_setTable_2025);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Method void QSqlTableModel::sort(int column, Qt::SortOrder order)\nThis is a reimplementation of QAbstractItemModel::sort", false, &_init_f_sort_2340, &_call_f_sort_2340);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Method bool QSqlTableModel::submit()\nThis is a reimplementation of QAbstractItemModel::submit", false, &_init_f_submit_0, &_call_f_submit_0);
  methods += new qt_gsi::GenericMethod ("submitAll", "@brief Method bool QSqlTableModel::submitAll()\n", false, &_init_f_submitAll_0, &_call_f_submitAll_0);
  methods += new qt_gsi::GenericMethod ("tableName", "@brief Method QString QSqlTableModel::tableName()\n", true, &_init_f_tableName_c0, &_call_f_tableName_c0);
  methods += gsi::qt_signal<int > ("beforeDelete(int)", "beforeDelete", gsi::arg("row"), "@brief Signal declaration for QSqlTableModel::beforeDelete(int row)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QSqlRecord & > ("beforeInsert(QSqlRecord &)", "beforeInsert", gsi::arg("record"), "@brief Signal declaration for QSqlTableModel::beforeInsert(QSqlRecord &record)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, QSqlRecord & > ("beforeUpdate(int, QSqlRecord &)", "beforeUpdate", gsi::arg("row"), gsi::arg("record"), "@brief Signal declaration for QSqlTableModel::beforeUpdate(int row, QSqlRecord &record)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeInserted(const QModelIndex &, int, int)", "columnsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationColumn"), "@brief Signal declaration for QSqlTableModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsAboutToBeRemoved(const QModelIndex &, int, int)", "columnsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsInserted(const QModelIndex &, int, int)", "columnsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::columnsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("columnsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "columnsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("column"), "@brief Signal declaration for QSqlTableModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("columnsRemoved(const QModelIndex &, int, int)", "columnsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex &, const QList<int> & > ("dataChanged(const QModelIndex &, const QModelIndex &, const QList<int> &)", "dataChanged", gsi::arg("topLeft"), gsi::arg("bottomRight"), gsi::arg("roles"), "@brief Signal declaration for QSqlTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSqlTableModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int > ("headerDataChanged(Qt::Orientation, int, int)", "headerDataChanged", gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutAboutToBeChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutAboutToBeChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QSqlTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QPersistentModelIndex> &, const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > ("layoutChanged(const QList<QPersistentModelIndex> &, QAbstractItemModel::LayoutChangeHint)", "layoutChanged", gsi::arg("parents"), gsi::arg("hint"), "@brief Signal declaration for QSqlTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelAboutToBeReset()", "modelAboutToBeReset", "@brief Signal declaration for QSqlTableModel::modelAboutToBeReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("modelReset()", "modelReset", "@brief Signal declaration for QSqlTableModel::modelReset()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QSqlTableModel::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, QSqlRecord & > ("primeInsert(int, QSqlRecord &)", "primeInsert", gsi::arg("row"), gsi::arg("record"), "@brief Signal declaration for QSqlTableModel::primeInsert(int row, QSqlRecord &record)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeInserted(const QModelIndex &, int, int)", "rowsAboutToBeInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsAboutToBeMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsAboutToBeMoved", gsi::arg("sourceParent"), gsi::arg("sourceStart"), gsi::arg("sourceEnd"), gsi::arg("destinationParent"), gsi::arg("destinationRow"), "@brief Signal declaration for QSqlTableModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsAboutToBeRemoved(const QModelIndex &, int, int)", "rowsAboutToBeRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsInserted(const QModelIndex &, int, int)", "rowsInserted", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::rowsInserted(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int, const QModelIndex &, int > ("rowsMoved(const QModelIndex &, int, int, const QModelIndex &, int)", "rowsMoved", gsi::arg("parent"), gsi::arg("start"), gsi::arg("end"), gsi::arg("destination"), gsi::arg("row"), "@brief Signal declaration for QSqlTableModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, int, int > ("rowsRemoved(const QModelIndex &, int, int)", "rowsRemoved", gsi::arg("parent"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QSqlTableModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlTableModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QSqlQueryModel> &qtdecl_QSqlQueryModel ();

qt_gsi::QtNativeClass<QSqlTableModel> decl_QSqlTableModel (qtdecl_QSqlQueryModel (), "QtSql", "QSqlTableModel_Native",
  methods_QSqlTableModel (),
  "@hide\n@alias QSqlTableModel");

GSI_QTSQL_PUBLIC gsi::Class<QSqlTableModel> &qtdecl_QSqlTableModel () { return decl_QSqlTableModel; }

}


class QSqlTableModel_Adaptor : public QSqlTableModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSqlTableModel_Adaptor();

  //  [adaptor ctor] QSqlTableModel::QSqlTableModel(QObject *parent, const QSqlDatabase &db)
  QSqlTableModel_Adaptor() : QSqlTableModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSqlTableModel::QSqlTableModel(QObject *parent, const QSqlDatabase &db)
  QSqlTableModel_Adaptor(QObject *parent) : QSqlTableModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSqlTableModel::QSqlTableModel(QObject *parent, const QSqlDatabase &db)
  QSqlTableModel_Adaptor(QObject *parent, const QSqlDatabase &db) : QSqlTableModel(parent, db)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QSqlTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QSqlTableModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSqlTableModel::beginInsertColumns(parent, first, last);
  }

  //  [expose] void QSqlTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QSqlTableModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QSqlTableModel::beginInsertRows(parent, first, last);
  }

  //  [expose] bool QSqlTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QSqlTableModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QSqlTableModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  [expose] bool QSqlTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QSqlTableModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QSqlTableModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  [expose] void QSqlTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QSqlTableModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QSqlTableModel::beginRemoveColumns(parent, first, last);
  }

  //  [expose] void QSqlTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QSqlTableModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QSqlTableModel::beginRemoveRows(parent, first, last);
  }

  //  [expose] void QSqlTableModel::beginResetModel()
  void fp_QSqlTableModel_beginResetModel_0 () {
    QSqlTableModel::beginResetModel();
  }

  //  [expose] void QSqlTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QSqlTableModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QSqlTableModel::changePersistentIndex(from, to);
  }

  //  [expose] void QSqlTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QSqlTableModel_changePersistentIndexList_5912 (const QList<QModelIndex> &from, const QList<QModelIndex> &to) {
    QSqlTableModel::changePersistentIndexList(from, to);
  }

  //  [expose] QModelIndex QSqlTableModel::createIndex(int row, int column, const void *data)
  QModelIndex fp_QSqlTableModel_createIndex_c3069 (int row, int column, const void *data) const {
    return QSqlTableModel::createIndex(row, column, data);
  }

  //  [expose] QModelIndex QSqlTableModel::createIndex(int row, int column, quintptr id)
  QModelIndex fp_QSqlTableModel_createIndex_c2657 (int row, int column, quintptr id) const {
    return QSqlTableModel::createIndex(row, column, id);
  }

  //  [expose] bool QSqlTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QSqlTableModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QSqlTableModel::decodeData(row, column, parent, stream);
  }

  //  [expose] void QSqlTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QSqlTableModel_encodeData_c4599 (const QList<QModelIndex> &indexes, QDataStream &stream) const {
    QSqlTableModel::encodeData(indexes, stream);
  }

  //  [expose] void QSqlTableModel::endInsertColumns()
  void fp_QSqlTableModel_endInsertColumns_0 () {
    QSqlTableModel::endInsertColumns();
  }

  //  [expose] void QSqlTableModel::endInsertRows()
  void fp_QSqlTableModel_endInsertRows_0 () {
    QSqlTableModel::endInsertRows();
  }

  //  [expose] void QSqlTableModel::endMoveColumns()
  void fp_QSqlTableModel_endMoveColumns_0 () {
    QSqlTableModel::endMoveColumns();
  }

  //  [expose] void QSqlTableModel::endMoveRows()
  void fp_QSqlTableModel_endMoveRows_0 () {
    QSqlTableModel::endMoveRows();
  }

  //  [expose] void QSqlTableModel::endRemoveColumns()
  void fp_QSqlTableModel_endRemoveColumns_0 () {
    QSqlTableModel::endRemoveColumns();
  }

  //  [expose] void QSqlTableModel::endRemoveRows()
  void fp_QSqlTableModel_endRemoveRows_0 () {
    QSqlTableModel::endRemoveRows();
  }

  //  [expose] void QSqlTableModel::endResetModel()
  void fp_QSqlTableModel_endResetModel_0 () {
    QSqlTableModel::endResetModel();
  }

  //  [expose] bool QSqlTableModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSqlTableModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSqlTableModel::isSignalConnected(signal);
  }

  //  [expose] QList<QModelIndex> QSqlTableModel::persistentIndexList()
  QList<QModelIndex> fp_QSqlTableModel_persistentIndexList_c0 () const {
    return QSqlTableModel::persistentIndexList();
  }

  //  [expose] QSqlRecord QSqlTableModel::primaryValues(int row)
  QSqlRecord fp_QSqlTableModel_primaryValues_c767 (int row) const {
    return QSqlTableModel::primaryValues(row);
  }

  //  [expose] int QSqlTableModel::receivers(const char *signal)
  int fp_QSqlTableModel_receivers_c1731 (const char *signal) const {
    return QSqlTableModel::receivers(signal);
  }

  //  [expose] QObject *QSqlTableModel::sender()
  QObject * fp_QSqlTableModel_sender_c0 () const {
    return QSqlTableModel::sender();
  }

  //  [expose] int QSqlTableModel::senderSignalIndex()
  int fp_QSqlTableModel_senderSignalIndex_c0 () const {
    return QSqlTableModel::senderSignalIndex();
  }

  //  [expose] void QSqlTableModel::setLastError(const QSqlError &error)
  void fp_QSqlTableModel_setLastError_2220 (const QSqlError &error) {
    QSqlTableModel::setLastError(error);
  }

  //  [expose] void QSqlTableModel::setPrimaryKey(const QSqlIndex &key)
  void fp_QSqlTableModel_setPrimaryKey_2202 (const QSqlIndex &key) {
    QSqlTableModel::setPrimaryKey(key);
  }

  //  [expose] void QSqlTableModel::setQuery(const QSqlQuery &query)
  void fp_QSqlTableModel_setQuery_2232 (const QSqlQuery &query) {
    QSqlTableModel::setQuery(query);
  }

  //  [emitter impl] void QSqlTableModel::beforeDelete(int row)
  void emitter_QSqlTableModel_beforeDelete_767(int row)
  {
    emit QSqlTableModel::beforeDelete(row);
  }

  //  [emitter impl] void QSqlTableModel::beforeInsert(QSqlRecord &record)
  void emitter_QSqlTableModel_beforeInsert_1610(QSqlRecord &record)
  {
    emit QSqlTableModel::beforeInsert(record);
  }

  //  [emitter impl] void QSqlTableModel::beforeUpdate(int row, QSqlRecord &record)
  void emitter_QSqlTableModel_beforeUpdate_2269(int row, QSqlRecord &record)
  {
    emit QSqlTableModel::beforeUpdate(row, record);
  }

  //  [adaptor impl] QModelIndex QSqlTableModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QSqlTableModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QSqlTableModel_Adaptor, QModelIndex, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QSqlTableModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_canDropMimeData_c7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent) const
  {
    return QSqlTableModel::canDropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent) const
  {
    if (cb_canDropMimeData_c7425_0.can_issue()) {
      return cb_canDropMimeData_c7425_0.issue<QSqlTableModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_canDropMimeData_c7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QSqlTableModel::canDropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_1(const QModelIndex &parent) const
  {
    return QSqlTableModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_1.can_issue()) {
      return cb_canFetchMore_c2395_1.issue<QSqlTableModel_Adaptor, bool, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_canFetchMore_c2395_1, parent);
    } else {
      return QSqlTableModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] void QSqlTableModel::clear()
  void cbs_clear_0_0()
  {
    QSqlTableModel::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QSqlTableModel_Adaptor>(&QSqlTableModel_Adaptor::cbs_clear_0_0);
    } else {
      QSqlTableModel::clear();
    }
  }

  //  [adaptor impl] bool QSqlTableModel::clearItemData(const QModelIndex &index)
  bool cbs_clearItemData_2395_0(const QModelIndex &index)
  {
    return QSqlTableModel::clearItemData(index);
  }

  virtual bool clearItemData(const QModelIndex &index)
  {
    if (cb_clearItemData_2395_0.can_issue()) {
      return cb_clearItemData_2395_0.issue<QSqlTableModel_Adaptor, bool, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_clearItemData_2395_0, index);
    } else {
      return QSqlTableModel::clearItemData(index);
    }
  }

  //  [adaptor impl] int QSqlTableModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    return QSqlTableModel::columnCount(parent);
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QSqlTableModel_Adaptor, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      return QSqlTableModel::columnCount(parent);
    }
  }

  //  [emitter impl] void QSqlTableModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_columnsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSqlTableModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  void emitter_QSqlTableModel_columnsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationColumn);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)'");
  }

  //  [emitter impl] void QSqlTableModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_columnsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSqlTableModel::columnsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_columnsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::columnsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSqlTableModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  void emitter_QSqlTableModel_columnsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (column);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)'");
  }

  //  [emitter impl] void QSqlTableModel::columnsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_columnsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::columnsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] QVariant QSqlTableModel::data(const QModelIndex &idx, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &idx, int role) const
  {
    return QSqlTableModel::data(idx, role);
  }

  virtual QVariant data(const QModelIndex &idx, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QSqlTableModel_Adaptor, QVariant, const QModelIndex &, int>(&QSqlTableModel_Adaptor::cbs_data_c3054_1, idx, role);
    } else {
      return QSqlTableModel::data(idx, role);
    }
  }

  //  [emitter impl] void QSqlTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  void emitter_QSqlTableModel_dataChanged_6833(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  {
    emit QSqlTableModel::dataChanged(topLeft, bottomRight, roles);
  }

  //  [emitter impl] void QSqlTableModel::destroyed(QObject *)
  void emitter_QSqlTableModel_destroyed_1302(QObject *arg1)
  {
    emit QSqlTableModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QSqlTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QSqlTableModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QSqlTableModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QSqlTableModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSqlTableModel::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSqlTableModel_Adaptor, bool, QEvent *>(&QSqlTableModel_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSqlTableModel::event(_event);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QSqlTableModel::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSqlTableModel_Adaptor, bool, QObject *, QEvent *>(&QSqlTableModel_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QSqlTableModel::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QSqlTableModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_1(const QModelIndex &parent)
  {
    QSqlTableModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_1.can_issue()) {
      cb_fetchMore_2395_1.issue<QSqlTableModel_Adaptor, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_fetchMore_2395_1, parent);
    } else {
      QSqlTableModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QSqlTableModel::flags(const QModelIndex &index)
  QFlags<Qt::ItemFlag> cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return QSqlTableModel::flags(index);
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return cb_flags_c2395_0.issue<QSqlTableModel_Adaptor, QFlags<Qt::ItemFlag>, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_flags_c2395_0, index);
    } else {
      return QSqlTableModel::flags(index);
    }
  }

  //  [adaptor impl] QVariant QSqlTableModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QSqlTableModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QSqlTableModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QSqlTableModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QSqlTableModel::headerData(section, orientation, role);
    }
  }

  //  [emitter impl] void QSqlTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)
  void emitter_QSqlTableModel_headerDataChanged_3231(Qt::Orientation orientation, int first, int last)
  {
    emit QSqlTableModel::headerDataChanged(orientation, first, last);
  }

  //  [adaptor impl] QModelIndex QSqlTableModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QSqlTableModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QSqlTableModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QSqlTableModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSqlTableModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QSqlTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QSqlTableModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSqlTableModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QSqlTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QSqlTableModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QMap<int, QVariant> QSqlTableModel::itemData(const QModelIndex &index)
  QMap<int, QVariant> cbs_itemData_c2395_0(const QModelIndex &index) const
  {
    return QSqlTableModel::itemData(index);
  }

  virtual QMap<int, QVariant> itemData(const QModelIndex &index) const
  {
    if (cb_itemData_c2395_0.can_issue()) {
      return cb_itemData_c2395_0.issue<QSqlTableModel_Adaptor, QMap<int, QVariant>, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_itemData_c2395_0, index);
    } else {
      return QSqlTableModel::itemData(index);
    }
  }

  //  [emitter impl] void QSqlTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QSqlTableModel_layoutAboutToBeChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QSqlTableModel::layoutAboutToBeChanged(parents, hint);
  }

  //  [emitter impl] void QSqlTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  void emitter_QSqlTableModel_layoutChanged_7947(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)
  {
    emit QSqlTableModel::layoutChanged(parents, hint);
  }

  //  [adaptor impl] QList<QModelIndex> QSqlTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  QList<QModelIndex> cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    return QSqlTableModel::match(start, role, value, hits, flags);
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return cb_match_c7932_2.issue<QSqlTableModel_Adaptor, QList<QModelIndex>, const QModelIndex &, int, const QVariant &, int, QFlags<Qt::MatchFlag> >(&QSqlTableModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, flags);
    } else {
      return QSqlTableModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QSqlTableModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const QList<QModelIndex> &indexes) const
  {
    return QSqlTableModel::mimeData(indexes);
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QSqlTableModel_Adaptor, QMimeData *, const QList<QModelIndex> &>(&QSqlTableModel_Adaptor::cbs_mimeData_c3010_0, indexes);
    } else {
      return QSqlTableModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QSqlTableModel::mimeTypes()
  QStringList cbs_mimeTypes_c0_0() const
  {
    return QSqlTableModel::mimeTypes();
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return cb_mimeTypes_c0_0.issue<QSqlTableModel_Adaptor, QStringList>(&QSqlTableModel_Adaptor::cbs_mimeTypes_c0_0);
    } else {
      return QSqlTableModel::mimeTypes();
    }
  }

  //  [emitter impl] void QSqlTableModel::modelAboutToBeReset()
  void emitter_QSqlTableModel_modelAboutToBeReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::modelAboutToBeReset()'");
  }

  //  [emitter impl] void QSqlTableModel::modelReset()
  void emitter_QSqlTableModel_modelReset_3767()
  {
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::modelReset()'");
  }

  //  [adaptor impl] bool QSqlTableModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveColumns_6659_0(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QSqlTableModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
  }

  virtual bool moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveColumns_6659_0.can_issue()) {
      return cb_moveColumns_6659_0.issue<QSqlTableModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QSqlTableModel_Adaptor::cbs_moveColumns_6659_0, sourceParent, sourceColumn, count, destinationParent, destinationChild);
    } else {
      return QSqlTableModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  bool cbs_moveRows_6659_0(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    return QSqlTableModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
  }

  virtual bool moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)
  {
    if (cb_moveRows_6659_0.can_issue()) {
      return cb_moveRows_6659_0.issue<QSqlTableModel_Adaptor, bool, const QModelIndex &, int, int, const QModelIndex &, int>(&QSqlTableModel_Adaptor::cbs_moveRows_6659_0, sourceParent, sourceRow, count, destinationParent, destinationChild);
    } else {
      return QSqlTableModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
  }

  //  [adaptor impl] void QSqlTableModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)
  void cbs_multiData_c4483_0(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    QSqlTableModel::multiData(index, roleDataSpan);
  }

  virtual void multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan) const
  {
    if (cb_multiData_c4483_0.can_issue()) {
      cb_multiData_c4483_0.issue<QSqlTableModel_Adaptor, const QModelIndex &, QModelRoleDataSpan>(&QSqlTableModel_Adaptor::cbs_multiData_c4483_0, index, roleDataSpan);
    } else {
      QSqlTableModel::multiData(index, roleDataSpan);
    }
  }

  //  [emitter impl] void QSqlTableModel::objectNameChanged(const QString &objectName)
  void emitter_QSqlTableModel_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QSqlTableModel::primeInsert(int row, QSqlRecord &record)
  void emitter_QSqlTableModel_primeInsert_2269(int row, QSqlRecord &record)
  {
    emit QSqlTableModel::primeInsert(row, record);
  }

  //  [adaptor impl] bool QSqlTableModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QSqlTableModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QSqlTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QSqlTableModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QSqlTableModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QSqlTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QSqlTableModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QSqlTableModel::revert()
  void cbs_revert_0_0()
  {
    QSqlTableModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QSqlTableModel_Adaptor>(&QSqlTableModel_Adaptor::cbs_revert_0_0);
    } else {
      QSqlTableModel::revert();
    }
  }

  //  [adaptor impl] void QSqlTableModel::revertRow(int row)
  void cbs_revertRow_767_0(int row)
  {
    QSqlTableModel::revertRow(row);
  }

  virtual void revertRow(int row)
  {
    if (cb_revertRow_767_0.can_issue()) {
      cb_revertRow_767_0.issue<QSqlTableModel_Adaptor, int>(&QSqlTableModel_Adaptor::cbs_revertRow_767_0, row);
    } else {
      QSqlTableModel::revertRow(row);
    }
  }

  //  [adaptor impl] QHash<int, QByteArray> QSqlTableModel::roleNames()
  QHash<int, QByteArray> cbs_roleNames_c0_0() const
  {
    return QSqlTableModel::roleNames();
  }

  virtual QHash<int, QByteArray> roleNames() const
  {
    if (cb_roleNames_c0_0.can_issue()) {
      return cb_roleNames_c0_0.issue<QSqlTableModel_Adaptor, QHash<int, QByteArray> >(&QSqlTableModel_Adaptor::cbs_roleNames_c0_0);
    } else {
      return QSqlTableModel::roleNames();
    }
  }

  //  [adaptor impl] int QSqlTableModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QSqlTableModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QSqlTableModel_Adaptor, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QSqlTableModel::rowCount(parent);
    }
  }

  //  [emitter impl] void QSqlTableModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_rowsAboutToBeInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSqlTableModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  void emitter_QSqlTableModel_rowsAboutToBeMoved_10318(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)
  {
    __SUPPRESS_UNUSED_WARNING (sourceParent);
    __SUPPRESS_UNUSED_WARNING (sourceStart);
    __SUPPRESS_UNUSED_WARNING (sourceEnd);
    __SUPPRESS_UNUSED_WARNING (destinationParent);
    __SUPPRESS_UNUSED_WARNING (destinationRow);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)'");
  }

  //  [emitter impl] void QSqlTableModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_rowsAboutToBeRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSqlTableModel::rowsInserted(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_rowsInserted_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::rowsInserted(const QModelIndex &parent, int first, int last)'");
  }

  //  [emitter impl] void QSqlTableModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  void emitter_QSqlTableModel_rowsMoved_10318(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (start);
    __SUPPRESS_UNUSED_WARNING (end);
    __SUPPRESS_UNUSED_WARNING (destination);
    __SUPPRESS_UNUSED_WARNING (row);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)'");
  }

  //  [emitter impl] void QSqlTableModel::rowsRemoved(const QModelIndex &parent, int first, int last)
  void emitter_QSqlTableModel_rowsRemoved_7372(const QModelIndex &parent, int first, int last)
  {
    __SUPPRESS_UNUSED_WARNING (parent);
    __SUPPRESS_UNUSED_WARNING (first);
    __SUPPRESS_UNUSED_WARNING (last);
    throw tl::Exception ("Can't emit private signal 'void QSqlTableModel::rowsRemoved(const QModelIndex &parent, int first, int last)'");
  }

  //  [adaptor impl] bool QSqlTableModel::select()
  bool cbs_select_0_0()
  {
    return QSqlTableModel::select();
  }

  virtual bool select()
  {
    if (cb_select_0_0.can_issue()) {
      return cb_select_0_0.issue<QSqlTableModel_Adaptor, bool>(&QSqlTableModel_Adaptor::cbs_select_0_0);
    } else {
      return QSqlTableModel::select();
    }
  }

  //  [adaptor impl] bool QSqlTableModel::selectRow(int row)
  bool cbs_selectRow_767_0(int row)
  {
    return QSqlTableModel::selectRow(row);
  }

  virtual bool selectRow(int row)
  {
    if (cb_selectRow_767_0.can_issue()) {
      return cb_selectRow_767_0.issue<QSqlTableModel_Adaptor, bool, int>(&QSqlTableModel_Adaptor::cbs_selectRow_767_0, row);
    } else {
      return QSqlTableModel::selectRow(row);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QSqlTableModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QSqlTableModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QSqlTableModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QSqlTableModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] void QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)
  void cbs_setEditStrategy_3163_0(const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & strategy)
  {
    QSqlTableModel::setEditStrategy(qt_gsi::QtToCppAdaptor<QSqlTableModel::EditStrategy>(strategy).cref());
  }

  virtual void setEditStrategy(QSqlTableModel::EditStrategy strategy)
  {
    if (cb_setEditStrategy_3163_0.can_issue()) {
      cb_setEditStrategy_3163_0.issue<QSqlTableModel_Adaptor, const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type &>(&QSqlTableModel_Adaptor::cbs_setEditStrategy_3163_0, qt_gsi::CppToQtAdaptor<QSqlTableModel::EditStrategy>(strategy));
    } else {
      QSqlTableModel::setEditStrategy(strategy);
    }
  }

  //  [adaptor impl] void QSqlTableModel::setFilter(const QString &filter)
  void cbs_setFilter_2025_0(const QString &filter)
  {
    QSqlTableModel::setFilter(filter);
  }

  virtual void setFilter(const QString &filter)
  {
    if (cb_setFilter_2025_0.can_issue()) {
      cb_setFilter_2025_0.issue<QSqlTableModel_Adaptor, const QString &>(&QSqlTableModel_Adaptor::cbs_setFilter_2025_0, filter);
    } else {
      QSqlTableModel::setFilter(filter);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QSqlTableModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QSqlTableModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QSqlTableModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QSqlTableModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  bool cbs_setItemData_5414_0(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    return QSqlTableModel::setItemData(index, roles);
  }

  virtual bool setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)
  {
    if (cb_setItemData_5414_0.can_issue()) {
      return cb_setItemData_5414_0.issue<QSqlTableModel_Adaptor, bool, const QModelIndex &, const QMap<int, QVariant> &>(&QSqlTableModel_Adaptor::cbs_setItemData_5414_0, index, roles);
    } else {
      return QSqlTableModel::setItemData(index, roles);
    }
  }

  //  [adaptor impl] void QSqlTableModel::setSort(int column, Qt::SortOrder order)
  void cbs_setSort_2340_0(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QSqlTableModel::setSort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void setSort(int column, Qt::SortOrder order)
  {
    if (cb_setSort_2340_0.can_issue()) {
      cb_setSort_2340_0.issue<QSqlTableModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QSqlTableModel_Adaptor::cbs_setSort_2340_0, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QSqlTableModel::setSort(column, order);
    }
  }

  //  [adaptor impl] void QSqlTableModel::setTable(const QString &tableName)
  void cbs_setTable_2025_0(const QString &tableName)
  {
    QSqlTableModel::setTable(tableName);
  }

  virtual void setTable(const QString &tableName)
  {
    if (cb_setTable_2025_0.can_issue()) {
      cb_setTable_2025_0.issue<QSqlTableModel_Adaptor, const QString &>(&QSqlTableModel_Adaptor::cbs_setTable_2025_0, tableName);
    } else {
      QSqlTableModel::setTable(tableName);
    }
  }

  //  [adaptor impl] QModelIndex QSqlTableModel::sibling(int row, int column, const QModelIndex &idx)
  QModelIndex cbs_sibling_c3713_0(int row, int column, const QModelIndex &idx) const
  {
    return QSqlTableModel::sibling(row, column, idx);
  }

  virtual QModelIndex sibling(int row, int column, const QModelIndex &idx) const
  {
    if (cb_sibling_c3713_0.can_issue()) {
      return cb_sibling_c3713_0.issue<QSqlTableModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_sibling_c3713_0, row, column, idx);
    } else {
      return QSqlTableModel::sibling(row, column, idx);
    }
  }

  //  [adaptor impl] void QSqlTableModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_0(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QSqlTableModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_0.can_issue()) {
      cb_sort_2340_0.issue<QSqlTableModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QSqlTableModel_Adaptor::cbs_sort_2340_0, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QSqlTableModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QSqlTableModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QSqlTableModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QSqlTableModel_Adaptor, QSize, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QSqlTableModel::span(index);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::submit()
  bool cbs_submit_0_0()
  {
    return QSqlTableModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QSqlTableModel_Adaptor, bool>(&QSqlTableModel_Adaptor::cbs_submit_0_0);
    } else {
      return QSqlTableModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QSqlTableModel::supportedDragActions()
  QFlags<Qt::DropAction> cbs_supportedDragActions_c0_0() const
  {
    return QSqlTableModel::supportedDragActions();
  }

  virtual QFlags<Qt::DropAction> supportedDragActions() const
  {
    if (cb_supportedDragActions_c0_0.can_issue()) {
      return cb_supportedDragActions_c0_0.issue<QSqlTableModel_Adaptor, QFlags<Qt::DropAction> >(&QSqlTableModel_Adaptor::cbs_supportedDragActions_c0_0);
    } else {
      return QSqlTableModel::supportedDragActions();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QSqlTableModel::supportedDropActions()
  QFlags<Qt::DropAction> cbs_supportedDropActions_c0_0() const
  {
    return QSqlTableModel::supportedDropActions();
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return cb_supportedDropActions_c0_0.issue<QSqlTableModel_Adaptor, QFlags<Qt::DropAction> >(&QSqlTableModel_Adaptor::cbs_supportedDropActions_c0_0);
    } else {
      return QSqlTableModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QSqlTableModel::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QSqlTableModel::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSqlTableModel_Adaptor, QChildEvent *>(&QSqlTableModel_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QSqlTableModel::childEvent(event);
    }
  }

  //  [adaptor impl] void QSqlTableModel::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QSqlTableModel::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSqlTableModel_Adaptor, QEvent *>(&QSqlTableModel_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QSqlTableModel::customEvent(event);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::deleteRowFromTable(int row)
  bool cbs_deleteRowFromTable_767_0(int row)
  {
    return QSqlTableModel::deleteRowFromTable(row);
  }

  virtual bool deleteRowFromTable(int row)
  {
    if (cb_deleteRowFromTable_767_0.can_issue()) {
      return cb_deleteRowFromTable_767_0.issue<QSqlTableModel_Adaptor, bool, int>(&QSqlTableModel_Adaptor::cbs_deleteRowFromTable_767_0, row);
    } else {
      return QSqlTableModel::deleteRowFromTable(row);
    }
  }

  //  [adaptor impl] void QSqlTableModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSqlTableModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSqlTableModel_Adaptor, const QMetaMethod &>(&QSqlTableModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSqlTableModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] QModelIndex QSqlTableModel::indexInQuery(const QModelIndex &item)
  QModelIndex cbs_indexInQuery_c2395_0(const QModelIndex &item) const
  {
    return QSqlTableModel::indexInQuery(item);
  }

  virtual QModelIndex indexInQuery(const QModelIndex &item) const
  {
    if (cb_indexInQuery_c2395_0.can_issue()) {
      return cb_indexInQuery_c2395_0.issue<QSqlTableModel_Adaptor, QModelIndex, const QModelIndex &>(&QSqlTableModel_Adaptor::cbs_indexInQuery_c2395_0, item);
    } else {
      return QSqlTableModel::indexInQuery(item);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::insertRowIntoTable(const QSqlRecord &values)
  bool cbs_insertRowIntoTable_2305_0(const QSqlRecord &values)
  {
    return QSqlTableModel::insertRowIntoTable(values);
  }

  virtual bool insertRowIntoTable(const QSqlRecord &values)
  {
    if (cb_insertRowIntoTable_2305_0.can_issue()) {
      return cb_insertRowIntoTable_2305_0.issue<QSqlTableModel_Adaptor, bool, const QSqlRecord &>(&QSqlTableModel_Adaptor::cbs_insertRowIntoTable_2305_0, values);
    } else {
      return QSqlTableModel::insertRowIntoTable(values);
    }
  }

  //  [adaptor impl] QString QSqlTableModel::orderByClause()
  QString cbs_orderByClause_c0_0() const
  {
    return QSqlTableModel::orderByClause();
  }

  virtual QString orderByClause() const
  {
    if (cb_orderByClause_c0_0.can_issue()) {
      return cb_orderByClause_c0_0.issue<QSqlTableModel_Adaptor, QString>(&QSqlTableModel_Adaptor::cbs_orderByClause_c0_0);
    } else {
      return QSqlTableModel::orderByClause();
    }
  }

  //  [adaptor impl] void QSqlTableModel::queryChange()
  void cbs_queryChange_0_0()
  {
    QSqlTableModel::queryChange();
  }

  virtual void queryChange()
  {
    if (cb_queryChange_0_0.can_issue()) {
      cb_queryChange_0_0.issue<QSqlTableModel_Adaptor>(&QSqlTableModel_Adaptor::cbs_queryChange_0_0);
    } else {
      QSqlTableModel::queryChange();
    }
  }

  //  [adaptor impl] void QSqlTableModel::resetInternalData()
  void cbs_resetInternalData_0_0()
  {
    QSqlTableModel::resetInternalData();
  }

  virtual void resetInternalData()
  {
    if (cb_resetInternalData_0_0.can_issue()) {
      cb_resetInternalData_0_0.issue<QSqlTableModel_Adaptor>(&QSqlTableModel_Adaptor::cbs_resetInternalData_0_0);
    } else {
      QSqlTableModel::resetInternalData();
    }
  }

  //  [adaptor impl] QString QSqlTableModel::selectStatement()
  QString cbs_selectStatement_c0_0() const
  {
    return QSqlTableModel::selectStatement();
  }

  virtual QString selectStatement() const
  {
    if (cb_selectStatement_c0_0.can_issue()) {
      return cb_selectStatement_c0_0.issue<QSqlTableModel_Adaptor, QString>(&QSqlTableModel_Adaptor::cbs_selectStatement_c0_0);
    } else {
      return QSqlTableModel::selectStatement();
    }
  }

  //  [adaptor impl] void QSqlTableModel::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QSqlTableModel::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSqlTableModel_Adaptor, QTimerEvent *>(&QSqlTableModel_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QSqlTableModel::timerEvent(event);
    }
  }

  //  [adaptor impl] bool QSqlTableModel::updateRowInTable(int row, const QSqlRecord &values)
  bool cbs_updateRowInTable_2964_0(int row, const QSqlRecord &values)
  {
    return QSqlTableModel::updateRowInTable(row, values);
  }

  virtual bool updateRowInTable(int row, const QSqlRecord &values)
  {
    if (cb_updateRowInTable_2964_0.can_issue()) {
      return cb_updateRowInTable_2964_0.issue<QSqlTableModel_Adaptor, bool, int, const QSqlRecord &>(&QSqlTableModel_Adaptor::cbs_updateRowInTable_2964_0, row, values);
    } else {
      return QSqlTableModel::updateRowInTable(row, values);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canDropMimeData_c7425_0;
  gsi::Callback cb_canFetchMore_c2395_1;
  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_clearItemData_2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_1;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_itemData_c2395_0;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_moveColumns_6659_0;
  gsi::Callback cb_moveRows_6659_0;
  gsi::Callback cb_multiData_c4483_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_revertRow_767_0;
  gsi::Callback cb_roleNames_c0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_select_0_0;
  gsi::Callback cb_selectRow_767_0;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setEditStrategy_3163_0;
  gsi::Callback cb_setFilter_2025_0;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_setItemData_5414_0;
  gsi::Callback cb_setSort_2340_0;
  gsi::Callback cb_setTable_2025_0;
  gsi::Callback cb_sibling_c3713_0;
  gsi::Callback cb_sort_2340_0;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDragActions_c0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_deleteRowFromTable_767_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_indexInQuery_c2395_0;
  gsi::Callback cb_insertRowIntoTable_2305_0;
  gsi::Callback cb_orderByClause_c0_0;
  gsi::Callback cb_queryChange_0_0;
  gsi::Callback cb_resetInternalData_0_0;
  gsi::Callback cb_selectStatement_c0_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateRowInTable_2964_0;
};

QSqlTableModel_Adaptor::~QSqlTableModel_Adaptor() { }

//  Constructor QSqlTableModel::QSqlTableModel(QObject *parent, const QSqlDatabase &db) (adaptor class)

static void _init_ctor_QSqlTableModel_Adaptor_3681 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("db", true, "QSqlDatabase()");
  decl->add_arg<const QSqlDatabase & > (argspec_1);
  decl->set_return_new<QSqlTableModel_Adaptor> ();
}

static void _call_ctor_QSqlTableModel_Adaptor_3681 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  const QSqlDatabase &arg2 = args ? gsi::arg_reader<const QSqlDatabase & >() (args, heap) : gsi::arg_maker<const QSqlDatabase & >() (QSqlDatabase(), heap);
  ret.write<QSqlTableModel_Adaptor *> (new QSqlTableModel_Adaptor (arg1, arg2));
}


// emitter void QSqlTableModel::beforeDelete(int row)

static void _init_emitter_beforeDelete_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_beforeDelete_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_beforeDelete_767 (arg1);
}


// emitter void QSqlTableModel::beforeInsert(QSqlRecord &record)

static void _init_emitter_beforeInsert_1610 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("record");
  decl->add_arg<QSqlRecord & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_beforeInsert_1610 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSqlRecord &arg1 = gsi::arg_reader<QSqlRecord & >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_beforeInsert_1610 (arg1);
}


// emitter void QSqlTableModel::beforeUpdate(int row, QSqlRecord &record)

static void _init_emitter_beforeUpdate_2269 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<QSqlRecord & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_beforeUpdate_2269 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QSqlRecord &arg2 = gsi::arg_reader<QSqlRecord & >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_beforeUpdate_2269 (arg1, arg2);
}


// exposed void QSqlTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSqlTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_beginInsertRows_3713 (arg1, arg2, arg3);
}


// exposed bool QSqlTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed bool QSqlTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}


// exposed void QSqlTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}


// exposed void QSqlTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}


// exposed void QSqlTableModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_beginResetModel_0 ();
}


// QModelIndex QSqlTableModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlTableModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}


// bool QSqlTableModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_canDropMimeData_c7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_canDropMimeData_c7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_canDropMimeData_c7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_canDropMimeData_c7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_canDropMimeData_c7425_0 = cb;
}


// bool QSqlTableModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_canFetchMore_c2395_1 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_canFetchMore_c2395_1 = cb;
}


// exposed void QSqlTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_changePersistentIndex_4682 (arg1, arg2);
}


// exposed void QSqlTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QList<QModelIndex> & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  const QList<QModelIndex> &arg2 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_changePersistentIndexList_5912 (arg1, arg2);
}


// void QSqlTableModel::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSqlTableModel::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// bool QSqlTableModel::clearItemData(const QModelIndex &index)

static void _init_cbs_clearItemData_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_clearItemData_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_clearItemData_2395_0 (arg1));
}

static void _set_callback_cbs_clearItemData_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_clearItemData_2395_0 = cb;
}


// int QSqlTableModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSqlTableModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}


// emitter void QSqlTableModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_columnsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSqlTableModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)

static void _init_emitter_columnsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_columnsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSqlTableModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_columnsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QSqlTableModel::columnsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_columnsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSqlTableModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)

static void _init_emitter_columnsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("column");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_columnsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_columnsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSqlTableModel::columnsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_columnsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_columnsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_columnsRemoved_7372 (arg1, arg2, arg3);
}


// exposed QModelIndex QSqlTableModel::createIndex(int row, int column, const void *data)

static void _init_fp_createIndex_c3069 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "nullptr");
  decl->add_arg<const void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c3069 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const void *arg3 = args ? gsi::arg_reader<const void * >() (args, heap) : gsi::arg_maker<const void * >() (nullptr, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_createIndex_c3069 (arg1, arg2, arg3));
}


// exposed QModelIndex QSqlTableModel::createIndex(int row, int column, quintptr id)

static void _init_fp_createIndex_c2657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quintptr > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  quintptr arg3 = gsi::arg_reader<quintptr >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_createIndex_c2657 (arg1, arg2, arg3));
}


// void QSqlTableModel::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QVariant QSqlTableModel::data(const QModelIndex &idx, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSqlTableModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}


// emitter void QSqlTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)

static void _init_emitter_dataChanged_6833 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QList<int>()");
  decl->add_arg<const QList<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_dataChanged_6833 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QList<int> &arg3 = args ? gsi::arg_reader<const QList<int> & >() (args, heap) : gsi::arg_maker<const QList<int> & >() (QList<int>(), heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_dataChanged_6833 (arg1, arg2, arg3);
}


// exposed bool QSqlTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QDataStream &arg4 = gsi::arg_reader<QDataStream & >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}


// bool QSqlTableModel::deleteRowFromTable(int row)

static void _init_cbs_deleteRowFromTable_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_deleteRowFromTable_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_deleteRowFromTable_767_0 (arg1));
}

static void _set_callback_cbs_deleteRowFromTable_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_deleteRowFromTable_767_0 = cb;
}


// emitter void QSqlTableModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_destroyed_1302 (arg1);
}


// void QSqlTableModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QSqlTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  const QModelIndex &arg5 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}


// exposed void QSqlTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = gsi::arg_reader<const QList<QModelIndex> & >() (args, heap);
  QDataStream &arg2 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_encodeData_c4599 (arg1, arg2);
}


// exposed void QSqlTableModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_endInsertColumns_0 ();
}


// exposed void QSqlTableModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_endInsertRows_0 ();
}


// exposed void QSqlTableModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_endMoveColumns_0 ();
}


// exposed void QSqlTableModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_endMoveRows_0 ();
}


// exposed void QSqlTableModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_endRemoveColumns_0 ();
}


// exposed void QSqlTableModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_endRemoveRows_0 ();
}


// exposed void QSqlTableModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_endResetModel_0 ();
}


// bool QSqlTableModel::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSqlTableModel::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QSqlTableModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_fetchMore_2395_1 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_fetchMore_2395_1 = cb;
}


// QFlags<Qt::ItemFlag> QSqlTableModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QSqlTableModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}


// QVariant QSqlTableModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QSqlTableModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}


// emitter void QSqlTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)

static void _init_emitter_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_headerDataChanged_3231 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_headerDataChanged_3231 (arg1, arg2, arg3);
}


// QModelIndex QSqlTableModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlTableModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}


// QModelIndex QSqlTableModel::indexInQuery(const QModelIndex &item)

static void _init_cbs_indexInQuery_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexInQuery_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlTableModel_Adaptor *)cls)->cbs_indexInQuery_c2395_0 (arg1));
}

static void _set_callback_cbs_indexInQuery_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_indexInQuery_c2395_0 = cb;
}


// bool QSqlTableModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}


// bool QSqlTableModel::insertRowIntoTable(const QSqlRecord &values)

static void _init_cbs_insertRowIntoTable_2305_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("values");
  decl->add_arg<const QSqlRecord & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRowIntoTable_2305_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlRecord &arg1 = args.read<const QSqlRecord & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_insertRowIntoTable_2305_0 (arg1));
}

static void _set_callback_cbs_insertRowIntoTable_2305_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_insertRowIntoTable_2305_0 = cb;
}


// bool QSqlTableModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}


// exposed bool QSqlTableModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_isSignalConnected_c2394 (arg1));
}


// QMap<int, QVariant> QSqlTableModel::itemData(const QModelIndex &index)

static void _init_cbs_itemData_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QMap<int, QVariant> > ();
}

static void _call_cbs_itemData_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QMap<int, QVariant> > ((QMap<int, QVariant>)((QSqlTableModel_Adaptor *)cls)->cbs_itemData_c2395_0 (arg1));
}

static void _set_callback_cbs_itemData_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_itemData_c2395_0 = cb;
}


// emitter void QSqlTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutAboutToBeChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutAboutToBeChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_layoutAboutToBeChanged_7947 (arg1, arg2);
}


// emitter void QSqlTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)

static void _init_emitter_layoutChanged_7947 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parents", true, "QList<QPersistentModelIndex>()");
  decl->add_arg<const QList<QPersistentModelIndex> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemModel::NoLayoutChangeHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_layoutChanged_7947 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPersistentModelIndex> &arg1 = args ? gsi::arg_reader<const QList<QPersistentModelIndex> & >() (args, heap) : gsi::arg_maker<const QList<QPersistentModelIndex> & >() (QList<QPersistentModelIndex>(), heap);
  const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemModel::LayoutChangeHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemModel::LayoutChangeHint>(heap, QAbstractItemModel::NoLayoutChangeHint), heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_layoutChanged_7947 (arg1, arg2);
}


// QList<QModelIndex> QSqlTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<QFlags<Qt::MatchFlag> > (argspec_4);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  QFlags<Qt::MatchFlag> arg5 = args.read<QFlags<Qt::MatchFlag> > (heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSqlTableModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}


// QMimeData *QSqlTableModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const QList<QModelIndex> & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QModelIndex> &arg1 = args.read<const QList<QModelIndex> & > (heap);
  ret.write<QMimeData * > ((QMimeData *)((QSqlTableModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}


// QStringList QSqlTableModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QSqlTableModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}


// emitter void QSqlTableModel::modelAboutToBeReset()

static void _init_emitter_modelAboutToBeReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelAboutToBeReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_modelAboutToBeReset_3767 ();
}


// emitter void QSqlTableModel::modelReset()

static void _init_emitter_modelReset_3767 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_modelReset_3767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_modelReset_3767 ();
}


// bool QSqlTableModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveColumns_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceColumn");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveColumns_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_moveColumns_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveColumns_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_moveColumns_6659_0 = cb;
}


// bool QSqlTableModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)

static void _init_cbs_moveRows_6659_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceRow");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("count");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationChild");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_moveRows_6659_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  int arg5 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_moveRows_6659_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_moveRows_6659_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_moveRows_6659_0 = cb;
}


// void QSqlTableModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)

static void _init_cbs_multiData_c4483_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roleDataSpan");
  decl->add_arg<QModelRoleDataSpan > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_multiData_c4483_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  QModelRoleDataSpan arg2 = args.read<QModelRoleDataSpan > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_multiData_c4483_0 (arg1, arg2);
}

static void _set_callback_cbs_multiData_c4483_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_multiData_c4483_0 = cb;
}


// emitter void QSqlTableModel::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_objectNameChanged_4567 (arg1);
}


// QString QSqlTableModel::orderByClause()

static void _init_cbs_orderByClause_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_orderByClause_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlTableModel_Adaptor *)cls)->cbs_orderByClause_c0_0 ());
}

static void _set_callback_cbs_orderByClause_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_orderByClause_c0_0 = cb;
}


// exposed QList<QModelIndex> QSqlTableModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_persistentIndexList_c0 ());
}


// exposed QSqlRecord QSqlTableModel::primaryValues(int row)

static void _init_fp_primaryValues_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_fp_primaryValues_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_primaryValues_c767 (arg1));
}


// emitter void QSqlTableModel::primeInsert(int row, QSqlRecord &record)

static void _init_emitter_primeInsert_2269 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("record");
  decl->add_arg<QSqlRecord & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_primeInsert_2269 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QSqlRecord &arg2 = gsi::arg_reader<QSqlRecord & >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_primeInsert_2269 (arg1, arg2);
}


// void QSqlTableModel::queryChange()

static void _init_cbs_queryChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_queryChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_queryChange_0_0 ();
}

static void _set_callback_cbs_queryChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_queryChange_0_0 = cb;
}


// exposed int QSqlTableModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_receivers_c1731 (arg1));
}


// bool QSqlTableModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}


// bool QSqlTableModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}


// void QSqlTableModel::resetInternalData()

static void _init_cbs_resetInternalData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_resetInternalData_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_resetInternalData_0_0 ();
}

static void _set_callback_cbs_resetInternalData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_resetInternalData_0_0 = cb;
}


// void QSqlTableModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}


// void QSqlTableModel::revertRow(int row)

static void _init_cbs_revertRow_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_revertRow_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_revertRow_767_0 (arg1);
}

static void _set_callback_cbs_revertRow_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_revertRow_767_0 = cb;
}


// QHash<int, QByteArray> QSqlTableModel::roleNames()

static void _init_cbs_roleNames_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHash<int, QByteArray> > ();
}

static void _call_cbs_roleNames_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHash<int, QByteArray> > ((QHash<int, QByteArray>)((QSqlTableModel_Adaptor *)cls)->cbs_roleNames_c0_0 ());
}

static void _set_callback_cbs_roleNames_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_roleNames_c0_0 = cb;
}


// int QSqlTableModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<int > ((int)((QSqlTableModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}


// emitter void QSqlTableModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_rowsAboutToBeInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSqlTableModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)

static void _init_emitter_rowsAboutToBeMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceStart");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceEnd");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_rowsAboutToBeMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSqlTableModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsAboutToBeRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsAboutToBeRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_rowsAboutToBeRemoved_7372 (arg1, arg2, arg3);
}


// emitter void QSqlTableModel::rowsInserted(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsInserted_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsInserted_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_rowsInserted_7372 (arg1, arg2, arg3);
}


// emitter void QSqlTableModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)

static void _init_emitter_rowsMoved_10318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destination");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("row");
  decl->add_arg<int > (argspec_4);
  decl->set_return<void > ();
}

static void _call_emitter_rowsMoved_10318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg4 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg5 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_rowsMoved_10318 (arg1, arg2, arg3, arg4, arg5);
}


// emitter void QSqlTableModel::rowsRemoved(const QModelIndex &parent, int first, int last)

static void _init_emitter_rowsRemoved_7372 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_rowsRemoved_7372 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ((QSqlTableModel_Adaptor *)cls)->emitter_QSqlTableModel_rowsRemoved_7372 (arg1, arg2, arg3);
}


// bool QSqlTableModel::select()

static void _init_cbs_select_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_select_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_select_0_0 ());
}

static void _set_callback_cbs_select_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_select_0_0 = cb;
}


// bool QSqlTableModel::selectRow(int row)

static void _init_cbs_selectRow_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_selectRow_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_selectRow_767_0 (arg1));
}

static void _set_callback_cbs_selectRow_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_selectRow_767_0 = cb;
}


// QString QSqlTableModel::selectStatement()

static void _init_cbs_selectStatement_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_selectStatement_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSqlTableModel_Adaptor *)cls)->cbs_selectStatement_c0_0 ());
}

static void _set_callback_cbs_selectStatement_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_selectStatement_c0_0 = cb;
}


// exposed QObject *QSqlTableModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_sender_c0 ());
}


// exposed int QSqlTableModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_senderSignalIndex_c0 ());
}


// bool QSqlTableModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}


// void QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)

static void _init_cbs_setEditStrategy_3163_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strategy");
  decl->add_arg<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setEditStrategy_3163_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlTableModel::EditStrategy>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_setEditStrategy_3163_0 (arg1);
}

static void _set_callback_cbs_setEditStrategy_3163_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_setEditStrategy_3163_0 = cb;
}


// void QSqlTableModel::setFilter(const QString &filter)

static void _init_cbs_setFilter_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFilter_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_setFilter_2025_0 (arg1);
}

static void _set_callback_cbs_setFilter_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_setFilter_2025_0 = cb;
}


// bool QSqlTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}


// bool QSqlTableModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)

static void _init_cbs_setItemData_5414_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("roles");
  decl->add_arg<const QMap<int, QVariant> & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setItemData_5414_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QMap<int, QVariant> &arg2 = args.read<const QMap<int, QVariant> & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_setItemData_5414_0 (arg1, arg2));
}

static void _set_callback_cbs_setItemData_5414_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_setItemData_5414_0 = cb;
}


// exposed void QSqlTableModel::setLastError(const QSqlError &error)

static void _init_fp_setLastError_2220 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const QSqlError & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setLastError_2220 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlError &arg1 = gsi::arg_reader<const QSqlError & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_setLastError_2220 (arg1);
}


// exposed void QSqlTableModel::setPrimaryKey(const QSqlIndex &key)

static void _init_fp_setPrimaryKey_2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QSqlIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setPrimaryKey_2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlIndex &arg1 = gsi::arg_reader<const QSqlIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_setPrimaryKey_2202 (arg1);
}


// exposed void QSqlTableModel::setQuery(const QSqlQuery &query)

static void _init_fp_setQuery_2232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QSqlQuery & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setQuery_2232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSqlQuery &arg1 = gsi::arg_reader<const QSqlQuery & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->fp_QSqlTableModel_setQuery_2232 (arg1);
}


// void QSqlTableModel::setSort(int column, Qt::SortOrder order)

static void _init_cbs_setSort_2340_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSort_2340_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_setSort_2340_0 (arg1, arg2);
}

static void _set_callback_cbs_setSort_2340_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_setSort_2340_0 = cb;
}


// void QSqlTableModel::setTable(const QString &tableName)

static void _init_cbs_setTable_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setTable_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_setTable_2025_0 (arg1);
}

static void _set_callback_cbs_setTable_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_setTable_2025_0 = cb;
}


// QModelIndex QSqlTableModel::sibling(int row, int column, const QModelIndex &idx)

static void _init_cbs_sibling_c3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("idx");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_sibling_c3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QSqlTableModel_Adaptor *)cls)->cbs_sibling_c3713_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_sibling_c3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_sibling_c3713_0 = cb;
}


// void QSqlTableModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_sort_2340_0 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_sort_2340_0 = cb;
}


// QSize QSqlTableModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QSqlTableModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}


// bool QSqlTableModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}


// QFlags<Qt::DropAction> QSqlTableModel::supportedDragActions()

static void _init_cbs_supportedDragActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDragActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSqlTableModel_Adaptor *)cls)->cbs_supportedDragActions_c0_0 ());
}

static void _set_callback_cbs_supportedDragActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_supportedDragActions_c0_0 = cb;
}


// QFlags<Qt::DropAction> QSqlTableModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::DropAction> > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::DropAction> > ((QFlags<Qt::DropAction>)((QSqlTableModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}


// void QSqlTableModel::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSqlTableModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// bool QSqlTableModel::updateRowInTable(int row, const QSqlRecord &values)

static void _init_cbs_updateRowInTable_2964_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("values");
  decl->add_arg<const QSqlRecord & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_updateRowInTable_2964_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QSqlRecord &arg2 = args.read<const QSqlRecord & > (heap);
  ret.write<bool > ((bool)((QSqlTableModel_Adaptor *)cls)->cbs_updateRowInTable_2964_0 (arg1, arg2));
}

static void _set_callback_cbs_updateRowInTable_2964_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlTableModel_Adaptor *)cls)->cb_updateRowInTable_2964_0 = cb;
}


namespace gsi
{

gsi::Class<QSqlTableModel> &qtdecl_QSqlTableModel ();

static gsi::Methods methods_QSqlTableModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlTableModel::QSqlTableModel(QObject *parent, const QSqlDatabase &db)\nThis method creates an object of class QSqlTableModel.", &_init_ctor_QSqlTableModel_Adaptor_3681, &_call_ctor_QSqlTableModel_Adaptor_3681);
  methods += new qt_gsi::GenericMethod ("emit_beforeDelete", "@brief Emitter for signal void QSqlTableModel::beforeDelete(int row)\nCall this method to emit this signal.", false, &_init_emitter_beforeDelete_767, &_call_emitter_beforeDelete_767);
  methods += new qt_gsi::GenericMethod ("emit_beforeInsert", "@brief Emitter for signal void QSqlTableModel::beforeInsert(QSqlRecord &record)\nCall this method to emit this signal.", false, &_init_emitter_beforeInsert_1610, &_call_emitter_beforeInsert_1610);
  methods += new qt_gsi::GenericMethod ("emit_beforeUpdate", "@brief Emitter for signal void QSqlTableModel::beforeUpdate(int row, QSqlRecord &record)\nCall this method to emit this signal.", false, &_init_emitter_beforeUpdate_2269, &_call_emitter_beforeUpdate_2269);
  methods += new qt_gsi::GenericMethod ("*beginInsertColumns", "@brief Method void QSqlTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginInsertRows", "@brief Method void QSqlTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginMoveColumns", "@brief Method bool QSqlTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
  methods += new qt_gsi::GenericMethod ("*beginMoveRows", "@brief Method bool QSqlTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
  methods += new qt_gsi::GenericMethod ("*beginRemoveColumns", "@brief Method void QSqlTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
  methods += new qt_gsi::GenericMethod ("*beginRemoveRows", "@brief Method void QSqlTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
  methods += new qt_gsi::GenericMethod ("*beginResetModel", "@brief Method void QSqlTableModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QSqlTableModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@brief Virtual method bool QSqlTableModel::canDropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canDropMimeData", "@hide", true, &_init_cbs_canDropMimeData_c7425_0, &_call_cbs_canDropMimeData_c7425_0, &_set_callback_cbs_canDropMimeData_c7425_0);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QSqlTableModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_1, &_call_cbs_canFetchMore_c2395_1);
  methods += new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_1, &_call_cbs_canFetchMore_c2395_1, &_set_callback_cbs_canFetchMore_c2395_1);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndex", "@brief Method void QSqlTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
  methods += new qt_gsi::GenericMethod ("*changePersistentIndexList", "@brief Method void QSqlTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSqlTableModel::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QSqlTableModel::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@brief Virtual method bool QSqlTableModel::clearItemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("clearItemData", "@hide", false, &_init_cbs_clearItemData_2395_0, &_call_cbs_clearItemData_2395_0, &_set_callback_cbs_clearItemData_2395_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QSqlTableModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeInserted", "@brief Emitter for signal void QSqlTableModel::columnsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeInserted_7372, &_call_emitter_columnsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeMoved", "@brief Emitter for signal void QSqlTableModel::columnsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationColumn)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeMoved_10318, &_call_emitter_columnsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsAboutToBeRemoved", "@brief Emitter for signal void QSqlTableModel::columnsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsAboutToBeRemoved_7372, &_call_emitter_columnsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsInserted", "@brief Emitter for signal void QSqlTableModel::columnsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsInserted_7372, &_call_emitter_columnsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_columnsMoved", "@brief Emitter for signal void QSqlTableModel::columnsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int column)\nCall this method to emit this signal.", false, &_init_emitter_columnsMoved_10318, &_call_emitter_columnsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_columnsRemoved", "@brief Emitter for signal void QSqlTableModel::columnsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_columnsRemoved_7372, &_call_emitter_columnsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSqlTableModel::createIndex(int row, int column, const void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c3069, &_call_fp_createIndex_c3069);
  methods += new qt_gsi::GenericMethod ("*createIndex", "@brief Method QModelIndex QSqlTableModel::createIndex(int row, int column, quintptr id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2657, &_call_fp_createIndex_c2657);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSqlTableModel::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QSqlTableModel::data(const QModelIndex &idx, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
  methods += new qt_gsi::GenericMethod ("emit_dataChanged", "@brief Emitter for signal void QSqlTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nCall this method to emit this signal.", false, &_init_emitter_dataChanged_6833, &_call_emitter_dataChanged_6833);
  methods += new qt_gsi::GenericMethod ("*decodeData", "@brief Method bool QSqlTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
  methods += new qt_gsi::GenericMethod ("*deleteRowFromTable", "@brief Virtual method bool QSqlTableModel::deleteRowFromTable(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_deleteRowFromTable_767_0, &_call_cbs_deleteRowFromTable_767_0);
  methods += new qt_gsi::GenericMethod ("*deleteRowFromTable", "@hide", false, &_init_cbs_deleteRowFromTable_767_0, &_call_cbs_deleteRowFromTable_767_0, &_set_callback_cbs_deleteRowFromTable_767_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSqlTableModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSqlTableModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QSqlTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
  methods += new qt_gsi::GenericMethod ("*encodeData", "@brief Method void QSqlTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
  methods += new qt_gsi::GenericMethod ("*endInsertColumns", "@brief Method void QSqlTableModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
  methods += new qt_gsi::GenericMethod ("*endInsertRows", "@brief Method void QSqlTableModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
  methods += new qt_gsi::GenericMethod ("*endMoveColumns", "@brief Method void QSqlTableModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endMoveRows", "@brief Method void QSqlTableModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveColumns", "@brief Method void QSqlTableModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
  methods += new qt_gsi::GenericMethod ("*endRemoveRows", "@brief Method void QSqlTableModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
  methods += new qt_gsi::GenericMethod ("*endResetModel", "@brief Method void QSqlTableModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSqlTableModel::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSqlTableModel::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QSqlTableModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_1, &_call_cbs_fetchMore_2395_1);
  methods += new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_1, &_call_cbs_fetchMore_2395_1, &_set_callback_cbs_fetchMore_2395_1);
  methods += new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QSqlTableModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
  methods += new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QSqlTableModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
  methods += new qt_gsi::GenericMethod ("emit_headerDataChanged", "@brief Emitter for signal void QSqlTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_headerDataChanged_3231, &_call_emitter_headerDataChanged_3231);
  methods += new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QSqlTableModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
  methods += new qt_gsi::GenericMethod ("*indexInQuery", "@brief Virtual method QModelIndex QSqlTableModel::indexInQuery(const QModelIndex &item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexInQuery_c2395_0, &_call_cbs_indexInQuery_c2395_0);
  methods += new qt_gsi::GenericMethod ("*indexInQuery", "@hide", true, &_init_cbs_indexInQuery_c2395_0, &_call_cbs_indexInQuery_c2395_0, &_set_callback_cbs_indexInQuery_c2395_0);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QSqlTableModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("*insertRowIntoTable", "@brief Virtual method bool QSqlTableModel::insertRowIntoTable(const QSqlRecord &values)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRowIntoTable_2305_0, &_call_cbs_insertRowIntoTable_2305_0);
  methods += new qt_gsi::GenericMethod ("*insertRowIntoTable", "@hide", false, &_init_cbs_insertRowIntoTable_2305_0, &_call_cbs_insertRowIntoTable_2305_0, &_set_callback_cbs_insertRowIntoTable_2305_0);
  methods += new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QSqlTableModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSqlTableModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemData", "@brief Virtual method QMap<int, QVariant> QSqlTableModel::itemData(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemData", "@hide", true, &_init_cbs_itemData_c2395_0, &_call_cbs_itemData_c2395_0, &_set_callback_cbs_itemData_c2395_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutAboutToBeChanged", "@brief Emitter for signal void QSqlTableModel::layoutAboutToBeChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutAboutToBeChanged_7947, &_call_emitter_layoutAboutToBeChanged_7947);
  methods += new qt_gsi::GenericMethod ("emit_layoutChanged", "@brief Emitter for signal void QSqlTableModel::layoutChanged(const QList<QPersistentModelIndex> &parents, QAbstractItemModel::LayoutChangeHint hint)\nCall this method to emit this signal.", false, &_init_emitter_layoutChanged_7947, &_call_emitter_layoutChanged_7947);
  methods += new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QSqlTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
  methods += new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QSqlTableModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QSqlTableModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_modelAboutToBeReset", "@brief Emitter for signal void QSqlTableModel::modelAboutToBeReset()\nCall this method to emit this signal.", false, &_init_emitter_modelAboutToBeReset_3767, &_call_emitter_modelAboutToBeReset_3767);
  methods += new qt_gsi::GenericMethod ("emit_modelReset", "@brief Emitter for signal void QSqlTableModel::modelReset()\nCall this method to emit this signal.", false, &_init_emitter_modelReset_3767, &_call_emitter_modelReset_3767);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@brief Virtual method bool QSqlTableModel::moveColumns(const QModelIndex &sourceParent, int sourceColumn, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveColumns", "@hide", false, &_init_cbs_moveColumns_6659_0, &_call_cbs_moveColumns_6659_0, &_set_callback_cbs_moveColumns_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@brief Virtual method bool QSqlTableModel::moveRows(const QModelIndex &sourceParent, int sourceRow, int count, const QModelIndex &destinationParent, int destinationChild)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("moveRows", "@hide", false, &_init_cbs_moveRows_6659_0, &_call_cbs_moveRows_6659_0, &_set_callback_cbs_moveRows_6659_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@brief Virtual method void QSqlTableModel::multiData(const QModelIndex &index, QModelRoleDataSpan roleDataSpan)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("multiData", "@hide", true, &_init_cbs_multiData_c4483_0, &_call_cbs_multiData_c4483_0, &_set_callback_cbs_multiData_c4483_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QSqlTableModel::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*orderByClause", "@brief Virtual method QString QSqlTableModel::orderByClause()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_orderByClause_c0_0, &_call_cbs_orderByClause_c0_0);
  methods += new qt_gsi::GenericMethod ("*orderByClause", "@hide", true, &_init_cbs_orderByClause_c0_0, &_call_cbs_orderByClause_c0_0, &_set_callback_cbs_orderByClause_c0_0);
  methods += new qt_gsi::GenericMethod ("*persistentIndexList", "@brief Method QList<QModelIndex> QSqlTableModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
  methods += new qt_gsi::GenericMethod ("*primaryValues", "@brief Method QSqlRecord QSqlTableModel::primaryValues(int row)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_primaryValues_c767, &_call_fp_primaryValues_c767);
  methods += new qt_gsi::GenericMethod ("emit_primeInsert", "@brief Emitter for signal void QSqlTableModel::primeInsert(int row, QSqlRecord &record)\nCall this method to emit this signal.", false, &_init_emitter_primeInsert_2269, &_call_emitter_primeInsert_2269);
  methods += new qt_gsi::GenericMethod ("*queryChange", "@brief Virtual method void QSqlTableModel::queryChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_queryChange_0_0, &_call_cbs_queryChange_0_0);
  methods += new qt_gsi::GenericMethod ("*queryChange", "@hide", false, &_init_cbs_queryChange_0_0, &_call_cbs_queryChange_0_0, &_set_callback_cbs_queryChange_0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSqlTableModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QSqlTableModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QSqlTableModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@brief Virtual method void QSqlTableModel::resetInternalData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("*resetInternalData", "@hide", false, &_init_cbs_resetInternalData_0_0, &_call_cbs_resetInternalData_0_0, &_set_callback_cbs_resetInternalData_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QSqlTableModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
  methods += new qt_gsi::GenericMethod ("revertRow", "@brief Virtual method void QSqlTableModel::revertRow(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revertRow_767_0, &_call_cbs_revertRow_767_0);
  methods += new qt_gsi::GenericMethod ("revertRow", "@hide", false, &_init_cbs_revertRow_767_0, &_call_cbs_revertRow_767_0, &_set_callback_cbs_revertRow_767_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@brief Virtual method QHash<int, QByteArray> QSqlTableModel::roleNames()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("roleNames", "@hide", true, &_init_cbs_roleNames_c0_0, &_call_cbs_roleNames_c0_0, &_set_callback_cbs_roleNames_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QSqlTableModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeInserted", "@brief Emitter for signal void QSqlTableModel::rowsAboutToBeInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeInserted_7372, &_call_emitter_rowsAboutToBeInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeMoved", "@brief Emitter for signal void QSqlTableModel::rowsAboutToBeMoved(const QModelIndex &sourceParent, int sourceStart, int sourceEnd, const QModelIndex &destinationParent, int destinationRow)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeMoved_10318, &_call_emitter_rowsAboutToBeMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsAboutToBeRemoved", "@brief Emitter for signal void QSqlTableModel::rowsAboutToBeRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsAboutToBeRemoved_7372, &_call_emitter_rowsAboutToBeRemoved_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsInserted", "@brief Emitter for signal void QSqlTableModel::rowsInserted(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsInserted_7372, &_call_emitter_rowsInserted_7372);
  methods += new qt_gsi::GenericMethod ("emit_rowsMoved", "@brief Emitter for signal void QSqlTableModel::rowsMoved(const QModelIndex &parent, int start, int end, const QModelIndex &destination, int row)\nCall this method to emit this signal.", false, &_init_emitter_rowsMoved_10318, &_call_emitter_rowsMoved_10318);
  methods += new qt_gsi::GenericMethod ("emit_rowsRemoved", "@brief Emitter for signal void QSqlTableModel::rowsRemoved(const QModelIndex &parent, int first, int last)\nCall this method to emit this signal.", false, &_init_emitter_rowsRemoved_7372, &_call_emitter_rowsRemoved_7372);
  methods += new qt_gsi::GenericMethod ("select", "@brief Virtual method bool QSqlTableModel::select()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_select_0_0, &_call_cbs_select_0_0);
  methods += new qt_gsi::GenericMethod ("select", "@hide", false, &_init_cbs_select_0_0, &_call_cbs_select_0_0, &_set_callback_cbs_select_0_0);
  methods += new qt_gsi::GenericMethod ("selectRow", "@brief Virtual method bool QSqlTableModel::selectRow(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectRow_767_0, &_call_cbs_selectRow_767_0);
  methods += new qt_gsi::GenericMethod ("selectRow", "@hide", false, &_init_cbs_selectRow_767_0, &_call_cbs_selectRow_767_0, &_set_callback_cbs_selectRow_767_0);
  methods += new qt_gsi::GenericMethod ("*selectStatement", "@brief Virtual method QString QSqlTableModel::selectStatement()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectStatement_c0_0, &_call_cbs_selectStatement_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectStatement", "@hide", true, &_init_cbs_selectStatement_c0_0, &_call_cbs_selectStatement_c0_0, &_set_callback_cbs_selectStatement_c0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSqlTableModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSqlTableModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QSqlTableModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
  methods += new qt_gsi::GenericMethod ("setEditStrategy", "@brief Virtual method void QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy strategy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setEditStrategy_3163_0, &_call_cbs_setEditStrategy_3163_0);
  methods += new qt_gsi::GenericMethod ("setEditStrategy", "@hide", false, &_init_cbs_setEditStrategy_3163_0, &_call_cbs_setEditStrategy_3163_0, &_set_callback_cbs_setEditStrategy_3163_0);
  methods += new qt_gsi::GenericMethod ("setFilter", "@brief Virtual method void QSqlTableModel::setFilter(const QString &filter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFilter_2025_0, &_call_cbs_setFilter_2025_0);
  methods += new qt_gsi::GenericMethod ("setFilter", "@hide", false, &_init_cbs_setFilter_2025_0, &_call_cbs_setFilter_2025_0, &_set_callback_cbs_setFilter_2025_0);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QSqlTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
  methods += new qt_gsi::GenericMethod ("setItemData", "@brief Virtual method bool QSqlTableModel::setItemData(const QModelIndex &index, const QMap<int, QVariant> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("setItemData", "@hide", false, &_init_cbs_setItemData_5414_0, &_call_cbs_setItemData_5414_0, &_set_callback_cbs_setItemData_5414_0);
  methods += new qt_gsi::GenericMethod ("*setLastError", "@brief Method void QSqlTableModel::setLastError(const QSqlError &error)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setLastError_2220, &_call_fp_setLastError_2220);
  methods += new qt_gsi::GenericMethod ("*setPrimaryKey", "@brief Method void QSqlTableModel::setPrimaryKey(const QSqlIndex &key)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setPrimaryKey_2202, &_call_fp_setPrimaryKey_2202);
  methods += new qt_gsi::GenericMethod ("*setQuery", "@brief Method void QSqlTableModel::setQuery(const QSqlQuery &query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setQuery_2232, &_call_fp_setQuery_2232);
  methods += new qt_gsi::GenericMethod ("setSort", "@brief Virtual method void QSqlTableModel::setSort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSort_2340_0, &_call_cbs_setSort_2340_0);
  methods += new qt_gsi::GenericMethod ("setSort", "@hide", false, &_init_cbs_setSort_2340_0, &_call_cbs_setSort_2340_0, &_set_callback_cbs_setSort_2340_0);
  methods += new qt_gsi::GenericMethod ("setTable", "@brief Virtual method void QSqlTableModel::setTable(const QString &tableName)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setTable_2025_0, &_call_cbs_setTable_2025_0);
  methods += new qt_gsi::GenericMethod ("setTable", "@hide", false, &_init_cbs_setTable_2025_0, &_call_cbs_setTable_2025_0, &_set_callback_cbs_setTable_2025_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@brief Virtual method QModelIndex QSqlTableModel::sibling(int row, int column, const QModelIndex &idx)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sibling", "@hide", true, &_init_cbs_sibling_c3713_0, &_call_cbs_sibling_c3713_0, &_set_callback_cbs_sibling_c3713_0);
  methods += new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QSqlTableModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_0, &_call_cbs_sort_2340_0);
  methods += new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_0, &_call_cbs_sort_2340_0, &_set_callback_cbs_sort_2340_0);
  methods += new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QSqlTableModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
  methods += new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QSqlTableModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@brief Virtual method QFlags<Qt::DropAction> QSqlTableModel::supportedDragActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDragActions", "@hide", true, &_init_cbs_supportedDragActions_c0_0, &_call_cbs_supportedDragActions_c0_0, &_set_callback_cbs_supportedDragActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QSqlTableModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSqlTableModel::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateRowInTable", "@brief Virtual method bool QSqlTableModel::updateRowInTable(int row, const QSqlRecord &values)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateRowInTable_2964_0, &_call_cbs_updateRowInTable_2964_0);
  methods += new qt_gsi::GenericMethod ("*updateRowInTable", "@hide", false, &_init_cbs_updateRowInTable_2964_0, &_call_cbs_updateRowInTable_2964_0, &_set_callback_cbs_updateRowInTable_2964_0);
  return methods;
}

gsi::Class<QSqlTableModel_Adaptor> decl_QSqlTableModel_Adaptor (qtdecl_QSqlTableModel (), "QtSql", "QSqlTableModel",
  methods_QSqlTableModel_Adaptor (),
  "@qt\n@brief Binding of QSqlTableModel");

}


//  Implementation of the enum wrapper class for QSqlTableModel::EditStrategy
namespace qt_gsi
{

static gsi::Enum<QSqlTableModel::EditStrategy> decl_QSqlTableModel_EditStrategy_Enum ("QtSql", "QSqlTableModel_EditStrategy",
    gsi::enum_const ("OnFieldChange", QSqlTableModel::OnFieldChange, "@brief Enum constant QSqlTableModel::OnFieldChange") +
    gsi::enum_const ("OnRowChange", QSqlTableModel::OnRowChange, "@brief Enum constant QSqlTableModel::OnRowChange") +
    gsi::enum_const ("OnManualSubmit", QSqlTableModel::OnManualSubmit, "@brief Enum constant QSqlTableModel::OnManualSubmit"),
  "@qt\n@brief This class represents the QSqlTableModel::EditStrategy enum");

static gsi::QFlagsClass<QSqlTableModel::EditStrategy > decl_QSqlTableModel_EditStrategy_Enums ("QtSql", "QSqlTableModel_QFlags_EditStrategy",
  "@qt\n@brief This class represents the QFlags<QSqlTableModel::EditStrategy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlTableModel> inject_QSqlTableModel_EditStrategy_Enum_in_parent (decl_QSqlTableModel_EditStrategy_Enum.defs ());
static gsi::ClassExt<QSqlTableModel> decl_QSqlTableModel_EditStrategy_Enum_as_child (decl_QSqlTableModel_EditStrategy_Enum, "EditStrategy");
static gsi::ClassExt<QSqlTableModel> decl_QSqlTableModel_EditStrategy_Enums_as_child (decl_QSqlTableModel_EditStrategy_Enums, "QFlags_EditStrategy");

}

