C **************************** LICENSE START ***********************************
C
C Copyright 2012 ECMWF and INPE. This software is distributed under the terms
C of the Apache License version 2.0. In applying this license, ECMWF does not
C waive the privileges and immunities granted to it by virtue of its status as
C an Intergovernmental Organization or submit itself to any jurisdiction.
C
C ***************************** LICENSE END ************************************

      SUBROUTINE SPECPRO(P1,K1,P2,K2,MTRUNCS,MT,IPTS,IERROR)
C
C       CATALOGUES THE SPECTRA
C
C    INPUT :
C       P1      : SPECTRAL FIELD
C       K1      : LENGTH OF ARRAY P1
C       K2      : LENGTH OF ARRAY P2
C       MT      : TRUNCATE INPUT (ORIGINAL) VALUE
C       MTRUNCS : TRUNCATE OUTPUT VALUE
C       IPTS    : NUMBER OF STEPS
C
C    OUTPUT :
C       P2      : SPECTRA
C       IERROR  : 0 - NO ERROR,  1 - ERROR
C
      INTEGER	  cputenv
      INTEGER   K1,MTRUNCS,MT,IPTS,IERROR
      DIMENSION P1(K1),P2(K2)
C
C        CALCULATION OF SPECTRUM
C
      IERROR = 0
      IF(MT.LT.MTRUNCS) THEN
         JJ=cputenv('SPECTRA_ENV=TRUNCATION VALUE TOO BIG')
         IERROR = 1
         RETURN
      ENDIF

C       IF(NFIELDR.EQ.131 .OR. NFIELDR.EQ.132 .OR.
C     @    NFIELDR.EQ.160.OR. NFIELDR.EQ.161) MT = MT + 1
      DO 100 N=0,MTRUNCS
         PT = 0.
         DO 1000 M=0,N
            INDEXI = ( 2*(N+1) + M*(2*MT + 1 - M) )
            PT = PT + P1(INDEXI  )*P1(INDEXI  ) +
     @           P1(INDEXI-1)*P1(INDEXI-1)
 1000    CONTINUE
            P2((MTRUNCS+1)*(IPTS-1) + N+1) = SQRT(PT)
 100  CONTINUE

      RETURN
      END
