/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ExternalEditor_H
#include "ExternalEditor.h"
#endif

#ifndef ShellTask_H
#include "ShellTask.h"
#endif


ExternalEditor::ExternalEditor(const IconClass& name,const string& kind):
	Editor(name,kind)
{
}

ExternalEditor::~ExternalEditor()
{
}

void ExternalEditor::edit()
{
	task_ = new ShellTask(command(),current());
	task_->add(this);
	task_->start();
}

void ExternalEditor::success(Task* t,const Request&)
{
	if(t == task_)
	{
		current_->modified();
		notifyObserverApply(); 
		Editor::done();
	}
}

void ExternalEditor::failure(Task* t)
{
	if(t == task_)
	{
		notifyObserverClose(); 
		Editor::done();
	}
}

void ExternalEditor::empty()
{
	task_ = 0;
}
