
;;; file: e0basics.scm



; ; Boolean variables are classical:

; ; ¬¬p → p

; (av "p" (py "boole"))

; (set-goal (pf "((p -> F) -> F) -> p"))
; (cases)
; (prop)
; (prop)

; ; ok, ?_3 is proved in minimal propositional logic.  Proof finished.

; (save "classicalBoole")
; (display-theorems "classicalBoole")




; ;;; ExFalso fuer boolsche Ausdruecke ???

; ; ⊥ → F

; (set-goal (pf"F->p"))

; (cases)
; (prop)
; (prop)

; ; ok, ?_3 is proved in minimal propositional logic.  Proof finished.

; (save "ExFalsoBoole")
; (display-theorems "ExFalsoBoole")





;;; Basic Definitions




;;; For displaying purposes


(load "~/minlog/examples/ordinals/e0display.scm")



(is-numeric-term? (pt"Zero"))
; #t
(is-numeric-term? (pt"OP Zero"))
; #f
(is-numeric-term? (pt"OP (OP 11 22) (OP 33 44)"))
; #t

(is-finite-ordinal? (pt"0"))
; #t
(is-finite-ordinal? (pt"OP Zero"))
; #f
(is-finite-ordinal? (pt"OP (OP 11 22) (OP 33 44)"))
; #f

(is-infinite-ordinal? (pt"0"))
; #f
(is-infinite-ordinal? (pt"OP Zero"))
; #f
(is-infinite-ordinal? (pt"OP (OP 11 22) (OP 33 44)"))
; #t

(is-inford-token-tree? (term-to-token-tree (pt"0")))
; #f
(is-inford-token-tree? (term-to-token-tree (pt"OP 0 0")))
; #f
(is-inford-token-tree? (term-to-token-tree (pt"OP 1 0")))
; #t


; od: Ordinal display

(od (pt" Zero"))
; 0
(od (pt "27"))
; 27
(od (pt "OP 1 0"))
; ω+0
(od (pt "OP 1 1"))
; ω+1
(od (pt "OP 0 (OP 1 1)"))
; 1+ω+1


;;;;;;;;; End of displaying stuff ;;;;;





; Trivial but important:

; eqtrans: α=β -> β=α

(set-goal(pf"a=b -> b=a"))
(strip)
(simp 1)
(search)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(save "eqtrans")
(display-theorems "eqtrans")




(aga "OPinjective" (pf "all a,b,g,d.OP a b = OP g d -> (a=g & b=d)"))
(display-global-assumptions "OPinjective")


; noOPleftFixedPoint

(set-goal(pf"(OP a b = a -> F) & (a=OP a b -> F)"))
(ind); a
       (cases); b
       (auto)
(assume "a1" "a2" "IHa1" "IHa2" "b")
(drop "IHa2")
(cut(pf"OP(OP a1 a2)b=OP a1 a2 -> F"))
(assume "left")
(cut(pf"OP(OP a1 a2)b=OP a1 a2 -> F"))
(cut(pf"OP a1 a2=OP(OP a1 a2)b -> F"))
(search)
(assume "requ")
(use "left")
(use "eqtrans")
(auto)

; ?_9: OP(OP a1 a2)b=OP a1 a2 -> F

(assume "equ")
(use "IHa1" (pt"a2") 'left)
(use "OPinjective" (pt"b") (pt"a2"))
(use "equ")

; ok, ?_20 is proved.  Proof finished.

(save"noOPleftFixedPoint")
(display-theorems"noOPleftFixedPoint")



; noOPrightFixedPoint

(set-goal(pf"all a.(OP a b = b -> F) & (b=OP a b -> F)"))
(ind); b
     (search)
(assume "b1" "b2" "IHb1" "IHb2" "a")
(drop "IHb1")
(cut(pf"OP a(OP b1 b2)=OP b1 b2 -> F"))
(assume "left")
(cut(pf"OP a(OP b1 b2)=OP b1 b2 -> F"))
(cut(pf"OP b1 b2=OP a(OP b1 b2) -> F"))
(search)
(assume "requ")
(use "left")
(use "eqtrans")
(auto)

; ?_7: OP a(OP b1 b2)=OP b1 b2 -> F

(assume "equ")
(use "IHb2" (pt"b1"))
(cut (pf"a=b1  & OP b1 b2=b2"))
(search)
(use"OPinjective")
(use"equ")

; ok, ?_20 is proved.  Proof finished.

(save"noOPrightFixedPoint")
(display-theorems"noOPrightFixedPoint")



; New

(set-goal (pf"(a=0->F)->ex x,y.a=OP x y"))
(cases)
(search)
(assume "a" "b")
(strip)
(ex-intro (pt"a"))
(ex-intro (pt"b"))
(search)

(save "NonZeroConstructed")
(display-theorems "NonZeroConstructed")


;;; End of Trivial





; Classical Zero: ¬¬(α=0) -> α=0

(set-goal (pf "((a=Zero -> F) -> F) -> a=Zero"))
(assume "a")
(use "classicalBoole")

; ok, ?_2 is proved.  Proof finished.

(save "ClassicalZero")
(display-theorems  "ClassicalZero")






;; Predicate/Relation LESS

(add-program-constant
 "LESS"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)

(add-token
 "<"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "LESS")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "LESS"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "<"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules For LESS

(add-computation-rule (pt "LESS a Zero")(pt "False"))
(add-computation-rule (pt "LESS Zero (OP a b)")(pt "True"))
(add-computation-rule (pt "LESS (OP a b) (OP g d)")
 (pt "[if (a<g) (LESS b (OP g d))
          ([if (g<a) (LESS (OP a b) d)
               (LESS b d)
          ])
      ]"
 )
)

(display-program-constants "LESS")


; Test for Less

(term-to-string (nt (pt "Zero < Zero")))
; 0<0 = False
(term-to-string (nt (pt "Zero < (OP Zero Zero)")))
; 0<1 = True
(term-to-string (nt (pt "(OP Zero Zero) < Zero")))
; 1<0 = False
(term-to-string (nt (pt "(OP Zero Zero) < (OP (OP Zero Zero) Zero)")))
; 1<ω = True
(term-to-string (nt (pt "(OP (OP Zero Zero) Zero) < (OP (OP Zero Zero) Zero)")))
; ω<ω = False
(term-to-string (nt (pt "(OP (OP Zero Zero) Zero) < (OP (OP Zero Zero) (OP Zero Zero))")))
; ω<ω+1 = True
(term-to-string (nt (pt "(OP (OP Zero Zero) Zero) < (OP Zero (OP (OP Zero Zero) Zero))")))
; ω<1+ω = False




; RW-rules for LESS <

(display-program-constants "LESS")



; α < β  ->  β ≠ 0

(set-goal (pf "a<b -> b=Zero -> False"))
(assume "a" "b" "a<b" "b=0")
(cut (pf"a<b"))
(simp "b=0")
(auto)

; ok, ?_5 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt "LESS Zero b") 
                  (pt "[if (b=Zero)(False)(True)]"))
(display-program-constants "LESS")



; α<1 -> α=0

(set-goal(pf"a<1->a=0"))
(cases)
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"a<1") (pt"a=0"))



; LESSirreflexsive : α ≮ α


(set-goal (pf "LESS a a -> False"))
(ind)
     (search)
(assume "a1" "a2" "IHa1")
(ng)
(simp "IHa1")
(search)

; ok, ?_6 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt "a<a") (pt "F"))



; α < β  <-> ω^α < ω^β

;(display-program-constants "LESS")

(set-goal(pf "(a<b -> OP a 0 < OP b 0) & (OP a 0 < OP b 0 -> a<b)"))
(auto)

; ok, ?_1 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt "(OP a Zero)<(OP b Zero)")(pt "a<b"))


; β < γ  <->  ω^α+β < ω^α+γ

(set-goal(pf"(b<g -> OP a b < OP a g) & (OP a b < OP a g -> b<g)"))
(auto)
; ok, ?_1 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt "(OP a b)<(OP a g)")(pt "b<g"))



; α<β <-> 1+α < 1+β

(set-goal(pf"a<b ->OP 0 a < OP 0 b & OP 0 a < OP 0 b -> a<b"))
(auto)

; ok, ?_1 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"OP 0 a < OP 0 b") (pt"a<b"))




; α < ω  <->  a < 1+α

(set-goal(pf"( a < OP 1 0 -> a < OP 0 a ) & ( a < OP 0 a -> a < OP 1 0 )"))
(ind) ; a
(search)

(assume "a1" "a2")
(ng)
(casedist (pt"a1=0"))
(strip 1)
(simp 1)
(auto)

; ok, ?_7 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"a < OP 0 a")(pt"a<OP 1 0"))


; α < ω  <->  1+a < 2+α

(set-goal(pf"( a<OP 1 0 -> OP 0 a <OP 0 (OP 0 a) ) & ( OP 0 a <OP 0 (OP 0 a) -> a<OP 1 0 )"))
(auto)

; ok, ?_1 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"a < OP 0 (OP 0 a)")(pt"a<OP 1 0"))



; 1+α < α  -> False

(set-goal(pf"OP 0 a<a->F"))
(ind)
      (search)
(assume "a1" "a2")
(ng)
(casedist(pt"a1=0"))
(assume "a1=0")
(simp "a1=0")
(auto)

; ok, ?_7 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"OP 0 a<a")(pt"F"))



; β<1+ω^α -> α≠0 -> β<ω^α

(set-goal(pf "all a.b<OP 0 (OP a 0) -> (a=0->F) -> b<OP a 0"))
(ind); b
    (search)
(assume "b1" "b2" "IHb1" "IHb2")
(ng)
(casedist(pt "b1=0"))
(assume "b1=0")
(simp "b1=0")
(ng)
(cases)
(auto)

; ok, ?_7 is proved by minimal quantifier logic.  Proof finished.

; With other RW-rules we have
; β<1+ω^α <-> ( (α=0 & β<2) ∨ β<ω^α)

(add-rewrite-rule (pt"b<OP 0 (OP a 0)") (pt"[if (a=0) ([if (b=0)(T)(b=1)]) (b<OP a 0)]"))



; 0 ≠ α  <->  0 < α

(set-goal (pf "((a=0 -> F) -> 0<a)  &  (0<a -> a=0 -> F)"))
(cases)
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"0<a") (pt"[if (a=0) (F) (T)]"))


; End of LESS's RW-rules

(display-program-constants "LESS")










;; Classical Properties of LESS



; Thms



(set-goal (pf "((a<b -> F)-> F)-> a<b "))

(assume "a" "b")
(use "classicalBoole")

; ok, ?_2 is proved.  Proof finished.

(save "ClassicalLESS")
(display-theorems "ClassicalLESS")



; LESS antisym : ¬(α<β & β<α)

(set-goal (pf "all a,b.a<b -> b<a -> False"))

(ind); on a
(ng)
(strip 2)
(search)

(assume "a1" "a2")
(strip 2)
; ?_7: all b.OP a1 a2<b -> b<OP a1 a2 -> F

(ind); on b
(prop)

(assume "b1" "b2")
(strip 2)

(casedist (pt"a1<b1"))
(strip 1)
(cut (pf "b1<a1->F"))
(strip 1)
(ng)
(simp 5)
(simp 6)
(use 2)
(use 1)
(use 5)

; ?_13: (a1<b1 -> F) -> OP a1 a2<OP b1 b2 -> OP b1 b2<OP a1 a2 -> F
(strip 1)

(casedist (pt"b1<a1"))
(strip 1)
(ng)
(simp 5)
(simp 6)
(use 4)

; ?_13: (a1<b1 -> F) -> OP a1 a2<OP b1 b2 -> OP b1 b2<OP a1 a2 -> F
(strip 1)
(ng)
(simp 5)
(simp 6)
(use 2)

; ok, ?_32 is proved.  Proof finished.

(save "LESSantisym")
(display-theorems "LESSantisym")






;; To proof that LESS is a strict partial order
;; it remains to show its transitivity

;; We already have

;; irreflexsive
(display-program-constants "LESS")


;; antisymmetric
(display-theorems "LESSantisym")

 

; LESSEQUtrans : 

; Proof uses LESSantisym
; and hence also LESSirreflexsive



(display-program-constants "LESS")

(display "
 LESSEQUtrans
 ( α ≤ β  ->  β < γ  ->  α < γ )
 ( γ ≤ α  ->  α < β  ->  γ < β )
 ( β ≤ γ  ->  γ < α  ->  β < α )
 ( α < β  ->  β ≤ γ  ->  α < γ )
 ( γ < α  ->  α ≤ β  ->  γ < β )
 ( β < γ  ->  γ ≤ α  ->  β < α )
")


(set-goal
 (pf "all a,b,g.((b<a->F) -> b<g -> a<g)
     &((a<g->F) -> a<b -> g<b)
     &((g<b->F) -> g<a -> b<a)
     &(a<b -> (g<b->F) -> a<g)
     &(g<a -> (b<a->F) -> g<b)
     &(b<g -> (a<g->F) -> b<a)"))


(ind); on a

; a = 0
(ind); on b
    (strip)
    (prop); intuitionistic logic !!!
(assume "b1" "b2")
(strip 2)
(ind); on g
     (prop)
(assume "g1" "g2")

(strip)
(split)
(split)
(split)
(split)
(split)
(prop)
(ng)
(strip)
(cut (pf"F"))
(use "Efq-Atom") ; intu logic !!!
(use 5)
(use 6)
; ?_20: (OP g1 g2<OP b1 b2 -> F) -> OP g1 g2<Zero -> OP b1 b2<Zero
(prop)
(prop)
(ng)
(strip)
(cut (pf"F"))
(use "Efq-Atom") ; intu logic !!!
(use 5)
(prop)

; END of a=0



(assume "a1" "a2")
(strip 2)

(ind); on b
    (strip)
    (prop); intuitionistic logic !!!
(assume "b1" "b2")
(strip 2)
(ind); on g
    (prop); intuitionistic logic !!!
(assume "g1" "g2")
(strip)

(display "\n Hiding of useless hypos \n")
(drop '3 5)

; ?_43: (...
(casedist (pt"a1<b1"))
(strip 1)
(cut (pf"b1<a1->F"))
(strip 1)
(casedist (pt"a1<g1"))
(strip 1)
(cut (pf"g1<a1->F"))
(strip 1)
(ng)
(simp 7)
(simp 8)
(simp 9)
(simp 10)
(use-with 2 (pt"OP b1 b2") (pt"OP g1 g2"))
; ?_54: g1<a1 -> F
(use "LESSantisym")
(use 9)

; ?_51: (a1<g1 -> F) ->...
(strip)
(casedist (pt"g1<a1"))
(strip)
(cut(pf"g1<b1"))
(strip)
(cut(pf"b1<g1->F"))
(strip)
(ng)
(simp 9)
(simp 10)
(simp 11)
(simp 12)
(use 6)
; ?_70: b1<g1 -> F
(use "LESSantisym")
(use 11)
(cut(pf"b1<a1 -> F"))
(use 1)
(use 10)
(use 8)


; ?_64: (g1<a1 -> F) ->...
(strip)
(cut(pf"g1<b1"))
(strip)
(cut(pf"b1<g1->F"))
(strip)
(ng)
(simp 7)
(simp 8)
(simp 9)
(simp 10)
(simp 11)
(simp 12)
(use-with 2 (pt"OP b1 b2")(pt"g2"))
; ?_86: b1<g1 -> F
(use "LESSantisym")
(use 11)
(cut(pf"a1<b1"))
(use 1)
(use 9)
(use 7)
(use "LESSantisym")
(use 7)


; ?_45: (a1<b1 -> F) ->...
(strip 1)
(casedist (pt"b1<a1"))
(strip 1)
(casedist (pt"b1<g1"))
(strip 1)
(cut (pf"g1<b1->F"))
(strip 1)
(ng)
(simp 7)
(simp 8)
(simp 9)
(simp 10)
(use-with 4 (pt"OP g1 g2"))
; ?_108: g1<b1 -> F
(use "LESSantisym")
(use 9)

; ?_105: (b1<g1 -> F) ->...
(strip)
(cut (pf"g1<a1"))
(strip 1)
(cut (pf"a1<g1->F"))
(strip 1)
(casedist (pt"g1<b1"))
(strip 1)
(ng)
(simp 9)
(simp 10)
(simp 11)
(simp 12)
(use 6)

; ?_124: (g1<b1 -> F) ->...
(strip 1)
(ng)
(simp 7)
(simp 8)
(simp 9)
(simp 10)
(simp 11)
(simp 12)
(use-with 4 (pt"g2"))
; ?_121: a1<g1 -> F
(use "LESSantisym")
(use 10)
; ?_118: g1<a1
(cut (pf"b1<a1"))
(use 1)
(use 9)
(use 8)

; ?_102: (b1<a1 -> F) ->...
(strip)

(casedist (pt"b1<g1"))
(strip)
(cut (pf"g1<b1->F"))
(strip)
(cut (pf"g1<a1->F"))
(strip)
(cut (pf"a1<g1"))
(strip)
(ng)
(simp 7)
(simp 8)
(simp 9)
(simp 10)
(simp 11)
(simp 12)
(use-with 2 (pt"b2") (pt"OP g1 g2"))
; ?_153: a1<g1
(cut (pf"b1<g1"))
(use 1)
(use 8)
(use 9)
(strip)
(use 8)
(cut (pf"g1<a1"))
(use 1)
(use 10)
(use 11)
(use "LESSantisym")
(use 9)

; ?_144: (b1<g1 -> F) ->...
(strip)
(casedist (pt"g1<b1"))
(strip)
(cut (pf"a1<g1->F"))
(strip)
(cut (pf"g1<a1"))
(strip)
(ng)
(simp 9)
(simp 10)
(simp 11)
(simp 12)
(use 6)
; ?_179: g1<a1
(cut (pf"a1<b1 -> F"))
(use 1)
(use 10)
(use 7)
(strip)
(use 7)
(cut (pf"g1<b1"))
(use 1)
(use "LESSantisym")
(use 11)
(use 10)

; ?_143: (g1<b1 -> F) ->...
(strip)
(cut (pf"a1<g1->F"))
(strip)
(cut (pf"g1<a1->F"))
(strip)
(ng)
(simp 7)
(simp 8)
(simp 9)
(simp 10)
(simp 11)
(simp 12)
(use 2)
; ?_201: g1<a1 -> F
(strip)
(use 10)
(cut (pf"b1<a1 -> F"))
(use 1)
(use 12)
(use 8)
; ?_197: a1<g1 -> F
(strip)
(use 9)
(cut (pf"a1<g1"))
(use 1)
(use 7)
(use 11)

; ok, ?_218 is proved.  Proof finished.

(save "LESSEQUtrans")
(display-theorems "LESSEQUtrans")



;; Easy Corollaries of LESSEQUtrans

; uses also LESSantisym
; (beside implictly inside LESSEQUtrans)

(display "\n LESStrans: α < β  ->  β < γ  ->  α < γ \n")

(set-goal (pf "a<b -> b<g -> a<g"))

(assume "a" "b" "g")
(strip 1)
(cut (pf"b<a->F"))
(use "LESSEQUtrans")
(use "LESSantisym")
(use 1)

; ok, ?_6 is proved.  Proof finished.

(save "LESStrans")
(display-theorems "LESStrans")


; LESStransEQU:
; α≤β  ->  β < γ  ->  α ≤ γ
; α<β  ->  β ≤ γ  ->  α ≤ γ

(set-goal (pf "((b<a->F) -> b<g -> g<a -> F) & (a<b -> (g<b->F) -> g<a -> F)"))
(assume "b" "a" "g")
(split)

; ?_3: (b<a -> F) -> b<g -> g<a -> F

(strip)
(cut (pf"g<b"))
(use"LESSantisym")
(auto)
(cut(pf"b<a -> F"))
(use "LESSEQUtrans")
(auto)

; ?_4: a<b -> (g<b -> F) -> g<a -> F

(strip)
(cut (pf"g<b"))
;(use"LESSantisym")
(auto)
(cut(pf"a<b"))
(use "LESStrans")
(auto)

; ok, ?_16 is proved by minimal quantifier logic.  Proof finished.

(save "LESStransEQU")
(display-theorems "LESStransEQU")



; LESSEQUtransEQU:
; α≤β  ->  β ≤ γ  ->  α ≤ γ

(set-goal (pf "((b<a->F) -> (g<b->F) -> g<a -> F)"))
(assume "b" "a" "g")
(strip)
(cut (pf"b<a"))
(search)
(cut(pf"g<a"))
(use "LESSEQUtrans")
(auto)

; ok, ?_7 is proved by minimal quantifier logic.  Proof finished.

(save "LESSEQUtransEQU")
(display-theorems "LESSEQUtransEQU")






;;;;;;;;LESS is partial order ;;;;;;;

(display "\n LESS is strict partial order: \n")
(display-program-constants "LESS")
(display-theorems "LESSantisym")
(display-theorems "LESStrans")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;








;;; We introduce two equality prediactes
; and show the linearity of LESS

; but first an easy but important corollary:




; LESSlinear:

; ∀γ(γ<α -> γ<β) ->  ¬(β<α)
; ∀γ(α<γ -> β<γ) ->  ¬(α<β)
; ¬(α<β) -> ¬(β<α) ->  (α<γ -> β<γ) & (γ<α -> γ<β)

; Proof w/o induction !

(display-program-constants "LESS")

(set-goal(pf"((all g.g<a->g<b) -> b<a->F)
             &((all g.a<g->b<g) -> a<b->F)
             &(all g.(a<b->F)->(b<a->F)-> ((a<g->b<g) & (g<a->g<b)) )"))
(assume "a" "b")
(split)
(split)
(strip)
(cut (pf"b<b"))
(prop)
(cut(pf"b<a"))
(use 1)
(use 2)

; ?_6: (all g.a<g -> b<g) -> a<b -> F
(strip)
(cut (pf"b<b"))
(prop)
(cut(pf"a<b"))
(use 1)
(use 2)

(strip)
(split)

; ?_18: a<g -> b<g
(use "LESSEQUtrans")
(use 1)
; ?_19: g<a -> g<b
(strip)
(cut(pf"b<a -> F"))
(use "LESSEQUtrans")
(use 3)
(use 2)

> ; ok, ?_23 is proved.  Proof finished.

(save"LESSlinear")
(display-theorems"LESSlinear")





; Additional RW-rules for LESS <


; α < ω^α + β  &  α ≤ ω^β + α

(set-goal(pf"all a,b.a<OP a b & (OP b a<a ->F)"))
(ind); a
    (search)
(assume "a1" "a2" "IHa1" "IHa2")
(cut(pf "a1<OP a1 a2"))
(assume "a1<OP a1 a2")
(cut(pf "a2<OP(OP a1 a2)0"))
(assume "a2<OP(OP a1 a2)0")

; ?_10: all b OP a1 a2<OP(OP a1 a2)b

(ind); b
    (ng)
    (simp "a1<OP a1 a2")
    (simp "a2<OP(OP a1 a2)0")
    (ng)
    (casedist (pt"a1=0"))
    (search)
    (search)
(assume "b1" "b2" "IHb1" "IHb2")

; ?_19: OP a1 a2<OP(OP a1 a2)(OP b1 b2) & OP a1 a2≤OP(OP b1 b2)(OP a1 a2)

(cut(pf "a2<OP(OP a1 a2)(OP b1 b2)"))
(assume "a2<OP(OP a1 a2)(OP b1 b2)")
(cut(pf "OP(OP b1 b2)(OP a1 a2)<a2->F"))
(assume "a2 ≤ OP(OP b1 b2)(OP a1 a2)")
(ng)
(simp "a1<OP a1 a2")
(simp "a2<OP(OP a1 a2)(OP b1 b2)")
(simp "a2 ≤ OP(OP b1 b2)(OP a1 a2)")
;(search)
(casedist(pt"OP b1 b2<a1"))
(search)
(casedist(pt"a1<OP b1 b2"))
(search)
(search)

; ?_24: OP(OP b1 b2)(OP a1 a2)<a2 -> F

(use "LESSEQUtransEQU" (pt"OP(OP b1 b2) a2"))
(search)
(search)

; ?_21: a2<OP(OP a1 a2)(OP b1 b2)

(use "LESStrans" (pt"OP(OP a1 a2)0"))
(search)
(search)

; ?_9: a2<OP(OP a1 a2)0

(cut(pf"OP(OP a1 a2)0<OP a2 0 ->F"))
(use "LESSEQUtrans")
(auto)

; ok, ?_6 is proved by minimal quantifier logic.  Proof finished.


(add-rewrite-rule (pt"a<OP a b") (pt"T"))
(add-rewrite-rule (pt"OP b a<a") (pt"F"))


; End of <'s additional RW-rules

(display-program-constants "LESS")





; EXPmonotone: β≤α -> ω^β+γ ≤ ω^α+γ

(set-goal(pf"((a<b->F) -> OP a g < OP b g -> F)"))
(ind); a
    (ind); b
    (search)
    (search)
(assume "a1" "a2" "IHa1" "IHa2")
(ind); b
    (search)
(assume "b1" "b2" "IHb1" "IHb2" "g")

; ?_9: ((OP a1 a2<OP b1 b2 -> F) -> ...

(ng)
(casedist(pt "a1<b1"))
(assume "a1<b1")
(ng)
(assume "OP b1 b2 ≮ a2")
(simp "OP b1 b2 ≮ a2")
(search)
(assume "a1≮b1")
(ng)
(casedist(pt "b1<a1"))
(assume "b1<a1")
(ng)
(assume "OP a1 a2 ≮ b2")
(simp "OP a1 a2 ≮ b2")
(search)
(assume "b1≮a1")
(ng)
(assume "b2≮a2")
(simp "b2≮a2")
(search)

; ok, ?_28 is proved by minimal quantifier logic.  Proof finished.

(save "EXPmonotone")
(display-theorems "EXPmonotone")









; Predicate NLESS : ≮

; α≮β :≡ α<β -> F


;(remove-program-constant "NLESS")
(add-program-constant
 "NLESS"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)

;(remove-token "≠")
(add-token
 "≮"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "NLESS")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "NLESS"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "≮"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules for ≮

(add-computation-rule (pt "a≮b")(pt "[if (a<b) (F)(T)]"))


; Trivial but important

; Nless

(set-goal(pf"(a≮b->a<b->F) & ((a<b->F)->a≮b)"))
(assume "a" "b")
(ng)
(casedist(pt"a<b"))
(auto)

; ok, ?_5 is proved by minimal quantifier logic.  Proof finished.

(save"Nless")
(display-theorems"Nless")

; End of Trivial


(pp(nt(pt"0≮a")))
; 0≮α  =  α=0
(pp(nt(pt"a≮0")))
; α≮0 = True
(pp(nt(pt"a≮a")))
; α≮α = True
(pp(nt(pt"0≮OP a b")))
; 0≮ω^α+β = False
(pp(nt(pt"OP a b≮0")))
; ω^α+β≮0 = True
(pp(nt(pt"OP 0 a ≮ a")))
; True


(display-program-constants "NLESS")


; End of ≮





; Predicate NEQ : ≠

; α≠β :≡ α=β -> F


;(remove-program-constant "NEQ")
(add-program-constant
 "NEQ"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)

;(remove-token "≠")
(add-token
 "≠"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "NEQ")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "NEQ"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "≠"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules for ≠

(add-computation-rule (pt "a≠b")(pt "[if (a=b) (F)(T)]"))


; Trivial but important

; neq

(set-goal(pf"(a≠b->a=b->F) & ((a=b->F)->a≠b)"))
(assume "a" "b")
(ng)
(casedist(pt"a=b"))
(auto)

; ok, ?_5 is proved by minimal quantifier logic.  Proof finished.

(save"neq")
(display-theorems"neq")

; End of Trivial



; RW Rules for ≠


; ω^α+β≠α

(set-goal(pf"OP a b≠a"))
(assume "a" "b")
(use "neq")
(use "noOPleftFixedPoint")

; ok, ?_3 is proved.  Proof finished.

(add-rewrite-rule (pt"OP a b≠a")(pt"T"))


; ω^α+β≠β

(set-goal(pf"OP a b≠b"))
(assume "a" "b")
(use "neq")
(use "noOPrightFixedPoint")

; ok, ?_3 is proved.  Proof finished.

(add-rewrite-rule (pt"OP a b≠b")(pt"T"))


; End of Rewriterules

(display-program-constants "NEQ")

; End of ≠





; Predicate LE : ≤

; α≤β :≡ β<α -> F

;(remove-program-constant "LE")
(add-program-constant
 "LE"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)

;(remove-token "≤")
(add-token
 "≤"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "LE")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "LE"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "≤"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules for LE

(add-computation-rule (pt "a≤b")(pt "[if (b<a) (F)(T)]"))


; Trivial but important

; le: α≤β <-> (β<α -> F)

(set-goal (pf"(a≤b -> b<a -> F) & ((b<a -> F) -> a≤b)"))
(assume "a" "b")
(ng)
(casedist(pt"b<a"))
(auto)

; ok, ?_5 is proved in minimal propositional logic.  Proof finished.

(save "le")
(display-theorems "le")



; LEES2LE: α<β -> α≤β

(set-goal (pf"a<b -> a≤b"))
(assume "a" "b" "a<b")
(cut(pf"b<a->F"))
(assume "b≮a")
(ng)
(simp "b≮a")
(search)
(use "LESSantisym")
(search)

; ok, ?_8 is proved by minimal quantifier logic.  Proof finished.

(save"LEES2LE")
(display-theorems "LEES2LE")


; End of Trivial



; Now we reformulate LESSEQUtrans with this new predicatesymbol

(display-theorems "LESSEQUtrans")

; Clearly from LESSEQUtrans follows

(aga "LESSEQUtrans2" (pf "all a,b,g.
      (a≤b -> b<g -> a<g)
     &(g≤a -> a<b -> g<b)
     &(b≤g -> g<a -> b<a)
     &(a<b -> b≤g -> a<g)
     &(g<a -> a≤b -> g<b)
     &(b<g -> g≤a -> b<a)")
)
(display-global-assumptions "LESSEQUtrans2")


; also from LESSEQUtransEQU

(display-theorems "LESSEQUtransEQU")

(aga "LEtrans" (pf "all a,b,g.a≤b -> b≤g -> a≤g"))

(display-global-assumptions "LEtrans")



; also from LESStransEQU

(display-theorems "LESStransEQU")

(aga "LESStransLE" (pf"all a,b,g.(a≤b -> b<g -> a≤g) & (a<b -> b≤g -> a≤g)"))

(display-global-assumptions "LESStransLE")




; RW-rules for LE



; End of LE's RW-rules

(display-program-constants "LE")




; Now we have two ways to define equality
; EQU directly on the terms
; IC expressing imcomp.



; EQU: equality defined on terms

; for which we need the following:

; Function apn  :  ω^α -> α ,  ω^α+β -> 0 if β≠0

; apn "enumerates" the additive principal numbers

(add-program-constant "apn" (mk-arrow (py "ord") (py "ord")) 1 'const 1)

(add-computation-rule (pt "apn Zero") (pt "Zero"))
(add-computation-rule (pt "apn (OP a Zero)") (pt "a"))
(add-computation-rule (pt "apn (OP a (OP b g))")
  (pt "[if (LESS (OP a Zero) (OP b g) ) (apn (OP b g)) (Zero)]")
)

(display-program-constants "apn")


; Test for apn

(term-to-string (nt (pt "apn Zero")))
; apn(0) = 0
(term-to-string (nt (pt "apn (OP Zero Zero)")))
; apn(1) = 0
(term-to-string (nt (pt "apn (OP Zero (OP Zero Zero))")))
; apn(2) = 0
(term-to-string (nt (pt "apn (OP 1 0)")))
; apn(ω) = apn(ω^0+0) = 1
(term-to-string (nt (pt "apn (OP Zero (OP 1 0))")))
; apn(1+ω) = apn(ω^0+0) = 1
(term-to-string (nt (pt "apn (OP 1 1)")))
; apn(ω+1) = apn(ω^1+1) = 0
(term-to-string (nt (pt "apn (OP (OP 1 0) 0)")))
; apn(ω^ω) = apn(ω^ω+0) = ω



(add-program-constant
 "EQU"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)

;;; Computation Rules For EQU

(add-computation-rule (pt "EQU Zero Zero")(pt "True"))
(add-computation-rule (pt "EQU Zero (OP a b)")(pt "False"))

(add-computation-rule (pt "EQU (OP a b) Zero")(pt "False"))

(add-computation-rule (pt "EQU (OP Zero b) (OP g d)")
 (pt "[if (EQU Zero g)(EQU b d)(EQU b (OP g d))]")
)

(add-computation-rule (pt "EQU (OP (OP a b) Zero) (OP g d)")
 (pt "[if (EQU (OP a b) g) (EQU Zero d)
          ([if (EQU (OP(OP a b)Zero) d)(LESS g (apn d))(False)])
     ]")
)

(add-computation-rule (pt "EQU (OP (OP x y) (OP z t)) (OP Zero d)")
 (pt "[if (EQU Zero (OP x y))(EQU (OP z t) d)(EQU (OP(OP x y)(OP z t)) d )]")
)

(add-computation-rule (pt "EQU (OP(OP x y)(OP z t)) (OP(OP g d)Zero)")
 (pt "[if (EQU (OP x y) (OP g d)) (EQU Zero (OP z t))
          ([if (EQU (OP z t) (OP(OP x y)Zero) ) (EQU (OP z t) (OP(OP x y)(OP z t)))(False)])
     ]")
)

(add-computation-rule (pt "EQU (OP (OP a b) (OP g d)) (OP (OP x y) (OP z t))")
  (pt "[if (EQU (OP g d) (OP(OP a b)(OP g d)) ) (EQU (OP g d) (OP(OP x y)(OP z t)) )
           ([if (EQU (OP z t) (OP (OP x y) (OP z t))) (EQU (OP z t) (OP (OP a b) (OP g d)))
                ([if (EQU (OP g d) (OP z t)) ([if (EQU (OP a b) (OP x y))(True)(False)])
                     (False)
                ])
           ])
       ]")
)


(display-program-constants "EQU")


; Test for EQU

(term-to-string (nt (pt "EQU 0 0")) )
;  0=0 => True
(term-to-string (nt (pt "EQU (OP 0 (OP 1 0)) (OP 1 0)")) )
; 1+ω=ω => True
(term-to-string (nt (pt "EQU (OP 1 0) (OP 0 (OP 1 0)) ")) )
; ω=1+ω => True
(term-to-string (nt
 (pt "EQU  (OP 1 1) (OP 0 (OP 1 1))")
))
; ω+1=1+ω+1 => True

; End of Test




; IC: equality defined as ≤ ≥

; IC(α,β) ≡ ¬(α<β) & ¬(β<α)


(add-program-constant
 "IC"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)


;(add-computation-rule (pt "IC a b")(pt "[if (a<b) (False) ([if(b<a)(False) (True)])]"))
; a bit faster:

(add-computation-rule (pt "IC a b")
    (pt "[if (a=b) (True)
                   ([if (a<b)(False)
                             ([if(b<a)(False)
                                      (True)])])]")
)

(display-program-constants "IC")


; Test for IC

(term-to-string (nt (pt "IC Zero Zero")) )
;  0=0 => True
(term-to-string (nt (pt "IC 0 1")))
;  0=1 => False
(term-to-string (nt (pt "IC (OP Zero (OP (OP Zero Zero) Zero)) (OP (OP Zero Zero) Zero)")) )
; 1+ω=ω => True
(term-to-string (nt (pt "IC (OP (OP Zero Zero) Zero) (OP Zero (OP (OP Zero Zero) Zero)) ")) )
; ω=1+ω => True
(term-to-string (nt
 (pt "IC  (OP (OP Zero Zero) (OP Zero Zero)) (OP Zero (OP (OP Zero Zero) (OP Zero Zero)))")
))
; ω+1=1+ω+1 => True


; End







; Comparing IC with EQU :


; ω+(ω+1)=1+(ω+(ω+1)) => True

(display "\n EQU ω+(ω+1)=1+(ω+(ω+1)) =  ")
(time (term-to-string (nt
 (pt "EQU ( OP 1 (OP 1 0) ) ( OP 0 (OP 1 (OP 1 0)) )")
)))


(display "\n IC ω+(ω+1)=1+(ω+(ω+1)) =  ")
(time (term-to-string (nt
 (pt "IC ( OP 1 (OP 1 0) )( OP 0 (OP 1 (OP 1 0)) )")
)))


; 100 = 100

(display "\n EQU 100 100 =  ")
(time (term-to-string (nt (pt "EQU 100 100"))))

(display "\n IC 100 100 =  ")
(time (term-to-string (nt (pt "IC 100 100 "))))

; End of comparing


;;; Certainly, one could show that EQU iff IC
;;; Feel free to do so if you don't mind the case distinction :-)

; For the time being we favour IC:



(add-token
 "~"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "IC")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "IC"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "~"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))



(display-program-constants "IC")

(pp(nt(pt"0~1")))
; "False"
(pp(nt(pt"a~a")))
; "True"
(pp(nt(pt"a~b")))
; "[if (a=b) True [if (a<b) False [if (b<a) False True]]]"




; Trivial but important

; IC: α~β -> α≤β

(set-goal(pf"(a~b -> (a≤b & b≤a)) & (a≤b -> b≤a -> a~b)"))
(assume "a" "b")
(ng)
(casedist(pt"a=b"))
(assume "a=b")
(simp "a=b")
(search)
(assume "a≠b")
(ng)

; ?_9: ([if (a<b)...

(casedist(pt"a<b"))
(assume "a<b")
(cut(pf"b<a->F"))
(assume "b≮a")
(simp "b≮a")
(search)
(use "LESSantisym")
(auto)

; ok, ?_11 is proved by minimal quantifier logic.  Proof finished.

(save "ic")
(display-theorems "ic")




; RW-rules for IC ~


; α≠0 -> ( 1+ω^α+β ≤ ω^α+β )  &  ( 1+ω^α+β ~ ω^α+β )

(set-goal(pf"a≠0 -> (OP a b < OP 0 (OP a b) -> F) & (OP 0 (OP a b) ≤ OP a b) & (OP 0 (OP a b) ~ OP a b)"))
(cases) ; a
(assume "b")
(prop) ; INTU
(auto)

; ok, ?_3 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"OP a b < OP 0 (OP a b)")(pt"[if (a=0)(b<OP 1 0)(F)]"))
(add-rewrite-rule (pt"OP 0 (OP a b) ≤ OP a b")(pt"[if (a=0)(OP 1 0 ≤ b)(T)]"))
(add-rewrite-rule (pt"OP 0 (OP a b) ~ OP a b")(pt"[if (a=0)(OP 1 0 ≤ b)(T)]"))



; α=1+α <-> ω≤α

(set-goal(pf"(a~OP 0 a -> OP 1 0 ≤ a) & (OP 1 0 ≤ a -> a~OP 0 a)"))
(assume "a")
(ng)
(cut(pf"a=OP 0 a->F"))
(assume "nfpr")
(simp "nfpr")
(casedist(pt"a<OP 1 0"))
(auto)
(use "noOPrightFixedPoint")

; ok, ?_5 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"a~OP 0 a")(pt"OP 1 0 ≤ a"))



;  ω ≤ β  <->  1+β ~ β

(set-goal(pf"( OP 1 0 ≤ b -> OP 0 b ~ b)  &  (OP 0 b ~  b -> OP 1 0 ≤ b)"))
(ind)
     (search)
(assume "b1" "b2")
(ng)
(casedist(pt"b1=0"))
(assume "b1=0")
(simp "b1=0")
(auto)

; ok, ?_7 is proved by minimal quantifier logic.  Proof finished.

(add-rewrite-rule (pt"OP 0 b ~ b") (pt"OP 1 0≤b"))

; End of IC's RW-rules

(display-program-constants "IC")






;;;; IC ~ is an equivalence relation.

; reflexsive

(pp(nt(pt"a~a")))
;"True"

; ICsym: α~β->β~α 

(set-goal(pf"a~b -> b~a"))
(assume "a" "b")

(ng)
(casedist (pt"a<b"))
(strip 1)
(cut (pf"b<a->F"))
(strip 1)
(ng)
(strip)
(simp 3)
(search)
(use "LESSantisym")
(use 1)

; ?_5: (a<b -> F) -> a~b -> b~a
(ng)
(strip 1)
(casedist (pt "b<a"))
(strip 1)
(ng)
(strip)
(simp 3)
(auto)

; ok, ?_17 is proved in minimal propositional logic.  Proof finished.

(save"ICsym")
(display-theorems"ICsym")


; ICtrans:
; α~β ⇒ β~γ ⇒ α~γ

(set-goal(pf"a~b -> b~g -> a~g"))

(assume "a" "b" "g")
(ng)

(casedist (pt"a=g"))
(search)

; ?_5: (a=g -> F) ->...

(casedist (pt"a<g"))
(casedist (pt"b<g"))
(strip 2)
(cut (pf"b=g->F"))
(strip 1)
(simp 3)
(search)
(strip)
(cut (pf"b<b"))
(search)
(cut (pf"b<g"))
(simp 3)
(auto)

; ?_9: (b<g -> F) ->...

(casedist (pt"g<b"))
(strip 2)
(cut (pf"b=g->F"))
(strip 1)
(simp 3)
(search)
(strip)
(cut (pf"b<b"))
(search)
(cut (pf"g<b"))
(simp 3)
(auto)

; ?_22: (g<b -> F) -> (b<g -> F) -> a<g -> (a=g -> F) ->...

(strip 4)
(cut (pf"a=b->F"))
(strip 1)
(cut (pf"a<b"))
(strip 1)
(simp 5)
(simp 6)
(search)
(cut (pf"b<g -> F"))
(use "LESSEQUtrans")
(use 3)
(use 2)
(strip)
(cut (pf"a<g"))
(simp 5)
(use 2)
(use 3)

; ?_7: (a<g -> F) ->...
(ng)
(casedist (pt"g<a"))
(casedist (pt"b=g"))
(strip 4)
(cut (pf"a=b->F"))
(strip 1)
(cut (pf"b<a"))
(strip 1)
(cut (pf"a<b->F"))
(strip 1)
(simp 5)
(simp 6)
(search)
(simp 1)
(use 3)
(simp 1)
(use 2)
(simp 1)
(use 4)

; ?_54: (b=g -> F) -> g<a -> (a<g -> F) -> (a=g -> F) ->...
(ng)
(casedist (pt"b<g"))
(search)

; ?_72: (b<g -> F) -> (b=g -> F) -> g<a -> (a<g -> F) -> (a=g -> F) ->...
(ng)
(casedist (pt"g<b"))
(search)

; ?_71: (g<b -> F) -> (b<g -> F) -> (b=g -> F) -> g<a ->...
(strip 6)
(cut (pf "b<a"))
(strip 1)
(cut (pf "a=b->F"))
(strip 1)
(cut (pf "a<b->F"))
(strip 1)
(simp 7)
(simp 8)
(search)
(use "LESSantisym")
(use 7)
(strip)
(cut (pf "g<a"))
(simp 8)
(use 1)
(use 4)
(cut (pf"g<a"))
(use "LESSEQUtrans")
(use 1)
(use 4)

; ?_52: (g<a -> F) -> (a<g -> F) -> (a=g -> F) ->...
(search)

; ok, ?_52 is proved in minimal propositional logic.  Proof finished.

(save"ICtrans")
(display-theorems"ICtrans")



;;; IC is equivalence relation ;;;

(pp(nt(pt"a~a")))
; "True"
(display-theorems"ICsym")
(display-theorems"ICtrans")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



; α<β v α~β v α>β

; Per definitionem of IC the linearity of LESS follows,
; i.e.
; (a<b->F) -> (b<a->F) -> a~b






; Some arithmetic

; InfiniteLess+One: α≠0 -> γ<1+ω^α+β -> γ<ω^α+β

(set-goal(pf"a≠0 -> g<OP 0 (OP a b) -> g<OP a b"))
(cases)
     (assume "g" "b")
     (prop) ; INTU !!!
(assume "a1" "a2")
(cases)
(search)
(assume "g1" "g2")
(ng)
(casedist(pt"g1=0"))
(assume "g1=0")
(simp "g1=0")
(auto)

; ok, ?_11 is proved by minimal quantifier logic.  Proof finished.

(save "InfiniteLess+One")
(display-theorems "InfiniteLess+One")




(load "~/minlog/examples/ordinals/e0end.scm")

; EOF