# Payment and billing

Since we host our repositories on GitHub, including both the Material for MkDocs
community edition and the private Insiders edition, [GitHub Sponsors] is a
natural fit for handling all financial transactions, as well as for access
management to the Insiders repository.

Therefore, to become a sponsor of Material for MkDocs, a [GitHub account] is mandatory.

  [GitHub Sponsors]: https://github.com/sponsors
  [GitHub account]: https://docs.github.com/en/get-started/start-your-journey/creating-an-account-on-github

## Payment

GitHub Sponsors currently only accepts payments via credit card, as they
[removed support for PayPal] at the beginning of 2023. When
entering your credit card details, ensure that the card remains [valid over an
extended period] to prevent any disruptions to your sponsorship.

  [valid over an extended period]: runtime-and-cancellation.md#automatic-cancellation
  [removed support for PayPal]: https://github.blog/changelog/2023-01-23-github-sponsors-will-stop-supporting-paypal/

## Invoices

GitHub Sponsors automatically issues and send a payment receipt via email after
each billing cycle. These receipts serve as confirmation of payment rather than
formal invoices. As all transactions are managed by [GitHub Sponsors], GitHub is
your primary point of contact for payment and billing matters, not us.

If you need an official invoice from us for your records, please get in touch
with us at sponsors@squidfunk.com before initiating your sponsorship.

## Refunds

Our team does not have insights or access to details related to sponsorship
transactions of our sponsors, as GitHub does not provide us with this
information. For questions regarding payment issues or for more detailed
information about your sponsorship, please get in touch with the [GitHub
support] team.

  [GitHub support]: https://support.github.com/

## Discounts

Unfortunately, we can't offer discounts. To ensure that everyone in our
community can afford to become a sponsor, we keep the barrier low and set
prices as low as possible, starting at [\$15 a month][15] for
[non-commercial use] and at [\$125 a month][125] for [commercial use].

  [15]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=210638
  [125]: https://github.com/sponsors/squidfunk/sponsorships?tier_id=210643
  [non-commercial use]: sponsoring-tiers.md/#non-commercial-use
  [commercial use]: sponsoring-tiers.md/#commercial-use

## Free access

Free access to the Insiders edition is only granted exclusively to our [Community
Experts] and to selected members of the MkDocs ecosystem. Our Community Experts
program is designed to recognize and reward users who significantly contribute
to the community by sharing their expertise on our [discussion board].

Our discussion board facilitates the exchange of insights on workarounds, setups,
and features and addresses queries from users at all levels of experience. All
communication is public and visible for the entire community, benefitting
everyone.

Community experts not only enrich our project but also enable our team to focus
on continuous improvement and the development of new features. Therefore, we are
happy to provide them with free access to the private Insiders repository and
encourage you to [join the team] as well!

  [community experts]: community-experts-program/index.md
  [discussion board]: https://github.com/squidfunk/mkdocs-material/discussions
  [join the team]: community-experts-program/index.md/#ready-to-get-started

## Billing cycle

The [billing cycle] is an account-level setting on GitHub and is set to monthly
or yearly. It can be changed at any time, so you might want to check the setting
before sponsoring and change it either to monthly or yearly according to your
own or your organization's preferences.

If, for whatever reason, you cannot change your billing cycle, a practical
solution is to create a dedicated [GitHub bot account] where you set the billing
cycle accordingly and use it specifically for your sponsorship contributions.
This is a strategy many of our organizational sponsors have successfully
implemented.

If you experience any difficulties or have further questions before sponsoring,
please don't hesitate to contact us at sponsors@squidfunk.com for additional
support.

  [billing cycle]: https://docs.github.com/en/github/setting-up-and-managing-billing-and-payments-on-github/changing-the-duration-of-your-billing-cycle
  [GitHub bot account]: https://docs.github.com/en/get-started/start-your-journey/creating-an-account-on-github
