<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## mermaidAPI

Edit this
Page[\[N|Solid\](img/GitHub-Mark-32px.png)][1]

This is the API to be used when optionally handling the integration with the web page, instead of
using the default integration provided by mermaid.js.

The core of this api is the [**render**][2] function which, given a graph
definition as text, renders the graph/diagram and returns an svg element for the graph.

It is is then up to the user of the API to make use of the svg, either insert it somewhere in the
page or do something completely different.

In addition to the render function, a number of behavioral configuration options are available.

## Configuration

**Configuration methods in Mermaid version 8.6.0 have been updated, to learn more\[[click
here][3]].**

## **What follows are config instructions for older versions**

These are the default options which can be overridden with the initialization call like so:

**Example 1:**<pre> mermaid.initialize({ flowchart:{ htmlLabels: false } }); </pre>

**Example 2:**<pre> <script> var config = { startOnLoad:true, flowchart:{ useMaxWidth:true,
htmlLabels:true, curve:'cardinal', },

    securityLevel:'loose',

}; mermaid.initialize(config); </script> </pre>

A summary of all options and their defaults is found [here][4].
A description of each option follows below.

## theme

Theme , the CSS style sheet

| Parameter | Description     | Type   | Required | Values                                         |
| --------- | --------------- | ------ | -------- | ---------------------------------------------- |
| theme     | Built in Themes | string | Optional | 'default', 'forest', 'dark', 'neutral', 'null' |

**Notes:** To disable any pre-defined mermaid theme, use "null".<pre> "theme": "forest",
"themeCSS": ".node rect { fill: red; }" </pre>

## fontFamily

| Parameter  | Description                                            | Type   | Required | Values                      |
| ---------- | ------------------------------------------------------ | ------ | -------- | --------------------------- |
| fontFamily | specifies the font to be used in the rendered diagrams | string | Required | Any Possible CSS FontFamily |

**Notes:** Default value: '"trebuchet ms", verdana, arial, sans-serif;'.

## logLevel

| Parameter | Description                                           | Type             | Required | Values        |
| --------- | ----------------------------------------------------- | ---------------- | -------- | ------------- |
| logLevel  | This option decides the amount of logging to be used. | string \| number | Required | 1, 2, 3, 4, 5 |

**Notes:**

-   Debug: 1
-   Info: 2
-   Warn: 3
-   Error: 4
-   Fatal: 5 (default)

## securityLevel

| Parameter     | Description                       | Type   | Required | Values                          |
| ------------- | --------------------------------- | ------ | -------- | ------------------------------- |
| securitylevel | Level of trust for parsed diagram | string | Required | 'strict', 'loose', 'antiscript' |

**Notes**:

-   **strict**: (**default**) tags in text are encoded, click functionality is disabled
-   **loose**: tags in text are allowed, click functionality is enabled
-   **antiscript**: html tags in text are allowed, (only script element is removed), click
    functionality is enabled

## startOnLoad

| Parameter   | Description                                  | Type    | Required | Values      |
| ----------- | -------------------------------------------- | ------- | -------- | ----------- |
| startOnLoad | Dictates whether mermaid starts on Page load | boolean | Required | true, false |

**Notes:** Default value: true

## arrowMarkerAbsolute

| Parameter           | Description                                                                  | Type    | Required | Values      |
| ------------------- | ---------------------------------------------------------------------------- | ------- | -------- | ----------- |
| arrowMarkerAbsolute | Controls whether or arrow markers in html code are absolute paths or anchors | boolean | Required | true, false |

**Notes**:

This matters if you are using base tag settings.

Default value: false

## secure

This option controls which currentConfig keys are considered _secure_ and can only be changed
via call to mermaidAPI.initialize. Calls to mermaidAPI.reinitialize cannot make changes to the
`secure` keys in the current currentConfig. This prevents malicious graph directives from
overriding a site's default security.

**Notes**:

Default value: ['secure', 'securityLevel', 'startOnLoad', 'maxTextSize']

## deterministicIds

This option controls if the generated ids of nodes in the SVG are generated randomly or based
on a seed. If set to false, the IDs are generated based on the current date and thus are not
deterministic. This is the default behaviour.

**Notes**:

This matters if your files are checked into sourcecontrol e.g. git and should not change unless
content is changed.

Default value: false

## deterministicIDSeed

This option is the optional seed for deterministic ids. if set to undefined but
deterministicIds is true, a simple number iterator is used. You can set this attribute to base
the seed on a static string.

## flowchart

The object containing configurations specific for flowcharts

### diagramPadding

| Parameter      | Description                                     | Type    | Required | Values             |
| -------------- | ----------------------------------------------- | ------- | -------- | ------------------ |
| diagramPadding | Amount of padding around the diagram as a whole | Integer | Required | Any Positive Value |

**Notes:**

The amount of padding around the diagram as a whole so that embedded diagrams have margins,
expressed in pixels

Default value: 8

### htmlLabels

| Parameter  | Description                                                                                  | Type    | Required | Values      |
| ---------- | -------------------------------------------------------------------------------------------- | ------- | -------- | ----------- |
| htmlLabels | Flag for setting whether or not a html tag should be used for rendering labels on the edges. | boolean | Required | true, false |

**Notes:** Default value: true.

### nodeSpacing

| Parameter   | Description                                         | Type    | Required | Values              |
| ----------- | --------------------------------------------------- | ------- | -------- | ------------------- |
| nodeSpacing | Defines the spacing between nodes on the same level | Integer | Required | Any positive Number |

**Notes:**

Pertains to horizontal spacing for TB (top to bottom) or BT (bottom to top) graphs, and the
vertical spacing for LR as well as RL graphs.\*\*

Default value: 50

### rankSpacing

| Parameter   | Description                                           | Type    | Required | Values              |
| ----------- | ----------------------------------------------------- | ------- | -------- | ------------------- |
| rankSpacing | Defines the spacing between nodes on different levels | Integer | Required | Any Positive Number |

**Notes**:

Pertains to vertical spacing for TB (top to bottom) or BT (bottom to top), and the horizontal
spacing for LR as well as RL graphs.

Default value 50

### curve

| Parameter | Description                                        | Type   | Required | Values                        |
| --------- | -------------------------------------------------- | ------ | -------- | ----------------------------- |
| curve     | Defines how mermaid renders curves for flowcharts. | string | Required | 'basis', 'linear', 'cardinal' |

**Notes:**

Default Value: 'basis'

### useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See notes   | boolean | 4        | true, false |

**Notes:**

When this flag is set the height and width is set to 100% and is then scaling with the
available space if not the absolute space required is used.

Default value: true

### defaultRenderer

| Parameter       | Description | Type    | Required | Values                  |
| --------------- | ----------- | ------- | -------- | ----------------------- |
| defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper |

**Notes:**

Decides which rendering engine that is to be used for the rendering. Legal values are:
dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid

Default value: 'dagre-d3'

## sequence

The object containing configurations specific for sequence diagrams

### activationWidth

| Parameter       | Description                  | Type    | Required | Values             |
| --------------- | ---------------------------- | ------- | -------- | ------------------ |
| activationWidth | Width of the activation rect | Integer | Required | Any Positive Value |

**Notes:** Default value :10

### diagramMarginX

| Parameter      | Description                                          | Type    | Required | Values             |
| -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
| diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |

**Notes:** Default value: 50

### diagramMarginY

| Parameter      | Description                                       | Type    | Required | Values             |
| -------------- | ------------------------------------------------- | ------- | -------- | ------------------ |
| diagramMarginY | Margin to the over and under the sequence diagram | Integer | Required | Any Positive Value |

**Notes:** Default value: 10

### actorMargin

| Parameter   | Description           | Type    | Required | Values             |
| ----------- | --------------------- | ------- | -------- | ------------------ |
| actorMargin | Margin between actors | Integer | Required | Any Positive Value |

**Notes:** Default value: 50

### width

| Parameter | Description          | Type    | Required | Values             |
| --------- | -------------------- | ------- | -------- | ------------------ |
| width     | Width of actor boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 150

### height

| Parameter | Description           | Type    | Required | Values             |
| --------- | --------------------- | ------- | -------- | ------------------ |
| height    | Height of actor boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 65

### boxMargin

| Parameter | Description              | Type    | Required | Values             |
| --------- | ------------------------ | ------- | -------- | ------------------ |
| boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 10

### boxTextMargin

| Parameter     | Description                                  | Type    | Required | Values             |
| ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
| boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 5

### noteMargin

| Parameter  | Description         | Type    | Required | Values             |
| ---------- | ------------------- | ------- | -------- | ------------------ |
| noteMargin | margin around notes | Integer | Required | Any Positive Value |

**Notes:** Default value: 10

### messageMargin

| Parameter     | Description            | Type    | Required | Values             |
| ------------- | ---------------------- | ------- | -------- | ------------------ |
| messageMargin | Space between messages | Integer | Required | Any Positive Value |

**Notes:** Default value: 35

### messageAlign

| Parameter    | Description                 | Type   | Required | Values                    |
| ------------ | --------------------------- | ------ | -------- | ------------------------- |
| messageAlign | Multiline message alignment | string | Required | 'left', 'center', 'right' |

**Notes:** Default value: 'center'

### mirrorActors

| Parameter    | Description                 | Type    | Required | Values      |
| ------------ | --------------------------- | ------- | -------- | ----------- |
| mirrorActors | Mirror actors under diagram | boolean | Required | true, false |

**Notes:** Default value: true

### forceMenus

| Parameter  | Description                                                             | Type    | Required | Values      |
| ---------- | ----------------------------------------------------------------------- | ------- | -------- | ----------- |
| forceMenus | forces actor popup menus to always be visible (to support E2E testing). | Boolean | Required | True, False |

**Notes:**

Default value: false.

### bottomMarginAdj

| Parameter       | Description                                | Type    | Required | Values             |
| --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
| bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | Required | Any Positive Value |

**Notes:**

Depending on css styling this might need adjustment.

Default value: 1

### useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See Notes   | boolean | Required | true, false |

**Notes:** When this flag is set to true, the height and width is set to 100% and is then
scaling with the available space. If set to false, the absolute space required is used.

Default value: true

### rightAngles

| Parameter   | Description                          | Type    | Required | Values      |
| ----------- | ------------------------------------ | ------- | -------- | ----------- |
| rightAngles | display curve arrows as right angles | boolean | Required | true, false |

**Notes:**

This will display arrows that start and begin at the same node as right angles, rather than a curve

Default value: false

### showSequenceNumbers

| Parameter           | Description                     | Type    | Required | Values      |
| ------------------- | ------------------------------- | ------- | -------- | ----------- |
| showSequenceNumbers | This will show the node numbers | boolean | Required | true, false |

**Notes:** Default value: false

### actorFontSize

| Parameter     | Description                                        | Type    | Required | Values             |
| ------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
| actorFontSize | This sets the font size of the actor's description | Integer | Require  | Any Positive Value |

**Notes:** **Default value 14**..

### actorFontFamily

| Parameter       | Description                                          | Type   | Required | Values                      |
| --------------- | ---------------------------------------------------- | ------ | -------- | --------------------------- |
| actorFontFamily | This sets the font family of the actor's description | string | Required | Any Possible CSS FontFamily |

**Notes:** Default value: "'Open-Sans", "sans-serif"'

### actorFontWeight

This sets the font weight of the actor's description

**Notes:** Default value: 400.

### noteFontSize

| Parameter    | Description                                     | Type    | Required | Values             |
| ------------ | ----------------------------------------------- | ------- | -------- | ------------------ |
| noteFontSize | This sets the font size of actor-attached notes | Integer | Required | Any Positive Value |

**Notes:** Default value: 14

### noteFontFamily

| Parameter      | Description                                        | Type   | Required | Values                      |
| -------------- | -------------------------------------------------- | ------ | -------- | --------------------------- |
| noteFontFamily | This sets the font family of actor-attached notes. | string | Required | Any Possible CSS FontFamily |

**Notes:** Default value: ''"trebuchet ms", verdana, arial, sans-serif'

### noteFontWeight

This sets the font weight of the note's description

**Notes:** Default value: 400

### noteAlign

| Parameter | Description                                          | Type   | Required | Values                    |
| --------- | ---------------------------------------------------- | ------ | -------- | ------------------------- |
| noteAlign | This sets the text alignment of actor-attached notes | string | required | 'left', 'center', 'right' |

**Notes:** Default value: 'center'

### messageFontSize

| Parameter       | Description                               | Type    | Required | Values              |
| --------------- | ----------------------------------------- | ------- | -------- | ------------------- |
| messageFontSize | This sets the font size of actor messages | Integer | Required | Any Positive Number |

**Notes:** Default value: 16

### messageFontFamily

| Parameter         | Description                                 | Type   | Required | Values                      |
| ----------------- | ------------------------------------------- | ------ | -------- | --------------------------- |
| messageFontFamily | This sets the font family of actor messages | string | Required | Any Possible CSS FontFamily |

**Notes:** Default value: '"trebuchet ms", verdana, arial, sans-serif'

### messageFontWeight

This sets the font weight of the message's description

**Notes:** Default value: 400.

### wrap

This sets the auto-wrap state for the diagram

**Notes:** Default value: false.

### wrapPadding

This sets the auto-wrap padding for the diagram (sides only)

**Notes:** Default value: 0.

### labelBoxWidth

This sets the width of the loop-box (loop, alt, opt, par)

**Notes:** Default value: 50.

### labelBoxHeight

This sets the height of the loop-box (loop, alt, opt, par)

**Notes:** Default value: 20.

## gantt

The object containing configurations specific for gantt diagrams

### titleTopMargin

### titleTopMargin

| Parameter      | Description                                    | Type    | Required | Values             |
| -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
| titleTopMargin | Margin top for the text over the gantt diagram | Integer | Required | Any Positive Value |

**Notes:** Default value: 25

### barHeight

| Parameter | Description                         | Type    | Required | Values             |
| --------- | ----------------------------------- | ------- | -------- | ------------------ |
| barHeight | The height of the bars in the graph | Integer | Required | Any Positive Value |

**Notes:** Default value: 20

### barGap

| Parameter | Description                                                      | Type    | Required | Values             |
| --------- | ---------------------------------------------------------------- | ------- | -------- | ------------------ |
| barGap    | The margin between the different activities in the gantt diagram | Integer | Optional | Any Positive Value |

**Notes:** Default value: 4

### topPadding

| Parameter  | Description                                                                | Type    | Required | Values             |
| ---------- | -------------------------------------------------------------------------- | ------- | -------- | ------------------ |
| topPadding | Margin between title and gantt diagram and between axis and gantt diagram. | Integer | Required | Any Positive Value |

**Notes:** Default value: 50

### rightPadding

| Parameter    | Description                                                             | Type    | Required | Values             |
| ------------ | ----------------------------------------------------------------------- | ------- | -------- | ------------------ |
| rightPadding | The space allocated for the section name to the right of the activities | Integer | Required | Any Positive Value |

**Notes:** Default value: 75

### leftPadding

| Parameter   | Description                                                            | Type    | Required | Values             |
| ----------- | ---------------------------------------------------------------------- | ------- | -------- | ------------------ |
| leftPadding | The space allocated for the section name to the left of the activities | Integer | Required | Any Positive Value |

**Notes:** Default value: 75

### gridLineStartPadding

| Parameter            | Description                                  | Type    | Required | Values             |
| -------------------- | -------------------------------------------- | ------- | -------- | ------------------ |
| gridLineStartPadding | Vertical starting position of the grid lines | Integer | Required | Any Positive Value |

**Notes:** Default value: 35

### fontSize

| Parameter | Description | Type    | Required | Values             |
| --------- | ----------- | ------- | -------- | ------------------ |
| fontSize  | Font size   | Integer | Required | Any Positive Value |

**Notes:** Default value: 11

### sectionFontSize

| Parameter       | Description            | Type    | Required | Values             |
| --------------- | ---------------------- | ------- | -------- | ------------------ |
| sectionFontSize | Font size for sections | Integer | Required | Any Positive Value |

**Notes:** Default value: 11

### numberSectionStyles

| Parameter           | Description                              | Type    | Required | Values             |
| ------------------- | ---------------------------------------- | ------- | -------- | ------------------ |
| numberSectionStyles | The number of alternating section styles | Integer | 4        | Any Positive Value |

**Notes:** Default value: 4

### axisFormat

| Parameter  | Description                 | Type | Required | Values           |
| ---------- | --------------------------- | ---- | -------- | ---------------- |
| axisFormat | Datetime format of the axis | 3    | Required | Date in yy-mm-dd |

**Notes:**

This might need adjustment to match your locale and preferences

Default value: '%Y-%m-%d'.

### useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See notes   | boolean | 4        | true, false |

**Notes:**

When this flag is set the height and width is set to 100% and is then scaling with the
available space if not the absolute space required is used.

Default value: true

### topAxis

| Parameter | Description | Type    | Required | Values      |
| --------- | ----------- | ------- | -------- | ----------- |
| topAxis   | See notes   | Boolean | 4        | True, False |

**Notes:** when this flag is set date labels will be added to the top of the chart

**Default value false**.

## journey

The object containing configurations specific for journey diagrams

### diagramMarginX

| Parameter      | Description                                          | Type    | Required | Values             |
| -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
| diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |

**Notes:** Default value: 50

### diagramMarginY

| Parameter      | Description                                        | Type    | Required | Values             |
| -------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
| diagramMarginY | Margin to the over and under the sequence diagram. | Integer | Required | Any Positive Value |

**Notes:** Default value: 10

### leftMargin

| Parameter   | Description           | Type    | Required | Values             |
| ----------- | --------------------- | ------- | -------- | ------------------ |
| actorMargin | Margin between actors | Integer | Required | Any Positive Value |

**Notes:** Default value: 50

### width

| Parameter | Description          | Type    | Required | Values             |
| --------- | -------------------- | ------- | -------- | ------------------ |
| width     | Width of actor boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 150

### height

| Parameter | Description           | Type    | Required | Values             |
| --------- | --------------------- | ------- | -------- | ------------------ |
| height    | Height of actor boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 65

### boxMargin

| Parameter | Description              | Type    | Required | Values             |
| --------- | ------------------------ | ------- | -------- | ------------------ |
| boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 10

### boxTextMargin

| Parameter     | Description                                  | Type    | Required | Values             |
| ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
| boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |

**Notes:** Default value: 5

### noteMargin

| Parameter  | Description         | Type    | Required | Values             |
| ---------- | ------------------- | ------- | -------- | ------------------ |
| noteMargin | Margin around notes | Integer | Required | Any Positive Value |

**Notes:** Default value: 10

### messageMargin

| Parameter     | Description             | Type    | Required | Values             |
| ------------- | ----------------------- | ------- | -------- | ------------------ |
| messageMargin | Space between messages. | Integer | Required | Any Positive Value |

**Notes:**

Space between messages.

Default value: 35

### messageAlign

| Parameter    | Description                 | Type | Required | Values                    |
| ------------ | --------------------------- | ---- | -------- | ------------------------- |
| messageAlign | Multiline message alignment | 3    | 4        | 'left', 'center', 'right' |

**Notes:** Default value: 'center'

### bottomMarginAdj

| Parameter       | Description                                | Type    | Required | Values             |
| --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
| bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | 4        | Any Positive Value |

**Notes:**

Depending on css styling this might need adjustment.

Default value: 1

### useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See notes   | boolean | 4        | true, false |

**Notes:**

When this flag is set the height and width is set to 100% and is then scaling with the
available space if not the absolute space required is used.

Default value: true

### rightAngles

| Parameter   | Description                       | Type | Required | Values      |
| ----------- | --------------------------------- | ---- | -------- | ----------- |
| rightAngles | Curved Arrows become Right Angles | 3    | 4        | true, false |

**Notes:**

This will display arrows that start and begin at the same node as right angles, rather than a curves

Default value: false

## useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See notes   | boolean | 4        | true, false |

**Notes:**

When this flag is set the height and width is set to 100% and is then scaling with the
available space if not the absolute space required is used.

Default value: true

## defaultRenderer

| Parameter       | Description | Type    | Required | Values                  |
| --------------- | ----------- | ------- | -------- | ----------------------- |
| defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper |

**Notes**:

Decides which rendering engine that is to be used for the rendering. Legal values are:
dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid

Default value: 'dagre-d3'

## useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See notes   | boolean | 4        | true, false |

**Notes:**

When this flag is set the height and width is set to 100% and is then scaling with the
available space if not the absolute space required is used.

Default value: true

## useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See notes   | boolean | 4        | true, false |

**Notes:**

When this flag is set the height and width is set to 100% and is then scaling with the
available space if not the absolute space required is used.

Default value: true

## defaultRenderer

| Parameter       | Description | Type    | Required | Values                  |
| --------------- | ----------- | ------- | -------- | ----------------------- |
| defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper |

**Notes:**

Decides which rendering engine that is to be used for the rendering. Legal values are:
dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid

Default value: 'dagre-d3'

## er

The object containing configurations specific for entity relationship diagrams

### diagramPadding

| Parameter      | Description                                     | Type    | Required | Values             |
| -------------- | ----------------------------------------------- | ------- | -------- | ------------------ |
| diagramPadding | Amount of padding around the diagram as a whole | Integer | Required | Any Positive Value |

**Notes:**

The amount of padding around the diagram as a whole so that embedded diagrams have margins,
expressed in pixels

Default value: 20

### layoutDirection

| Parameter       | Description                              | Type   | Required | Values                 |
| --------------- | ---------------------------------------- | ------ | -------- | ---------------------- |
| layoutDirection | Directional bias for layout of entities. | string | Required | "TB", "BT", "LR", "RL" |

**Notes:**

'TB' for Top-Bottom, 'BT'for Bottom-Top, 'LR' for Left-Right, or 'RL' for Right to Left.

T = top, B = bottom, L = left, and R = right.

Default value: 'TB'

### minEntityWidth

| Parameter      | Description                        | Type    | Required | Values             |
| -------------- | ---------------------------------- | ------- | -------- | ------------------ |
| minEntityWidth | The minimum width of an entity box | Integer | Required | Any Positive Value |

**Notes:** Expressed in pixels. Default value: 100

### minEntityHeight

| Parameter       | Description                         | Type    | Required | Values             |
| --------------- | ----------------------------------- | ------- | -------- | ------------------ |
| minEntityHeight | The minimum height of an entity box | Integer | 4        | Any Positive Value |

**Notes:** Expressed in pixels Default value: 75

### entityPadding

| Parameter     | Description                                                 | Type    | Required | Values             |
| ------------- | ----------------------------------------------------------- | ------- | -------- | ------------------ |
| entityPadding | Minimum internal padding betweentext in box and box borders | Integer | 4        | Any Positive Value |

**Notes:**

The minimum internal padding betweentext in an entity box and the enclosing box borders,
expressed in pixels.

Default value: 15

### stroke

| Parameter | Description                         | Type   | Required | Values               |
| --------- | ----------------------------------- | ------ | -------- | -------------------- |
| stroke    | Stroke color of box edges and lines | string | 4        | Any recognized color |

**Notes:** Default value: 'gray'

### fill

| Parameter | Description                | Type   | Required | Values               |
| --------- | -------------------------- | ------ | -------- | -------------------- |
| fill      | Fill color of entity boxes | string | 4        | Any recognized color |

**Notes:** Default value: 'honeydew'

### fontSize

| Parameter | Description         | Type    | Required | Values             |
| --------- | ------------------- | ------- | -------- | ------------------ |
| fontSize  | Font Size in pixels | Integer |          | Any Positive Value |

**Notes:**

Font size (expressed as an integer representing a number of pixels) Default value: 12

### useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See Notes   | boolean | Required | true, false |

**Notes:**

When this flag is set to true, the diagram width is locked to 100% and scaled based on
available space. If set to false, the diagram reserves its absolute width.

Default value: true

## pie

The object containing configurations specific for pie diagrams

### useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See Notes   | boolean | Required | true, false |

**Notes:**

When this flag is set to true, the diagram width is locked to 100% and scaled based on
available space. If set to false, the diagram reserves its absolute width.

Default value: true

## requirement

The object containing configurations specific for req diagrams

### useMaxWidth

| Parameter   | Description | Type    | Required | Values      |
| ----------- | ----------- | ------- | -------- | ----------- |
| useMaxWidth | See Notes   | boolean | Required | true, false |

**Notes:**

When this flag is set to true, the diagram width is locked to 100% and scaled based on
available space. If set to false, the diagram reserves its absolute width.

Default value: true

## setSiteConfig

## setSiteConfig

| Function      | Description                           | Type        | Values                                  |
| ------------- | ------------------------------------- | ----------- | --------------------------------------- |
| setSiteConfig | Sets the siteConfig to desired values | Put Request | Any Values, except ones in secure array |

**Notes:** Sets the siteConfig. The siteConfig is a protected configuration for repeat use. Calls
to reset() will reset the currentConfig to siteConfig. Calls to reset(configApi.defaultConfig)
will reset siteConfig and currentConfig to the defaultConfig Note: currentConfig is set in this
function \*Default value: At default, will mirror Global Config\*\*

### Parameters

-   `conf`  The base currentConfig to use as siteConfig

Returns **[object][5]** The siteConfig

## parse

### Parameters

-   `text`  

Returns **any** 

## getSiteConfig

## getSiteConfig

| Function      | Description                                       | Type        | Values                           |
| ------------- | ------------------------------------------------- | ----------- | -------------------------------- |
| setSiteConfig | Returns the current siteConfig base configuration | Get Request | Returns Any Values in siteConfig |

**Notes**: Returns **any** values in siteConfig.

Returns **[object][5]** The siteConfig

## setConfig

## setConfig

| Function      | Description                           | Type        | Values                                  |
| ------------- | ------------------------------------- | ----------- | --------------------------------------- |
| setSiteConfig | Sets the siteConfig to desired values | Put Request | Any Values, except ones in secure array |

**Notes**: Sets the currentConfig. The parameter conf is sanitized based on the siteConfig.secure
keys. Any values found in conf with key found in siteConfig.secure will be replaced with the
corresponding siteConfig value.

### Parameters

-   `conf` **any** The potential currentConfig

Returns **any** The currentConfig merged with the sanitized conf

## getConfig

## getConfig

| Function  | Description               | Type        | Return Values                  |
| --------- | ------------------------- | ----------- | ------------------------------ |
| getConfig | Obtains the currentConfig | Get Request | Any Values from current Config |

**Notes**: Returns **any** the currentConfig

Returns **any** The currentConfig

## sanitize

## sanitize

| Function | Description                            | Type        | Values |
| -------- | -------------------------------------- | ----------- | ------ |
| sanitize | Sets the siteConfig to desired values. | Put Request | None   |

Ensures options parameter does not attempt to override siteConfig secure keys **Notes**: modifies
options in-place

### Parameters

-   `options` **any** The potential setConfig parameter

## addDirective

Pushes in a directive to the configuration

### Parameters

-   `directive` **[object][5]** The directive to push in

## reset

## reset

| Function | Description                  | Type        | Required | Values |
| -------- | ---------------------------- | ----------- | -------- | ------ |
| reset    | Resets currentConfig to conf | Put Request | Required | None   |

## conf

| Parameter | Description                                                   | Type       | Required | Values                                       |
| --------- | ------------------------------------------------------------- | ---------- | -------- | -------------------------------------------- |
| conf      | base set of values, which currentConfig coul be **reset** to. | Dictionary | Required | Any Values, with respect to the secure Array |

**Notes**: (default: current siteConfig ) (optional, default `getSiteConfig()`)

## render

Function that renders an svg with a graph from a chart definition. Usage example below.

```javascript
mermaidAPI.initialize({
  startOnLoad: true,
});
$(function () {
  const graphDefinition = 'graph TB\na-->b';
  const cb = function (svgGraph) {
    console.log(svgGraph);
  };
  mermaidAPI.render('id1', graphDefinition, cb);
});
```

### Parameters

-   `id` **any** The id of the element to be rendered
-   `_txt` **any** The graph definition
-   `cb` **any** Callback which is called after rendering is finished with the svg code as inparam.
-   `container` **any** Selector to element in which a div with the graph temporarily will be
      inserted. In one is provided a hidden div will be inserted in the body of the page instead. The
      element will be removed when rendering is completed.

Returns **any** 

## updateRendererConfigs

### Parameters

-   `conf` **any** 

## initialize

### Parameters

-   `options` **any** 

## 

## mermaidAPI configuration defaults

```html
<script>
  var config = {
    theme: 'default',
    logLevel: 'fatal',
    securityLevel: 'strict',
    startOnLoad: true,
    arrowMarkerAbsolute: false,

    er: {
      diagramPadding: 20,
      layoutDirection: 'TB',
      minEntityWidth: 100,
      minEntityHeight: 75,
      entityPadding: 15,
      stroke: 'gray',
      fill: 'honeydew',
      fontSize: 12,
      useMaxWidth: true,
    },
    flowchart: {
      diagramPadding: 8,
      htmlLabels: true,
      curve: 'basis',
    },
    sequence: {
      diagramMarginX: 50,
      diagramMarginY: 10,
      actorMargin: 50,
      width: 150,
      height: 65,
      boxMargin: 10,
      boxTextMargin: 5,
      noteMargin: 10,
      messageMargin: 35,
      messageAlign: 'center',
      mirrorActors: true,
      bottomMarginAdj: 1,
      useMaxWidth: true,
      rightAngles: false,
      showSequenceNumbers: false,
    },
    gantt: {
      titleTopMargin: 25,
      barHeight: 20,
      barGap: 4,
      topPadding: 50,
      leftPadding: 75,
      gridLineStartPadding: 35,
      fontSize: 11,
      fontFamily: '"Open-Sans", "sans-serif"',
      numberSectionStyles: 4,
      axisFormat: '%Y-%m-%d',
      topAxis: false,
    },
  };
  mermaid.initialize(config);
</script>
```

[1]: https://github.com/mermaid-js/mermaid/blob/develop/src/mermaidAPI.js

[2]: Setup.md?id=render

[3]: 8.6.0_docs.md

[4]: #mermaidapi-configuration-defaults

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object
