# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 510-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53200);
 script_bugtraq_id(10438);
 script_cve_id("CVE-2004-0448");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 510-1 (jftpgw)";
 script_name(name);

 desc = "The remote host is missing an update to jftpgw
announced via advisory DSA 510-1.

jaguar@felinemenace.org discovered a vulnerability in jftpgw, an FTP
proxy program, whereby a remote user could potentially cause arbitrary
code to be executed with the privileges of the jftpgw server process.
By default, the server runs as user nobody.

CVE-2004-0448: format string vulnerability via syslog(3) in log()
function

For the current stable distribution (woody) this problem has been
fixed in version 0.13.1-1woody1.

For the unstable distribution (sid), this problem has been fixed in
version 0.13.4-1.

We recommend that you update your jftpgw package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20510-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 510-1 (jftpgw)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"jftpgw", ver:"0.13.1-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
