# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 532-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53703);
 script_cve_id("CVE-2004-0488", "CVE-2004-0700");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 532-1 (libapache-mod-ssl)";
 script_name(name);

 desc = "The remote host is missing an update to libapache-mod-ssl
announced via advisory DSA 532-1.

Two vulnerabilities were discovered in libapache-mod-ssl:

CVE-2004-0488 - Stack-based buffer overflow in the
ssl_util_uuencode_binary function in ssl_util.c for Apache mod_ssl,
when mod_ssl is configured to trust the issuing CA, may allow remote
attackers to execute arbitrary code via a client certificate with a
long subject DN.

CVE-2004-0700 - Format string vulnerability in the ssl_log function
in ssl_engine_log.c in mod_ssl 2.8.19 for Apache 1.3.31 may allow
remote attackers to execute arbitrary messages via format string
specifiers in certain log messages for HTTPS.

For the current stable distribution (woody), these problems have been
fixed in version 2.8.9-2.3.

For the unstable distribution (sid), CVE-2004-0488 was fixed in
version 2.8.18, and CVE-2004-0700 will be fixed soon.

We recommend that you update your libapache-mod-ssl package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20532-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 532-1 (libapache-mod-ssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libapache-mod-ssl-doc", ver:"2.8.9-2.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-ssl", ver:"2.8.9-2.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
