# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10981 (blam)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66194);
 script_cve_id("CVE-2009-3380", "CVE-2009-3382", "CVE-2009-3376", "CVE-2009-3375", "CVE-2009-1563", "CVE-2009-3374", "CVE-2009-3373", "CVE-2009-3372", "CVE-2009-3274", "CVE-2009-3370");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-10981 (blam)");

 desc = "The remote host is missing an update to blam
announced via advisory FEDORA-2009-10981.

Update Information:

Update to new upstream Firefox version 3.0.15, fixing multiple security issues
detailed in the upstream advisories:
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.15

Update also includes all packages depending on gecko-libs rebuilt against
new version of Firefox / XULRunner.

ChangeLog:

* Tue Oct 27 2009 Jan Horak  - 1.8.5-15
- Rebuild against newer gecko

References:

[ 1 ] Bug #530567 - CVE-2009-3380 Firefox crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=530567
[ 2 ] Bug #530569 - CVE-2009-3382 Firefox crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=530569
[ 3 ] Bug #530168 - CVE-2009-3376 Firefox download filename spoofing with RTL override
https://bugzilla.redhat.com/show_bug.cgi?id=530168
[ 4 ] Bug #530167 - CVE-2009-3375 Firefox cross-origin data theft through document.getSelection()
https://bugzilla.redhat.com/show_bug.cgi?id=530167
[ 5 ] Bug #530162 - CVE-2009-1563 Firefox heap buffer overflow in string to number conversion
https://bugzilla.redhat.com/show_bug.cgi?id=530162
[ 6 ] Bug #530157 - CVE-2009-3374 Firefox chrome privilege escalation in XPCVariant::VariantDataToJS()
https://bugzilla.redhat.com/show_bug.cgi?id=530157
[ 7 ] Bug #530156 - CVE-2009-3373 Firefox heap buffer overflow in GIF color map parser
https://bugzilla.redhat.com/show_bug.cgi?id=530156
[ 8 ] Bug #530155 - CVE-2009-3372 Firefox crash in proxy auto-configuration regexp parsing
https://bugzilla.redhat.com/show_bug.cgi?id=530155
[ 9 ] Bug #524815 - CVE-2009-3274 Firefox: Predictable /tmp pathname use
https://bugzilla.redhat.com/show_bug.cgi?id=524815
[ 10 ] Bug #530151 - CVE-2009-3370 Firefox form history vulnerable to stealing
https://bugzilla.redhat.com/show_bug.cgi?id=530151

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update blam' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10981

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10981 (blam)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"blam", rpm:"blam~1.8.5~15.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"blam-debuginfo", rpm:"blam-debuginfo~1.8.5~15.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
