###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for JRE and JDK HPSBUX00132
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835059);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00132");
  script_name( "HP-UX Update for JRE and JDK HPSBUX00132");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with Java 1.1 and 1.2 
  applicationsrunning on HP-UX. The vulnerability could be exploitedremotely 
  to create an unauthorized access. 

  Impact:
  Remote unauthorized access.

  Affected Software/OS:
  JRE and JDK on
  HP-UX release B.10.20, B.10.24, B.11.00, B.11.04, and B.11.11. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00993897-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of JRE and JDK");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"JDK 1.1", revision:"1.1.8.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.1", revision:"1.1.8.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JDK 1.2", revision:"1.2.2.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.2", revision:"1.2.2.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JDK 1.3", revision:"1.3.0.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.3", revision:"1.3.0.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.24")
{

  if(ishpuxpkgvuln(pkg:"JDK 1.1", revision:"1.1.8.04", rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.1", revision:"1.1.8.04", rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"JDK 1.1", revision:"1.1.8.04", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.1", revision:"1.1.8.04", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JDK 1.2", revision:"1.2.2.04", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.2", revision:"1.2.2.04", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JDK 1.3", revision:"1.3.0.00", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.3", revision:"1.3.0.00", rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"JDK 1.1", revision:"1.1.8.04", rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.1", revision:"1.1.8.04", rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"JDK 1.1", revision:"1.1.8.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.1", revision:"1.1.8.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JDK 1.2", revision:"1.2.2.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.2", revision:"1.2.2.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JDK 1.3", revision:"1.3.0.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"JRE 1.3", revision:"1.3.0.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
