###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for expat vulnerabilities USN-890-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840375);
  script_version("$Revision: 8167 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "890-1");
  script_cve_id("CVE-2009-2625", "CVE-2009-3560", "CVE-2009-3720");
  script_name("Ubuntu Update for expat vulnerabilities USN-890-1");
  desc = "

  Vulnerability Insight:

  Jukka Taimisto, Tero Rontti and Rauli Kaksonen discovered that Expat did
  not properly process malformed XML. If a user or application linked against
  Expat were tricked into opening a crafted XML file, an attacker could cause
  a denial of service via application crash. (CVE-2009-2625, CVE-2009-3720)
  
  It was discovered that Expat did not properly process malformed UTF-8
  sequences. If a user or application linked against Expat were tricked into
  opening a crafted XML file, an attacker could cause a denial of service via
  application crash. (CVE-2009-3560)

  Affected Software/OS:
  expat vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001033.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of expat vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"lib64expat1-dev", ver:"2.0.1-4ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"lib64expat1", ver:"2.0.1-4ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1-dev", ver:"2.0.1-4ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1", ver:"2.0.1-4ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"expat", ver:"2.0.1-4ubuntu0.9.04.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"expat", ver:"1.95.8-3ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1-dev", ver:"1.95.8-3ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1", ver:"1.95.8-3ubuntu0.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"lib64expat1-dev", ver:"2.0.1-4ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"lib64expat1", ver:"2.0.1-4ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1-dev", ver:"2.0.1-4ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1", ver:"2.0.1-4ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"expat", ver:"2.0.1-4ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"lib64expat1-dev", ver:"2.0.1-0ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"lib64expat1", ver:"2.0.1-0ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1-dev", ver:"2.0.1-0ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1", ver:"2.0.1-0ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"expat", ver:"2.0.1-0ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"lib64expat1-dev", ver:"2.0.1-4ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"lib64expat1", ver:"2.0.1-4ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1-dev", ver:"2.0.1-4ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexpat1", ver:"2.0.1-4ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"expat", ver:"2.0.1-4ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}