##############################################################################
#
#  Apache mod_proxy_ftp Wildcard Characters XSS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/08
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0088
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900107);
 script_bugtraq_id(30560);
 script_cve_id("CVE-2008-2939");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("Apache mod_proxy_ftp Wildcard Characters XSS Vulnerability");
 script_summary("Check for vulnerable version of Apache");
 desc = "
 Overview : The host is running Apache, which is prone to cross-site scripting
 vulnerability.
	
 Vulnerability Insight :

        Input passed to the module mod_proxy_ftp with wildcard character
        is not properly sanitized before returning to the user.

        Impact : Remote attackers can execute arbitrary script code.

 Impact Level : Application

 Affected Software/OS :
        Apache 2.0.0 to 2.0.63 and Apache 2.2.0 to 2.2.9 on All Platform

 ***
    Note: The script might report a False Positive as it is only checking for 
    the vulnerable version of Apache. Vulnerability is only when mod_proxy 
    and mod_proxy_ftp is configured with the installed Apache version. 
 ***

 Fix : Fixed is available in the SVN repository,
 http://svn.apache.org/viewvc?view=rev&revision=682871
 http://svn.apache.org/viewvc?view=rev&revision=682868

 References :
 http://httpd.apache.org/
 http://www.securityfocus.com/archive/1/495180
 http://httpd.apache.org/docs/2.0/mod/mod_proxy_ftp.html

 CVSS Score :
        CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
        CVSS Temporal Score : 4.5
 Risk factor : Medium";
 script_description(desc);
 exit(0);
}

 include("http_func.inc");

 port = get_http_port(default:80);
 if(!port){
 	exit(0);
 }

 banner = get_http_banner(port:port);
 if(banner)
 {
	if(egrep(pattern:"Apache/2\.(0\.([0-5]?[0-9]|6[0-3])|2\.[0-9])($|[^.0-9])",
		 string:strstr(banner, "Server:"))){
		security_warning(port); 
	}
 }
