##############################################################################
#
#  RealVNC VNC Viewer Remote Code Execution Vulnerability (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/22
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0374
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900162);
  script_cve_id("CVE-2008-4770");
 script_bugtraq_id(31832);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_tag(name:"cvss_base", value:"6.0");
  script_tag(name:"risk_factor", value:"High");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("RealVNC VNC Viewer Remote Code Execution Vulnerability (Win)");
  script_summary("Check for vulnerable version of RealVNC");
  desc = "
  Overview: This host has RealVNC VNC Viewer installed and is prone to security 
  vulnerability.

  The flaw is caused due to error in 'CMsgReader::readRect()' function in
  common/rfb/CMsgReader.cxx processing encoding types, and is exploited by
  sending specially crafted messages to the application.

  Impact:
  Successful exploitation will allow execution of arbitrary code when user
  connects to a malicious server.

  Impact Level: Application

  Affected Software/OS:
  RealVNC VNC Free Edition version prior to 4.1.3

  Fix: Update to version 4.1.3
  http://www.realvnc.com/products/download.html

  References:
  http://secunia.com/advisories/32317/
  http://www.realvnc.com/products/free/4.1/release-notes.html

  CVSS Score:
    CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 4.4
  Risk factor : Medium";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl", "find_service.nes");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports("Services/vnc", 5800, 139, 445);
  exit(0);
}


include("smb_nt.inc");
include("http_func.inc");

port = get_kb_item("Services/vnc");
if(!port){
  port = 5800;
}

if(!get_port_state(port)){
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if("RealVNC/4.0" >!< get_http_banner(port)){
  exit(0);
}

vncVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                             "\Uninstall\RealVNC_is1",
                         item:"DisplayVersion");

if(egrep(pattern:"^(4\.[01](\.[0-2])?)($|[^.0-9])", string:vncVer)){
  security_warning(port);
}
