#
# This script was written by Tor Houghton, but I looked at "htdig" by 
# Renaud Deraison <deraison@cvs.nessus.org>
#
# modifications by rd:
#	- pattern read is different
#	- request /SilverStream not /SilverStream/Pages
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      Added links to the Bugtraq message archive
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10846);
 script_version ("$Revision: 7589 $");
 script_tag(name:"risk_factor", value:"Medium");
 name = "SilverStream directory listing";
 script_name(name);
 
 desc = "
SilverStream directory listings are enabled.
An attacker may use this problem to gain more knowledge
on this server and possibly to get files you would want
to hide.

Risk factor : Medium

Reference : http://online.securityfocus.com/archive/101/144786

Solution : Reconfigure the server so that others
cannot view directory listings";

 script_description(desc);
 
 summary = "Checks if SilverStream directory listings are disabled.";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2002 Tor Houghton");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("http_version.nasl");
  script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");
port = get_http_port(default:80);


if(get_port_state(port)) {
     buf = string("/SilverStream");
     buf = http_get(item:buf, port:port);
     rep = http_keepalive_send_recv(port:port, data:buf);
     if ( ! rep ) exit(0);
     lookfor = "<html><head><title>.*SilverStream.*</title>";
      
      if((egrep(pattern:lookfor, string:rep)) && ("/Pages" >< rep))
         security_warning(port);
}

