/*	Projection_Pane

PIRL CVS ID: Projection_Pane.java,v 1.4 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2007-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package PIRL.Viewers;

import	PIRL.Image_Tools.Projection;
import	PIRL.PVL.Parameter;
import	PIRL.PVL.Parser;
import	PIRL.PVL.PVL_Exception;
import	PIRL.Viewers.Dialog_Box;

import	javax.swing.JPanel;
import	javax.swing.JLabel;
import	javax.swing.JTextField;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.awt.Insets;
import	java.awt.Point;
import	java.awt.geom.Point2D;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;
import	java.util.NoSuchElementException;

/**	A <i>Projection_Pane</i> provides a JPanel with interactive image
	and real world coordinate fields.
<p>
	The Projection used to construct the Projection_Pane is used to
	map between image and world coordinates. Whenever a new coordinate
	value is entered the other coordinate values are updated.
<p>
	@author		Bradford Castalia UA/PIRL
	@version	1.4
	@see		PIRL.Image_Tools.Projection
*/
public class Projection_Pane
	extends JPanel
{
/**	Class name and version identification.
*/
public static final String
	ID = "PIRL.Image_Tools.Projection_Pane (1.4 2012/04/16 06:22:59)";

private Parameter
	Parameters			= null;

private Projection
	The_Projection		= new Projection ();

private JTextField
	Image_X_Field,
	Image_Y_Field,
	World_Latitude_Field,
	World_Longitude_Field;

private Point
	Image_Coordinates	= new Point (0, 0);
private Point2D.Double
	World_Coordinates;

public static final int
	EXIT_SUCCESS				= 0,
	EXIT_COMMAND_LINE_SYNTAX	= 1,
	EXIT_NO_PARAMETERS			= 2,
	EXIT_NO_PROJECTION			= 3;
	

//  DEBUG control.
private static final int
	DEBUG_OFF				= 0,
	DEBUG_CONSTRUCTORS		= 1 << 0,
	DEBUG_ACCESSORS			= 1 << 1,
	DEBUG_CONVERTERS		= 1 << 2,
	DEBUG_ALL				= -1,

	DEBUG					= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
/**	Construct a Projection_Pane from a Projection.
<p>
	@param	projection	The Projection to use.
*/
Projection_Pane
	(
	Projection	projection
	)
{
if (projection == null)
	projection = new Projection ();
The_Projection = projection;
Assemble_Panel ();
}

/**	Construct a Pojrection_Pane with an identity Projection.
*/
Projection_Pane ()
{this (null);}

/*==============================================================================
	GUI
*/
private void Assemble_Panel ()
{
setLayout (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();

//	Projection name.
location.anchor		= GridBagConstraints.EAST;
location.fill		= GridBagConstraints.NONE;
location.insets		= new Insets (5, 5, 0, 5);
add (new JLabel ("Projection:"), location);

location.anchor		= GridBagConstraints.WEST;
location.gridwidth	= GridBagConstraints.REMAINDER;
location.insets		= new Insets (5, 0, 0, 5);
add (new JLabel (The_Projection.Name ()), location);

//	Image coordinates.
location.anchor		= GridBagConstraints.EAST;
location.fill		= GridBagConstraints.NONE;
location.gridwidth	= 1;
location.insets		= new Insets (5, 5, 0, 5);
add (new JLabel ("Image:"), location);

location.anchor		= GridBagConstraints.WEST;
location.fill		= GridBagConstraints.HORIZONTAL;
location.weightx	= 0.5;
location.insets		= new Insets (5, 0, 0, 5);
add (Image_X_Field = new JTextField ("0"), location);
Image_X_Field.setHorizontalAlignment (JTextField.RIGHT);
Image_X_Field.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{Image_X_Action ();}});

location.fill		= GridBagConstraints.NONE;
location.weightx	= 0.0;
location.insets		= new Insets (5, 0, 0, 10);
add (new JLabel ("x"), location);

location.anchor		= GridBagConstraints.WEST;
location.fill		= GridBagConstraints.HORIZONTAL;
location.weightx	= 0.5;
location.insets		= new Insets (5, 0, 0, 5);
add (Image_Y_Field = new JTextField ("0"), location);
Image_Y_Field.setHorizontalAlignment (JTextField.RIGHT);
Image_Y_Field.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{Image_Y_Action ();}});

location.fill		= GridBagConstraints.NONE;
location.weightx	= 0.0;
location.gridwidth	= GridBagConstraints.REMAINDER;
location.insets		= new Insets (5, 0, 0, 5);
add (new JLabel ("y"), location);

//	World coordinates.
location.anchor		= GridBagConstraints.EAST;
location.fill		= GridBagConstraints.NONE;
location.gridwidth	= 1;
location.insets		= new Insets (0, 5, 5, 5);
add (new JLabel ("World:"), location);

location.anchor		= GridBagConstraints.WEST;
location.fill		= GridBagConstraints.HORIZONTAL;
location.weightx	= 0.5;
location.insets		= new Insets (0, 0, 5, 5);
add (World_Longitude_Field = new JTextField (7), location);
World_Longitude_Field.setHorizontalAlignment (JTextField.RIGHT);
World_Longitude_Field.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{World_Longitude_Action ();}});

location.fill		= GridBagConstraints.NONE;
location.weightx	= 0.0;
location.insets		= new Insets (0, 0, 5, 10);
add (new JLabel ("lon"), location);

location.anchor		= GridBagConstraints.WEST;
location.fill		= GridBagConstraints.HORIZONTAL;
location.weightx	= 0.5;
location.insets		= new Insets (0, 0, 5, 5);
add (World_Latitude_Field = new JTextField (7), location);
World_Latitude_Field.setHorizontalAlignment (JTextField.RIGHT);
World_Latitude_Field.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{World_Latitude_Action ();}});

location.fill		= GridBagConstraints.NONE;
location.weightx	= 0.0;
location.gridwidth	= GridBagConstraints.REMAINDER;
location.insets		= new Insets (0, 0, 5, 5);
add (new JLabel ("lat"), location);

Image_X_Action ();	//	Initialize the fields.
}

/*==============================================================================
	Actions
*/
private void Image_X_Action ()
{
String
	value = Image_X_Field.getText ().trim ();
if (value.length () == 0)
	Image_X_Field.setText (String.valueOf (Image_Coordinates.x));
else
	{
	try
		{
		Image_Coordinates.x = Integer.parseInt (value);
		World_Coordinates = The_Projection.to_World (Image_Coordinates);
		World_Longitude_Field.setText (String.valueOf (World_Coordinates.x));
		World_Latitude_Field.setText (String.valueOf (World_Coordinates.y));
		}
	catch (NumberFormatException exception)
		{
		Dialog_Box.Error
			("An image x coordinate is required.\n"
			+'"' + value + "\" is not an integer.",
			this);
		Image_X_Field.setText (String.valueOf (Image_Coordinates.x));
		}
	}
}


private void Image_Y_Action ()
{
String
	value = Image_Y_Field.getText ().trim ();
if (value.length () == 0)
	Image_Y_Field.setText (String.valueOf (Image_Coordinates.y));
else
	{
	try
		{
		Image_Coordinates.y = Integer.parseInt (value);
		World_Coordinates = The_Projection.to_World (Image_Coordinates);
		World_Longitude_Field.setText (String.valueOf (World_Coordinates.x));
		World_Latitude_Field.setText (String.valueOf (World_Coordinates.y));
		}
	catch (NumberFormatException exception)
		{
		Dialog_Box.Error
			("An image y coordinate is required.\n"
			+'"' + value + "\" is not an integer.",
			this);
		Image_Y_Field.setText (String.valueOf (Image_Coordinates.y));
		}
	}
}


private void World_Longitude_Action ()
{
String
	value = World_Longitude_Field.getText ().trim ();
if (value.length () == 0)
	World_Longitude_Field.setText (String.valueOf (World_Coordinates.x));
else
	{
	try
		{
		World_Coordinates.x = Double.parseDouble (value);
		Image_Coordinates = The_Projection.to_Image (World_Coordinates);
		Image_X_Field.setText (String.valueOf (Image_Coordinates.x));
		Image_Y_Field.setText (String.valueOf (Image_Coordinates.y));
		}
	catch (NumberFormatException exception)
		{
		Dialog_Box.Error
			("A longitude value is required.\n"
			+'"' + value + "\" is not a real number.",
			this);
		World_Longitude_Field.setText (String.valueOf (World_Coordinates.x));
		}
	}
}


private void World_Latitude_Action ()
{
String
	value = World_Latitude_Field.getText ().trim ();
if (value.length () == 0)
	World_Latitude_Field.setText (String.valueOf (World_Coordinates.y));
else
	{
	try
		{
		World_Coordinates.y = Double.parseDouble (value);
		Image_Coordinates = The_Projection.to_Image (World_Coordinates);
		Image_X_Field.setText (String.valueOf (Image_Coordinates.x));
		Image_Y_Field.setText (String.valueOf (Image_Coordinates.y));
		}
	catch (NumberFormatException exception)
		{
		Dialog_Box.Error
			("A latitude value is required.\n"
			+'"' + value + "\" is not a real number.",
			this);
		World_Latitude_Field.setText (String.valueOf (World_Coordinates.y));
		}
	}
}

}
