/* $Cambridge: hermes/src/prayer/cmd/cmd_disp_undelete.c,v 1.4 2008/09/17 17:20:25 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_disp_undelete(struct session *session)
{
    struct request *request = session->request;
    struct pool *pool = request->pool;
    MAILSTREAM *stream = session->stream;
    unsigned long msgno, msguid;
    char *s;
    struct msgmap *zm = session->zm;
    unsigned long zm_offset;

    if (request->argc < 2) {
        session_redirect(session, request, "error");
        return;
    }

    msgno = atoi(request->argv[1]);
    msguid = atoi(request->argv[2]);

    if (!(msgno = stream_check_uid(session, stream, msgno, msguid))) {
        session_redirect(session, request, "restart");
        return;
    }

    if (!ml_flag(session, stream, string_itoa_tmp(msgno), "\\DELETED", 0)) {
        session_alert(session, "Failed to undelete message number %lu",
                      msgno);
        session_log(session,
                    ("[cmd_disp_undelete] "
                     "Failed to undelete message number %lu from %s: %s"),
                    msgno, session->foldername, ml_errmsg());
        session_redirect(session, request, "restart");
        return;
    }

    session_log(session,
                "[cmd_disp_undelete] Undeleted message number %lu from %s",
                msgno, session->foldername);

    /* Find next marked message, then invalidate zoom map */
    if (!msgmap_update(zm)) {
        session_redirect(session, request, "restart");
        return;
    }

    if (zm->sort_reverse) {
        zm_offset = msgmap_find(zm, msgno);
        if (zm_offset > 1) {
            unsigned long next = msgmap_value(zm, zm_offset - 1);

            session_message(session, ("Undeleted message number %lu, "
                                      "displaying %lu out of %lu"),
                            msgno, next, zm->nmsgs);

            s = pool_printf(pool, "display/%lu/%lu",
                            next, ml_uid(session, stream, next));
            session_redirect(session, request, s);
        } else {
            session_message(session,
                            "Undeleted message number %lu, no more messages",
                            msgno);
            session->current = msgno;
            session_redirect(session, request, "list");
        }
    } else {
        zm_offset = msgmap_find(zm, msgno);
        if (zm_offset < msgmap_size(zm)) {
            unsigned long next = msgmap_value(zm, zm_offset + 1);

            session_message(session, ("Undeleted message number %lu, "
                                      "displaying %lu out of %lu"),
                            msgno, next, zm->nmsgs);

            s = pool_printf(pool, "display/%lu/%lu",
                            next, ml_uid(session, stream, next));
            session_redirect(session, request, s);
        } else {
            session_message(session,
                            "Undeleted message number %lu, no more messages",
                            msgno);
            session->current = msgno;
            session_redirect(session, request, "list");
        }
    }
}
