/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

public class AttributeNameFilter
implements AttributeVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final AttributeVisitor attributeVisitor;

    public AttributeNameFilter(String string, AttributeVisitor attributeVisitor) {
        this(new ListParser(new NameParser()).parse(string), attributeVisitor);
    }

    public AttributeNameFilter(List list, AttributeVisitor attributeVisitor) {
        this(new ListParser(new NameParser()).parse(list), attributeVisitor);
    }

    public AttributeNameFilter(StringMatcher stringMatcher, AttributeVisitor attributeVisitor) {
        this.regularExpressionMatcher = stringMatcher;
        this.attributeVisitor = attributeVisitor;
    }

    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        if (this.accepted(clazz, unknownAttribute)) {
            unknownAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        if (this.accepted(clazz, bootstrapMethodsAttribute)) {
            bootstrapMethodsAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        if (this.accepted(clazz, sourceFileAttribute)) {
            sourceFileAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        if (this.accepted(clazz, sourceDirAttribute)) {
            sourceDirAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        if (this.accepted(clazz, innerClassesAttribute)) {
            innerClassesAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (this.accepted(clazz, enclosingMethodAttribute)) {
            enclosingMethodAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        if (this.accepted(clazz, deprecatedAttribute)) {
            deprecatedAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitDeprecatedAttribute(Clazz clazz, Field field, DeprecatedAttribute deprecatedAttribute) {
        if (this.accepted(clazz, deprecatedAttribute)) {
            deprecatedAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitDeprecatedAttribute(Clazz clazz, Method method, DeprecatedAttribute deprecatedAttribute) {
        if (this.accepted(clazz, deprecatedAttribute)) {
            deprecatedAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        if (this.accepted(clazz, syntheticAttribute)) {
            syntheticAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitSyntheticAttribute(Clazz clazz, Field field, SyntheticAttribute syntheticAttribute) {
        if (this.accepted(clazz, syntheticAttribute)) {
            syntheticAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitSyntheticAttribute(Clazz clazz, Method method, SyntheticAttribute syntheticAttribute) {
        if (this.accepted(clazz, syntheticAttribute)) {
            syntheticAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        if (this.accepted(clazz, signatureAttribute)) {
            signatureAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitSignatureAttribute(Clazz clazz, Field field, SignatureAttribute signatureAttribute) {
        if (this.accepted(clazz, signatureAttribute)) {
            signatureAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        if (this.accepted(clazz, signatureAttribute)) {
            signatureAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        if (this.accepted(clazz, constantValueAttribute)) {
            constantValueAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        if (this.accepted(clazz, exceptionsAttribute)) {
            exceptionsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.accepted(clazz, codeAttribute)) {
            codeAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        if (this.accepted(clazz, stackMapAttribute)) {
            stackMapAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        if (this.accepted(clazz, stackMapTableAttribute)) {
            stackMapTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        if (this.accepted(clazz, lineNumberTableAttribute)) {
            lineNumberTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        if (this.accepted(clazz, localVariableTableAttribute)) {
            localVariableTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        if (this.accepted(clazz, localVariableTypeTableAttribute)) {
            localVariableTypeTableAttribute.accept(clazz, method, codeAttribute, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeVisibleAnnotationsAttribute)) {
            runtimeVisibleAnnotationsAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Field field, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeVisibleAnnotationsAttribute)) {
            runtimeVisibleAnnotationsAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeVisibleAnnotationsAttribute)) {
            runtimeVisibleAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeInvisibleAnnotationsAttribute)) {
            runtimeInvisibleAnnotationsAttribute.accept(clazz, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Field field, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeInvisibleAnnotationsAttribute)) {
            runtimeInvisibleAnnotationsAttribute.accept(clazz, field, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeInvisibleAnnotationsAttribute)) {
            runtimeInvisibleAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeVisibleParameterAnnotationsAttribute)) {
            runtimeVisibleParameterAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        if (this.accepted(clazz, runtimeInvisibleParameterAnnotationsAttribute)) {
            runtimeInvisibleParameterAnnotationsAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        if (this.accepted(clazz, annotationDefaultAttribute)) {
            annotationDefaultAttribute.accept(clazz, method, this.attributeVisitor);
        }
    }

    private boolean accepted(Clazz clazz, Attribute attribute) {
        return this.regularExpressionMatcher.matches(attribute.getAttributeName(clazz));
    }
}

