'''OpenGL extension SGIS.shared_multisample

This module customises the behaviour of the 
OpenGL.raw.GLX.SGIS.shared_multisample to provide a more 
Python-friendly API

Overview (from the spec)
	
	While the OpenGL multisample extension (SGIS_multisample) provides
	good out-of-order antialiasing via subpixel samples, multisample
	hardware is very expensive because it multiplies the per-pixel
	framebuffer memory required to maintain color, depth, and stencil
	state by the number of samples.
	
	The cost-sensitive Location Based Entertainment (LBE) market
	desires good quality antialiasing, but the cost of maintaining
	multisample memory for every pixel in the framebuffer managed area
	is often prohibitive.  Low-end multi-channel visual simulation may
	have similar cost constraints.
	
	LBE applications typically render several channels that are output
	to different video display devices.  For example, an LBE
	application may render four 800x600 resolution channels, one per
	game player.  While the total managed area may be 1600x1200, each
	channel ends up being rendered serially.  With traditional
	multisampling (as specified by SGIS_multisample), multisample
	memory must be retained across the entire 1600x1200 managed area
	though in fact the application is never using more than an 800x600
	rectangle of multisample pixel state at any given time.
	
	This sharing of multisample framebuffer state can result in a
	substantial competitive advantage for high-end multi-channel
	multisampling hardware for LBE applications.  Unlike a "cheap PC
	per seat" solution, a high-end solution can be amortized by sharing
	both texture and multisample memory between the multiple channels
	(as well as host resources such as disk and CPUs).  For cheap PCs
	to have the same amount of texture memory and quality of
	antialiasing, texture and multisample memory have to be replicated
	in every PC.
	
	In a typical windowed environment, the entire framebuffer managed
	area must retain multisample state because windows can be moved
	dynamically and resized (up to the entire size of the managed
	area).  For LBE applications though, the layout of channel
	subrectangles in the framebuffer managed area is static and the
	LBE application monopolizes the graphics device (no other
	concurrent windowed apps).  Because of their channel-oriented,
	dedicated, cost-sensitive nature, LBE applications can benefit from
	a means to share the available multisample memory resources among
	all the channels.
	
	The SGIS_shared_multisample extension specifies a single
	multisample buffer subrectangle sized smaller than the total
	managed area that is both shared among multiple windows and
	repositionable within in a window.
	
	Use of the SGIS_shared_multisample extension is predicated on
	specially configuring the window system, typically via a command
	line option added to the window system server's startup command.
	When run in this mode, OpenGL applications will see the
	GL_SGIS_shared_multisample string advertised in the GL_EXTENSIONS
	string (along with the GL_SGIS_multisample string).  In this mode,
	the behavior of multisample extension changes.  Instead of the
	multisample buffer memory being retained per-pixel across the
	entire managed area, multisample memory is shared among multisample
	windows and repositionable within a multisample window.
	
	Switching windows or repositioning the multisample subrectangle
	will make undefined the shared state within the multisample, depth,
	stencil, and accumulation buffers.
	
	When rendering into a multisample window, fragments that fall
	outside the window's multisample subrectangle are discarded
	(scissored).  By default, the window's multisample rectangle is
	positioned at its window origin.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIS/shared_multisample.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLX import _types, _glgets
from OpenGL.raw.GLX.SGIS.shared_multisample import *
from OpenGL.raw.GLX.SGIS.shared_multisample import _EXTENSION_NAME

def glInitSharedMultisampleSGIS():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION