# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessIdName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessIdName."""

    ACCESS = "access"
    GIT_ACCESS = "gitAccess"


class AccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of access to be used for the storage account."""

    ACCESS_KEY = "AccessKey"
    """Use access key."""
    SYSTEM_ASSIGNED_MANAGED_IDENTITY = "SystemAssignedManagedIdentity"
    """Use system assigned managed identity."""
    USER_ASSIGNED_MANAGED_IDENTITY = "UserAssignedManagedIdentity"
    """Use user assigned managed identity."""


class AlwaysLog(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies for what type of messages sampling settings should not apply."""

    ALL_ERRORS = "allErrors"
    """Always log all erroneous request regardless of sampling settings."""


class ApiManagementSkuCapacityScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scale type applicable to the sku."""

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
    NONE = "None"


class ApiManagementSkuRestrictionsReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for restriction."""

    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"


class ApiManagementSkuRestrictionsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of restrictions."""

    LOCATION = "Location"
    ZONE = "Zone"


class ApimIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes
    both an implicitly created identity and a set of user assigned identities. The type 'None' will
    remove any identities from the service.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class ApiType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of API."""

    HTTP = "http"
    SOAP = "soap"
    WEBSOCKET = "websocket"
    GRAPHQL = "graphql"


class AppType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AppType."""

    PORTAL = "portal"
    """User create request was sent by legacy developer portal."""
    DEVELOPER_PORTAL = "developerPortal"
    """User create request was sent by new developer portal."""


class AsyncOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of an async operation."""

    STARTED = "Started"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class AsyncResolverStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of an async resolver."""

    STARTED = "Started"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class AuthorizationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AuthorizationMethod."""

    HEAD = "HEAD"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"
    GET = "GET"
    POST = "POST"
    PUT = "PUT"
    PATCH = "PATCH"
    DELETE = "DELETE"


class AuthorizationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Authorization type options."""

    O_AUTH2 = "OAuth2"
    """OAuth2 authorization type"""


class BackendProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Backend communication protocol."""

    HTTP = "http"
    """The Backend is a RESTful service."""
    SOAP = "soap"
    """The Backend is a SOAP service."""


class BearerTokenSendingMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BearerTokenSendingMethod."""

    AUTHORIZATION_HEADER = "authorizationHeader"
    QUERY = "query"


class BearerTokenSendingMethods(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Form of an authorization grant, which the client uses to request the access token."""

    AUTHORIZATION_HEADER = "authorizationHeader"
    """Access token will be transmitted in the Authorization header using Bearer schema"""
    QUERY = "query"
    """Access token will be transmitted as query parameters."""


class CertificateConfigurationStoreName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only
    Root and CertificateAuthority are valid locations.
    """

    CERTIFICATE_AUTHORITY = "CertificateAuthority"
    ROOT = "Root"


class CertificateSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Certificate Source."""

    MANAGED = "Managed"
    KEY_VAULT = "KeyVault"
    CUSTOM = "Custom"
    BUILT_IN = "BuiltIn"


class CertificateStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Certificate Status."""

    COMPLETED = "Completed"
    FAILED = "Failed"
    IN_PROGRESS = "InProgress"


class ClientAuthenticationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ClientAuthenticationMethod."""

    BASIC = "Basic"
    """Basic Client Authentication method."""
    BODY = "Body"
    """Body based Authentication method."""


class ConfigurationIdName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ConfigurationIdName."""

    CONFIGURATION = "configuration"


class Confirmation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines the type of confirmation e-mail that will be sent to the newly created user."""

    SIGNUP = "signup"
    """Send an e-mail to the user confirming they have successfully signed up."""
    INVITE = "invite"
    """Send an e-mail inviting the user to sign-up and complete registration."""


class ConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The connection status."""

    UNKNOWN = "Unknown"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    DEGRADED = "Degraded"


class ConnectivityCheckProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The request's protocol. Specific protocol configuration can be available based on this
    selection. The specified destination address must be coherent with this value.
    """

    TCP = "TCP"
    HTTP = "HTTP"
    HTTPS = "HTTPS"


class ConnectivityStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource Connectivity Status Type identifier."""

    INITIALIZING = "initializing"
    SUCCESS = "success"
    FAILURE = "failure"


class ContentFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Format of the Content in which the API is getting imported."""

    WADL_XML = "wadl-xml"
    """The contents are inline and Content type is a WADL document."""
    WADL_LINK_JSON = "wadl-link-json"
    """The WADL document is hosted on a publicly accessible internet address."""
    SWAGGER_JSON = "swagger-json"
    """The contents are inline and Content Type is a OpenAPI 2.0 JSON Document."""
    SWAGGER_LINK_JSON = "swagger-link-json"
    """The OpenAPI 2.0 JSON document is hosted on a publicly accessible internet address."""
    WSDL = "wsdl"
    """The contents are inline and the document is a WSDL/Soap document."""
    WSDL_LINK = "wsdl-link"
    """The WSDL document is hosted on a publicly accessible internet address."""
    OPENAPI = "openapi"
    """The contents are inline and Content Type is a OpenAPI 3.0 YAML Document."""
    OPENAPI_JSON = "openapi+json"
    """The contents are inline and Content Type is a OpenAPI 3.0 JSON Document."""
    OPENAPI_LINK = "openapi-link"
    """The OpenAPI 3.0 YAML document is hosted on a publicly accessible internet address."""
    OPENAPI_JSON_LINK = "openapi+json-link"
    """The OpenAPI 3.0 JSON document is hosted on a publicly accessible internet address."""
    GRAPHQL_LINK = "graphql-link"
    """The GraphQL API endpoint hosted on a publicly accessible internet address."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DataMaskingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data masking mode."""

    MASK = "Mask"
    """Mask the value of an entity."""
    HIDE = "Hide"
    """Hide the presence of an entity."""


class ExportApi(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExportApi."""

    TRUE = "true"


class ExportFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExportFormat."""

    SWAGGER = "swagger-link"
    """Export the Api Definition in OpenAPI 2.0 Specification as JSON document to the Storage Blob."""
    WSDL = "wsdl-link"
    """Export the Api Definition in WSDL Schema to Storage Blob. This is only supported for APIs of
    Type ``soap``"""
    WADL = "wadl-link"
    """Export the Api Definition in WADL Schema to Storage Blob."""
    OPENAPI = "openapi-link"
    """Export the Api Definition in OpenAPI 3.0 Specification as YAML document to Storage Blob."""
    OPENAPI_JSON = "openapi+json-link"
    """Export the Api Definition in OpenAPI 3.0 Specification as JSON document to Storage Blob."""


class ExportResultFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Format in which the API Details are exported to the Storage Blob with Sas Key valid for 5
    minutes.
    """

    SWAGGER = "swagger-link-json"
    """The API Definition is exported in OpenAPI Specification 2.0 format to the Storage Blob."""
    WSDL = "wsdl-link+xml"
    """The API Definition is exported in WSDL Schema to Storage Blob. This is only supported for APIs
    of Type ``soap``"""
    WADL = "wadl-link-json"
    """Export the API Definition in WADL Schema to Storage Blob."""
    OPEN_API = "openapi-link"
    """Export the API Definition in OpenAPI Specification 3.0 to Storage Blob."""


class GrantType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GrantType."""

    AUTHORIZATION_CODE = "authorizationCode"
    """Authorization Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.1."""
    IMPLICIT = "implicit"
    """Implicit Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.2."""
    RESOURCE_OWNER_PASSWORD = "resourceOwnerPassword"
    """Resource Owner Password Grant flow as described
    https://tools.ietf.org/html/rfc6749#section-4.3."""
    CLIENT_CREDENTIALS = "clientCredentials"
    """Client Credentials Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.4."""


class GroupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Group type."""

    CUSTOM = "custom"
    SYSTEM = "system"
    EXTERNAL = "external"


class HostnameType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Hostname type."""

    PROXY = "Proxy"
    PORTAL = "Portal"
    MANAGEMENT = "Management"
    SCM = "Scm"
    DEVELOPER_PORTAL = "DeveloperPortal"


class HttpCorrelationProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sets correlation protocol to use for Application Insights diagnostics."""

    NONE = "None"
    """Do not read and inject correlation headers."""
    LEGACY = "Legacy"
    """Inject Request-Id and Request-Context headers with request correlation data. See
    https://github.com/dotnet/corefx/blob/master/src/System.Diagnostics.DiagnosticSource/src/HttpCorrelationProtocol.md."""
    W3_C = "W3C"
    """Inject Trace Context headers. See https://w3c.github.io/trace-context."""


class IdentityProviderType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IdentityProviderType."""

    FACEBOOK = "facebook"
    """Facebook as Identity provider."""
    GOOGLE = "google"
    """Google as Identity provider."""
    MICROSOFT = "microsoft"
    """Microsoft Live as Identity provider."""
    TWITTER = "twitter"
    """Twitter as Identity provider."""
    AAD = "aad"
    """Azure Active Directory as Identity provider."""
    AAD_B2_C = "aadB2C"
    """Azure Active Directory B2C as Identity provider."""


class IssueType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of issue."""

    UNKNOWN = "Unknown"
    AGENT_STOPPED = "AgentStopped"
    GUEST_FIREWALL = "GuestFirewall"
    DNS_RESOLUTION = "DnsResolution"
    SOCKET_BIND = "SocketBind"
    NETWORK_SECURITY_RULE = "NetworkSecurityRule"
    USER_DEFINED_ROUTE = "UserDefinedRoute"
    PORT_THROTTLED = "PortThrottled"
    PLATFORM = "Platform"


class KeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Key to be used to generate token for user."""

    PRIMARY = "primary"
    SECONDARY = "secondary"


class LoggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Logger type."""

    AZURE_EVENT_HUB = "azureEventHub"
    """Azure Event Hub as log destination."""
    APPLICATION_INSIGHTS = "applicationInsights"
    """Azure Application Insights as log destination."""
    AZURE_MONITOR = "azureMonitor"
    """Azure Monitor"""


class Method(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The HTTP method to be used."""

    GET = "GET"
    POST = "POST"


class NameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Invalid indicates the name provided does not match the resource provider’s naming requirements
    (incorrect length, unsupported characters, etc.)  AlreadyExists indicates that the name is
    already in use and is therefore unavailable.
    """

    VALID = "Valid"
    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class NatGatewayState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Property can be used to enable NAT Gateway for this API Management service."""

    ENABLED = "Enabled"
    """Nat Gateway is enabled for the service."""
    DISABLED = "Disabled"
    """Nat Gateway is disabled for the service."""


class NotificationName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NotificationName."""

    REQUEST_PUBLISHER_NOTIFICATION_MESSAGE = "RequestPublisherNotificationMessage"
    """The following email recipients and users will receive email notifications about subscription
    requests for API products requiring approval."""
    PURCHASE_PUBLISHER_NOTIFICATION_MESSAGE = "PurchasePublisherNotificationMessage"
    """The following email recipients and users will receive email notifications about new API product
    subscriptions."""
    NEW_APPLICATION_NOTIFICATION_MESSAGE = "NewApplicationNotificationMessage"
    """The following email recipients and users will receive email notifications when new applications
    are submitted to the application gallery."""
    BCC = "BCC"
    """The following recipients will receive blind carbon copies of all emails sent to developers."""
    NEW_ISSUE_PUBLISHER_NOTIFICATION_MESSAGE = "NewIssuePublisherNotificationMessage"
    """The following email recipients and users will receive email notifications when a new issue or
    comment is submitted on the developer portal."""
    ACCOUNT_CLOSED_PUBLISHER = "AccountClosedPublisher"
    """The following email recipients and users will receive email notifications when developer closes
    his account."""
    QUOTA_LIMIT_APPROACHING_PUBLISHER_NOTIFICATION_MESSAGE = "QuotaLimitApproachingPublisherNotificationMessage"
    """The following email recipients and users will receive email notifications when subscription
    usage gets close to usage quota."""


class OAuth2GrantType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """OAuth2 grant type options."""

    AUTHORIZATION_CODE = "AuthorizationCode"
    """Authorization Code grant"""
    CLIENT_CREDENTIALS = "ClientCredentials"
    """Client Credential grant"""


class OperationNameFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The format of the Operation Name for Application Insights telemetries. Default is Name."""

    NAME = "Name"
    """API_NAME;rev=API_REVISION - OPERATION_NAME"""
    URL = "Url"
    """HTTP_VERB URL"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The origin of the issue."""

    LOCAL = "Local"
    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class PlatformVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Compute Platform Version running the service."""

    UNDETERMINED = "undetermined"
    """Platform version cannot be determined, as compute platform is not deployed."""
    STV1 = "stv1"
    """Platform running the service on Single Tenant V1 platform."""
    STV2 = "stv2"
    """Platform running the service on Single Tenant V2 platform."""
    MTV1 = "mtv1"
    """Platform running the service on Multi Tenant V1 platform."""


class PolicyContentFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Format of the policyContent."""

    XML = "xml"
    """The contents are inline and Content type is an XML document."""
    XML_LINK = "xml-link"
    """The policy XML document is hosted on a HTTP endpoint accessible from the API Management
    service."""
    RAWXML = "rawxml"
    """The contents are inline and Content type is a non XML encoded policy document."""
    RAWXML_LINK = "rawxml-link"
    """The policy document is not XML encoded and is hosted on a HTTP endpoint accessible from the API
    Management service."""


class PolicyExportFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyExportFormat."""

    XML = "xml"
    """The contents are inline and Content type is an XML document."""
    RAWXML = "rawxml"
    """The contents are inline and Content type is a non XML encoded policy document."""


class PolicyFragmentContentFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyFragmentContentFormat."""

    XML = "xml"
    """The contents are inline and Content type is an XML document."""
    RAWXML = "rawxml"
    """The contents are inline and Content type is a non XML encoded policy document."""


class PolicyIdName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyIdName."""

    POLICY = "policy"


class PolicyScopeContract(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PolicyScopeContract."""

    TENANT = "Tenant"
    PRODUCT = "Product"
    API = "Api"
    OPERATION = "Operation"
    ALL = "All"


class PortalRevisionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the portal's revision."""

    PENDING = "pending"
    """Portal's revision has been queued."""
    PUBLISHING = "publishing"
    """Portal's revision is being published."""
    COMPLETED = "completed"
    """Portal's revision publishing completed."""
    FAILED = "failed"
    """Portal's revision publishing failed."""


class PortalSettingsCspMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode of the developer portal Content Security Policy (CSP)."""

    ENABLED = "enabled"
    """The browser will block requests not matching allowed origins."""
    DISABLED = "disabled"
    """The browser will not apply the origin restrictions."""
    REPORT_ONLY = "reportOnly"
    """The browser will report requests not matching allowed origins without blocking them."""


class PreferredIPVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IP version to be used. Only IPv4 is supported for now."""

    I_PV4 = "IPv4"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class ProductState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """whether product is published or not. Published products are discoverable by users of developer
    portal. Non published products are visible only to administrators. Default state of Product is
    notPublished.
    """

    NOT_PUBLISHED = "notPublished"
    PUBLISHED = "published"


class Protocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol."""

    HTTP = "http"
    HTTPS = "https"
    WS = "ws"
    WSS = "wss"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether or not public endpoint access is allowed for this API Management service.  Value is
    optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints
    are the exclusive access method. Default value is 'Enabled'.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ResourceSkuCapacityScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scale type applicable to the sku."""

    AUTOMATIC = "automatic"
    """Supported scale type automatic."""
    MANUAL = "manual"
    """Supported scale type manual."""
    NONE = "none"
    """Scaling not supported."""


class SamplingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sampling type."""

    FIXED = "fixed"
    """Fixed-rate sampling."""


class SchemaType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Schema Type. Immutable."""

    XML = "xml"
    """XML schema type."""
    JSON = "json"
    """Json schema type."""


class SettingsTypeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SettingsTypeName."""

    PUBLIC = "public"


class Severity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity of the issue."""

    ERROR = "Error"
    WARNING = "Warning"


class SkuType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the Sku."""

    DEVELOPER = "Developer"
    """Developer SKU of Api Management."""
    STANDARD = "Standard"
    """Standard SKU of Api Management."""
    PREMIUM = "Premium"
    """Premium SKU of Api Management."""
    BASIC = "Basic"
    """Basic SKU of Api Management."""
    CONSUMPTION = "Consumption"
    """Consumption SKU of Api Management."""
    ISOLATED = "Isolated"
    """Isolated SKU of Api Management."""


class SoapApiType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of API to create.


    * ``http`` creates a REST API
    * ``soap`` creates a SOAP pass-through API
    * ``websocket`` creates websocket API
    * ``graphql`` creates GraphQL API.
    """

    SOAP_TO_REST = "http"
    """Imports a SOAP API having a RESTful front end."""
    SOAP_PASS_THROUGH = "soap"
    """Imports the SOAP API having a SOAP front end."""
    WEB_SOCKET = "websocket"
    """Imports the API having a Websocket front end."""
    GRAPH_QL = "graphql"
    """Imports the API having a GraphQL front end."""


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the issue."""

    PROPOSED = "proposed"
    """The issue is proposed."""
    OPEN = "open"
    """The issue is opened."""
    REMOVED = "removed"
    """The issue was removed."""
    RESOLVED = "resolved"
    """The issue is now resolved."""
    CLOSED = "closed"
    """The issue was closed."""


class SubscriptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Subscription state. Possible states are * active – the subscription is active, * suspended –
    the subscription is blocked, and the subscriber cannot call any APIs of the product, *
    submitted – the subscription request has been made by the developer, but has not yet been
    approved or rejected, * rejected – the subscription request has been denied by an
    administrator, * cancelled – the subscription has been cancelled by the developer or
    administrator, * expired – the subscription reached its expiration date and was deactivated.
    """

    SUSPENDED = "suspended"
    ACTIVE = "active"
    EXPIRED = "expired"
    SUBMITTED = "submitted"
    REJECTED = "rejected"
    CANCELLED = "cancelled"


class TemplateName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TemplateName."""

    APPLICATION_APPROVED_NOTIFICATION_MESSAGE = "applicationApprovedNotificationMessage"
    ACCOUNT_CLOSED_DEVELOPER = "accountClosedDeveloper"
    QUOTA_LIMIT_APPROACHING_DEVELOPER_NOTIFICATION_MESSAGE = "quotaLimitApproachingDeveloperNotificationMessage"
    NEW_DEVELOPER_NOTIFICATION_MESSAGE = "newDeveloperNotificationMessage"
    EMAIL_CHANGE_IDENTITY_DEFAULT = "emailChangeIdentityDefault"
    INVITE_USER_NOTIFICATION_MESSAGE = "inviteUserNotificationMessage"
    NEW_COMMENT_NOTIFICATION_MESSAGE = "newCommentNotificationMessage"
    CONFIRM_SIGN_UP_IDENTITY_DEFAULT = "confirmSignUpIdentityDefault"
    NEW_ISSUE_NOTIFICATION_MESSAGE = "newIssueNotificationMessage"
    PURCHASE_DEVELOPER_NOTIFICATION_MESSAGE = "purchaseDeveloperNotificationMessage"
    PASSWORD_RESET_IDENTITY_DEFAULT = "passwordResetIdentityDefault"
    PASSWORD_RESET_BY_ADMIN_NOTIFICATION_MESSAGE = "passwordResetByAdminNotificationMessage"
    REJECT_DEVELOPER_NOTIFICATION_MESSAGE = "rejectDeveloperNotificationMessage"
    REQUEST_DEVELOPER_NOTIFICATION_MESSAGE = "requestDeveloperNotificationMessage"


class TranslateRequiredQueryParametersConduct(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Strategy of translating required query parameters to template ones. By default has value
    'template'. Possible values: 'template', 'query'.
    """

    TEMPLATE = "template"
    """Translates required query parameters to template ones. Is a default value"""
    QUERY = "query"
    """Leaves required query parameters as they are (no translation done)."""


class UserState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Account state. Specifies whether the user is active or not. Blocked users are unable to sign
    into the developer portal or call any APIs of subscribed products. Default state is Active.
    """

    ACTIVE = "active"
    """User state is active."""
    BLOCKED = "blocked"
    """User is blocked. Blocked users cannot authenticate at developer portal or call API."""
    PENDING = "pending"
    """User account is pending. Requires identity confirmation before it can be made active."""
    DELETED = "deleted"
    """User account is closed. All identities and related entities are removed."""


class Verbosity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The verbosity level applied to traces emitted by trace policies."""

    VERBOSE = "verbose"
    """All the traces emitted by trace policies will be sent to the logger attached to this diagnostic
    instance."""
    INFORMATION = "information"
    """Traces with 'severity' set to 'information' and 'error' will be sent to the logger attached to
    this diagnostic instance."""
    ERROR = "error"
    """Only traces with 'severity' set to 'error' will be sent to the logger attached to this
    diagnostic instance."""


class VersioningScheme(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An value that determines where the API Version identifier will be located in a HTTP request."""

    SEGMENT = "Segment"
    """The API Version is passed in a path segment."""
    QUERY = "Query"
    """The API Version is passed in a query parameter."""
    HEADER = "Header"
    """The API Version is passed in a HTTP header."""


class VirtualNetworkType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of VPN in which API Management service needs to be configured in. None (Default Value)
    means the API Management service is not part of any Virtual Network, External means the API
    Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint,
    and Internal means that API Management deployment is setup inside a Virtual Network having an
    Intranet Facing Endpoint only.
    """

    NONE = "None"
    """The service is not part of any Virtual Network."""
    EXTERNAL = "External"
    """The service is part of Virtual Network and it is accessible from Internet."""
    INTERNAL = "Internal"
    """The service is part of Virtual Network and it is only accessible from within the virtual
    network."""
