# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class ElseCondition(_serialization.Model):
    """The else block of storage task operation.

    All required parameters must be populated in order to send to server.

    :ivar operations: List of operations to execute in the else block. Required.
    :vartype operations: list[~azure.mgmt.storageactions.models.StorageTaskOperation]
    """

    _validation = {
        "operations": {"required": True},
    }

    _attribute_map = {
        "operations": {"key": "operations", "type": "[StorageTaskOperation]"},
    }

    def __init__(self, *, operations: List["_models.StorageTaskOperation"], **kwargs: Any) -> None:
        """
        :keyword operations: List of operations to execute in the else block. Required.
        :paramtype operations: list[~azure.mgmt.storageactions.models.StorageTaskOperation]
        """
        super().__init__(**kwargs)
        self.operations = operations


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.storageactions.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.storageactions.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.storageactions.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.storageactions.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class IfCondition(_serialization.Model):
    """The if block of storage task operation.

    All required parameters must be populated in order to send to server.

    :ivar condition: Condition predicate to evaluate each object. See
     https://aka.ms/storagetaskconditions for valid properties and operators. Required.
    :vartype condition: str
    :ivar operations: List of operations to execute when the condition predicate satisfies.
     Required.
    :vartype operations: list[~azure.mgmt.storageactions.models.StorageTaskOperation]
    """

    _validation = {
        "condition": {"required": True},
        "operations": {"required": True},
    }

    _attribute_map = {
        "condition": {"key": "condition", "type": "str"},
        "operations": {"key": "operations", "type": "[StorageTaskOperation]"},
    }

    def __init__(self, *, condition: str, operations: List["_models.StorageTaskOperation"], **kwargs: Any) -> None:
        """
        :keyword condition: Condition predicate to evaluate each object. See
         https://aka.ms/storagetaskconditions for valid properties and operators. Required.
        :paramtype condition: str
        :keyword operations: List of operations to execute when the condition predicate satisfies.
         Required.
        :paramtype operations: list[~azure.mgmt.storageactions.models.StorageTaskOperation]
        """
        super().__init__(**kwargs)
        self.condition = condition
        self.operations = operations


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.storageactions.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.storageactions.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.storageactions.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.storageactions.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.storageactions.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.storageactions.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.storageactions.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.storageactions.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.storageactions.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    """


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageTask(TrackedResource):
    """Represents Storage Task.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed service identity of the resource. Required.
    :vartype identity: ~azure.mgmt.storageactions.models.ManagedServiceIdentity
    :ivar properties: Properties of the storage task. Required.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "identity": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "properties": {"key": "properties", "type": "StorageTaskProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        identity: "_models.ManagedServiceIdentity",
        properties: "_models.StorageTaskProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed service identity of the resource. Required.
        :paramtype identity: ~azure.mgmt.storageactions.models.ManagedServiceIdentity
        :keyword properties: Properties of the storage task. Required.
        :paramtype properties: ~azure.mgmt.storageactions.models.StorageTaskProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.properties = properties


class StorageTaskAction(_serialization.Model):
    """The storage task action represents conditional statements and operations to be performed on
    target objects.

    All required parameters must be populated in order to send to server.

    :ivar if_property: The if block of storage task operation. Required.
    :vartype if_property: ~azure.mgmt.storageactions.models.IfCondition
    :ivar else_property: The else block of storage task operation.
    :vartype else_property: ~azure.mgmt.storageactions.models.ElseCondition
    """

    _validation = {
        "if_property": {"required": True},
    }

    _attribute_map = {
        "if_property": {"key": "if", "type": "IfCondition"},
        "else_property": {"key": "else", "type": "ElseCondition"},
    }

    def __init__(
        self,
        *,
        if_property: "_models.IfCondition",
        else_property: Optional["_models.ElseCondition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword if_property: The if block of storage task operation. Required.
        :paramtype if_property: ~azure.mgmt.storageactions.models.IfCondition
        :keyword else_property: The else block of storage task operation.
        :paramtype else_property: ~azure.mgmt.storageactions.models.ElseCondition
        """
        super().__init__(**kwargs)
        self.if_property = if_property
        self.else_property = else_property


class StorageTaskAssignment(_serialization.Model):
    """Storage Task Assignment associated with this Storage Task.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the Storage Task Assignment.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class StorageTaskAssignmentsListResult(_serialization.Model):
    """The response from the List Storage Tasks operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Storage Task Assignment Resource IDs associated with this Storage Task.
    :vartype value: list[~azure.mgmt.storageactions.models.StorageTaskAssignment]
    :ivar next_link: Request URL that can be used to query next page of Resource IDs. Returned when
     total number of requested Resource IDs exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageTaskAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageTaskOperation(_serialization.Model):
    """Represents an operation to be performed on the object.

    All required parameters must be populated in order to send to server.

    :ivar name: The operation to be performed on the object. Required. Known values are:
     "SetBlobTier", "SetBlobTags", "SetBlobImmutabilityPolicy", "SetBlobLegalHold", "SetBlobExpiry",
     "DeleteBlob", and "UndeleteBlob".
    :vartype name: str or ~azure.mgmt.storageactions.models.StorageTaskOperationName
    :ivar parameters: Key-value parameters for the operation.
    :vartype parameters: dict[str, str]
    :ivar on_success: Action to be taken when the operation is successful for a object. Default
     value is "continue".
    :vartype on_success: str
    :ivar on_failure: Action to be taken when the operation fails for a object. Default value is
     "break".
    :vartype on_failure: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "parameters": {"key": "parameters", "type": "{str}"},
        "on_success": {"key": "onSuccess", "type": "str"},
        "on_failure": {"key": "onFailure", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.StorageTaskOperationName"],
        parameters: Optional[Dict[str, str]] = None,
        on_success: Optional[Literal["continue"]] = None,
        on_failure: Optional[Literal["break"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The operation to be performed on the object. Required. Known values are:
         "SetBlobTier", "SetBlobTags", "SetBlobImmutabilityPolicy", "SetBlobLegalHold", "SetBlobExpiry",
         "DeleteBlob", and "UndeleteBlob".
        :paramtype name: str or ~azure.mgmt.storageactions.models.StorageTaskOperationName
        :keyword parameters: Key-value parameters for the operation.
        :paramtype parameters: dict[str, str]
        :keyword on_success: Action to be taken when the operation is successful for a object. Default
         value is "continue".
        :paramtype on_success: str
        :keyword on_failure: Action to be taken when the operation fails for a object. Default value is
         "break".
        :paramtype on_failure: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.parameters = parameters
        self.on_success = on_success
        self.on_failure = on_failure


class StorageTaskPreviewAction(_serialization.Model):
    """Storage Task Preview Action.

    All required parameters must be populated in order to send to server.

    :ivar properties: Properties of the storage task preview. Required.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "StorageTaskPreviewActionProperties"},
    }

    def __init__(self, *, properties: "_models.StorageTaskPreviewActionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the storage task preview. Required.
        :paramtype properties: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class StorageTaskPreviewActionCondition(_serialization.Model):
    """Represents the storage task conditions to be tested for a match with container and blob
    properties.

    All required parameters must be populated in order to send to server.

    :ivar if_property: The condition to be tested for a match with container and blob properties.
     Required.
    :vartype if_property: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionIfCondition
    :ivar else_block_exists: Specify whether the else block is present in the condition. Required.
    :vartype else_block_exists: bool
    """

    _validation = {
        "if_property": {"required": True},
        "else_block_exists": {"required": True},
    }

    _attribute_map = {
        "if_property": {"key": "if", "type": "StorageTaskPreviewActionIfCondition"},
        "else_block_exists": {"key": "elseBlockExists", "type": "bool"},
    }

    def __init__(
        self, *, if_property: "_models.StorageTaskPreviewActionIfCondition", else_block_exists: bool, **kwargs: Any
    ) -> None:
        """
        :keyword if_property: The condition to be tested for a match with container and blob
         properties. Required.
        :paramtype if_property: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionIfCondition
        :keyword else_block_exists: Specify whether the else block is present in the condition.
         Required.
        :paramtype else_block_exists: bool
        """
        super().__init__(**kwargs)
        self.if_property = if_property
        self.else_block_exists = else_block_exists


class StorageTaskPreviewActionIfCondition(_serialization.Model):
    """Represents storage task preview action condition.

    :ivar condition: Storage task condition to bes tested for a match.
    :vartype condition: str
    """

    _attribute_map = {
        "condition": {"key": "condition", "type": "str"},
    }

    def __init__(self, *, condition: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword condition: Storage task condition to bes tested for a match.
        :paramtype condition: str
        """
        super().__init__(**kwargs)
        self.condition = condition


class StorageTaskPreviewActionProperties(_serialization.Model):
    """Storage task preview action properties.

    All required parameters must be populated in order to send to server.

    :ivar container: Properties of a sample container to test for a match with the preview action.
     Required.
    :vartype container: ~azure.mgmt.storageactions.models.StorageTaskPreviewContainerProperties
    :ivar blobs: Properties of some sample blobs in the container to test for matches with the
     preview action. Required.
    :vartype blobs: list[~azure.mgmt.storageactions.models.StorageTaskPreviewBlobProperties]
    :ivar action: Preview action to test. Required.
    :vartype action: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionCondition
    """

    _validation = {
        "container": {"required": True},
        "blobs": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "container": {"key": "container", "type": "StorageTaskPreviewContainerProperties"},
        "blobs": {"key": "blobs", "type": "[StorageTaskPreviewBlobProperties]"},
        "action": {"key": "action", "type": "StorageTaskPreviewActionCondition"},
    }

    def __init__(
        self,
        *,
        container: "_models.StorageTaskPreviewContainerProperties",
        blobs: List["_models.StorageTaskPreviewBlobProperties"],
        action: "_models.StorageTaskPreviewActionCondition",
        **kwargs: Any
    ) -> None:
        """
        :keyword container: Properties of a sample container to test for a match with the preview
         action. Required.
        :paramtype container: ~azure.mgmt.storageactions.models.StorageTaskPreviewContainerProperties
        :keyword blobs: Properties of some sample blobs in the container to test for matches with the
         preview action. Required.
        :paramtype blobs: list[~azure.mgmt.storageactions.models.StorageTaskPreviewBlobProperties]
        :keyword action: Preview action to test. Required.
        :paramtype action: ~azure.mgmt.storageactions.models.StorageTaskPreviewActionCondition
        """
        super().__init__(**kwargs)
        self.container = container
        self.blobs = blobs
        self.action = action


class StorageTaskPreviewBlobProperties(_serialization.Model):
    """Storage task preview container properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of test blob.
    :vartype name: str
    :ivar properties: properties key value pairs to be tested for a match against the provided
     condition.
    :vartype properties:
     list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    :ivar metadata: metadata key value pairs to be tested for a match against the provided
     condition.
    :vartype metadata: list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    :ivar tags: tags key value pairs to be tested for a match against the provided condition.
    :vartype tags: list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    :ivar matched_block: Represents the condition block name that matched blob properties. Known
     values are: "If", "Else", "None", "If", and "Else".
    :vartype matched_block: str or ~azure.mgmt.storageactions.models.MatchedBlockName
    """

    _validation = {
        "matched_block": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "[StorageTaskPreviewKeyValueProperties]"},
        "metadata": {"key": "metadata", "type": "[StorageTaskPreviewKeyValueProperties]"},
        "tags": {"key": "tags", "type": "[StorageTaskPreviewKeyValueProperties]"},
        "matched_block": {"key": "matchedBlock", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
        metadata: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
        tags: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of test blob.
        :paramtype name: str
        :keyword properties: properties key value pairs to be tested for a match against the provided
         condition.
        :paramtype properties:
         list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
        :keyword metadata: metadata key value pairs to be tested for a match against the provided
         condition.
        :paramtype metadata:
         list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
        :keyword tags: tags key value pairs to be tested for a match against the provided condition.
        :paramtype tags: list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties
        self.metadata = metadata
        self.tags = tags
        self.matched_block = None


class StorageTaskPreviewContainerProperties(_serialization.Model):
    """Storage task preview container properties.

    :ivar name: Name of test container.
    :vartype name: str
    :ivar metadata: metadata key value pairs to be tested for a match against the provided
     condition.
    :vartype metadata: list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "metadata": {"key": "metadata", "type": "[StorageTaskPreviewKeyValueProperties]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        metadata: Optional[List["_models.StorageTaskPreviewKeyValueProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of test container.
        :paramtype name: str
        :keyword metadata: metadata key value pairs to be tested for a match against the provided
         condition.
        :paramtype metadata:
         list[~azure.mgmt.storageactions.models.StorageTaskPreviewKeyValueProperties]
        """
        super().__init__(**kwargs)
        self.name = name
        self.metadata = metadata


class StorageTaskPreviewKeyValueProperties(_serialization.Model):
    """Storage task preview object key value pair properties.

    :ivar key: Represents the key property of the pair.
    :vartype key: str
    :ivar value: Represents the value property of the pair.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Represents the key property of the pair.
        :paramtype key: str
        :keyword value: Represents the value property of the pair.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class StorageTaskProperties(_serialization.Model):
    """Properties of the storage task.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar task_version: Storage task version.
    :vartype task_version: int
    :ivar enabled: Storage Task is enabled when set to true and disabled when set to false.
     Required.
    :vartype enabled: bool
    :ivar description: Text that describes the purpose of the storage task. Required.
    :vartype description: str
    :ivar action: The storage task action that is executed. Required.
    :vartype action: ~azure.mgmt.storageactions.models.StorageTaskAction
    :ivar provisioning_state: Represents the provisioning state of the storage task. Known values
     are: "ValidateSubscriptionQuotaBegin", "ValidateSubscriptionQuotaEnd", "Accepted", "Creating",
     "Succeeded", "Deleting", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.storageactions.models.ProvisioningState
    :ivar creation_time_in_utc: The creation date and time of the storage task in UTC.
    :vartype creation_time_in_utc: ~datetime.datetime
    """

    _validation = {
        "task_version": {"readonly": True, "maximum": 1, "minimum": 1},
        "enabled": {"required": True},
        "description": {"required": True},
        "action": {"required": True},
        "provisioning_state": {"readonly": True},
        "creation_time_in_utc": {"readonly": True},
    }

    _attribute_map = {
        "task_version": {"key": "taskVersion", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
        "description": {"key": "description", "type": "str"},
        "action": {"key": "action", "type": "StorageTaskAction"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "creation_time_in_utc": {"key": "creationTimeInUtc", "type": "iso-8601"},
    }

    def __init__(self, *, enabled: bool, description: str, action: "_models.StorageTaskAction", **kwargs: Any) -> None:
        """
        :keyword enabled: Storage Task is enabled when set to true and disabled when set to false.
         Required.
        :paramtype enabled: bool
        :keyword description: Text that describes the purpose of the storage task. Required.
        :paramtype description: str
        :keyword action: The storage task action that is executed. Required.
        :paramtype action: ~azure.mgmt.storageactions.models.StorageTaskAction
        """
        super().__init__(**kwargs)
        self.task_version = None
        self.enabled = enabled
        self.description = description
        self.action = action
        self.provisioning_state = None
        self.creation_time_in_utc = None


class StorageTaskReportInstance(ProxyResource):
    """Storage Tasks run report instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storageactions.models.SystemData
    :ivar properties: Storage task execution report for a run instance.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskReportProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "StorageTaskReportProperties"},
    }

    def __init__(self, *, properties: Optional["_models.StorageTaskReportProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Storage task execution report for a run instance.
        :paramtype properties: ~azure.mgmt.storageactions.models.StorageTaskReportProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class StorageTaskReportProperties(_serialization.Model):
    """Storage task execution report for a run instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar task_assignment_id: Resource ID of the Storage Task Assignment associated with this
     reported run.
    :vartype task_assignment_id: str
    :ivar storage_account_id: Resource ID of the Storage Account where this reported run executed.
    :vartype storage_account_id: str
    :ivar start_time: Start time of the run instance. Filter options such as startTime gt
     '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for
     DateTime properties in
     https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators.  # pylint: disable=line-too-long
    :vartype start_time: str
    :ivar finish_time: End time of the run instance. Filter options such as startTime gt
     '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for
     DateTime properties in
     https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators.  # pylint: disable=line-too-long
    :vartype finish_time: str
    :ivar objects_targeted_count: Total number of objects that meet the condition as defined in the
     storage task assignment execution context. Filter options such as objectsTargetedCount gt 50
     and other comparison operators can be used as described for Numerical properties in
     https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators.  # pylint: disable=line-too-long
    :vartype objects_targeted_count: str
    :ivar objects_operated_on_count: Total number of objects that meet the storage tasks condition
     and were operated upon. Filter options such as objectsOperatedOnCount ge 100 and other
     comparison operators can be used as described for Numerical properties in
     https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators.  # pylint: disable=line-too-long
    :vartype objects_operated_on_count: str
    :ivar object_failed_count: Total number of objects where task operation failed when was
     attempted. Filter options such as objectFailedCount eq 0 and other comparison operators can be
     used as described for Numerical properties in
     https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators.  # pylint: disable=line-too-long
    :vartype object_failed_count: str
    :ivar objects_succeeded_count: Total number of objects where task operation succeeded when was
     attempted.Filter options such as objectsSucceededCount gt 150 and other comparison operators
     can be used as described for Numerical properties in
     https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators.  # pylint: disable=line-too-long
    :vartype objects_succeeded_count: str
    :ivar run_status_error: Well known Azure Storage error code that represents the error
     encountered during execution of the run instance.
    :vartype run_status_error: str
    :ivar run_status_enum: Represents the status of the execution. Known values are: "InProgress"
     and "Finished".
    :vartype run_status_enum: str or ~azure.mgmt.storageactions.models.RunStatusEnum
    :ivar summary_report_path: Full path to the verbose report stored in the reporting container as
     specified in the assignment execution context for the storage account.
    :vartype summary_report_path: str
    :ivar task_id: Resource ID of the Storage Task applied during this run.
    :vartype task_id: str
    :ivar task_version: Storage Task Version.
    :vartype task_version: str
    :ivar run_result: Represents the overall result of the execution for the run instance. Known
     values are: "Succeeded" and "Failed".
    :vartype run_result: str or ~azure.mgmt.storageactions.models.RunResult
    """

    _validation = {
        "task_assignment_id": {"readonly": True},
        "storage_account_id": {"readonly": True},
        "start_time": {"readonly": True},
        "finish_time": {"readonly": True},
        "objects_targeted_count": {"readonly": True},
        "objects_operated_on_count": {"readonly": True},
        "object_failed_count": {"readonly": True},
        "objects_succeeded_count": {"readonly": True},
        "run_status_error": {"readonly": True},
        "run_status_enum": {"readonly": True},
        "summary_report_path": {"readonly": True},
        "task_id": {"readonly": True},
        "task_version": {"readonly": True},
        "run_result": {"readonly": True},
    }

    _attribute_map = {
        "task_assignment_id": {"key": "taskAssignmentId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "finish_time": {"key": "finishTime", "type": "str"},
        "objects_targeted_count": {"key": "objectsTargetedCount", "type": "str"},
        "objects_operated_on_count": {"key": "objectsOperatedOnCount", "type": "str"},
        "object_failed_count": {"key": "objectFailedCount", "type": "str"},
        "objects_succeeded_count": {"key": "objectsSucceededCount", "type": "str"},
        "run_status_error": {"key": "runStatusError", "type": "str"},
        "run_status_enum": {"key": "runStatusEnum", "type": "str"},
        "summary_report_path": {"key": "summaryReportPath", "type": "str"},
        "task_id": {"key": "taskId", "type": "str"},
        "task_version": {"key": "taskVersion", "type": "str"},
        "run_result": {"key": "runResult", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.task_assignment_id = None
        self.storage_account_id = None
        self.start_time = None
        self.finish_time = None
        self.objects_targeted_count = None
        self.objects_operated_on_count = None
        self.object_failed_count = None
        self.objects_succeeded_count = None
        self.run_status_error = None
        self.run_status_enum = None
        self.summary_report_path = None
        self.task_id = None
        self.task_version = None
        self.run_result = None


class StorageTaskReportSummary(_serialization.Model):
    """Fetch Storage Tasks Run Summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets storage tasks run result summary.
    :vartype value: list[~azure.mgmt.storageactions.models.StorageTaskReportInstance]
    :ivar next_link: Request URL that can be used to query next page of storage task run results
     summary. Returned when the number of run instances and summary reports exceed maximum page
     size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageTaskReportInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageTasksListResult(_serialization.Model):
    """The response from the List Storage Task operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of storage tasks and their properties.
    :vartype value: list[~azure.mgmt.storageactions.models.StorageTask]
    :ivar next_link: Request URL that can be used to query next page of storage tasks. Returned
     when total number of requested storage tasks exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageTask]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageTaskUpdateParameters(_serialization.Model):
    """Parameters of the storage task update request.

    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.storageactions.models.ManagedServiceIdentity
    :ivar tags: Gets or sets a list of key value pairs that describe the resource. These tags can
     be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags
     can be provided for a resource. Each tag must have a key no greater in length than 128
     characters and a value no greater in length than 256 characters.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the storage task.
    :vartype properties: ~azure.mgmt.storageactions.models.StorageTaskProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "StorageTaskProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StorageTaskProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.storageactions.models.ManagedServiceIdentity
        :keyword tags: Gets or sets a list of key value pairs that describe the resource. These tags
         can be used in viewing and grouping this resource (across resource groups). A maximum of 15
         tags can be provided for a resource. Each tag must have a key no greater in length than 128
         characters and a value no greater in length than 256 characters.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the storage task.
        :paramtype properties: ~azure.mgmt.storageactions.models.StorageTaskProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.properties = properties


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storageactions.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storageactions.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.storageactions.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.storageactions.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
