% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ihw_convex.R
\name{ihw.DESeqResults}
\alias{ihw.DESeqResults}
\title{ihw.DESeqResults: IHW method dispatching on DESeqResults objects}
\usage{
\method{ihw}{DESeqResults}(deseq_res, filter = "baseMean", alpha = 0.1, adjustment_type = "BH", ...)
}
\arguments{
\item{deseq_res}{"DESeqResults" object}

\item{filter}{Vector of length equal to number of rows of deseq_res object. This is used
for the covariates in the call to ihw. Can also be a character,
in which case deseq_res[[filter]] is used as the covariate}

\item{alpha}{Numeric, sets the nominal level for FDR control.}

\item{adjustment_type}{Character ("BH" or "bonferroni") depending on whether you want to control FDR or FWER.}

\item{...}{Other optional keyword arguments passed to ihw.}
}
\value{
A "DESeqResults" object, which includes weights and adjusted p-values returned
        	by IHW. In addition, includes a metadata slot with an "ihwResult" object.
}
\description{
ihw.DESeqResults: IHW method dispatching on DESeqResults objects
}
\examples{
\dontrun{
   library("DESeq2")
   library("airway")
   data("airway")
   dds <- DESeqDataSet(se = airway, design = ~ cell + dex)
   dds <- DESeq(dds)
   deseq_res <- results(dds)
   deseq_res <- ihw(deseq_res, alpha=0.1)
   #equivalent: deseq_res2 <- results(dds, filterFun = ihw)
}

}
\seealso{
ihw, ihwResult
}
