% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/375-extractDrugMACCS.R
\name{extractDrugMACCSComplete}
\alias{extractDrugMACCSComplete}
\title{Calculate the MACCS Molecular Fingerprints (in Complete Format)}
\usage{
extractDrugMACCSComplete(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule,
the columns represent the fingerprints.
}
\description{
Calculate the MACCS Molecular Fingerprints (in Complete Format)
}
\details{
The popular 166 bit MACCS keys described by MDL.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
fp  = extractDrugMACCSComplete(mol)
dim(fp)}
}
\seealso{
\link{extractDrugMACCS}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{extractDrugMACCSComplete}
