% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{TCGAanalyze_EA}
\alias{TCGAanalyze_EA}
\title{Enrichment analysis of a gene-set with GO [BP,MF,CC]  and pathways.}
\usage{
TCGAanalyze_EA(
  GeneName,
  RegulonList,
  TableEnrichment,
  EAGenes,
  GOtype,
  FDRThresh = 0.01,
  GeneSymbolsTable = FALSE
)
}
\arguments{
\item{GeneName}{is the name of gene signatures list}

\item{RegulonList}{is a gene signature (lisf of genes) in which perform EA.}

\item{TableEnrichment}{is a table related to annotations of gene symbols such as
GO[BP,MF,CC] and Pathways. It was created from DAVID gene ontology on-line.}

\item{EAGenes}{is a table with informations about genes
such as ID, Gene, Description, Location and Family.}

\item{GOtype}{is type of gene ontology Biological process (BP), Molecular Function (MF),
Cellular componet (CC)}

\item{FDRThresh}{pvalue corrected (FDR) as threshold to selected significant
BP, MF,CC, or pathways. (default FDR < 0.01)}

\item{GeneSymbolsTable}{if it is TRUE will return a table with GeneSymbols in common GO or pathways.}
}
\value{
Table with enriched GO or pathways by selected gene signature.
}
\description{
The rational behind a enrichment analysis ( gene-set, pathway etc) is to compute
statistics of whether the overlap between the focus list (signature) and the gene-set
is significant. ie the confidence that overlap between the list is not due to chance.
 The Gene Ontology project describes genes (gene products) using terms from
 three structured vocabularies: biological process, cellular component and molecular function.
 The Gene Ontology Enrichment component, also referred to as the GO Terms" component, allows
 the genes in any such "changed-gene" list to be characterized using the Gene Ontology terms
 annotated to them. It asks, whether for any particular GO term, the fraction of genes
 assigned to it in the "changed-gene" list is higher than expected by chance
 (is over-represented), relative to the fraction of genes assigned to that term in the
 reference set.
 In statistical terms it perform the analysis tests the null hypothesis that,
 for any particular ontology term, there is no difference in the proportion of genes
 annotated to it in the reference list and the proportion annotated to it in the test list.
 We adopted a Fisher Exact Test to perform the EA.
}
\examples{
\dontrun{
EAGenes <- get("EAGenes")
RegulonList <- rownames(dataDEGsFiltLevel)
ResBP <- TCGAanalyze_EA(
  GeneName="DEA genes Normal Vs Tumor",
  RegulonList = RegulonList,
  TableEnrichment = DAVID_BP_matrix,
   EAGenes = EAGenes,
   GOtype = "DavidBP"
 )
}
}
