% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robu.R
\name{vcovCR.robu}
\alias{vcovCR.robu}
\title{Cluster-robust variance-covariance matrix for a robu object.}
\usage{
\method{vcovCR}{robu}(obj, cluster, type, target, inverse_var, form = "sandwich", ...)
}
\arguments{
\item{obj}{Fitted model for which to calculate the variance-covariance matrix}

\item{cluster}{Optional expression or vector indicating which observations 
belong to the same cluster. If not specified, will be set to the
\code{studynum} used in fitting the \code{\link[robumeta]{robu}} object.}

\item{type}{Character string specifying which small-sample adjustment should 
be used, with available options \code{"CR0"}, \code{"CR1"}, \code{"CR1p"},
\code{"CR1S"}, \code{"CR2"}, or \code{"CR3"}. See "Details" section of 
\code{\link{vcovCR}} for further information.}

\item{target}{Optional matrix or vector describing the working 
variance-covariance model used to calculate the \code{CR2} and \code{CR4} 
adjustment matrices. If not specified, the target is taken to be the 
inverse of the estimated weights used in fitting the
\code{\link[robumeta]{robu}} object.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread. \code{form = "estfun"} will return the 
(appropriately scaled) estimating function, the transposed crossproduct of 
which is equal to the sandwich variance-covariance matrix.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists 
  of a matrix of the estimated variance of and covariances between the 
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates from a
\code{\link[robumeta]{robu}} object.
}
\examples{
library(robumeta)
data(hierdat)

robu_fit <- robu(effectsize ~ binge + followup + sreport + age, 
                 data = hierdat, studynum = studyid, 
                 var.eff.size = var, modelweights = "HIER")
robu_fit

robu_CR2 <- vcovCR(robu_fit, type = "CR2")
robu_CR2
coef_test(robu_fit, vcov = robu_CR2, test = c("Satterthwaite", "saddlepoint"))

Wald_test(robu_fit, constraints = constrain_zero(c(2,4)), vcov = robu_CR2)
Wald_test(robu_fit, constraints = constrain_zero(2:5), vcov = robu_CR2)

}
\seealso{
\code{\link{vcovCR}}
}
