% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{emst_mlpack}
\alias{emst_mlpack}
\title{Euclidean Minimum Spanning Tree}
\usage{
emst_mlpack(X, leaf_size = 1, naive = FALSE, verbose = FALSE)
}
\arguments{
\item{X}{a numeric matrix (or an object coercible to one,
e.g., a data frame with numeric-like columns)}

\item{leaf_size}{size of leaves in the kd-tree,
controls the trade-off between speed and memory consumption}

\item{naive}{logical; whether to use the naive, quadratic-time algorithm}

\item{verbose}{logical; whether to print diagnostic messages}
}
\value{
An object of class \code{mst}, see \code{\link{mst}()} for details.
}
\description{
Provides access to the implementation of the Dual-Tree Boruvka
algorithm from the \code{mlpack} package (if available).
It is based on kd-trees and is fast for (very) low-dimensional
Euclidean spaces. For higher dimensional spaces (say, over 5 features)
or other metrics, use the parallelised Prim-like algorithm implemented
in \code{\link{mst}()}.
}
\references{
March W.B., Ram P., Gray A.G.,
Fast Euclidean Minimum Spanning Tree: Algorithm, Analysis, and Applications,
\emph{Proc. ACM SIGKDD'10}, 2010, 603-611,
\url{https://mlpack.org/papers/emst.pdf}.

Curtin R.R., Edel M., Lozhnikov M., Mentekidis Y., Ghaisas S., Zhang S.,
mlpack 3: A fast, flexible machine learning library,
\emph{Journal of Open Source Software} 3(26), 2018, 726.
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
\seealso{
The official online manual of \pkg{genieclust} at \url{https://genieclust.gagolewski.com/}

Gagolewski M., \pkg{genieclust}: Fast and robust hierarchical clustering, \emph{SoftwareX} 15:100722, 2021, \doi{10.1016/j.softx.2021.100722}.

}
