% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step4_bayesModelAver.R
\name{bayes.model.aver}
\alias{bayes.model.aver}
\alias{bayes.model.aver.explicit}
\title{Bayesian Model Averaging}
\usage{
bayes.model.aver(step2, step3, taxon.name.map = NULL,
  poster.prob.thr = 0.9, burnin = 0.4)

bayes.model.aver.explicit(result, pij.sparse.mat, read.weights, outDir,
  gen.prob.unknown, taxon.name.map = NULL, poster.prob.thr = 0.9,
  burnin = 0.4)
}
\arguments{
\item{step2}{list. The output from reduce.space(), i.e the second step of the pipeline.  Alternatively, it can be a character string containing the path name of the ".RData" file  where step2 list was saved.}

\item{step3}{list. The output from parallel.temper(), i.e the third step of the pipeline.  Alternatively, it can be a character string containing the path name of the ".RData" file  where step3 list was saved.}

\item{taxon.name.map}{The 'names.dmp' taxonomy names file, mapping each taxon identifier to the corresponding scientific name. It can be downloaded from  \url{ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz}}

\item{poster.prob.thr}{Posterior probability of presence of species threshold for reporting in the species summary.}

\item{burnin}{Percentage of burn in iterations, default value is 0.4}

\item{result}{The list produced by parallel.temper()  (or paraller.temper.nucl()) . It holds a detailed record for each chain, what moves were proposed, which were accepted and which were rejected as well the log-likelihood through the iterations.}

\item{pij.sparse.mat}{see ?reduce.space}

\item{read.weights}{see ?reduce.space}

\item{outDir}{see ?reduce.space}

\item{gen.prob.unknown}{see ?reduce.space}
}
\description{
Perform Bayesian Model Averaging.  We concentrate on the chain with temperature=1 , i.e the untempered posterior,  to study the distribution over the model choices and perform model averaging.  We consider as present the species that have a posterior probability greater than 0.9. We then fit the mixture model with these species in order to obtain relative abundances and read classification probabilities. A tab seperated file that has a species summary is produced, as well as log-likelihood traceplots and cumulative histogram plots.

bayes.model.aver.explicit is the same function as bayes.model.aver with a more involved syntax.
}
\examples{
## See vignette for more details

\dontrun{
# Either load the object created by previous steps
data(step2)   ## example output of step2, i.e reduce.space()
data(step3)   ## example ouput of step3, i.e  parallel.temper()
step4<-bayes.model.aver(step2=step2, step3=step3, taxon.name.map="pathtoFile/taxon.file")

# or alternatively point to the location of the step2.RData and step3.RData objects
step4<-bayes.model.aver(step2="pathtoFile/step2.RData", step3="pathtoFile/step3.RData",
                        taxon.name.map="pathtoFile/taxon.file")

}                                                      
}
\keyword{bayes.model.aver}
\keyword{bayes.model.aver.explicit}
