% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePartialDependence.R
\name{plotPartialDependence}
\alias{plotPartialDependence}
\title{Plot a partial dependence with ggplot2.}
\usage{
plotPartialDependence(
  obj,
  geom = "line",
  facet = NULL,
  facet.wrap.nrow = NULL,
  facet.wrap.ncol = NULL,
  p = 1,
  data = NULL
)
}
\arguments{
\item{obj}{\link{PartialDependenceData}\cr
Generated by \link{generatePartialDependenceData}.}

\item{geom}{(\code{charater(1)})\cr
The type of geom to use to display the data. Can be \dQuote{line} or \dQuote{tile}.
For tiling at least two features must be used with \code{interaction = TRUE} in the call to
\link{generatePartialDependenceData}. This may be used in conjuction with the
\code{facet} argument if three features are specified in the call to
\link{generatePartialDependenceData}.
Default is \dQuote{line}.}

\item{facet}{(\code{character(1)})\cr
The name of a feature to be used for facetting.
This feature must have been an element of the \code{features} argument to
\link{generatePartialDependenceData} and is only applicable when said argument had length
greater than 1.
The feature must be a factor or an integer.
If \link{generatePartialDependenceData} is called with the \code{interaction} argument \code{FALSE}
(the default) with argument \code{features} of length greater than one, then \code{facet} is ignored and
each feature is plotted in its own facet.
Default is \code{NULL}.}

\item{facet.wrap.nrow, facet.wrap.ncol}{(\link{integer})\cr
Number of rows and columns for facetting. Default for both is \code{NULL}.
In this case ggplot's \code{facet_wrap} will choose the layout itself.}

\item{p}{(\code{numeric(1)})\cr
If \code{individual = TRUE} then \code{sample} allows the user to sample without replacement
from the output to make the display more readable. Each row is sampled with probability \code{p}.
Default is \code{1}.}

\item{data}{(\link{data.frame})\cr
Data points to plot. Usually the training data. For survival and binary classification tasks a rug plot
wherein ticks represent failures or instances of the positive class are shown. For regression tasks
points are shown. For multiclass classification tasks ticks are shown and colored according to their class.
Both the features and the target must be included.
Default is \code{NULL}.}
}
\value{
ggplot2 plot object.
}
\description{
Plot a partial dependence from \link{generatePartialDependenceData} using ggplot2.
}
\seealso{
Other partial_dependence: 
\code{\link{generatePartialDependenceData}()}

Other plot: 
\code{\link{createSpatialResamplingPlots}()},
\code{\link{plotBMRBoxplots}()},
\code{\link{plotBMRRanksAsBarChart}()},
\code{\link{plotBMRSummary}()},
\code{\link{plotCalibration}()},
\code{\link{plotCritDifferences}()},
\code{\link{plotLearningCurve}()},
\code{\link{plotROCCurves}()},
\code{\link{plotResiduals}()},
\code{\link{plotThreshVsPerf}()}
}
\concept{partial_dependence}
\concept{plot}
