% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-partial.R
\name{partial}
\alias{partial}
\title{Partially apply a function, filling in some arguments}
\usage{
partial(
  .f,
  ...,
  .env = deprecated(),
  .lazy = deprecated(),
  .first = deprecated()
)
}
\arguments{
\item{.f}{a function. For the output source to read well, this should be a
named function.}

\item{...}{named arguments to \code{.f} that should be partially applied.

Pass an empty \verb{... = } argument to specify the position of future
arguments relative to partialised ones. See
\code{\link[rlang:call_modify]{rlang::call_modify()}} to learn more about this syntax.

These dots support quasiquotation. If you unquote a value, it is
evaluated only once at function creation time.  Otherwise, it is
evaluated each time the function is called.}

\item{.env}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The environments are
now captured via quosures.}

\item{.lazy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please unquote the
arguments that should be evaluated once at function creation time
with \verb{!!}.}

\item{.first}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please pass an
empty argument \verb{... = } to specify the position of future
arguments.}
}
\value{
A function that takes the same arguments as \code{.f}, but returns
a different value, as described above.
}
\description{
Partial function application allows you to modify a function by pre-filling
some of the arguments. It is particularly useful in conjunction with
functionals and other function operators.
}
\details{
\code{partial()} creates a function that takes \code{...} arguments. Unlike
\code{\link[=compose]{compose()}} and other function operators like \code{\link[=negate]{negate()}}, it
doesn't reuse the function signature of \code{.f}. This is because
\code{partial()} explicitly supports NSE functions that use
\code{substitute()} on their arguments. The only way to support those is
to forward arguments through dots.

Other unsupported patterns:
\itemize{
\item It is not possible to call \code{partial()} repeatedly on the same
argument to pre-fill it with a different expression.
\item It is not possible to refer to other arguments in pre-filled
argument.
}
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
# Partial is designed to replace the use of anonymous functions for
# filling in function arguments. Instead of:
compact1 <- function(x) discard(x, is.null)

# we can write:
compact2 <- partial(discard, .p = is.null)

# partial() works fine with functions that do non-standard
# evaluation
my_long_variable <- 1:10
plot2 <- partial(plot, my_long_variable)
plot2()
plot2(runif(10), type = "l")

# Note that you currently can't partialise arguments multiple times:
my_mean <- partial(mean, na.rm = TRUE)
my_mean <- partial(my_mean, na.rm = FALSE)
try(my_mean(1:10))


# The evaluation of arguments normally occurs "lazily". Concretely,
# this means that arguments are repeatedly evaluated across invocations:
f <- partial(runif, n = rpois(1, 5))
f
f()
f()

# You can unquote an argument to fix it to a particular value.
# Unquoted arguments are evaluated only once when the function is created:
f <- partial(runif, n = !!rpois(1, 5))
f
f()
f()


# By default, partialised arguments are passed before new ones:
my_list <- partial(list, 1, 2)
my_list("foo")

# Control the position of these arguments by passing an empty
# `... = ` argument:
my_list <- partial(list, 1, ... = , 2)
my_list("foo")
}
\seealso{
Other adverbs: 
\code{\link{auto_browse}()},
\code{\link{compose}()},
\code{\link{insistently}()},
\code{\link{negate}()},
\code{\link{possibly}()},
\code{\link{quietly}()},
\code{\link{safely}()},
\code{\link{slowly}()}
}
\concept{adverbs}
