% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_to_colnames.R
\name{label_to_colnames}
\alias{label_to_colnames}
\title{Use variable labels as column names}
\usage{
label_to_colnames(x)
}
\arguments{
\item{x}{A data frame.}
}
\value{
\code{x} with variable labels as column names. For variables without
  variable labels, the column name is left unchanged.
}
\description{
This function sets variable labels as column names, to use "labelled
  data" also for those functions that cannot cope with labelled data by default.
}
\examples{
data(iris)

iris <- var_labels(
  iris,
  Petal.Length = "Petal length (cm)",
  Petal.Width = "Petal width (cm)"
)

colnames(iris)
plot(iris)

colnames(label_to_colnames(iris))
plot(label_to_colnames(iris))
}
