use strict;
use warnings;

use RT::Test tests => undef;

my ($base, $m) = RT::Test->started_ok;

my $link = RT::Test->load_or_create_custom_field(
    Name            => 'link',
    Type            => 'Freeform',
    MaxValues       => 1,
    Queue           => 0,
    LinkValueTo     => '__CustomField__',
);

my $include = RT::Test->load_or_create_custom_field(
    Name                    => 'include',
    Type                    => 'Freeform',
    MaxValues               => 1,
    Queue                   => 0,
    IncludeContentForValue  => '__CustomField__',
);

my $data_uri = 'data:text/html;base64,PHNjcmlwdD5hbGVydChkb2N1bWVudC5jb29raWUpPC9zY3JpcHQ+';
my $xss      = q{')-eval(decodeURI('alert("xss")'))-('};

my $ticket = RT::Ticket->new(RT->SystemUser);
$ticket->Create(
    Queue                       => 'General',
    Subject                     => 'ticket A',
    'CustomField-'.$link->id    => $data_uri,
    'CustomField-'.$include->id => $xss,
);
ok $ticket->Id, 'created ticket';

ok $m->login('root', 'password'), "logged in";
$m->get_ok($base . "/Ticket/Display.html?id=" . $ticket->id);

# look for lack of link to data:text/html;base64,...
ok !$m->find_link(text => $data_uri), "no data: link";
ok !$m->find_link(url  => $data_uri), "no data: link";

# look for unescaped JS
$m->content_lacks($xss, 'escaped js');

$m->warning_like(qr/Potentially dangerous URL type/, "found warning about dangerous link");
undef $m;
done_testing;
