% This LilyPond file was generated by Rosegarden 23.06
\include "nederlands.ly"
\version "2.12.0"
\header {
    arranger = "D. Michael McIntyre"
    composer = "Handel"
    copyright = "Public Domain"
    dedication = "Thanks to the Mutopia Project"
    meter = "Allegro"
    opus = "HWV 56"
    title = "Halleluja Chorus from Messiah"
    tagline = "Created using Rosegarden 23.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 4/4
    \skip 1*94 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 120  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()
        \context StaffGroup = "1" <<

            \context Staff = "track 2, Oboi" << 
                \set Staff.instrumentName = \markup { \center-column { "Oboi " } }
                \set Staff.shortInstrumentName = "Ob."
                \set Staff.midiInstrument = "Oboe"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 1.0" {
                    % Segment: oboe
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble"
                    \key d \major
                    R1*3  |
                    d'' 4. -\f a' 8 [ b' ] a' r4  |
%% 5
                    d'' 4. a' 8 [ b' ] a' r d'' 16 [ d'' ]  |
                    d'' 8 [ d'' ] r d'' 16 [ d'' ] d'' 8 [ d'' ] r d''  |
                    cis'' 8 d'' 4 cis'' 8 d'' 4 r  |
                    e'' 4. a' 8 [ fis'' ] e'' r4  |
                    e'' 4. a' 8 [ fis'' ] e'' r e'' 16 [ e'' ]  |
%% 10
                    fis'' 8 [ e'' ] r e'' 16 [ e'' ] fis'' 8 [ e'' ] r e''  |
                    fis'' 8 [ e'' ] d'' 4 cis'' r  |
                    a' 2 b' 4 cis''  |
                    d'' 8 [ d' ] d'' 4. d'' 8 cis'' 4  |
                    b' 2 a' 4 r8 e'' 16 [ e'' ]  |
%% 15
                    d'' 8 [ cis'' ] r e'' 16 [ e'' ] d'' 8 [ cis'' ] r e'' 16 [ e'' ]  |
                    fis'' 8 [ e'' ] r e'' 16 [ e'' ] fis'' 8 [ e'' ] r4  |
                    R1*2  |
                    r2 r4 r8 d'' 16 [ d'' ]  |
%% 20
                    d'' 8 [ d'' ] r d'' 16 [ d'' ] d'' 8 [ d'' ] r d'' 16 [ d'' ]  |
                    d'' 8 [ d'' ] r d'' 16 [ d'' ] d'' 8 [ d'' ] r4  |
                    d'' 2 e'' 4 fis''  |
                    g'' 8 [ g' ] g'' 4. g'' 8 fis'' 4  |
                    e'' 2 d'' 4 r8 d'' 16 [ d'' ]  |
%% 25
                    cis'' 8 [ a' ] r cis'' 16 [ cis'' ] d'' 8 [ d'' 16 d'' ] e'' 8 [ e'' ]  |
                    a' 4 r8 d'' 16 [ cis'' ] b' 8 [ b' ] r e''  |
                    d'' 8 [ cis'' d'' e'' 16 d'' ] cis'' 8 [ cis'' 16 cis'' ] e'' 8 [ cis'' ]  |
                    r8 a' 16 [ a' ] d'' 8 [ a' ] r cis'' 16 [ cis'' ] e'' 8 [ cis'' ]  |
                    r8 a' 16 [ a' ] fis'' 8 [ d'' ] r cis'' 16 [ cis'' ] d'' 8 [ a' ]  |
%% 30
                    r8 b' 16 [ b' ] e'' 8 [ e'' ] r cis'' 16 [ cis'' ] d'' 8 [ d'' ]  |
                    d'' 4 cis'' d'' d''  |
                    d'' 4 d'' d'' 2  |
                    r2 r4 a'  |
                    a' 4 g' fis' e' 8. [ d' 16 ]  |
%% 35
                    d' 1  |
                    r2 fis' 4 e' 8. [ d' 16 ]  |
                    d' 2. fis'' 4  |
                    e'' 4 d'' d'' cis''  |
                    d'' 4. cis'' 8 d'' 4 d''  |
%% 40
                    cis'' 4. a' 8 b' 4 cis''  |
                    d'' 2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 45
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r4 d''  |
                    a'' 4 cis'' fis'' a'  |
%% 50
                    d'' 4 cis'' 8 [ b' ] cis'' 4 b' 8. [ a' 16 ]  |
                    a' 2 a' 4 a'  |
                    a' 1 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    r4 a' a' a'  |
%% 55
                    a' 1 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    r2 d'' 4 d''  |
                    d'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
                    \skip 1  |
%% 60
                    r4 d'' e'' e''  |
                    e'' 1 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    e'' 2 fis'' 4 fis''  |
                    fis'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
%% 65
                    \skip 1  |
                    r4 r8 fis'' g'' 4 g''  |
                    g'' 1 -\tenuto  |
                    r4 r8 g'' [ fis'' e'' ] fis'' [ g'' ]  |
                    e'' 2 r8 cis'' [ d'' e'' ]  |
%% 70
                    a' 4 r r2  |
                    r2 r4 a'  |
                    d'' 4 fis' b' d''  |
                    g'' 4 fis'' 8 [ e'' ] fis'' 4 e'' 8. [ d'' 16 ]  |
                    d'' 2 r  |
%% 75
                    r4 r8 d'' [ g'' fis'' ] r d''  |
                    g'' 8 [ fis'' ] r4 r2  |
                    r4 r8 d'' 16 [ d'' ] g'' 8 [ fis'' ] r d'' 16 [ d'' ]  |
                    g'' 8 [ fis'' ] r a' a' 4 d''  |
                    fis'' 4 d'' d'' a' 8 [ a' ]  |
%% 80
                    cis'' 4 d'' 8 [ d'' ] d'' 4 cis''  |
                    d'' 4 r a' a'  |
                    d'' 4 r8 a' a' 4 a'  |
                    d'' 4 r a' a'  |
                    d'' 4 r8 a' a' 4 a'  |
%% 85
                    d'' 4 r r a'  |
                    d'' 4 fis'' b' d''  |
                    g'' 4 fis'' 8 [ e'' ] e'' 2  |
                    d'' 4 r d'' d''  |
                    d'' 4 r8 d'' d'' 4 d''  |
%% 90
                    d'' 4 r8 d'' 16 [ d'' ] d'' 8 [ d'' ] r d'' 16 [ d'' ]  |
                    d'' 8 [ d'' ] r d'' 16 [ d'' ] d'' 8 [ d'' ] r d'' 16 [ d'' ]  |
                    d'' 8 [ d'' ] r4 r d''  |
                    d'' 2. d'' 4  |
                    d'' 1  |
                    \bar "|."
                } % Voice

                % End of segment oboe

                % End voice 0
            >> % Staff ends

            \context Staff = "track 3, Fagotti" << 
                \set Staff.instrumentName = \markup { \center-column { "Fagotti " } }
                \set Staff.shortInstrumentName = "Fag."
                \set Staff.midiInstrument = "Bassoon"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 2.0" {
                    % Segment: bassoon
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "bass"
                    \key d \major
                    d 8 -\f [ e fis d ] g [ d fis a ]  |
                    d 8 [ e fis d ] e [ d ] r fis  |
                    e 8 [ d a a, ] d 4 r  |
                    d 8 [ d e fis ] g [ d ] r4  |
%% 5
                    d 8 [ d e fis ] g [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis  |
                    e 8 [ d a a, ] d [ fis e d ]  |
                    a 4. cis' 8 [ d' ] a r4  |
                    a 4. cis' 8 [ d' ] a r cis' 16 [ cis' ]  |
%% 10
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis'  |
                    d' 8 [ cis' ] b 4 a r  |
                    a 2 b 4 cis'  |
                    d' 8 [ d ] d' 2 cis' 4  |
                    b 2 a 4 r8 cis' 16 [ cis' ]  |
%% 15
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis' 16 [ cis' ]  |
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r4  |
                    d 2 e 4 fis  |
                    g 8 [ g, ] g 2 fis 4  |
                    e 2 d 4 r8 fis 16 [ fis ]  |
%% 20
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ fis ] r fis 16 [ fis ] g 8 [ d ] r4  |
                    R1*2  |
                    r4 r8 a 16 [ a ] fis 8 [ d d' d ]  |
%% 25
                    a 2 b 4 cis'  |
                    d' 8 [ d ] d' 2 cis' 4  |
                    b 2 a 4 r8 a 16 [ a ]  |
                    fis 8 [ d ] r d' 16 [ d' ] cis' 8 [ a cis' a ]  |
                    d' 4. d' 16 [ d' ] cis' 8 [ a ] r d' 16 [ d' ]  |
%% 30
                    b 8 [ g ] r e 16 [ e ] a 8 [ a ] r b 16 [ b ]  |
                    g 8 [ e ] a 8. [ g 16 ] fis 4 r8 d' 16 [ d' ]  |
                    b 8 [ g b cis' ] d' [ d 16 d ] d 8 [ d ]  |
                    b, 8 [ b, 16 b, ] g, 8 [ g, ] d 4 d  |
                    cis 4 b, a, g  |
%% 35
                    fis 2. d 4  |
                    cis 4 b, a, 4. a, 8  |
                    d 2. d' 4  |
                    cis' 4 b a g  |
                    fis 4. e 8 d 4 b  |
%% 40
                    a 4. fis 8 g 4 e  |
                    d 4. a 8 d' 4 fis  |
                    b 4 d g fis 8 [ e ]  |
                    e 2 d 4 r  |
                    r4 r8 a [ d' d ] r fis  |
%% 45
                    b 8 [ gis ] a 4 r8 e [ d e ]  |
                    cis 8 [ a g a ] fis 4 r8 fis  |
                    g 8 [ d ] r b [ e' cis' ] d' [ g ]  |
                    a 8 [ a, ] r a [ fis d ] r d'  |
                    cis' 8 [ a ] r cis' [ d' d ] r fis  |
%% 50
                    b 8 [ gis a d ] e [ e, ] r e  |
                    cis 4 a, r2  |
                    r4 r8 cis' [ d' a ] r cis'  |
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis' 16 [ cis' ]  |
                    d' 8 [ a ] r4 r2  |
%% 55
                    r4 r8 cis' [ d' a ] r cis'  |
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis' 16 [ cis' ]  |
                    d' 8 [ a ] r4 r2  |
                    r4 r8 fis [ g d ] r fis  |
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
%% 60
                    g 8 [ d ] r4 r2  |
                    r4 r8 gis [ a e ] r gis  |
                    a 8 [ e ] r gis 16 [ gis ] a 8 [ e ] r gis 16 [ gis ]  |
                    a 8 [ e ] r4 r2  |
                    r4 r8 bes [ b fis ] r bes  |
%% 65
                    b 8 [ fis ] r bes 16 [ bes ] b 8 [ fis ] r bes 16 [ bes ]  |
                    b 4 b, r2  |
                    r2 b 4 b  |
                    cis' 4. cis' 8 d' 4 d  |
                    a 4. a, 8 a 4 cis  |
%% 70
                    fis 4 a, d cis  |
                    b, 2 a, 4 r  |
                    r2 r8 d, [ g, fis, ]  |
                    e, 4 fis, 8 [ g ] a 4 g 8 [ a ]  |
                    fis 4 d r2  |
%% 75
                    r4 r8 fis [ g d ] r fis  |
                    g 8 [ d ] r4 r2  |
                    r4 r8 fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r d d' 4 fis  |
                    b 4 d g fis 8 [ fis ]  |
%% 80
                    e 4 d 8 [ d ] a 2  |
                    d 4 r d d  |
                    d' 4 r8 d d 4 d  |
                    d' 4 r d d  |
                    d' 4 r8 d d 4 d  |
%% 85
                    d' 4 r8 d d' 4 fis  |
                    b 4 d g fis 8 [ fis ]  |
                    e 4 d 8 [ d ] a 2  |
                    d 4 r8 fis [ g d ] r fis  |
                    g 8 [ d ] r fis [ g d ] r fis  |
%% 90
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r4 r d  |
                    g, 2. g, 4  |
                    d, 1  |
                    \bar "|."
                } % Voice

                % End of segment bassoon

                % End voice 0
            >> % Staff ends

            \context Staff = "track 5, Trombe in B" << 
                \set Staff.instrumentName = \markup { \center-column { "Trombe in B " \line { "in B" \smaller \flat } } }
                \set Staff.shortInstrumentName = "Tpt."
                \set Staff.midiInstrument = "Trumpet"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 4.0" {
                    % Segment: trumpet I
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble"
                    \key e \major
                    R1*13  |
                    r2 r4 r8 < b' fis'' > 16 [ < b' fis'' > ]  |
%% 15
                    < b' gis'' > 8 [ < b' fis'' > ] r < b' fis'' > 16 [ < b' fis'' > ] < b' gis'' > 8 [ < b' fis'' > ] r < fis'' b'' > 16 [ < fis'' b'' > ]  |
                    < gis'' b'' > 8 [ < fis'' b'' > 16 < fis'' b'' > ] < fis'' b'' > 8 [ < b' fis'' > 16 < b' fis'' > ] < b' gis'' > 8 [ < b' fis'' > ] r4  |
                    R1*2  |
                    r2 r4 r8 < e'' b'' > 16 [ < e'' b'' > ]  |
%% 20
                    < a'' cis''' > 8 [ < gis'' b'' > ] r < e'' b'' > 16 [ < e'' b'' > ] < a'' cis''' > 8 [ < gis'' b'' > ] r < gis' e'' > 16 [ < gis' e'' > ]  |
                    < a'' e' > 8 [ < gis'' e' > 16 < gis'' e' > ] < b' gis'' > 8 [ < gis' e'' > 16 < gis' e'' > ] < e' e'' > 8 [ < gis' b' > 16 < gis' b' > ] < gis' b' > 8 [ < gis' b' > 16 < gis' b' > ]  |
                    < e' gis' > 4 r r2  |
                    r2 r  |
                    r2 r  |
%% 25
                    r8 < b' fis'' > 16 [ < b' fis'' > ] < b' fis'' > 8 [ b' 16 -\tenuto ] r < gis' e'' > 8 [ < a'' e' > 16 < gis'' e' > ] < b' fis'' > 8 [ < b' b'' > 16 < b' a'' > ]  |
                    < b' gis'' > 4 r8 < e'' gis'' > fis'' 4 -\tenuto r8 fis''  |
                    e'' 8 [ < b' b'' > e'' fis'' 16 e'' ] fis'' 4 r8 < fis'' b'' > 16 [ < fis'' b'' > ]  |
                    < e'' b'' > 8 [ < b' gis'' > ] r < gis' gis'' > 16 [ < gis' gis'' > ] < b' fis'' > 8 [ < b' fis'' > ] r4  |
                    e'' 2 fis'' 4 gis''  |
%% 30
                    a'' 4 a'' 2 gis'' 4  |
                    fis'' 2 e'' 
                    % warning: overlong bar truncated here |
                    \skip 2 r8 < b' gis'' > 16 [ < b' gis'' > ] < b' gis'' > 8 [ < b' gis'' > ]  |
                    < e'' a'' > 8 [ < e' e'' > 16 < e' e'' > ] < e' e'' > 8 [ < e' e'' > ] < gis' b' > 4 r  |
                    R1*3  |
                    r2 r4 < gis'' b'' >  |
                    < fis'' b'' > 4 < e'' a'' > < e'' gis'' > b' 8. -\tenuto r16  |
                    < b' e'' > 4. < b' fis'' > 8 < b' gis'' > 4 < e'' ais'' >  |
%% 40
                    < fis'' b'' > 4. < gis'' b'' > 8 e'' 4 < fis'' a'' >  |
                    < b' gis'' > 2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 45
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 50
                    r2 r  |
                    r2 r  |
                    r4 r8 < b' fis'' > [ < b' gis'' > < b' fis'' > ] r < b' fis'' >  |
                    < b' gis'' > 8 [ < b' fis'' > ] r < b' fis'' > 16 [ < b' fis'' > ] < b' gis'' > 8 [ < b' fis'' > ] r < b' fis'' > 16 [ < b' fis'' > ]  |
                    < b' gis'' > 8 [ < b' fis'' > ] r4 r2  |
%% 55
                    r4 r8 fis'' gis'' [ fis'' ] r fis''  |
                    gis'' 8 [ fis'' ] r fis'' 16 [ fis'' ] gis'' 8 [ fis'' ] r fis'' 16 [ fis'' ]  |
                    gis'' 8 [ fis'' ] r16 a'' [ gis'' fis'' ] e'' 4 e''  |
                    e'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
                    \skip 1  |
%% 60
                    r4 e'' fis'' fis''  |
                    fis'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    r2 gis'' 4 gis''  |
                    gis'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
%% 65
                    \skip 1  |
                    r4 r8 gis'' a'' 4 a''  |
                    r2 e'' 4 e''  |
                    fis'' 4. < fis'' a'' > 8 [ < e'' gis'' > b' b' ] b'  |
                    < b' fis'' > 2 r  |
%% 70
                    r2 r  |
                    R1  |
                    r2 r  |
                    r2 r  |
                    r2 e' 4 e'  |
%% 75
                    e' 1 -\tenuto  |
                    r4 r8 e' e' 4 e'  |
                    e' 1 -\tenuto  |
                    r8 e' 16 [ e' ] < e' gis' > 8 [ < e' b' > ] < gis' e'' > 4 < e'' b'' >  |
                    < gis'' e''' > 4 < e'' gis'' > < e'' cis''' > e''  |
%% 80
                    < fis'' a'' > 4 < e'' gis'' > 8 [ fis'' fis'' -\tenuto ] r16 r r8 < b' e'' >  |
                    < gis' e'' > 4 r < e'' gis'' > < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
                    < gis'' b'' > 4 r8 < gis'' b'' > < e'' gis'' > 4 < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
                    < gis'' b'' > 4 r < e'' gis'' > < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
                    < gis'' b'' > 4 r8 < gis'' b'' > < e'' gis'' > 4 < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
%% 85
                    < gis'' b'' > 4 r r < gis' b' >  |
                    < e'' gis' > 8 ^( [ e' < gis'' b' > gis' ) ] < e'' cis''' > 4 < b' e'' >  |
                    < fis'' a'' > 4 < e'' gis'' > 8 [ < b' fis'' > < fis'' b' > -\tenuto b' 16 b' ] b' 8 [ < b' e'' > ]  |
                    < e'' gis' > 8 -\tenuto [ e' 16 e' ] gis' 8 [ < b' gis' > 16 -\tenuto b' ] < e'' e' > 8 _( [ e' e'' b' ) ]  |
                    < e' e'' > 8 [ < e'' gis'' > < gis'' b'' > < e'' gis'' > ] < e' e'' > 4 < e' e'' >  |
%% 90
                    < e' e'' > 8 [ < e'' gis'' > < gis'' b'' > < e'' gis'' > ] < e' e'' > 4 < e' e'' >  |
                    < e' e'' > 8 [ < e'' gis'' > 16 < fis'' a'' > ] < gis'' b'' > 8 [ < e'' gis'' > < e' e'' > < e'' gis'' > 16 < fis'' a'' > ] < gis'' b'' > 8 [ < e'' gis'' > 16 < e'' gis'' > ]  |
                    < e' e'' > 8 [ < gis' e'' > ] r4 r < b' gis'' >  |
                    < e' e'' > 2. < e' e'' > 4  |
                    < gis' e'' > 1  |
                    \bar "|."
                } % Voice

                % End of segment trumpet I

                % End voice 0

                \context Voice = "voice 4.1" {
                    % Segment: trumpet II
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble"
                    \key e \major
                    R1*13  |
                    r2 r4 r8 < b' fis'' > 16 [ < b' fis'' > ]  |
%% 15
                    < b' gis'' > 8 [ < b' fis'' > ] r < b' fis'' > 16 [ < b' fis'' > ] < b' gis'' > 8 [ < b' fis'' > ] r < fis'' b'' > 16 [ < fis'' b'' > ]  |
                    < gis'' b'' > 8 [ < fis'' b'' > 16 < fis'' b'' > ] < fis'' b'' > 8 [ < b' fis'' > 16 < b' fis'' > ] < b' gis'' > 8 [ < b' fis'' > ] r4  |
                    R1*2  |
                    r2 r4 r8 < e'' b'' > 16 [ < e'' b'' > ]  |
%% 20
                    < a'' cis''' > 8 [ < gis'' b'' > ] r < e'' b'' > 16 [ < e'' b'' > ] < a'' cis''' > 8 [ < gis'' b'' > ] r < gis' e'' > 16 [ < gis' e'' > ]  |
                    < a'' e' > 8 [ < gis'' e' > 16 < gis'' e' > ] < b' gis'' > 8 [ < gis' e'' > 16 < gis' e'' > ] < e' e'' > 8 [ < gis' b' > 16 < gis' b' > ] < gis' b' > 8 [ < gis' b' > 16 < gis' b' > ]  |
                    < e' gis' > 4 r r2  |
                    r2 r  |
                    r2 r  |
%% 25
                    r8 < b' fis'' > 16 [ < b' fis'' > ] < b' fis'' > 8 [ gis'' 16 fis'' ] < gis' e'' > 8 [ < a'' e' > 16 < gis'' e' > ] < b' fis'' > 8 [ < b' b'' > 16 < b' a'' > ]  |
                    < b' gis'' > 4 r8 < e'' gis'' > ais'' 4 b'' 8 -\tenuto r  |
                    e'' 8 [ < b' b'' > ais'' -\tenuto ] r16 r < fis'' b'' > 4 r8 < fis'' b'' > 16 [ < fis'' b'' > ]  |
                    < e'' b'' > 8 [ < b' gis'' > ] r < gis' gis'' > 16 [ < gis' gis'' > ] < b' fis'' > 8 [ < b' fis'' > ] r4  |
                    e'' 2 fis'' 4 gis''  |
%% 30
                    a'' 4 a'' 2 gis'' 4  |
                    fis'' 2 e'' _~  |
                    e'' 2 r8 < b' gis'' > 16 [ < b' gis'' > ] < b' gis'' > 8 [ < b' gis'' > ]  |
                    < e'' a'' > 8 [ < e' e'' > 16 < e' e'' > ] < e' e'' > 8 [ < e' e'' > ] < gis' b' > 4 r  |
                    R1*3  |
                    r2 r4 < gis'' b'' >  |
                    < fis'' b'' > 4 < e'' a'' > < e'' gis'' > fis'' 8. [ e'' 16 ]  |
                    < b' e'' > 4. < b' fis'' > 8 < b' gis'' > 4 < e'' ais'' >  |
%% 40
                    < fis'' b'' > 4. < gis'' b'' > 8 e'' 4 < fis'' a'' >  |
                    < b' gis'' > 2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 45
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 50
                    r2 r  |
                    r2 r  |
                    r4 r8 < b' fis'' > [ < b' gis'' > < b' fis'' > ] r < b' fis'' >  |
                    < b' gis'' > 8 [ < b' fis'' > ] r < b' fis'' > 16 [ < b' fis'' > ] < b' gis'' > 8 [ < b' fis'' > ] r < b' fis'' > 16 [ < b' fis'' > ]  |
                    < b' gis'' > 8 [ < b' fis'' > ] r4 r2  |
%% 55
                    r4 b'' 8 -\tenuto r b'' 2 -\tenuto _~  |
                    b'' 1 -\tenuto _~  |
                    b'' 4 -\tenuto r16 a'' [ gis'' fis'' ] e'' 4 e''  |
                    e'' 1 -\tenuto _~  |
                    e'' 1 -\tenuto  |
%% 60
                    r4 e'' fis'' fis''  |
                    fis'' 1 -\tenuto _~  |
                    fis'' 1 -\tenuto  |
                    r2 gis'' 4 gis''  |
                    gis'' 1 -\tenuto _~  |
%% 65
                    gis'' 1 -\tenuto  |
                    r4 r8 gis'' a'' 4 a''  |
                    a'' 2 -\tenuto r4 r  |
                    fis'' 4. < fis'' a'' > 8 [ < e'' gis'' > fis'' gis'' ] a''  |
                    fis'' 2 r  |
%% 70
                    r2 r  |
                    R1  |
                    r2 r  |
                    r2 r  |
                    r2 e' 4 e'  |
%% 75
                    e' 1 -\tenuto  |
                    r4 r8 e' e' 4 e'  |
                    e' 1 -\tenuto  |
                    r8 e' 16 [ e' ] < e' gis' > 8 [ < e' b' > ] < gis' e'' > 4 < e'' b'' >  |
                    < gis'' e''' > 4 < e'' gis'' > < e'' cis''' > e''  |
%% 80
                    < fis'' a'' > 4 < e'' gis'' > 8 [ < b' fis'' > < fis'' b' > -\tenuto b' 16 b' ] b' 8 [ < b' e'' > ]  |
                    < gis' e'' > 4 r < e'' gis'' > < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
                    < gis'' b'' > 4 r8 < gis'' b'' > < e'' gis'' > 4 < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
                    < gis'' b'' > 4 r < e'' gis'' > < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
                    < gis'' b'' > 4 r8 < gis'' b'' > < e'' gis'' > 4 < e'' gis'' > 8. [ < fis'' a'' > 16 ]  |
%% 85
                    < gis'' b'' > 4 r r < gis' b' >  |
                    < e'' gis' > 8 ^( [ e' < gis'' b' > gis' ) ] < e'' cis''' > 4 < b' e'' >  |
                    < fis'' a'' > 4 < e'' gis'' > 8 [ < b' fis'' > < fis'' b' > -\tenuto b' 16 b' ] b' 8 [ < b' e'' > ]  |
                    < e'' gis' > 8 -\tenuto [ e' 16 e' ] gis' 8 [ < b' gis' > 16 -\tenuto b' ] < e'' e' > 8 _( [ e' e'' b' ) ]  |
                    < e' e'' > 8 [ < e'' gis'' > < gis'' b'' > < e'' gis'' > ] < e' e'' > 4 < e' e'' >  |
%% 90
                    < e' e'' > 8 [ < e'' gis'' > < gis'' b'' > < e'' gis'' > ] < e' e'' > 4 < e' e'' >  |
                    < e' e'' > 8 [ < e'' gis'' > 16 < fis'' a'' > ] < gis'' b'' > 8 [ < e'' gis'' > < e' e'' > < e'' gis'' > 16 < fis'' a'' > ] < gis'' b'' > 8 [ < e'' gis'' > 16 < e'' gis'' > ]  |
                    < e' e'' > 8 [ < gis' e'' > ] r4 r < b' gis'' >  |
                    < e' e'' > 2. < e' e'' > 4  |
                    < gis' e'' > 1  |
                    \bar "|."
                } % Voice

                % End of segment trumpet II

                % End voice 1
            >> % Staff ends

            \context Staff = "track 7, Timpani in A und D" << 
                \set Staff.instrumentName = \markup { \center-column { "Timpani in A und D " } }
                \set Staff.shortInstrumentName = "Tmp."
                \set Staff.midiInstrument = "Timpani"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 6.0" {
                    % Segment: timpani
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "bass"
                    \key d \major
                    R1*13  |
                    r2 r4 r8 a, 16 [ a, ]  |
%% 15
                    d 8 [ a, ] r a, 16 [ a, ] d 8 [ a, ] r a, 16 [ a, ]  |
                    d 8 [ a, 16 a, ] a, 8 [ a, 16 a, ] d 8 [ a, ] r4  |
                    R1*2  |
                    r2 r4 r8 d 16 [ d ]  |
%% 20
                    d 8 [ d ] r d 16 [ d ] d 8 [ d ] r d 16 [ d ]  |
                    d 8 [ d 16 d ] d 8 [ d 16 d ] d 8 [ d 16 d ] d 8 [ d 16 d ]  |
                    d 4 r r2  |
                    r2 r  |
                    r2 r  |
%% 25
                    r8 a, 16 [ a, ] a, 8 [ a, d d 16 d ] a, 8 [ a, 16 a, ]  |
                    d 8 [ a, ] d 4. d 8 a, 4  |
                    r8 d d 8. [ d 16 ] a, 4 r8 a, 16 [ a, ]  |
                    d 8 [ d ] r d 16 [ d ] a, 8 [ a, ] r4  |
                    R1*3  |
                    r2 r8 d 16 [ d ] d 8 [ d ]  |
                    d 8 [ d 16 d ] d 8 [ d ] d 4 r  |
                    R1*3  |
                    r2 r4 d  |
                    a, 4 d a, 4. a, 8  |
                    d 4. a, 8 d 4 d  |
%% 40
                    a, 4. d 8 d 4 a,  |
                    d 2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 45
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 50
                    r2 r  |
                    r2 r  |
                    r4 r8 a, [ d a, ] r a,  |
                    d 8 [ a, ] r a, 16 [ a, ] d 8 [ a, ] r a, 16 [ a, ]  |
                    d 8 [ a, ] r4 r2  |
%% 55
                    r4 r8 a, [ d a, ] r a,  |
                    d 8 [ a, ] r a, 16 [ a, ] d 8 [ a, ] r a, 16 [ a, ]  |
                    d 8 [ a, ] r4 r2  |
                    r2 r  |
                    r2 r  |
%% 60
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 65
                    r2 r  |
                    r2 r  |
                    r2 d 4 d  |
                    a, 4. a, 8 [ d d d ] d  |
                    a, 2 r  |
%% 70
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 75
                    r4 r8 d [ d d ] r d  |
                    d 8 [ d ] r4 r2  |
                    r4 r8 d 16 [ d ] d 8 [ d ] r d 16 [ d ]  |
                    d 8 [ d 16 d ] d 8 [ d d d ] d [ d ]  |
                    d 4 d 8. [ d 16 ] d 8 [ d 16 d ] d 8 [ d ]  |
%% 80
                    a, 4 d a, 4. a, 8  |
                    d 4 r d d 8. [ d 16 ]  |
                    d 4 r8 d d 4 d 8. [ d 16 ]  |
                    d 4 r d d  |
                    d 4 r8 d d 4 d 8. [ d 16 ]  |
%% 85
                    d 4 r r d  |
                    d 4 d d d  |
                    a, 4 d 8 [ d ] a, 4. a, 8  |
                    d 4 r8 d [ d d ] r d  |
                    d 4 r8 d [ d d ] r d  |
%% 90
                    d 8 [ d ] r d 16 [ d ] d 8 [ d ] r d 16 [ d ]  |
                    d 4 r8 d 16 [ d ] d 8 [ d 16 d ] d 8 [ d 16 d ]  |
                    d 8 [ d ] r4 r d  |
                    d 2. d 4  |
                    d 1  |
                    \bar "|."
                } % Voice

                % End of segment timpani

                % End voice 0
            >> % Staff ends
        >> % StaffGroup 1
        \context StaffGroup = "2" <<

            \context Staff = "track 9, Violino I" << 
                \set Staff.instrumentName = \markup { \center-column { "Violino I " } }
                \set Staff.shortInstrumentName = "Vln I"
                \set Staff.midiInstrument = "Violin"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 8.0" {
                    % Segment: violin
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble"
                    \key d \major
                    d'' 4. -\f a'' 8 [ b'' ] a'' r4  |
                    d''' 4. fis'' 8 [ g'' ] fis'' r a''  |
                    g'' 8 [ fis'' ] e'' 4 d'' 8 [ a' b' cis'' ]  |
                    d'' 4 r d'' 4. a' 8  |
%% 5
                    fis' 8 [ d' ] r4 d''' 4. a'' 8  |
                    d'' 8 [ fis'' 16 fis'' ] g'' 8 [ fis'' ] r a'' 16 [ a'' ] b'' 8 [ a'' ]  |
                    r4 r8 cis'' [ fis'' a'' ] g'' [ fis'' ]  |
                    e'' 4 r a'' 4. e'' 8  |
                    cis'' 4 r r8 e'' 16 [ e'' ] fis'' 8 [ e'' ]  |
%% 10
                    r8 cis''' 16 [ cis''' ] d''' 8 [ cis''' ] r cis''' 16 [ cis''' ] d''' 8 [ cis''' ]  |
                    fis'' 8 a'' 4 gis'' 8 [ a'' ] e'' 16 [ e'' ] fis'' 8 [ e'' ]  |
                    a' 2 b' 4 cis''  |
                    d'' 8 [ d' ] d'' 2 cis'' 4  |
                    b' 2 a' 4 r8 a'' 16 [ a'' ]  |
%% 15
                    d''' 8 [ cis''' ] r a'' 16 [ a'' ] d''' 8 [ cis''' ] r a'' 16 [ a'' ]  |
                    d''' 8 [ cis''' 16 cis''' ] cis''' 8 [ a'' 16 a'' ] d''' 8 [ cis''' ] r4  |
                    d' 2 e' 4 fis'  |
                    g' 8 [ g ] g' 2 fis' 4  |
                    e' 2 d' 4 r8 a'' 16 [ a'' ]  |
%% 20
                    b'' 8 [ a'' ] r d''' 16 [ a'' ] b'' 8 [ a'' ] r d''' 16 [ a'' ]  |
                    b'' 8 [ d''' 16 d''' ] d''' 8 [ d''' 16 a'' ] b'' 8 [ a'' ] r4  |
                    d'' 2 e'' 4 fis''  |
                    g'' 8 [ g' ] g'' 2 fis'' 4  |
                    e'' 2 d'' 4 r8 d''' 16 [ d''' ]  |
%% 25
                    cis''' 8 [ a'' ] r fis'' 16 [ e'' ] d'' 8 [ g'' 16 fis'' ] e'' 8 [ a'' 16 g'' ]  |
                    fis'' 4 r8 d''' 16 [ cis''' ] b'' 8 [ gis'' 16 fis'' ] e'' 8 [ fis'' 16 e'' ]  |
                    d'' 8 [ cis'' d'' e'' 16 d'' ] cis'' 8 [ e'' 16 e'' ] a'' 8 [ cis'' ]  |
                    r8 a'' 16 [ a'' ] d''' 8 [ a'' ] r a'' 16 [ a'' ] a'' 8 [ e'' ]  |
                    r8 a' 16 [ a' ] fis'' 8 [ d'' ] r cis''' 16 [ cis''' ] d''' 8 [ a'' ]  |
%% 30
                    d'' 8 [ b' 16 b' ] e'' 8 [ e'' ] r cis''' 16 [ cis''' ] d''' 8 [ d''' ]  |
                    d''' 8 [ d''' ] cis''' 8. [ cis''' 16 ] d''' 8 [ a'' 16 a'' ] fis'' 8 [ d'' ]  |
                    r8 b'' [ b'' b'' ] a'' [ a'' 16 a'' ] fis'' 8 [ d'' ]  |
                    g'' 8 [ g'' 16 g'' ] b'' 8 [ b'' ] a'' 4 a'  |
                    a' 4 g' fis' e' 8. [ d' 16 ]  |
%% 35
                    d' 2. a' 4  |
                    a' 4 g' fis' e' 8. [ d' 16 ]  |
                    d' 2. a'' 4  |
                    a'' 4 g'' fis'' e'' 8. [ d'' 16 ]  |
                    d'' 4. e'' 8 fis'' 4 gis''  |
%% 40
                    a'' 4. a'' 8 b'' 4 cis'''  |
                    d''' 2 r  |
                    r2 r  |
                    r2 r4 d'  |
                    a' 4 cis' fis' a  |
%% 45
                    d' 4 cis' 8 [ b ] cis' 4 b 8. [ a 16 ]  |
                    a 4 r r8 a [ d' d' ]  |
                    d' 4 r8 b [ e' cis' ] d' 4 
                    % warning: overlong bar truncated here |
                    \skip 4 cis' 4 d' d''  |
                    a'' 4 cis'' fis'' a'  |
%% 50
                    d'' 4 cis'' 8 [ b' ] cis'' 4 b' 8. [ a' 16 ]  |
                    a' 2 r  |
                    r4 r8 a'' [ d''' cis''' ] r a''  |
                    d''' 8 [ cis''' ] r a'' 16 [ a'' ] d''' 8 [ cis''' ] r a'' 16 [ a'' ]  |
                    d''' 8 [ cis''' ] r4 r2  |
%% 55
                    r4 r8 a'' [ d''' cis''' ] r a''  |
                    d''' 8 [ cis''' ] r a'' 16 [ a'' ] d''' 8 [ cis''' ] r a'' 16 [ a'' ]  |
                    d''' 8 [ cis''' ] r4 r2  |
                    r4 r8 a'' [ b'' a'' ] d''' [ a'' ]  |
                    b'' 8 [ a'' ] r a'' 16 [ a'' ] b'' 8 [ a'' ] r a'' 16 [ a'' ]  |
%% 60
                    b'' 8 [ a'' ] r4 r2  |
                    r4 r8 b'' [ cis''' b'' ] e'' [ b'' ]  |
                    cis''' 8 [ b'' e'' b'' 16 b'' ] cis''' 8 [ b'' ] r b'' 16 [ b'' ]  |
                    cis''' 8 [ b'' ] r4 r2  |
                    r4 r8 cis''' [ d''' cis''' ] fis'' [ cis''' ]  |
%% 65
                    d''' 8 [ cis''' fis'' cis''' 16 cis''' ] d''' 8 [ cis''' ] r cis''' 16 [ cis''' ]  |
                    d''' 4 d'' r2  |
                    r2 d''' 4 d'''  |
                    a'' 8 [ e'' e'' g'' ] fis'' [ e'' fis'' g'' ]  |
                    e'' 2 r  |
%% 70
                    r2 r  |
                    r2 r4 a''  |
                    d''' 4 fis'' b'' d''  |
                    g'' 4 fis'' 8 [ e'' ] fis'' 4 e'' 8. [ d'' 16 ]  |
                    d'' 2 d' 4 d'  |
%% 75
                    d' 4 r8 a'' [ b'' a'' ] r a''  |
                    b'' 8 [ a'' ] r d' d' 4 d'  |
                    d' 4 r8 a'' 16 [ a'' ] b'' 8 [ a'' ] r a'' 16 [ a'' ]  |
                    b'' 8 [ a'' ] r4 r a''  |
                    d''' 4 fis'' b'' d''  |
%% 80
                    g'' 4 fis'' 8 [ e'' ] e'' 4. a'' 8  |
                    fis'' 16 [ e'' fis'' g'' ] a'' [ g'' fis'' e'' ] d'' 8 [ d'' 16 d'' ] fis'' 8 [ fis'' 16 g'' ]  |
                    a'' 8 [ fis'' 16 g'' ] a'' 8 [ b'' 16 cis''' ] d''' 8 [ d'' 16 e'' ] fis'' 8 [ fis'' 16 g'' ]  |
                    a'' 8 [ fis'' 16 g'' ] a'' 8 [ b'' 16 cis''' ] d''' 8 [ d'' 16 e'' ] fis'' 8 [ fis'' 16 g'' ]  |
                    a'' 8 [ fis'' 16 g'' ] a'' 8 [ b'' 16 cis''' ] d''' 8 [ d'' 16 e'' ] fis'' 8 [ fis'' 16 g'' ]  |
%% 85
                    a'' 8 [ fis'' 16 g'' ] a'' 8 [ b'' 16 cis''' ] d''' 4 a''  |
                    d''' 4 fis'' b'' d''  |
                    g'' 4 fis'' 8 [ e'' ] e'' 4. d'' 8  |
                    d'' 4 r8 a'' [ b'' a'' ] r a''  |
                    b'' 8 [ a'' ] r a'' [ b'' a'' ] r a''  |
%% 90
                    b'' 8 [ a'' 16 a'' ] d''' 8 [ a'' 16 a'' ] b'' 8 [ a'' 16 a'' ] d''' 8 [ a'' 16 a'' ]  |
                    b'' 8 [ a'' 16 a'' ] d''' 8 [ a'' 16 a'' ] b'' 8 [ a'' 16 a'' ] d''' 8 [ a'' 16 a'' ]  |
                    b'' 8 [ a'' ] r4 r a''  |
                    b'' 2. b'' 4  |
                    a'' 1  |
                    \bar "|."
                } % Voice

                % End of segment violin

                % End voice 0
            >> % Staff ends

            \context Staff = "track 10, Violino II" << 
                \set Staff.instrumentName = \markup { \center-column { "Violino II " } }
                \set Staff.shortInstrumentName = "Vln II"
                \set Staff.midiInstrument = "Pizzicato Strings"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 9.0" {
                    % Segment: violin
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble"
                    \key d \major
                    a' 4. -\f fis'' 8 [ g'' ] fis'' r4  |
                    fis'' 4 a' 8 [ d'' cis'' d'' ] r a'  |
                    cis'' 8 d'' 4 cis'' 8 [ d'' fis' g' ] e'  |
                    fis' 4 r d' 4. fis' 8  |
%% 5
                    d' 8 [ a ] r4 d'' 4. d'' 8  |
                    b' 8 [ a' 16 a' ] b' 8 [ a' ] r fis'' 16 [ fis'' ] g'' 8 [ d'' ]  |
                    r4 r8 cis'' [ d'' d'' ] cis'' [ d'' ]  |
                    cis'' 4 r a' 4. cis'' 8  |
                    a' 4 r r8 cis'' 16 [ cis'' ] d'' 8 [ cis'' ]  |
%% 10
                    r8 e'' 16 [ e'' ] fis'' 8 [ e'' ] r e'' 16 [ e'' ] fis'' 8 [ e'' ]  |
                    a' 8 [ e'' ] d'' 4 cis'' 8 [ cis'' 16 cis'' ] d'' 8 [ cis'' ]  |
                    a' 2 b' 4 cis''  |
                    d'' 8 [ d' ] d'' 2 cis'' 4  |
                    b' 2 a' 4 r8 e'' 16 [ e'' ]  |
%% 15
                    fis'' 8 [ e'' ] r e'' 16 [ e'' ] fis'' 8 [ e'' ] r e'' 16 [ e'' ]  |
                    fis'' 8 [ e'' 16 e'' ] e'' 8 [ e'' 16 e'' ] fis'' 8 [ e'' ] r4  |
                    d' 2 e' 4 fis'  |
                    g' 8 [ g ] g' 2 fis' 4  |
                    e' 2 d' 4 r8 d'' 16 [ d'' ]  |
%% 20
                    g'' 8 [ fis'' ] r a'' 16 [ d'' ] g'' 8 [ fis'' ] r a'' 16 [ d'' ]  |
                    g'' 8 [ fis'' 16 fis'' ] fis'' 8 [ a'' 16 d'' ] g'' 8 [ fis'' ] r4  |
                    r2 r8 a' 16 [ a' ] fis' 8 [ d' ]  |
                    r8 d' 16 [ d' ] b' 8 [ b' e' a' ] r a' 16 [ a' ]  |
                    g' 8 [ e' a' a' ] a' [ a'' 16 a'' ] fis'' 8 [ d'' ]  |
%% 25
                    r8 e'' 16 [ e'' ] cis'' 8 [ cis''' 16 cis''' ] d''' 8 [ d'' 16 d'' ] a' 8 [ e'' 16 e'' ]  |
                    a' 8 [ a'' 16 g'' ] fis'' 8 [ b'' 16 a'' ] gis'' 8 [ e'' ] a'' 4 
                    % warning: overlong bar truncated here |
                    \skip 4 gis'' 4 a'' 8 [ cis'' 16 cis'' ] e'' 8 [ cis'' ]  |
                    r8 fis'' 16 [ fis'' ] a'' 8 [ fis'' ] r cis'' 16 [ cis'' ] e'' 8 [ cis'' ]  |
                    r8 fis' 16 [ fis' ] a' 8 [ fis'' 16 fis'' ] a'' 8 [ e'' 16 e'' ] a' 8 [ d'' 16 d'' ]  |
%% 30
                    g'' 8 [ d'' 16 d'' ] b' 8 [ g' 16 g' ] e' 8 [ e'' 16 e'' ] fis'' 8 [ d'' 16 d'' ]  |
                    b'' 8 [ g'' ] e'' 8. [ e'' 16 ] a'' 8 [ d'' 16 d'' ] a' 8 [ fis'' 16 fis'' ]  |
                    g'' 8 [ g'' g'' g'' ] fis'' [ fis'' 16 fis'' ] d'' 8 [ a' ]  |
                    d'' 8 [ d'' 16 d'' ] g'' 8 [ g'' ] fis'' 4 fis'  |
                    e' 4 d' 2 cis' 4  |
%% 35
                    d' 2. fis' 4  |
                    e' 4 d' 2 cis' 8. [ d' 16 ]  |
                    a 2. fis'' 4  |
                    e'' 4 d'' d'' cis''  |
                    a' 4. cis'' 8 d'' 4 d''  |
%% 40
                    cis'' 4. d'' 8 d'' 4 g''  |
                    fis'' 2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 45
                    r2 r  |
                    r4 a' d'' fis'  |
                    b' 4 d' g' fis' 8 [ e' ]  |
                    fis' 4 e' 8. [ d' 16 ] d' 8 [ a' fis' d' ]  |
                    r8 e' [ a' e' ] r d' [ cis' a ]  |
%% 50
                    d' 8 [ b' ] a' 2 gis' 4  |
                    a' 4 e' r2  |
                    r4 r8 e'' [ fis'' e'' ] r e''  |
                    fis'' 8 [ e'' ] r e'' 16 [ e'' ] fis'' 8 [ e'' ] r e'' 16 [ e'' ]  |
                    fis'' 8 [ e'' ] r4 r2  |
%% 55
                    r4 r8 e'' [ fis'' e'' ] r e''  |
                    fis'' 8 [ e'' ] r e'' 16 [ e'' ] fis'' 8 [ e'' ] r e'' 16 [ e'' ]  |
                    fis'' 8 [ e'' ] r4 r2  |
                    r4 r8 d'' [ g'' fis'' ] a'' [ fis'' ]  |
                    d'' 8 [ fis'' ] r d'' 16 [ d'' ] g'' 8 [ fis'' ] r d'' 16 [ d'' ]  |
%% 60
                    g'' 8 [ fis'' ] r4 r2  |
                    r4 r8 e'' [ a'' gis'' ] b' [ gis'' ]  |
                    a'' 8 [ gis'' e'' gis'' 16 gis'' ] a'' 8 [ gis'' ] r gis'' 16 [ gis'' ]  |
                    a'' 8 [ gis'' ] r4 r2  |
                    r4 r8 fis'' [ b'' bes'' ] cis'' [ fis'' ]  |
%% 65
                    b'' 8 [ bes'' cis'' fis'' 16 fis'' ] b'' 8 [ bes'' ] r fis'' 16 [ fis'' ]  |
                    b'' 4 fis'' r2  |
                    r2 d'' 4 d''  |
                    e'' 8 [ a' a' e'' ] d'' [ cis'' d'' e'' ]  |
                    cis'' 2 r8 cis'' [ d'' e'' ]  |
%% 70
                    a' 4 r r8 fis'' [ gis'' a'' ]  |
                    d'' 8 [ cis'' d'' e'' 16 d'' ] cis'' 8 [ e' a' g' ]  |
                    fis' 4. e' 8 d' 4. d'' 8  |
                    d'' 8 [ cis'' d'' d'' ] d'' 4 cis''  |
                    d'' 2 d' 4 d'  |
%% 75
                    d' 4 r8 d'' [ g'' fis'' ] r d''  |
                    g'' 8 [ fis'' ] r d' d' 4 d'  |
                    d' 4 r8 d'' 16 [ d'' ] g'' 8 [ fis'' ] r d'' 16 [ d'' ]  |
                    g'' 8 [ fis'' ] r a'' [ fis'' 16 e'' fis'' g'' ] a'' [ g'' fis'' e'' ]  |
                    d'' 16 [ cis'' d'' e'' ] d'' [ cis'' b' a' ] g' [ a' b' g' ] a' 8 [ a'' ]  |
%% 80
                    cis''' 4 d''' 8 [ d''' ] d''' 4 cis'''  |
                    d''' 8 [ d'' 16 e'' ] fis'' [ e'' d'' cis'' ] d'' 8 [ a' 16 a' ] d'' 8 [ d'' 16 e'' ]  |
                    fis'' 8 [ d'' 16 e'' ] fis'' 8 [ g'' 16 e'' ] fis'' 8 [ fis'' 16 g'' ] a'' 8 [ d'' 16 e'' ]  |
                    fis'' 8 [ d'' 16 e'' ] fis'' 8 [ g'' 16 e'' ] fis'' 8 [ fis'' 16 g'' ] a'' 8 [ d'' 16 e'' ]  |
                    fis'' 8 [ d'' 16 e'' ] fis'' 8 [ g'' 16 e'' ] fis'' 8 [ fis'' 16 g'' ] a'' 8 [ d'' 16 e'' ]  |
%% 85
                    fis'' 8 [ d'' 16 e'' ] fis'' 8 [ g'' 16 e'' ] fis'' 8 [ fis'' 16 g'' ] a'' [ g'' fis'' e'' ]  |
                    d'' 16 [ cis'' d'' e'' ] d'' [ cis'' b' a' ] g' [ a' b' g' ] a' 8 [ a'' ]  |
                    cis'' 4 d'' d'' cis''  |
                    d'' 4 r8 d'' [ g'' fis'' ] r d''  |
                    g'' 8 [ fis'' ] r d'' [ g'' fis'' ] r d''  |
%% 90
                    g'' 8 [ fis'' 16 fis'' ] fis'' 8 [ d'' 16 d'' ] g'' 8 [ fis'' 16 fis'' ] fis'' 8 [ d'' 16 d'' ]  |
                    g'' 8 [ fis'' 16 fis'' ] fis'' 8 [ d'' 16 d'' ] g'' 8 [ fis'' 16 fis'' ] fis'' 8 [ d'' 16 d'' ]  |
                    g'' 8 [ fis'' ] r4 r fis''  |
                    g'' 2. g'' 4  |
                    fis'' 1  |
                    \bar "|."
                } % Voice

                % End of segment violin

                % End voice 0
            >> % Staff ends

            \context Staff = "track 11, Viola" << 
                \set Staff.instrumentName = \markup { \center-column { "Viola " } }
                \set Staff.shortInstrumentName = "Vla."
                \set Staff.midiInstrument = "Viola"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 10.0" {
                    % Segment: viola
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "alto"
                    \key d \major
                    fis' 8 -\f [ g' a' d' ] d'' [ d' ] r4  |
                    a' 4. a' 8 [ g' ] a' r d'  |
                    g' 8 [ a' a' e' ] fis' 4 r  |
                    r2 d' 4. d' 8  |
%% 5
                    a 8 [ fis ] r4 d' 4. d' 8  |
                    d' 8 [ d' 16 d' ] d' 8 [ d' ] r d' 16 [ d' ] d' 8 [ d' ]  |
                    r4 r8 a' [ a' a' ] e' [ a' ]  |
                    a' 4 r a' 4. a' 8  |
                    e' 4 r r8 a' 16 [ a' ] a' 8 [ a' ]  |
%% 10
                    r8 a' 16 [ a' ] a' 8 [ a' ] r a' 16 [ a' ] a' 8 [ a' ]  |
                    d'' 8 [ a' ] b' 4 e' 8 [ a' 16 a' ] a' 8 [ a' ]  |
                    a' 2 b' 4 cis''  |
                    d'' 8 [ d' ] d'' 2 cis'' 4  |
                    b' 2 a' 4 r8 a' 16 [ a' ]  |
%% 15
                    a' 8 [ a' ] r a' 16 [ a' ] a' 8 [ a' ] r a' 16 [ a' ]  |
                    a' 8 [ a' 16 a' ] a' 8 [ cis'' 16 cis'' ] a' 8 [ a' ] r4  |
                    d' 2 e' 4 fis'  |
                    g' 8 [ g ] g' 2 fis' 4  |
                    e' 2 d' 4 r8 d' 16 [ d' ]  |
%% 20
                    d'' 8 [ d'' ] r d' 16 [ fis' ] d'' 8 [ d'' ] r d' 16 [ fis' ]  |
                    d'' 8 [ d'' 16 a' ] d' 8 [ d' 16 d' ] d'' 8 [ d'' ] r4  |
                    r4 r8 d' 16 [ d' ] cis' 8 [ a ] r d' 16 [ d' ]  |
                    b 8 [ b ] r e' 16 [ e' ] cis' 8 [ a ] d' 4 
                    % warning: overlong bar truncated here |
                    \skip 4 cis' 4 d' 8 [ fis' 16 fis' ] a' 8 [ fis' ]  |
%% 25
                    r8 cis'' 16 [ cis'' ] a' 8 [ cis'' 16 a' ] fis' 8 [ d' 16 d' ] cis'' 8 [ cis'' 16 cis'' ]  |
                    fis' 8 [ fis' 16 e' ] d' 8 [ fis' b' b' ] cis'' [ cis'' ]  |
                    fis' 8 [ fis' d' d' ] e' [ a' 16 a' ] cis'' 8 [ a' ]  |
                    r8 a' 16 [ a' ] fis' 8 [ d' ] r e' 16 [ e' ] cis' 8 [ a ]  |
                    r8 d' 16 [ d' ] d'' 8 [ a' 16 a' ] e' 8 [ a' 16 a' ] fis' 8 [ fis' 16 fis' ]  |
%% 30
                    d' 8 [ d' 16 d' ] g' 8 [ g' 16 g' ] cis' 8 [ a' 16 a' ] d'' 8 [ fis' 16 d' ]  |
                    e' 8 [ b' cis' a' ] a' [ fis' 16 fis' ] d' 8 [ a' 16 a' ]  |
                    d' 8 [ d' 16 d' ] d' 8 [ e' fis' fis' 16 fis' ] a' 8 [ fis' ]  |
                    g' 8 [ g' 16 g' ] d' 8 [ d' ] d' 4 d'  |
                    a 4 d' a cis'  |
%% 35
                    a 2. d' 4  |
                    a 4 d a g 8. [ fis 16 ]  |
                    fis 2. d'' 4  |
                    a' 4 d' a' e'  |
                    fis' 4. g' 8 a' 4 b'  |
%% 40
                    e' 4. fis' 8 g' 4 g'  |
                    a' 2 r  |
                    r2 r  |
                    r2 r4 d'  |
                    a' 4 cis' fis' a  |
%% 45
                    d' 4 cis' 8 [ b ] cis' 4 b 8. [ a 16 ]  |
                    a 4 a' d'' fis'  |
                    b' 4 d' g' fis' 8 [ e' ]  |
                    fis' 4 e' 8. [ d' 16 ] d' 4 r8 fis'  |
                    e' 8 [ cis' ] r a' [ a' d' ] r a'  |
%% 50
                    fis' 8 [ e' e' fis' ] e' 4 e'  |
                    e' 4 cis' r2  |
                    r4 r8 a' [ a' a' ] r a'  |
                    a' 8 [ a' ] r a' 16 [ a' ] a' 8 [ a' ] r a' 16 [ a' ]  |
                    a' 8 [ a' ] r4 r2  |
%% 55
                    r4 r8 a' [ a' a' ] r a'  |
                    a' 8 [ a' ] r a' 16 [ a' ] a' 8 [ a' ] r a' 16 [ a' ]  |
                    a' 8 [ a' ] r4 r2  |
                    r4 r8 d' [ d' d' ] fis' [ d' ]  |
                    d' 8 [ d' ] r d' 16 [ d' ] d' 8 [ d' ] r d' 16 [ d' ]  |
%% 60
                    d' 8 [ d' ] r4 r2  |
                    r4 r8 e' [ e' e' ] gis' [ e' ]  |
                    e' 8 [ e' gis' e' 16 e' ] e' 8 [ e' ] r e' 16 [ e' ]  |
                    e' 8 [ e' ] r4 r2  |
                    r4 r8 fis' [ fis' fis' ] bes' [ fis' ]  |
%% 65
                    fis' 8 [ fis' bes' fis' 16 fis' ] fis' 8 [ fis' ] r fis' 16 [ fis' ]  |
                    fis' 4 fis' r2  |
                    r2 g' 4 g'  |
                    e' 4. a' 8 [ a' a' a' ] a'  |
                    a' 2 r  |
%% 70
                    r8 a' [ b' cis'' ] fis' [ a' e' a' ]  |
                    a' 4 gis' a' r  |
                    r8 a [ d' cis' ] b 4. a' 8  |
                    g' 4 a' 8 [ b' ] a' 2  |
                    a' 2 d' 4 d'  |
%% 75
                    d' 4 r8 d' [ d'' d'' ] r d'  |
                    d'' 8 [ d'' ] r d' d' 4 d'  |
                    d' 4 r8 d' 16 [ d' ] d' 8 [ d' ] r d' 16 [ d' ]  |
                    d' 8 [ d' ] r fis' a' 4 d'  |
                    fis' 4 fis' d' d'  |
%% 80
                    e' 4 a' a' a'  |
                    a' 4 r fis' 8 [ fis' 16 fis' ] a' 8 [ a' 16 a' ]  |
                    a' 4 r8 a' [ a' a' 16 a' ] a' 8 [ a' 16 a' ]  |
                    d'' 4 r a' 8 [ a' 16 a' ] a' 8 [ a' 16 a' ]  |
                    d'' 4 r8 a' [ a' a' 16 a' ] a' 8 [ a' 16 a' ]  |
%% 85
                    a' 4 r8 a' a' 4 d'  |
                    fis' 8 [ d' a' fis' ] d' 4 a'  |
                    e' 4 a' 8 [ a' ] a' 4 e'  |
                    fis' 4 r8 a' [ d'' d' ] r d'  |
                    d'' 8 [ d' ] r d' [ d'' d' ] r d'  |
%% 90
                    d'' 8 [ d' 16 d' ] a' 8 [ fis' 16 fis' ] d' 8 [ d' 16 d' ] a' 8 [ fis' 16 fis' ]  |
                    d' 8 [ d' 16 d' ] a' 8 [ fis' 16 fis' ] d' 8 [ d' 16 d' ] a' 8 [ fis' 16 fis' ]  |
                    d' 8 [ d' ] r4 r d'  |
                    d' 2. d' 4  |
                    d' 1  |
                    \bar "|."
                } % Voice

                % End of segment viola

                % End voice 0
            >> % Staff ends

            \context Staff = "track 12, Violoncello" << 
                \set Staff.instrumentName = \markup { \center-column { "Violoncello " } }
                \set Staff.shortInstrumentName = "Cel."
                \set Staff.midiInstrument = "Cello"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 11.0" {
                    % Segment: cello
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "bass"
                    \key d \major
                    d 8 -\f [ e fis d ] g [ d fis a ]  |
                    d 8 [ e fis d ] e [ d ] r fis  |
                    e 8 [ d a a, ] d 4 r  |
                    d 8 [ d e fis ] g [ d ] r4  |
%% 5
                    d 8 [ d e fis ] g [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis  |
                    e 8 [ d a a, ] d [ fis e d ]  |
                    a 4. cis' 8 [ d' ] a r4  |
                    a 4. cis' 8 [ d' ] a r cis' 16 [ cis' ]  |
%% 10
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis'  |
                    d' 8 [ cis' ] b 4 a r  |
                    a 2 b 4 cis'  |
                    d' 8 [ d ] d' 2 cis' 4  |
                    b 2 a 4 r8 cis' 16 [ cis' ]  |
%% 15
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis' 16 [ cis' ]  |
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r4  |
                    d 2 e 4 fis  |
                    g 8 [ g, ] g 2 fis 4  |
                    e 2 d 4 r8 fis 16 [ fis ]  |
%% 20
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ fis ] r fis 16 [ fis ] g 8 [ d ] r4  |
                    r4 r8 d' 16 [ d' ] cis' 8 [ a ] r d' 16 [ d' ]  |
                    b 8 [ b ] r e' 16 [ e' ] cis' 8 [ a ] d' 4 
                    % warning: overlong bar truncated here |
                    \skip 4 cis' 8 [ a 16 a ] fis 8 [ d d' d ]  |
%% 25
                    a 2 b 4 cis'  |
                    d' 8 [ d ] d' 2 cis' 4  |
                    b 2 a 4 r8 a 16 [ a ]  |
                    fis 8 [ d ] r d' 16 [ d' ] cis' 8 [ a cis' a ]  |
                    d' 4. d' 16 [ d' ] cis' 8 [ a ] r d' 16 [ d' ]  |
%% 30
                    b 8 [ g ] r e 16 [ e ] a 8 [ a ] r b 16 [ b ]  |
                    g 8 [ e ] a 8. [ g 16 ] fis 4 r8 d' 16 [ d' ]  |
                    b 8 [ g b cis' ] d' [ d 16 d ] d 8 [ d ]  |
                    b, 8 [ b, 16 b, ] g, 8 [ g, ] d 4 d  |
                    cis 4 b, a, g  |
%% 35
                    fis 2. d 4  |
                    cis 4 b, a, 4. a, 8  |
                    d 2. d' 4  |
                    cis' 4 b a g  |
                    fis 4. e 8 d 4 b  |
%% 40
                    a 4. fis 8 g 4 e  |
                    d 4. a 8 d' 4 fis  |
                    b 4 d g fis 8 [ e ]  |
                    e 2 d 4 r  |
                    r4 r8 a [ d' d ] r fis  |
%% 45
                    b 8 [ gis ] a 4 r8 e [ d e ]  |
                    cis 8 [ a g a ] fis 4 r8 fis  |
                    g 8 [ d ] r b [ e' cis' ] d' [ g ]  |
                    a 8 [ a, ] r a [ fis d ] r d'  |
                    cis' 8 [ a ] r cis' [ d' d ] r fis  |
%% 50
                    b 8 [ gis a d ] e [ e, ] r e  |
                    cis 4 a, r2  |
                    r4 r8 cis' [ d' a ] r cis'  |
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis' 16 [ cis' ]  |
                    d' 8 [ a ] r4 r2  |
%% 55
                    r4 r8 cis' [ d' a ] r cis'  |
                    d' 8 [ a ] r cis' 16 [ cis' ] d' 8 [ a ] r cis' 16 [ cis' ]  |
                    d' 8 [ a ] r4 r2  |
                    r4 r8 fis [ g d ] r fis  |
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
%% 60
                    g 8 [ d ] r4 r2  |
                    r4 r8 gis [ a e ] r gis  |
                    a 8 [ e ] r gis 16 [ gis ] a 8 [ e ] r gis 16 [ gis ]  |
                    a 8 [ e ] r4 r2  |
                    r4 r8 bes [ b fis ] r bes  |
%% 65
                    b 8 [ fis ] r bes 16 [ bes ] b 8 [ fis ] r bes 16 [ bes ]  |
                    b 4 b, r2  |
                    r2 b 4 b  |
                    cis' 4. cis' 8 d' 4 d  |
                    a 4. a, 8 a 4 cis  |
%% 70
                    fis 4 a, d cis  |
                    b, 2 a, 8 [ e' a' g' ]  |
                    fis' 8 [ a d' cis' ] b [ d g fis ]  |
                    e 4 fis 8 [ g ] a 4 g 8 [ a ]  |
                    fis 4 d r2  |
%% 75
                    r4 r8 fis [ g d ] r fis  |
                    g 8 [ d ] r4 r2  |
                    r4 r8 fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r d d' 4 fis  |
                    b 4 d g fis 8 [ fis ]  |
%% 80
                    e 4 d 8 [ d ] a 2  |
                    d 4 r d d  |
                    d' 4 r8 d d 4 d  |
                    d' 4 r d d  |
                    d' 4 r8 d d 4 d  |
%% 85
                    d' 4 r8 d d' 4 fis  |
                    b 4 d g fis 8 [ fis ]  |
                    e 4 d 8 [ d ] a 2  |
                    d 4 r8 fis [ g d ] r fis  |
                    g 8 [ d ] r fis [ g d ] r fis  |
%% 90
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r fis 16 [ fis ] g 8 [ d ] r fis 16 [ fis ]  |
                    g 8 [ d ] r4 r d  |
                    g, 2. g, 4  |
                    d, 1  |
                    \bar "|."
                } % Voice

                % End of segment cello

                % End voice 0
            >> % Staff ends
        >> % StaffGroup 2
        \context StaffGroup = "3" <<

            \context Staff = "track 14, Soprano" << 
                \set Staff.instrumentName = \markup { \center-column { "Soprano " } }
                \set Staff.shortInstrumentName = "S"
                \set Staff.midiInstrument = "Choir Aahs"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 13.0" {
                    % Segment: flute
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble"
                    \key d \major
                    R1*3  |
                    d'' 4. a' 8 b' a' r4  |
%% 5
                    d'' 4. a' 8 b' a' r d'' 16 d''  |
                    d'' 8 d'' r d'' 16 d'' d'' 8 d'' r d''  |
                    cis'' 8 ^( d'' 4 ) cis'' 8 d'' 4 r  |
                    e'' 4. a' 8 fis'' e'' r4  |
                    e'' 4. a' 8 fis'' e'' r e'' 16 e''  |
%% 10
                    fis'' 8 e'' r e'' 16 e'' fis'' 8 e'' r e''  |
                    fis'' 8 [ e'' ] d'' 4 cis'' r  |
                    a' 2 b' 4 cis''  |
                    d'' 8 d' d'' 4. d'' 8 cis'' 4  |
                    b' 2 a' 4 r8 e'' 16 e''  |
%% 15
                    d'' 8 cis'' r e'' 16 e'' d'' 8 cis'' r e'' 16 e''  |
                    fis'' 8 e'' r e'' 16 e'' fis'' 8 e'' r4  |
                    R1*2  |
                    r2 r4 r8 d'' 16 d''  |
%% 20
                    d'' 8 d'' r d'' 16 d'' d'' 8 d'' r d'' 16 d''  |
                    d'' 8 d'' r d'' 16 d'' d'' 8 d'' r4  |
                    d'' 2 e'' 4 fis''  |
                    g'' 8 g' g'' 4. g'' 8 fis'' 4  |
                    e'' 2 d'' 4 r8 d'' 16 d''  |
%% 25
                    cis'' 8 a' r cis'' 16 cis'' d'' 8 d'' 16 d'' e'' 8 e''  |
                    a' 4 r8 d'' 16 cis'' b' 8 b' r e''  |
                    d'' 8 cis'' d'' e'' 16 d'' cis'' 8 cis'' 16 cis'' e'' 8 cis''  |
                    r8 a' 16 a' d'' 8 a' r cis'' 16 cis'' e'' 8 cis''  |
                    r8 a' 16 a' fis'' 8 d'' r cis'' 16 cis'' d'' 8 a'  |
%% 30
                    r8 b' 16 b' e'' 8 e'' r cis'' 16 cis'' d'' 8 d'' 16 d''  |
                    d'' 4 cis'' d'' d''  |
                    d'' 4 d'' d'' 2  |
                    r2 r4 a'  |
                    a' 4 g' fis' e' 8. d' 16  |
%% 35
                    d' 1  |
                    r2 fis' 4 e' 8. d' 16  |
                    d' 2. fis'' 4  |
                    e'' 4 d'' d'' cis''  |
                    d'' 4. cis'' 8 d'' 4 d''  |
%% 40
                    cis'' 4. a' 8 b' 4 cis''  |
                    d'' 2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 45
                    r2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r4 d''  |
                    a'' 4 cis'' fis'' a'  |
%% 50
                    d'' 4 cis'' 8 b' cis'' 4 b' 8. a' 16  |
                    a' 2 a' 4 a'  |
                    a' 1 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    r4 a' a' a'  |
%% 55
                    a' 1 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    r2 d'' 4 d''  |
                    d'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
                    \skip 1  |
%% 60
                    r4 d'' e'' e''  |
                    e'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    r2 fis'' 4 fis''  |
                    fis'' 1 -\tenuto 
                    % warning: overlong bar truncated here |
%% 65
                    \skip 1  |
                    r4 r8 fis'' g'' 4 g''  |
                    g'' 1 -\tenuto  |
                    r4 r8 g'' fis'' e'' fis'' g''  |
                    e'' 2 r8 cis'' d'' e''  |
%% 70
                    a' 4 r r2  |
                    r2 r4 a'  |
                    d'' 4 fis' b' d'  |
                    g' 4 fis' 8 e' fis' 4 e' 8. d' 16  |
                    d' 2 r  |
%% 75
                    r4 r8 d'' g'' fis'' r d''  |
                    g'' 8 fis'' r4 r2  |
                    r4 r8 d'' 16 d'' g'' 8 fis'' r d'' 16 d''  |
                    g'' 8 fis'' r a' a' 4 d''  |
                    fis'' 4 d'' d'' a' 8 a'  |
%% 80
                    cis'' 4 d'' 8 d'' d'' 4 cis''  |
                    d'' 4 r a' a'  |
                    d'' 4 r8 a' a' 4 a'  |
                    d'' 4 r a' a'  |
                    d'' 4 r8 a' a' 4 a'  |
%% 85
                    d'' 4 r r a'  |
                    d'' 4 fis'' b' d''  |
                    g'' 4 fis'' 8 e'' e'' 2  |
                    d'' 4 r d'' d''  |
                    d'' 4 r8 d'' d'' 4 d''  |
%% 90
                    d'' 4 r8 d'' 16 d'' d'' 8 d'' r d'' 16 d''  |
                    d'' 8 d'' r d'' 16 d'' d'' 8 d'' r d'' 16 d''  |
                    d'' 8 d'' r4 r d''  |
                    d'' 2. d'' 4  |
                    d'' 1  |
                    \bar "|."
                } % Voice

                % End of segment flute

                % End voice 0

                % cycle 1   verse line 1
                \new Lyrics
                \with {alignBelowContext="track 14"}
                \lyricsto "voice 13.0" {
                    \lyricmode {
                        \override LyricText #'self-alignment-X = #LEFT
                        \set ignoreMelismata = ##t

                        % Segment "flute": verse 1

                        %{   4 %}    Hal le lu ja,
                        %{   5 %}    Hal le lu ja, Hal le
                        %{   6 %}    lu ja, Hal le lu ja, Hal
                        %{   7 %}    le _ lu ja,
                        %{   8 %}    Hal le lu ja,
                        %{   9 %}    Hal le lu ja, Hal le
                        %{  10 %}    lu ja, Hal le lu ja, Hal
                        %{  11 %}    le _ lu ja,
                        %{  12 %}    denn Gott der
                        %{  13 %}    Herr re gie ret all
                        %{  14 %}    mäch tig, Hal le
                        %{  15 %}    lu ja, Hal le lu ja, Hal le
                        %{  16 %}    lu ja, Hal le lu ja,
                        %{  19 %}    Hal le
                        %{  20 %}    lu ja, Hal le lu ja, Hal le
                        %{  21 %}    lu ja, Hal le lu ja,
                        %{  22 %}    denn Gott der
                        %{  23 %}    Herr re gie ret all
                        %{  24 %}    mäch tig, Hal le
                        %{  25 %}    lu ja, Hal le lu ja, Hal le lu
                        %{  26 %}    ja, Hal le lu ja, Hal
                        %{  27 %}    le _ lu _ _ ja, Hal le lu ja,
                        %{  28 %}    Hal le lu ja, Hal le lu ja,
                        %{  29 %}    Hal le lu ja, Hal le lu ja,
                        %{  30 %}    Hal le lu ja, Hal le lu ja, Hal
                        %{  31 %}    le lu ja, Hal
                        %{  32 %}    le lu ja!
                        %{  33 %}    Das
                        %{  34 %}    Kö nig reich der _
                        %{  35 %}    Welt
                        %{  36 %}    ist fort _
                        %{  37 %}    an das
                        %{  38 %}    Kö nig reich des
                        %{  39 %}    Herrn und sei nes
                        %{  40 %}    Christ, und sei nes
                        %{  41 %}    Christ,
                        %{  48 %}    und
                        %{  49 %}    er re giert auf
                        %{  50 %}    im mer und e _ _
                        %{  51 %}    wig, Herr der
                        %{  52 %}    Herrn,
                        %{  54 %}    der Wel ten
                        %{  55 %}    Gott,
                        %{  57 %}    Herr der
                        %{  58 %}    Herrn,
                        %{  60 %}    der Wel ten
                        %{  61 %}    Gott,
                        %{  63 %}    Herr der
                        %{  64 %}    Herrn,
                        %{  66 %}    der Wel ten
                        %{  67 %}    Gott,
                        %{  68 %}    der Wel _ ten _
                        %{  69 %}    Gott, und er reg
                        %{  70 %}    giert,
                        %{  71 %}    und
                        %{  72 %}    er re giert auf
                        %{  73 %}    im mer und e _ _
                        %{  74 %}    wig,
                        %{  75 %}    auf im mer und
                        %{  76 %}    e wig,
                        %{  77 %}    Hal le lu ja, Hal le
                        %{  78 %}    lu ja, und er re
                        %{  79 %}    giert auf e wig, auf
                        %{  80 %}    im mer und e _
                        %{  81 %}    wig, Herr der
                        %{  82 %}    Herrn, der Wel ten
                        %{  83 %}    Gott, Herr der
                        %{  84 %}    Herrn, der Wel ten
                        %{  85 %}    Gott, und
                        %{  86 %}    er re giert auf
                        %{  87 %}    im mer und e
                        %{  88 %}    wig, Herr der
                        %{  89 %}    Herrn, der Wel ten
                        %{  90 %}    Gott, Hal le lu ja, Hal le
                        %{  91 %}    lu ja, Hal le lu ja, Hal le
                        %{  92 %}    lu ja, Hal
                        %{  93 %}    le lu
                        %{  94 %}    ja!

                        \unset ignoreMelismata
                    }
                } % Lyrics 
            >> % Staff ends

            \context Staff = "track 15, Alto" << 
                \set Staff.instrumentName = \markup { \center-column { "Alto " } }
                \set Staff.shortInstrumentName = "A"
                \set Staff.midiInstrument = "Synth Voice"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 14.0" {
                    % Segment: oboe
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble"
                    \key d \major
                    R1*3  |
                    a' 4. a' 8 g' fis' r4  |
%% 5
                    a' 4. a' 8 g' fis' r a' 16 a'  |
                    b' 8 a' r a' 16 a' b' 8 a' r a'  |
                    g' 8 _( [ fis' ] e' ) e' fis' 4 r  |
                    a' 4. a' 8 a' a' r4  |
                    a' 4. a' 8 a' a' r a' 16 a'  |
%% 10
                    a' 8 a' r a' 16 a' a' 8 a' r a'  |
                    a' 4. gis' 8 a' 4 r  |
                    a' 2 b 4 cis'  |
                    d' 8 d' d' 4. d' 8 cis' 4  |
                    b 2 a 4 r8 a' 16 a'  |
%% 15
                    a' 8 a' r a' 16 a' a' 8 a' r a' 16 a'  |
                    a' 8 a' r a' 16 a' a' 8 a' r4  |
                    d' 2 e' 4 fis'  |
                    g' 8 g g' 4. g' 8 fis' 4  |
                    e' 2 d' 4 r8 a' 16 a'  |
%% 20
                    b' 8 a' r a' 16 a' b' 8 a' r a' 16 a'  |
                    b' 8 a' r a' 16 a' b' 8 a' r4  |
                    R1  |
                    r2 r4 r8 a' 16 a'  |
                    g' 8 e' 16 e' a' 8 a' a' a' 16 a' fis' 8 d'  |
%% 25
                    r8 e' 16 d' cis' 8 a r g' 16 fis' e' 8 a' 16 g'  |
                    fis' 4 r8 b' 16 a' gis' 8 e' a' 4 
                    % warning: overlong bar truncated here |
                    \skip 4 gis' 4 a' r8 e' 16 e'  |
                    a' 8 fis' r fis' 16 fis' e' 8 cis' r4  |
                    d' 2 e' 4 fis'  |
%% 30
                    g' 8 g g' 4. g' 8 fis' 4  |
                    e' 2 d' 8 a' 16 a' fis' 8 d'  |
                    r8 b' b' b' a' 2  |
                    r2 r4 fis'  |
                    e' 4 d' d' cis'  |
%% 35
                    d' 1  |
                    r4 d' 2 cis' 4  |
                    d' 2. a' 4  |
                    a' 4 d' fis' e' 8. d' 16  |
                    d' 4. e' 8 fis' 4 gis'  |
%% 40
                    a' 4. a' 8 g' 4 g'  |
                    a' 2 r  |
                    r2 r  |
                    r2 r  |
                    r2 r  |
%% 45
                    r2 r  |
                    r4 a' d'' fis'  |
                    b' 4 d' g' fis' 8 e'  |
                    fis' 4 e' 8. d' 16 d' 8 a' fis' d'  |
                    r8 e' a' e' r4 r8 cis'  |
%% 50
                    d' 8 b' a' 2 gis' 4  |
                    a' 4 e' a' a'  |
                    a' 1 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    r4 a' a' a'  |
%% 55
                    a' 1 -\tenuto 
                    % warning: overlong bar truncated here |
                    \skip 1  |
                    R1  |
                    r4 r8 a' b' a' r a'  |
                    b' 8 a' r a' 16 a' b' 8 a' r a' 16 a'  |
%% 60
                    b' 8 a' r4 r2  |
                    r4 r8 e' a' gis' r e'  |
                    a' 8 gis' r e' 16 e' a' 8 gis' r e' 16 e'  |
                    a' 8 gis' r4 r2  |
                    r4 r8 fis' b' bes' r fis'  |
%% 65
                    b' 8 bes' r fis' 16 fis' b' 8 bes' r fis' 16 fis'  |
                    b' 4 fis' r2  |
                    r2 b' 4 b'  |
                    a' 4. a' 8 a' 4 a'  |
                    a' 2 r  |
%% 70
                    r2 r8 fis' gis' a'  |
                    d' 8 cis' d' e' 16 d' cis' 8 d' a' g'  |
                    fis' 4. e' 8 d' 4. d' 8  |
                    d' 8 cis' d' d' d' 4 cis'  |
                    d' 2 d' 4 d'  |
%% 75
                    d' 4 r8 a' b' a' r a'  |
                    b' 8 a' r d' d' 4 d'  |
                    d' 4 r8 a' 16 a' b' 8 a' r a' 16 a'  |
                    b' 8 a' r4 r a'  |
                    d'' 4 fis' b' d'  |
%% 80
                    g' 4 fis' 8 e' e' 2  |
                    fis' 4 r fis' fis' 8. g' 16  |
                    a' 4 r8 fis' fis' 4 fis' 8. g' 16  |
                    a' 4 r fis' fis'  |
                    a' 4 r8 fis' fis' 4 fis' 8. g' 16  |
%% 85
                    a' 4 r r fis'  |
                    fis' 4 fis' d' a'  |
                    e' 4 a' 8 a' a' 2  |
                    a' 4 r8 a' b' a' r a'  |
                    b' 8 a' r a' b' a' r a'  |
%% 90
                    b' 8 a' r a' 16 a' b' 8 a' r a' 16 a'  |
                    b' 8 a' r a' 16 a' b' 8 a' r a' 16 a'  |
                    b' 8 a' r4 r fis'  |
                    g' 2. g' 4  |
                    fis' 1  |
                    \bar "|."
                } % Voice

                % End of segment oboe

                % End voice 0

                % cycle 1   verse line 1
                \new Lyrics
                \with {alignBelowContext="track 15"}
                \lyricsto "voice 14.0" {
                    \lyricmode {
                        \override LyricText #'self-alignment-X = #LEFT
                        \set ignoreMelismata = ##t

                        % Segment "oboe": verse 1

                        %{   4 %}    Hal le lu ja,
                        %{   5 %}    Hal le lu ja, Hal le
                        %{   6 %}    lu ja, Hal le lu ja, Hal
                        %{   7 %}    le _ _ lu ja,
                        %{   8 %}    Hal le lu ja,
                        %{   9 %}    Hal le lu ja, Hal le
                        %{  10 %}    lu ja, Hal le lu ja, Hal
                        %{  11 %}    le lu ja,
                        %{  12 %}    denn Gott der
                        %{  13 %}    Herr re gie ret all
                        %{  14 %}    mäch tig, Hal le
                        %{  15 %}    lu ja, Hal le lu ja, Hal le
                        %{  16 %}    lu ja, Hal le lu ja,
                        %{  17 %}    denn Gott der
                        %{  18 %}    Herr re gie ret all
                        %{  19 %}    mäch tig, Hal le
                        %{  20 %}    lu ja, Hal le lu ja, Hal le
                        %{  21 %}    lu ja, Hal le lu ja,
                        %{  23 %}    Hal le
                        %{  24 %}    lu ja, Hal le lu ja, Hal le lu ja,
                        %{  25 %}    Hal le lu ja, Hal _ le lu ja,
                        %{  26 %}    Hal le lu ja, Hal le
                        %{  27 %}    lu ja, Hal le
                        %{  28 %}    lu ja, Hal le lu ja,
                        %{  29 %}    denn Gott der
                        %{  30 %}    Herr re gie ret all
                        %{  31 %}    mäch tig, Hal le lu ja,
                        %{  32 %}    Hal le lu ja,
                        %{  33 %}    Das
                        %{  34 %}    Kö nig reich der
                        %{  35 %}    Welt
                        %{  36 %}    ist fort
                        %{  37 %}    an das
                        %{  38 %}    Kö nig reich des _
                        %{  39 %}    Herrn und sei nes
                        %{  40 %}    Christ, und sei nes
                        %{  41 %}    Christ,
                        %{  46 %}    And He shall
                        %{  47 %}    reign auf e wig und
                        %{  48 %}    e _ _ wig, auf e wig
                        %{  49 %}    und e wig, auf
                        %{  50 %}    e _ wig und
                        %{  51 %}    e wig, Herr der
                        %{  52 %}    Herrn,
                        %{  54 %}    der Wel ten
                        %{  55 %}    Gott,
                        %{  58 %}    auf e wig und
                        %{  59 %}    e wig, Hal le lu ja, Hal le
                        %{  60 %}    lu ja,
                        %{  61 %}    auf e wig und
                        %{  62 %}    e wig, Hal le lu ja, Hal le
                        %{  63 %}    lu ja,
                        %{  64 %}    auf e wig und
                        %{  65 %}    e wig, Hal le lu ja, Hal le
                        %{  66 %}    lu ja,
                        %{  67 %}    Herr der
                        %{  68 %}    Herrn, der Wel ten
                        %{  69 %}    Gott,
                        %{  70 %}    und er re
                        %{  71 %}    giert _ _ _ _ _ und er re
                        %{  72 %}    giert _ _ auf
                        %{  73 %}    im _ mer und e _
                        %{  74 %}    wig, Herr der
                        %{  75 %}    Herrn, auf im mer und
                        %{  76 %}    e wig, der Wel ten
                        %{  77 %}    Gott, Hal le lu ja, Hal le
                        %{  78 %}    lu ja, und
                        %{  79 %}    er re giert auf
                        %{  80 %}    im mer und e
                        %{  81 %}    wig, Herr der _
                        %{  82 %}    Herrn, der Wel ten _
                        %{  83 %}    Gott, Herr der
                        %{  84 %}    Herrn, der Wel ten _
                        %{  85 %}    Gott, und
                        %{  86 %}    er re giert auf
                        %{  87 %}    im mer und e
                        %{  88 %}    wig, auf im mer und
                        %{  89 %}    e wig, auf im mer and
                        %{  90 %}    w eig Hal le lu ja, Hal le
                        %{  91 %}    lu ja, Hal le lu ja, Hal le
                        %{  92 %}    lu ja, Hal
                        %{  93 %}    le lu
                        %{  94 %}    jah!

                        \unset ignoreMelismata
                    }
                } % Lyrics 
            >> % Staff ends

            \context Staff = "track 16, Tenore" << 
                \set Staff.instrumentName = \markup { \center-column { "Tenore " } }
                \set Staff.shortInstrumentName = "T"
                \set Staff.midiInstrument = "Blown Bottle"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 15.0" {
                    % Segment: clarinet
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "treble_8"
                    \key d \major
                    R1*3  |
                    fis' 4. d' 8 d' d' r4  |
%% 5
                    fis' 4. d' 8 d' d' r d' 16 d'  |
                    g' 8 fis' r d' 16 d' g' 8 fis' r d'  |
                    e' 8 ^( a 4 ) a 8 a 4 r  |
                    cis' 4. e' 8 d' cis' r4  |
                    cis' 4. e' 8 d' cis' r e' 16 e'  |
%% 10
                    d' 8 cis' r e' 16 e' d' 8 cis' r e'  |
                    d' 8 ^( [ e' ] fis' ) d' e' 4 r  |
                    a 2 b 4 cis'  |
                    d' 8 d d' 4. d' 8 cis' 4  |
                    b 2 a 4 r8 a 16 a  |
%% 15
                    fis' 8 e' r e' 16 e' fis' 8 e' r e' 16 e'  |
                    d' 8 cis' r e' 16 e' d' 8 cis' r4  |
                    d' 2 e' 4 fis'  |
                    g' 8 g g 4. g 8 fis 4  |
                    e 2 d 4 r8 d' 16 d'  |
%% 20
                    g' 8 fis' r d' 16 d' g' 8 fis' r d' 16 d'  |
                    g' 8 fis' r d' 16 d' g' 8 fis' r4  |
                    r4 r8 d' 16 d' cis' 8 a r d' 16 d'  |
                    b 8 b r e' 16 e' cis' 8 a 16 a d' 4 
                    % warning: overlong bar truncated here |
                    \skip 4 cis' 4 d' 8 fis' 16 fis' a' 8 fis'  |
%% 25
                    a 2 b 4 cis'  |
                    d' 8 d d' 4. d' 8 cis' 4  |
                    b 2 a 8 e' 16 e' cis' 8 a  |
                    r8 d' 16 d' fis' 8 d' r e' 16 e' cis' 8 a  |
                    d' 2 e' 4 fis'  |
%% 30
                    g' 8 g g' 4. g' 8 fis' 4  |
                    e' 2 d' 4. fis' 8  |
                    g' 4. g' 8 fis' 2  |
                    r2 r4 d'  |
                    a 4 d a 4. a 8  |
%% 35
                    a 1  |
                    r2 a 4 g 8. fis 16  |
                    fis 2. d' 4  |
                    e' 4 g' a 4. a 8  |
                    a 4. g 8 a 4 d'  |
%% 40
                    e' 4. d' 8 d' 4 e'  |
                    fis' 2 r  |
                    r2 r  |
                    r2 r4 d'  |
                    a' 4 cis' fis' a  |
%% 45
                    d' 4 cis' 8 b cis' 4 b 8. a 16  |
                    a 4 r r8 a d' d'  |
                    d' 4 r8 b e' cis' d' d'  |
                    d' 4 cis' d' r  |
                    r2 r8 d' cis' a  |
%% 50
                    fis' 8 e' 4 fis' 8 e' e' r e'  |
                    e' 4 cis' r2  |
                    r4 r8 e' fis' e' r e'  |
                    fis' 8 e' r e' 16 e' fis' 8 e' r e' 16 e'  |
                    fis' 8 e' r4 r2  |
%% 55
                    r4 r8 e' fis' e' r e'  |
                    fis' 8 e' r e' 16 e' fis' 8 e' r e' 16 e'  |
                    fis' 8 e' r4 r2  |
                    r4 r8 d' g' fis' r d'  |
                    g' 8 fis' r d' 16 d' g' 8 fis' r d' 16 d'  |
%% 60
                    g' 8 fis' r4 r2  |
                    r4 r8 b cis' b r b  |
                    cis' 8 b r b 16 b cis' 8 b r b 16 b  |
                    cis' 8 b r4 r2  |
                    r4 r8 cis' d' cis' r cis'  |
%% 65
                    d' 8 cis' r cis' 16 cis' d' 8 cis' r cis' 16 cis'  |
                    d' 4 d' r2  |
                    r2 d' 4 d'  |
                    e' 4. e' 8 d' cis' d' e'  |
                    cis' 2 r  |
%% 70
                    r8 a b cis' fis a a 4 
                    % warning: overlong bar truncated here |
                    \skip 4 gis 4 a r  |
                    r8 a d' cis' b 4. a 8  |
                    g 4 a 8 b a 2  |
                    a 2 d' 4 d'  |
%% 75
                    d' 1 -\tenuto  |
                    r4 r8 d' d' 4 d'  |
                    d' 1 -\tenuto  |
                    r4 r8 fis' fis' 4 d'  |
                    d' 4 d' b a 8 a  |
%% 80
                    g 4 a 8 a a 2  |
                    a 4 r d' d' 8. e' 16  |
                    fis' 4 r8 d' d' 4 d' 8. e' 16  |
                    fis' 4 r d' d'  |
                    fis' 4 r8 d' d' 4 d' 8. e' 16  |
%% 85
                    fis' 4 r r d'  |
                    d' 4 a b a  |
                    cis' 4 d' 8 d' d' 4 cis'  |
                    fis' 4 r8 d' g' fis' r d'  |
                    g' 8 fis' r d' g' fis' r d'  |
%% 90
                    g' 8 fis' r d' 16 d' g' 8 fis' r d' 16 d'  |
                    g' 8 fis' r d' 16 d' g' 8 fis' r d' 16 d'  |
                    g' 8 fis' r4 r a  |
                    b 2. b 4  |
                    a 1  |
                    \bar "|."
                } % Voice

                % End of segment clarinet

                % End voice 0

                % cycle 1   verse line 1
                \new Lyrics
                \with {alignBelowContext="track 16"}
                \lyricsto "voice 15.0" {
                    \lyricmode {
                        \override LyricText #'self-alignment-X = #LEFT
                        \set ignoreMelismata = ##t

                        % Segment "clarinet": verse 1

                        %{   4 %}    Hal le lu ja,
                        %{   5 %}    Hal le lu ja, Hal le
                        %{   6 %}    lu ja, Hal le lu ja, Hal
                        %{   7 %}    le _ lu ja,
                        %{   8 %}    Hal le lu ja,
                        %{   9 %}    Hal le lu ja, Hal le
                        %{  10 %}    lu ja, Hal le lu ja, Hal
                        %{  11 %}    le _ _ lu ja,
                        %{  12 %}    denn Gott der
                        %{  13 %}    Herr reg gie ret all
                        %{  14 %}    mäch tig, Hal le
                        %{  15 %}    lu ja, Hal le lu ja, Hal le
                        %{  16 %}    lu ja, Hal le lu ja,
                        %{  17 %}    denn Gott der
                        %{  18 %}    Herr reg gie ret all
                        %{  19 %}    mäch tig, Hal le
                        %{  20 %}    lu ja, Hal le lu ja, Hal le
                        %{  21 %}    lu ja, Hal le lu ja,
                        %{  22 %}    Hal le lu ja, Hal le
                        %{  23 %}    lu ja, Hal le lu ja, Hal le
                        %{  24 %}    lu ja, Hal le lu ja,
                        %{  25 %}    denn Gott der
                        %{  26 %}    Herr reg gie ret all
                        %{  27 %}    mäch tig, Hal le lu ja,
                        %{  28 %}    Hal le lu ja, Hal le lu ja,
                        %{  29 %}    denn Gott der
                        %{  30 %}    Herr reg gie ret all
                        %{  31 %}    mäch tig, Hal
                        %{  32 %}    le lu ja!
                        %{  33 %}    Das
                        %{  34 %}    Kö nig reich der
                        %{  35 %}    Welt
                        %{  36 %}    ist fort _
                        %{  37 %}    an das
                        %{  38 %}    Kö nig reich des
                        %{  39 %}    Herrn und sei nes
                        %{  40 %}    Christ, und sei nes
                        %{  41 %}    Christ,
                        %{  43 %}    und
                        %{  44 %}    er re giert auf
                        %{  45 %}    im mer und e _ _
                        %{  46 %}    wig, und er re
                        %{  47 %}    giert auf _ im mer und
                        %{  48 %}    e _ wig,
                        %{  49 %}    und er re
                        %{  50 %}    giert _ auf im mer und
                        %{  51 %}    e wig,
                        %{  52 %}    auf im mer und
                        %{  53 %}    e wig, Hal le lu ja, Hal le
                        %{  54 %}    lu ja,
                        %{  55 %}    auf im mer und
                        %{  56 %}    e wig, Hal le lu ja, Hal le
                        %{  57 %}    lu ja,
                        %{  58 %}    auf im mer und
                        %{  59 %}    e wig, Hal le lu ja, Hal le
                        %{  60 %}    lu ja,
                        %{  61 %}    auf im mer und
                        %{  62 %}    e wig, Hal le lu ja, Hal le
                        %{  63 %}    lu ja,
                        %{  64 %}    auf im mer und
                        %{  65 %}    e wig, Hal le lu ja, Hal le
                        %{  66 %}    lu ja,
                        %{  67 %}    Herr der
                        %{  68 %}    Herrn, der Wel _ ten _
                        %{  69 %}    Gott,
                        %{  70 %}    und er re giert, und er
                        %{  71 %}    re giert,
                        %{  72 %}    und er re giert, auf
                        %{  73 %}    im mer und e
                        %{  74 %}    wig, Herr der
                        %{  75 %}    Herrn,
                        %{  76 %}    der Wel ten
                        %{  77 %}    Gott,
                        %{  78 %}    und er re
                        %{  79 %}    giert auf e wig, auf
                        %{  80 %}    im mer und e
                        %{  81 %}    wig, Herr der _
                        %{  82 %}    Herrn, der Wel ten _
                        %{  83 %}    Gott, Herr der
                        %{  84 %}    Herrn, der Wel ten _
                        %{  85 %}    Gott, und
                        %{  86 %}    er re giert auf
                        %{  87 %}    im mer und e _
                        %{  88 %}    wig, auf im mer und
                        %{  89 %}    e wif, auf im mer und
                        %{  90 %}    e wif, Hal le lu ja, Hal le
                        %{  91 %}    lu ja, Hal le lu ja, Hal le
                        %{  92 %}    lu ja, Hal
                        %{  93 %}    le lu
                        %{  94 %}    ja!

                        \unset ignoreMelismata
                    }
                } % Lyrics 
            >> % Staff ends

            \context Staff = "track 17, Basso" << 
                \set Staff.instrumentName = \markup { \center-column { "Basso " } }
                \set Staff.shortInstrumentName = "B"
                \set Staff.midiInstrument = "Choir Aahs"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 16.0" {
                    % Segment: bassoon
                    \override Voice.TextScript #'padding = #2.0
                    \override MultiMeasureRest #'expand-limit = 1
                    \once \override Staff.TimeSignature #'style = #'numbered 
                    \time 4/4
                    
                    \clef "bass"
                    \key d \major
                    R1*3  |
                    d 4. fis 8 g d r4  |
%% 5
                    d 4. fis 8 g d r fis 16 fis  |
                    g 8 d r fis 16 fis g 8 d r fis  |
                    e 8 ^( [ d ] a ) a d 4 r  |
                    a 4. cis' 8 d' a r4  |
                    a 4. cis' 8 d' a r cis' 16 cis'  |
%% 10
                    d' 8 a r cis' 16 cis' d' 8 a r cis'  |
                    d' 8 [ cis' ] b 4 a r  |
                    a 2 b 4 cis'  |
                    d' 8 d d' 4. d' 8 cis' 4  |
                    b 2 a 4 r8 cis' 16 cis'  |
%% 15
                    d' 8 a r cis' 16 cis' d' 8 a r cis' 16 cis'  |
                    d' 8 a r cis' 16 cis' d' 8 a r4  |
                    d 2 e 4 fis  |
                    g 8 g, g 4. g 8 fis 4  |
                    e 2 d 4 r8 fis 16 fis  |
%% 20
                    g 8 d r fis 16 fis g 8 d r fis 16 fis  |
                    g 8 d r fis 16 fis g 8 d r4  |
                    R1*2  |
                    r4 r8 a 16 a fis 8 d r4  |
%% 25
                    a 2 b 4 cis'  |
                    d' 8 d d' 4. d' 8 cis' 4  |
                    b 2 a 4 r8 a 16 a  |
                    fis 8 d r d' 16 d' cis' 8 a r4  |
                    r4 r8 d' 16 d' cis' 8 a r d' 16 d'  |
%% 30
                    b 8 g r e 16 e a 8 a r b 16 b  |
                    g 8 e 16 e a 8. g 16 fis 4 r8 d' 16 d'  |
                    b 8 g 16 g b 8 cis' d' 2  |
                    r2 r4 d  |
                    cis 4 b, a, g 8. fis 16  |
%% 35
                    fis 1  |
                    r2 a, 4. a, 8  |
                    d 2. d' 4  |
                    cis' 4 b a g 8. fis 16  |
                    fis 4. e 8 d 4 b  |
%% 40
                    a 4. fis 8 g 4 e  |
                    d 4. a 8 d' 4 fis  |
                    b 4 d g fis 8 e  |
                    e 2 d 4 r  |
                    r4 r8 a d' d r fis  |
%% 45
                    b 8 gis a 4 r8 e d e  |
                    cis 8 a g a fis 4 r8 fis  |
                    g 8 d r4 r r8 g  |
                    a 8 a, r a fis d r d'  |
                    cis' 8 a r cis' d' d r fis  |
%% 50
                    b 8 gis a d e e r e  |
                    cis 4 a, r2  |
                    r4 r8 cis' d' a r cis'  |
                    d' 8 a r cis' 16 cis' d' 8 a r cis' 16 cis'  |
                    d' 8 a r4 r2  |
%% 55
                    r4 r8 cis' d' a r cis'  |
                    d' 8 a r cis' 16 cis' d' 8 a r cis' 16 cis'  |
                    d' 8 a r4 r2  |
                    r4 r8 fis g d r fis  |
                    g 8 d r fis 16 fis g 8 d r fis 16 fis  |
%% 60
                    g 8 d r4 r2  |
                    r4 r8 gis a e r gis  |
                    a 8 e r gis 16 gis a 8 e r gis 16 gis  |
                    a 8 e r4 r2  |
                    r4 r8 bes b fis r bes  |
%% 65
                    b 8 fis r bes 16 bes b 8 fis r bes 16 bes  |
                    b 4 b, r2  |
                    r2 b 4 b  |
                    cis' 4. cis' 8 d' 4 d  |
                    a 4. a, 8 a 4 cis  |
%% 70
                    fis 4 a, d cis 8 cis  |
                    b, 2 a, 4 r  |
                    r2 r8 d g fis  |
                    e 4 fis 8 g a 4 g 8 a  |
                    fis 4 d d' d'  |
%% 75
                    d' 4 r8 fis g d r fis  |
                    g 8 d r d' d' 4 d'  |
                    d' 4 r8 fis 16 fis g 8 d r fis 16 fis  |
                    g 8 d r d d' 4 fis  |
                    b 4 d g fis 8 fis  |
%% 80
                    e 4 d 8 d a 2  |
                    d 4 r d d  |
                    d' 4 r8 d d 4 d  |
                    d' 4 r d d  |
                    d' 4 r8 d d 4 d  |
%% 85
                    d' 4 r8 d d' 4 fis  |
                    b 4 d g fis 8 fis  |
                    e 4 d 8 d a 2  |
                    d 4 r8 fis g d r fis  |
                    g 8 d r fis g d r fis  |
%% 90
                    g 8 d r fis 16 fis g 8 d r fis 16 fis  |
                    g 8 d r fis 16 fis g 8 d r fis 16 fis  |
                    g 8 d r4 r d  |
                    g 2. g 4  |
                    d 1  |
                    \bar "|."
                } % Voice

                % End of segment bassoon

                % End voice 0

                % cycle 1   verse line 1
                \new Lyrics
                \with {alignBelowContext="track 17"}
                \lyricsto "voice 16.0" {
                    \lyricmode {
                        \override LyricText #'self-alignment-X = #LEFT
                        \set ignoreMelismata = ##t

                        % Segment "bassoon": verse 1

                        %{   4 %}    Hal le lu ja,
                        %{   5 %}    Hal le lu ja, Hal le
                        %{   6 %}    lu ja, Hal le lu ja, Hal
                        %{   7 %}    le _ _ lu ja,
                        %{   8 %}    Hal le lu ja,
                        %{   9 %}    Hal le lu ja, Hal le
                        %{  10 %}    lu ja, Hal le lu ja, Hal
                        %{  11 %}    le _ lu ja,
                        %{  12 %}    denn Gott der
                        %{  13 %}    Herr re gie ret all
                        %{  14 %}    mäch tig, Hal le
                        %{  15 %}    lu ja, Hal le lu ja, Hal le
                        %{  16 %}    lu ja, Hal le lu ja,
                        %{  17 %}    denn Gott der
                        %{  18 %}    Herr re gie ret all
                        %{  19 %}    mäch tig, Hal le
                        %{  20 %}    lu jah! Hal le lu jah! Hal le
                        %{  21 %}    lu jah! Hal le lu jah!
                        %{  24 %}    Hal le lu jah!
                        %{  25 %}    denn Gott der
                        %{  26 %}    Herr re gie ret all
                        %{  27 %}    mäch tig, Hal le
                        %{  28 %}    lu jah, hal le lu jah!
                        %{  29 %}    Hal le lu jah, hal le
                        %{  30 %}    lu jah, hal le lu jah, hal le
                        %{  31 %}    lu jah, hal le lu jah! Hal le
                        %{  32 %}    lu jah, hal le lu jah!
                        %{  33 %}    Das
                        %{  34 %}    Kö nig reich der _
                        %{  35 %}    Welt
                        %{  36 %}    ist fort
                        %{  37 %}    an das
                        %{  38 %}    Kö nig reich des _
                        %{  39 %}    Herrn und sei nes
                        %{  40 %}    Christ, und sei nes
                        %{  41 %}    Christ, und er re
                        %{  42 %}    giert auf im mer und
                        %{  43 %}    e wig,
                        %{  44 %}    auf im mer und
                        %{  45 %}    e _ wig, und er re
                        %{  46 %}    giert, und er re giert auf
                        %{  47 %}    e wig, auf
                        %{  48 %}    im mer und e wig, auf
                        %{  49 %}    im mer und e wig, auf
                        %{  50 %}    e _ wig, auf im mer und
                        %{  51 %}    e wig,
                        %{  52 %}    auf e wig und
                        %{  53 %}    e wig, Hal le lu ja, Hal le
                        %{  54 %}    lu ja,
                        %{  55 %}    auf e wig und
                        %{  56 %}    e wig, Hal le lu ja, Hal le
                        %{  57 %}    lu ja,
                        %{  58 %}    auf e wig und
                        %{  59 %}    e wig, Hal le lu ja, Hal le
                        %{  60 %}    lu ja,
                        %{  61 %}    auf e wig und
                        %{  62 %}    e wig, Hal le lu ja, Hal le
                        %{  63 %}    lu ja,
                        %{  64 %}    auf e wig und
                        %{  65 %}    e wig, Hal le lu ja, Hal le
                        %{  66 %}    lu ja,
                        %{  67 %}    Herr der
                        %{  68 %}    Herrn, der Wel ten
                        %{  69 %}    Gott, und er re
                        %{  70 %}    giert auf im mer und
                        %{  71 %}    e wig,
                        %{  72 %}    und er re
                        %{  73 %}    giert auf _ im mer und
                        %{  74 %}    e wig, Herr der
                        %{  75 %}    Herrn, auf e wig und
                        %{  76 %}    e wig der Wel ten
                        %{  77 %}    Gott, Hal le lu ja, Hal le
                        %{  78 %}    lu ja, und er re
                        %{  79 %}    giert auf e wig, auf
                        %{  80 %}    im mer und e
                        %{  81 %}    wig, Herr der
                        %{  82 %}    Herrn, der Wel ten
                        %{  83 %}    Gott, Herr der
                        %{  84 %}    Herrn, der Wel ten
                        %{  85 %}    Gott, und er re
                        %{  86 %}    giert auf e wig, auf
                        %{  87 %}    im mer und e
                        %{  88 %}    wig, auf e wig und
                        %{  89 %}    e wig auf e wig und
                        %{  90 %}    e wig Hal le lu ja, Hal le
                        %{  91 %}    lu ja, Hal le lu ja, Hal le
                        %{  92 %}    lu ja, Hal
                        %{  93 %}    le lu
                        %{  94 %}    ja!

                        \unset ignoreMelismata
                    }
                } % Lyrics 
            >> % Staff ends
        >> % StaffGroup 3

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
