/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTDrivers.hxx
    \author Romain BONDUE
    \date 30/08/2005
    \warning This file should only be included from RTDrivers.h */
#include <cstring> // memcpy()



inline nsWireless::CRTDriver::CRTDriver (const std::string& DeviceName)
                                                throw (nsErrors::CSystemExc)
    : CWE17Driver (DeviceName) {}


inline void nsWireless::CRT2400Driver::GetScanResult
                                                (std::vector<CCell>& CellVec)
                            const throw (nsErrors::CException, std::bad_alloc)
{
        /* Don't call CWE17Driver::GetScanResult() because it's not supported
           by rt2400.           RTLINUX_GET_OID_802_11_BSSID_LIST */
    CRTDriver::GetScanResult (m_PrivateIoctl, 8001, CellVec);

} // GetScanResult()


inline void nsWireless::CRTAdvancedDriver::SetFlag (int Flag, bool B) throw()
{
    if (B) m_Flags |= Flag;
    else m_Flags &= ~Flag;

} // SetFlag()


inline bool nsWireless::CRTAdvancedDriver::GetFlag (int Flag) const throw()
{
    return m_Flags & Flag;

} // GetFlag()


inline int nsWireless::CRTAdvancedDriver::GetRfmontxIoctl () const throw()
{
    return m_RfmontxIoctl;

} // GetRfmontxIoctl()


inline void nsWireless::CRTAdvancedDriver::SetWirelessMode
                            (WirelessMode_e WMode) throw (nsErrors::CSystemExc)
{
    SetIoctl ("WirelessMode", WMode, "Can't set the wireless mode.");
    SetFlag (IsB_Only, WMode == B_Only);

} // SetWirelessMode()


inline void nsWireless::CRTAdvancedDriver::SetTxBurst (bool B)
                                                    throw (nsErrors::CSystemExc)
{
    SetIoctl ("TxBurst", B ? 1 : 0, "Can't set TxBurst.");
    SetFlag (TxBurst, B);

} // SetTxBurst()


inline void nsWireless::CRTAdvancedDriver::SetBGProtection
                        (BGProtection_e Protection) throw (nsErrors::CSystemExc)
{
    SetIoctl ("BGProtection", Protection, "Can't set B/G protection.");
    m_BGProtection = Protection;

} // SetBGProtection()


inline void nsWireless::CRTAdvancedDriver::SetTxPreamble (TxPreamble_e Preamble)
                                                    throw (nsErrors::CSystemExc)
{
    SetIoctl ("TxPreamble", Preamble, "Can't set TxPreamble.");
    m_TxPreamble = Preamble;

} // SetTxPreamble()


inline void nsWireless::CRTAdvancedDriver::SetTurboRate (bool B)
                                                    throw (nsErrors::CSystemExc)
{
    SetIoctl ("TurboRate", B ? 1 : 0, "Can't set turbo rate.");
    SetFlag (TurboRate, B);

} // SetTurboRate()


inline void nsWireless::CRTAdvancedDriver::SetAdHocOFDM (bool B)
                                                    throw (nsErrors::CSystemExc)
{
    SetIoctl ("AdhocOfdm", B ? 1 : 0, "Can't set OFDM mode.");
    SetFlag (AdHocOFDM, B);

} // SetAdHocOFDM()


inline void nsWireless::CRTAdvancedDriver::IWPrivHandler::operator ()
                            (const ::iw_priv_args&) throw (nsErrors::CException)
{

} // operator ()()


inline nsWireless::CRTAdvancedDriver::IWPrivHandler::~IWPrivHandler () throw()
{

} // ~IWPrivHandler()


inline nsWireless::WirelessMode_e
                nsWireless::CRTAdvancedDriver::GetWirelessMode () const throw()
{
    return m_Flags & IsB_Only ? B_Only : Mixed;

} // GetWirelessMode()


inline bool nsWireless::CRTAdvancedDriver::GetTxBurst () const throw()
{
    return m_Flags & TxBurst;

} // GetTxBurst()


inline nsWireless::BGProtection_e
                nsWireless::CRTAdvancedDriver::GetBGProtection () const throw()
{
    return m_BGProtection;

} // GetBGProtection()


inline nsWireless::TxPreamble_e nsWireless::CRTAdvancedDriver::GetTxPreamble ()
                                                                const throw()
{
    return m_TxPreamble;

} // GetTxPreamble()


inline bool nsWireless::CRTAdvancedDriver::GetTurboRate () const throw()
{
    return m_Flags & TurboRate;

} // GetTurboRate()


inline bool nsWireless::CRTAdvancedDriver::GetAdHocOFDM () const throw()
{
    return m_Flags & AdHocOFDM;

} // GetAdHocOFDM()


inline bool nsWireless::CRTAdvancedDriver::GetRfmontx () const throw()
{
    return m_Flags & Rfmontx;
    
} // GetRfmontx()


inline int nsWireless::CRTAdvancedDriver::GetTxRate () const
                                                    throw (nsErrors::CSystemExc)
{
    const int Rate (CWE17Driver::GetTxRate());
    return Rate == 5000 ? 5500 : Rate;

} // GetTxRate()


inline void nsWireless::CRTAdvancedDriver::SetTxRate (int Rate)
                                                    throw (nsErrors::CSystemExc)
{
    CWE17Driver::SetTxRate (Rate == 5500 ? 5000 : Rate);

} // SetTxRate()


inline nsWireless::BGProtection_e
            nsWireless::CRTAdvancedDriver::GetBGProtectionFlag () const throw()
{
    return m_BGProtection;

} // GetBGProtectionFlag()


inline void nsWireless::CRTAdvancedDriver::SetBGProtectionFlag
                                                (BGProtection_e Status) throw()
{
    m_BGProtection = Status;

} // SetBGProtectionFlag()


inline nsWireless::TxPreamble_e
            nsWireless::CRTAdvancedDriver::GetTxPreambleFlag () const throw()
{
    return m_TxPreamble;

} // GetTxPreambleFlag()


inline void nsWireless::CRTAdvancedDriver::SetTxPreambleFlag
                                                (TxPreamble_e Status) throw()
{
    m_TxPreamble = Status;

} // SetTxPreambleFlag()


inline void nsWireless::CRT2500Driver::GetScanResult
(std::vector<CCell>& CellVec) const throw (nsErrors::CException, std::bad_alloc)
{                               // OID_802_11_BSSID_LIST
    CRTAdvancedDriver::GetScanResult (0x0116U, CellVec);

} // GetScanResult()


inline nsWireless::CEncryptionD nsWireless::CRT2500Driver::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
        // OID_802_11_WEP_STATUS and OID_802_11_AUTHENTICATION_MODE
    return CRTAdvancedDriver::GetEncryption (0x011AU, 0x0117U);

} // GetEncryption()


inline void nsWireless::CRT2570Driver::PrivateIoctl (int IoctlCode, int Value,
                    const std::string& ErrorMsg) throw (nsErrors::CSystemExc)
{
    std::memcpy (m_Data.name, &Value, sizeof (Value));
    Ioctl (IoctlCode, ErrorMsg);

} // PrivateIoctl()


inline void nsWireless::CRT2570Driver::SetRfmontx (bool B)
                                                    throw (nsErrors::CSystemExc)
{
    PrivateIoctl (m_RfmontxIoctl, B ? 1 : 0, "Can't set rfmontx.");

} // SetRfmontx()


inline bool nsWireless::CRT2570Driver::GetRfmontx () const throw()
{
    return m_Flags & RfMontx;

} // GetRfmontx()


inline void nsWireless::CRT2570Driver::SetPrismHeader (PrismMode_e PrismMode)
                                                    throw (nsErrors::CSystemExc)
{
    PrivateIoctl (m_PrismHeaderIoctl, int (PrismMode),
                  "Can't force prism header.");

} // SetPrismHeader()


inline nsWireless::CRT2570Driver::PrismMode_e
                    nsWireless::CRT2570Driver::GetPrismHeader () const throw()
{
    return m_PrismMode;

} // GetPrismHeader()


inline nsWireless::CRT2570Driver::AdHocMode_e
                        nsWireless::CRT2570Driver::GetAdHocMode () const throw()
{
    return m_AdHocMode;

} // GetAdHocMode()


inline void nsWireless::CRT2570Driver::SetAdHocMode (AdHocMode_e Mode)
                                                    throw (nsErrors::CSystemExc)
{
    PrivateIoctl (m_AdHocModeIoctl, int (Mode), "Can't set adhoc mode.");

} // SetAdHocMode()


inline nsWireless::CEncryptionD nsWireless::CRT61Driver::GetEncryption ()
                                    throw (nsErrors::CSystemExc, std::bad_alloc)
{
        // OID_802_11_WEP_STATUS and OID_802_11_AUTHENTICATION_MODE
    return CRTAdvancedDriver::GetEncryption (0x0510U, 0x0511U);

} // GetEncryption()


inline void nsWireless::CRT61Driver::Scan () throw (nsErrors::CSystemExc)
{
    UpdateScanTime();
    CRTAdvancedDriver::Scan();

} // Scan()


inline nsWireless::CRT61Driver::IWPrivHandlerRT61::IWPrivHandlerRT61
                                            (int& GetSiteSurveyIoctl) throw()
    : m_GetSiteSurveyIoctl (GetSiteSurveyIoctl) {}


inline time_t nsWireless::CRT61Driver::GetLastScanTime () const throw()
{
    return m_LastScanTime;

} // GetLastScanTime()


inline int nsWireless::CRT61Driver::GetSiteSurveyIoctl () const throw()
{
    return m_GetSiteSurveyIoctl;

} // GetSiteSurveyIoctl()


inline nsWireless::CRT73Driver::CRT73Driver (const std::string& Ifname)
                                    throw (nsErrors::CException, std::bad_alloc)
    : CRT61Driver (Ifname) {}
