/* Public domain. */

#ifndef DNS_HELPER_H
#define DNS_HELPER_H

#include "gccattributes.h"
#include "bytestr.h"
#include "stralloc.h"

#define DNS_C_IN "\0\1"
#define DNS_C_ANY "\0\377"

#define DNS_T_A "\0\1"
#define DNS_T_NS "\0\2"
#define DNS_T_CNAME "\0\5"
#define DNS_T_SOA "\0\6"
#define DNS_T_PTR "\0\14"
#define DNS_T_HINFO "\0\15"
#define DNS_T_MX "\0\17"
#define DNS_T_TXT "\0\20"
#define DNS_T_RP "\0\21"
#define DNS_T_SIG "\0\30"
#define DNS_T_KEY "\0\31"
#define DNS_T_AAAA "\0\34"
#define DNS_T_SRV "\0\41"
#define DNS_T_AXFR "\0\374"
#define DNS_T_ANY "\0\377"


extern void dns_sortip (char *, unsigned int) ;

extern void dns_domain_free (char **) ;
extern int dns_domain_copy (char **, char const *) ;
extern unsigned int dns_domain_length (char const *) gccattr_pure ;
#define dns_domain_equal(a, b) (!case_diffs((a), (b)))
extern int dns_domain_suffix (char const *, char const *) gccattr_pure ;
extern unsigned int dns_domain_suffixpos (char const *, char const *) gccattr_pure ;
extern int dns_domain_fromdot (char **, char const *, unsigned int) ;
extern int dns_domain_todot_cat (stralloc *, char const *) ;

extern unsigned int dns_packet_copy (char const *, unsigned int, unsigned int, char *, unsigned int) ;
extern unsigned int dns_packet_getname (char const *, unsigned int, unsigned int, char **) ;
extern unsigned int dns_packet_skipname (char const *, unsigned int, unsigned int) gccattr_pure ;

extern int dns_ip4_packet (stralloc *, char const *, unsigned int) ;
extern int dns_name_packet (stralloc *, char const *, unsigned int) ;
extern void dns_name4_domain (char *, char const *) ;
#define DNS_NAME4_DOMAIN 31
extern int dns_txt_packet (stralloc *, char const *, unsigned int) ;
extern int dns_mx_packet (stralloc *, char const *, unsigned int) ;

#endif
