/* Public domain. */

#include "caltimedate.h"

unsigned int caldate_scan (char const *s, struct caldate *cd)
{
  int sign = 1 ;
  char const *t = s ;
  unsigned long z = 0 ;
  unsigned long c ;

  if (*t == '-') { ++t ; sign = -1 ; }
  while ((c = (unsigned char) (*t - '0')) <= 9) { z = z * 10 + c ; ++t ; }
  cd->year = z * sign ;

  if (*t++ != '-') return 0 ;
  z = 0 ;
  while ((c = (unsigned char) (*t - '0')) <= 9) { z = z * 10 + c ; ++t ; }
  cd->month = z ;

  if (*t++ != '-') return 0 ;
  z = 0 ;
  while ((c = (unsigned char) (*t - '0')) <= 9) { z = z * 10 + c ; ++t ; }
  cd->day = z ;

  return t - s ;
}
