/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _DIFFINFO_H
#define _DIFFINFO_H

// sc
//#include "svn/Diff.h"
#include "sublib/ConflictType.h"
#include "sublib/BlockInfo.h"

// sys
#include <vector>


enum MergeType
{
  msNotMerged,
  msOriginal,
  msModified,
  msLatest
  //msModifiedLatest,
  //msLatestModified
};

// \todo make blockNumber unsigned
class DiffInfo
{
public:
  DiffInfo( ConflictType type, int blockNumber, const BlockInfo& info );
  DiffInfo( const DiffInfo& src );

  MergeType getMergeType() const;
  void setMergeType( MergeType t );

  ConflictType getType() const;

  int getDiffNumber() const;
  int getBlockNumber() const;
  
  const BlockInfo& getBlockInfo() const;

  void setDiffNumber( int num );

private:
  ConflictType     _type;
  MergeType        _merged;

  int              _diff;
  int              _block;
  BlockInfo        _blockInfo;
};

typedef std::vector<DiffInfo> DiffInfos;


#endif // _DIFFINFO_H

