/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string>
#include <iostream>

#include "swac.hh"
#include "posix.hh"
#include "global.hh"
#include "options.hh"
#include "basic.hh"

Toptions options;

void show_copying() {
	std::cout << _("Copyright (C) 2008 Vion Nicolas.") << std::endl;
	std::cout << _("License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>") << std::endl;
	std::cout << _("This is free software: you are free to change and redistribute it.") << std::endl;
	std::cout << _("There is NO WARRANTY, to the extent permitted by law.") << std::endl;
}

void show_version() {
	std::cout << "swac-get " VERSION << std::endl;
}


//get the default database's path ~/.swac/swac/db
std::string target_get_default() {
	std::string db_dir(get_home_dir() + ".swac" + pathDelim);

	if (!is_dir(db_dir)) 
		mkdir(db_dir);

	return db_dir + "swac.db";
}



void swac_action() {

	//open database
	std::string path(options.target);
	if (path == "")
		path = target_get_default();

	bool exists = fileexists(path);

	Tswac swac;
	swac.db_open(path);

	if (!exists)
		swac.db_init();
	else if (!swac.db_check_version()) {
		std::cout << _("Database structure has to be updated!") << std::endl;
		swac.upgrade_structure();
	}
	

	switch (options.action) {
		case CLEAR : 
			swac.db_clear();
			break;
		case SELECT : 
			swac.package_select(options.action_arg);
			break;
		case DESELECT : 
			swac.package_deselect(options.action_arg);
			break;
		case LIST_SOURCES : 
			swac.sql("SELECT * FROM sources;");
			break;
		case LIST : 
			swac.sql("SELECT packid, version, format, path FROM packages;");
			break;
		case LIST_AVAILABLE : 
			swac.sql("SELECT packid, version, format, path FROM packages_available;");
			break;
		case SOURCE_SELECT : 
			swac.source_select(options.action_arg);
			break;
		case SOURCE_DESELECT : 
			swac.source_deselect(options.action_arg);
			break;
		case SOURCE_DELETE : 
			swac.source_delete(options.action_arg);
			break;
		case UPDATE : 
			swac.update();
			break;
		case UPGRADE : 
			swac.upgrade();
			break;
		case SQL : 
			swac.sql(options.action_arg);
			break;
	}
	swac.db_close();
}



int main(int argc, char *argv[]) {
	if (!options.parse(argc, argv)) 
		return 0;

	if (options.version) {
		show_version();
		return 0;
	}

	if (options.help) {
		options.show_help();
		return 0;
	}

	if (options.action == 0) {
		show_version();
		show_copying();
		options.show_short_help();
		return 0;
	}

	swac_action();
}

