#! /usr/bin/env python

# System includes
import os
import subprocess
import sys
from optparse import OptionParser

def create_docstrings(package,
                      doxygen=None):

    # Handle default arguments
    if doxygen is None:
        doxygen = "doxygen"

    # Define various string names
    out_name      = package + ".out"
    err_name      = package + ".err"
    doxyfile_name = "Doxyfile_" + package

    ######################################################################
    # Run doxygen on the appropriate Doxyfile

    # Open output and error files
    out_file = open(out_name, 'w')
    err_file = open(err_name, 'w')

    # Print message
    print "Running doxygen on package", package, "...",
    sys.stdout.flush()

    # Run and wait for completion
    result = subprocess.call([doxygen, doxyfile_name],
                             stdout=out_file,
                             stderr=err_file)

    # Complete the message
    if result != 0:
        print "ERRORS!"
        print open(err_name).read()
        sys.exit(result)
    else:
        print "success"

    ######################################################################
    # Run doxy2swig.py on the appropriate index.xml file

    # Get the doxy2swig script, source filename, and output filename
    source_dir = os.path.split(__file__)[0]
    doxy2swig  = os.path.join(source_dir,"doxy2swig.py")
    doxy2swig  = os.path.abspath(doxy2swig)
    source     = os.path.join(package, "index.xml")
    output     = package + "_dox.i"

    # Open output and error files
    out_file = open(out_name, 'w')
    err_file = open(err_name, 'w')

    # Print message
    print "Converting doxygen XML to SWIG docstring directives for", \
          package, "...",
    sys.stdout.flush()

    # Run and wait for completion
    result = subprocess.call([doxy2swig, source, output],
                             stdout=out_file,
                             stderr=err_file)

    # Complete the message
    if result != 0:
        print "ERRORS!"
        print open(err_name).read()
        sys.exit(result)
    else:
        print "success"

    ######################################################################
    # Cleanup
    if os.path.isfile(out_name):
        os.remove(out_name)
    if os.path.isfile(err_name):
        os.remove(err_name)

##########################################################################

if __name__ == "__main__":

    parser = OptionParser()
    parser.add_option("-d", "--doxygen", dest="doxygen", metavar="DOXYGEN",
                      default=None, help="specify the path to doxygen")
    (options, packages) = parser.parse_args()

    for package in packages:
        create_docstrings(package, options.doxygen)
